/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;

public class HorizontalLineLayout
implements LayoutManager2,
LayoutManager {
    private Dimension preferredSize = null;
    private Dimension minimumSize = null;
    private List<Element> elements = new LinkedList<Element>();

    private void addLayoutComponent(String name, Component comp, Sizing constant) {
        Element element = new Element();
        element.comp = comp;
        element.sizing = constant;
        this.elements.add(element);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(name, comp, Sizing.PREFERRED);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            this.addLayoutComponent(comp, (Object)Sizing.PREFERRED);
            return;
        }
        if (!(constraints instanceof Sizing)) {
            throw new IllegalArgumentException("sizing should be MINIMIZE, PREFERED,MAXIMIZE or FILL");
        }
        this.addLayoutComponent(null, comp, (Sizing)((Object)constraints));
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.preferredSize = null;
        this.minimumSize = null;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return target.getPreferredSize();
    }

    private void layoutMinimum(Container parent, int mincount, int prefcount, int maxcount, int needed, int prefered, int avaible) {
        int width;
        int xPos = 0;
        for (Element element : this.elements) {
            width = element.comp.getMinimumSize().width;
            element.bounds.x = xPos;
            element.bounds.width = width;
            xPos += width;
        }
        if (xPos > avaible) {
            while (xPos > avaible) {
                xPos = 0;
                for (Element element : this.elements) {
                    width = element.bounds.width - 1;
                    element.bounds.x = xPos;
                    element.bounds.width = width;
                    xPos = element.bounds.x + width;
                }
            }
        }
    }

    private void layoutMedium(Container parent, int mincount, int prefcount, int maxcount, int needed, int prefered, int avaible) {
        int flexC = prefcount + maxcount;
        int usedWidth = 0;
        for (Element element : this.elements) {
            element.bounds.width = element.comp.getMinimumSize().width;
            usedWidth += element.bounds.width;
        }
        int sizingElements = flexC;
        while (sizingElements > 0 && usedWidth < avaible) {
            sizingElements = flexC;
            for (Element element : this.elements) {
                if (element.sizing != Sizing.PREFERRED && element.sizing != Sizing.MAXIMIZE && element.sizing != Sizing.FILL || usedWidth >= avaible) continue;
                Dimension preferredDimension = element.comp.getPreferredSize();
                Dimension maxDimension = element.comp.getMaximumSize();
                if (element.bounds.width < preferredDimension.width && element.bounds.width < maxDimension.width) {
                    ++element.bounds.width;
                    ++usedWidth;
                    continue;
                }
                --sizingElements;
            }
        }
        sizingElements = maxcount;
        while (sizingElements > 0 && usedWidth < avaible) {
            sizingElements = maxcount;
            for (Element element : this.elements) {
                if (element.sizing != Sizing.MAXIMIZE && element.sizing != Sizing.FILL || usedWidth >= avaible) continue;
                if (element.bounds.width < element.comp.getMaximumSize().width || element.sizing == Sizing.FILL) {
                    ++element.bounds.width;
                    ++usedWidth;
                    continue;
                }
                --sizingElements;
            }
        }
        int posX = 0;
        for (Element element : this.elements) {
            element.bounds.x = posX;
            posX += element.bounds.width;
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension currentSize = parent.getSize();
        int preferredElements = 0;
        int minimizeElements = 0;
        int maximizeElements = 0;
        int minWidth = 0;
        int prefWidth = 0;
        for (Element element : this.elements) {
            element.bounds = new Rectangle();
            if (element.sizing == Sizing.MAXIMIZE || element.sizing == Sizing.FILL) {
                ++maximizeElements;
                minWidth += element.comp.getMinimumSize().width;
                prefWidth += element.comp.getPreferredSize().width;
            } else if (element.sizing == Sizing.MINIMIZE) {
                ++minimizeElements;
                minWidth += element.comp.getMinimumSize().width;
                prefWidth += element.comp.getMinimumSize().width;
            } else if (element.sizing == Sizing.PREFERRED) {
                ++preferredElements;
                minWidth += element.comp.getMinimumSize().width;
                prefWidth += element.comp.getPreferredSize().width;
            }
            if (element.comp.getPreferredSize().height < currentSize.height) {
                element.bounds.height = element.comp.getPreferredSize().height;
                continue;
            }
            element.bounds.height = currentSize.height;
        }
        if (currentSize.width < minWidth) {
            this.layoutMinimum(parent, minimizeElements, preferredElements, maximizeElements, minWidth, prefWidth, currentSize.width);
        } else if (currentSize.width < prefWidth) {
            this.layoutMedium(parent, minimizeElements, preferredElements, maximizeElements, minWidth, prefWidth, currentSize.width);
        } else {
            this.layoutMedium(parent, minimizeElements, preferredElements, maximizeElements, minWidth, prefWidth, currentSize.width);
        }
        for (Element element : this.elements) {
            element.comp.setBounds(element.bounds);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.minimumSize == null) {
            int width = 0;
            int height = 0;
            for (Element element : this.elements) {
                width += element.comp.getMinimumSize().width;
                if (element.comp.getMinimumSize().height <= height) continue;
                height = element.comp.getMinimumSize().height;
            }
            this.minimumSize = new Dimension(width, height);
        }
        return this.minimumSize;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.preferredSize == null) {
            int width = 0;
            int height = 0;
            for (Element element : this.elements) {
                width += element.comp.getPreferredSize().width;
                if (element.comp.getPreferredSize().height <= height) continue;
                height = element.comp.getPreferredSize().height;
            }
            this.preferredSize = new Dimension(width, height);
        }
        return this.preferredSize;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        for (Element element : this.elements) {
            if (!element.comp.equals(comp)) continue;
            this.elements.remove(element);
            break;
        }
    }

    private class Element {
        private Component comp;
        private Sizing sizing;
        private Rectangle bounds;

        private Element() {
        }
    }

    public static enum Sizing {
        MINIMIZE,
        PREFERRED,
        MAXIMIZE,
        FILL;

    }
}

