/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.model.explorer;

import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.swing.model.explorer.ETreeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ETreeElement {
    private List<ETreeElement> childs = new LinkedList<ETreeElement>();
    private List<ETreeListener> listener = new LinkedList<ETreeListener>();
    private Map<String, Object> data = new HashMap<String, Object>();
    private String title;
    private ETreeElement parent;
    private ETEEventHandler eventHandler = new ETEEventHandler(this);
    private BusinessObject businessObject;

    public ETreeElement() {
    }

    public ETreeElement(String title) {
        this();
        this.title = title;
    }

    public ETreeElement(String title, BusinessObject businessObject) {
        this();
        this.title = title;
        this.businessObject = businessObject;
    }

    public ETreeElement getParent() {
        return this.parent;
    }

    public void setParent(ETreeElement parent) {
        this.parent = parent;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BusinessObject getBusinessObject() {
        return this.businessObject;
    }

    public void setBusinessObject(BusinessObject businessObject) {
        this.businessObject = businessObject;
    }

    public void addChild(ETreeElement e) {
        this.childs.add(e);
        e.addListener(this.eventHandler);
    }

    public ETreeElement[] getChilds() {
        return this.childs.toArray(new ETreeElement[0]);
    }

    public boolean removeChild(ETreeElement e) {
        e.removeListener(this.eventHandler);
        return this.childs.remove(e);
    }

    public void addData(String key, Object value) {
        this.data.put(key, value);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public void removeChild(String key) {
        this.data.remove(key);
    }

    public void addListener(ETreeListener l) {
        this.listener.add(l);
    }

    public ETreeListener[] getListener() {
        return this.listener.toArray(new ETreeListener[0]);
    }

    public boolean removeListener(ETreeListener l) {
        return this.listener.remove(l);
    }

    public void fireTreeChanged() {
        ETreeListener[] myListener = this.getListener();
        for (int i = 0; i < myListener.length; ++i) {
            myListener[i].nodeChanged();
        }
    }

    public String toString() {
        return this.getTitle();
    }

    private class ETEEventHandler
    implements ETreeListener {
        private ETreeElement myMaster;

        public ETEEventHandler(ETreeElement master) {
            this.myMaster = master;
        }

        @Override
        public void nodeChanged() {
            ETreeListener[] targetListener = this.myMaster.getListener();
            for (int i = 0; i < targetListener.length; ++i) {
                targetListener[i].nodeChanged();
            }
        }
    }
}

