/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.table;

import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCAutoNum;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCBupNum;
import de.effectivecompany.base.datatypes.EFCCalMonth;
import de.effectivecompany.base.datatypes.EFCCalWeek;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCDocItem;
import de.effectivecompany.base.datatypes.EFCDocNum;
import de.effectivecompany.base.datatypes.EFCDuration;
import de.effectivecompany.base.datatypes.EFCFactor;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCMatNum;
import de.effectivecompany.base.datatypes.EFCMoney;
import de.effectivecompany.base.datatypes.EFCObjectId;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCPercent;
import de.effectivecompany.base.datatypes.EFCQuantity;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.gui.components.model.table.EFCTableColExt;
import de.effectivecompany.gui.interfaces.model.EFCModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCColumnResizer {
    private static Logger logger = LoggerFactory.getLogger(EFCColumnResizer.class);
    private static final float SCALE_FACTOR = 1.2f;

    public static void adjustColumnPreferredWidthsByType(JTable table) {
        EFCColumnResizer.adjustColumnPreferredWidthsByType(table, null, null);
    }

    public static void adjustColumnPreferredWidthsByType(JTable table, Double sizeMulti) {
        EFCColumnResizer.adjustColumnPreferredWidthsByType(table, sizeMulti, null);
    }

    public static void adjustColumnPreferredWidthsByType(JTable table, Double sizeMulti, List<EFCTableColExt> tableColumns) {
        TableColumnModel columnModel = table.getColumnModel();
        int maxwidth = 0;
        for (int col = 0; col < table.getColumnCount(); ++col) {
            maxwidth = 0;
            TableColumn column = columnModel.getColumn(col);
            Integer columnWidthFromLayout = ((EFCModel)((Object)table.getModel())).getColumnWidth(column.getIdentifier().toString());
            if (columnWidthFromLayout != null) {
                maxwidth = columnWidthFromLayout;
            }
            if (maxwidth == 0) {
                TableCellRenderer headerRenderer;
                Object value;
                if (table.getRowCount() > 0 && (value = table.getValueAt(0, col)) != null && value instanceof BaseType && (maxwidth = EFCColumnResizer.getWidthByDateType((BaseType)value)) > 0) {
                    logger.debug("EFCDateType DLUs: " + maxwidth);
                    TableCellRenderer rend = table.getCellRenderer(0, col);
                    Component comp = rend.getTableCellRendererComponent(table, value, false, false, 0, col);
                    maxwidth = UnitConverter.pixelForDLUx(maxwidth, comp);
                    logger.debug("Pixels: " + maxwidth);
                }
                if (maxwidth == 0) {
                    for (int row = 0; row < table.getRowCount(); ++row) {
                        TableCellRenderer rend = table.getCellRenderer(row, col);
                        value = table.getValueAt(row, col);
                        Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                        maxwidth = (int)((float)Math.max(comp.getPreferredSize().width, maxwidth) * 1.2f);
                        if (row <= 20) {
                            continue;
                        }
                        break;
                    }
                } else {
                    maxwidth = (int)((float)maxwidth * 1.2f);
                }
                if ((headerRenderer = column.getHeaderRenderer()) == null) {
                    headerRenderer = table.getTableHeader().getDefaultRenderer();
                }
                Object headerValue = column.getHeaderValue();
                Component headerComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, col);
                if ((maxwidth = Math.max(maxwidth, headerComp.getPreferredSize().width)) > 300) {
                    maxwidth = 200;
                }
                if (sizeMulti != null) {
                    maxwidth = (int)((double)maxwidth * sizeMulti);
                }
            }
            if (tableColumns != null) {
                EFCTableColExt tableColumn = tableColumns.stream().filter(c -> c.getIdentifier() != null && column != null && c.getIdentifier().equals(column.getIdentifier())).findFirst().orElse(null);
                if (tableColumn != null) {
                    if (!tableColumn.isDefaultSize()) {
                        column.setPreferredWidth(tableColumn.getPreferredWidth());
                        continue;
                    }
                    column.setPreferredWidth(maxwidth);
                    continue;
                }
                column.setPreferredWidth(maxwidth);
                continue;
            }
            column.setPreferredWidth(maxwidth);
        }
    }

    public static void adjustPrimaryPopupTableColumnPreferredWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        if (columnModel.getColumn(0) != null) {
            columnModel.getColumn(0).setPreferredWidth(new Double((double)(EFCLookAndFeelManager.PRIMARY_TABLE_WIDTH - 18) * 0.25).intValue());
        }
        if (columnModel.getColumnCount() > 2) {
            if (columnModel.getColumn(1) != null) {
                columnModel.getColumn(1).setPreferredWidth(new Double((double)(EFCLookAndFeelManager.PRIMARY_TABLE_WIDTH - 18) * 0.25).intValue());
            }
            if (columnModel.getColumn(2) != null) {
                columnModel.getColumn(2).setPreferredWidth(new Double((double)(EFCLookAndFeelManager.PRIMARY_TABLE_WIDTH - 18) * 0.75).intValue());
            }
        } else if (columnModel.getColumn(1) != null) {
            columnModel.getColumn(1).setPreferredWidth(new Double((double)(EFCLookAndFeelManager.PRIMARY_TABLE_WIDTH - 18) * 0.75).intValue());
        }
    }

    public static void adjustSecondaryPopupTableColumnPreferredWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        if (columnModel.getColumn(0) != null) {
            columnModel.getColumn(0).setPreferredWidth(new Double((double)(EFCLookAndFeelManager.SECONDARY_TABLE_WIDTH - 18) * 0.25).intValue());
        }
        if (columnModel.getColumn(1) != null) {
            columnModel.getColumn(1).setPreferredWidth(new Double((double)(EFCLookAndFeelManager.SECONDARY_TABLE_WIDTH - 18) * 0.75).intValue());
        }
    }

    private static int getWidthByDateType(BaseType value) {
        if (value instanceof EFCMatNum) {
            return 60;
        }
        if (value instanceof EFCBupNum) {
            return 30;
        }
        if (value instanceof EFCDocNum) {
            return 40;
        }
        if (value instanceof EFCString) {
            int maxwidth = 0;
            maxwidth = (int)((EFCString)value).getMaxsize();
            if (maxwidth > 40) {
                maxwidth = 40;
            }
            if ((maxwidth = 2 * maxwidth + 20) <= 0) {
                int stringLength = 0;
                try {
                    stringLength = ((EFCString)value).getData().length();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                maxwidth = 2 * stringLength + 8;
            }
            return maxwidth;
        }
        if (value instanceof EFCCalMonth) {
            return 30;
        }
        if (value instanceof EFCCalWeek) {
            return 30;
        }
        if (value instanceof EFCOption) {
            return 25;
        }
        if (value instanceof EFCQuantity) {
            return 50;
        }
        if (value instanceof EFCMoney) {
            return 50;
        }
        if (value instanceof EFCDate) {
            return 40;
        }
        if (value instanceof EFCDateTime) {
            return 65;
        }
        if (value instanceof EFCBoolean) {
            return 10;
        }
        if (value instanceof EFCAutoNum) {
            return 30;
        }
        if (value instanceof EFCObjectId) {
            return 30;
        }
        if (value instanceof EFCDocItem) {
            return 20;
        }
        if (value instanceof EFCInteger) {
            return 20;
        }
        if (value instanceof EFCPercent) {
            return 30;
        }
        if (value instanceof EFCDuration) {
            return 50;
        }
        if (value instanceof EFCFactor) {
            return 30;
        }
        return 0;
    }

    public static void sizeColumnsToFit(JTable table, int columnMargin) {
        for (int columnIndex = 0; columnIndex < table.getColumnCount(); ++columnIndex) {
            TableColumnModel colModel = table.getColumnModel();
            TableColumn col = colModel.getColumn(columnIndex);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            for (int r = 0; r < table.getRowCount(); ++r) {
                renderer = table.getCellRenderer(r, columnIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, columnIndex), false, false, r, columnIndex);
                int currentWidth = comp.getPreferredSize().width;
                width = Math.max(width, currentWidth);
            }
            col.setPreferredWidth(width += 2 * columnMargin);
            col.setWidth(width);
        }
    }
}

