/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.table;

import de.effectivecompany.gui.components.swing.EFCNumberTableCellRenderer;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;

public class EFCNumberTable
extends JXTable
implements ChangeListener,
PropertyChangeListener,
FocusListener {
    private static final long serialVersionUID = 1222881711136150805L;
    private final JTable table;
    private Integer colSize;
    private TableColumn column;

    public EFCNumberTable(JTable table, Integer colSize) {
        this.table = table;
        this.colSize = colSize;
        this.setDefaultRenderer(Object.class, new EFCNumberTableCellRenderer());
        this.setFocusable(false);
        this.setAutoCreateColumnsFromModel(false);
        table.addPropertyChangeListener(this);
        this.column = new TableColumn();
    }

    public void updateTable() {
        this.setModel(this.table.getModel());
        this.setSelectionModel(this.table.getSelectionModel());
        this.setFont(this.table.getFont());
        this.updateRowHeight();
        this.updateModel();
        this.updateSelectionModel();
        this.column.setHeaderValue(" ");
        if (this.getColumnModel().getColumnCount() == 0) {
            this.addColumn(this.column);
        }
        if (this.colSize != null) {
            this.getColumnModel().getColumn(0).setMinWidth(this.colSize);
            this.getColumnModel().getColumn(0).setMaxWidth(this.colSize);
        } else {
            EFCColumnResizer.sizeColumnsToFit((JTable)((Object)this), 5);
        }
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void addNotify() {
        super.addNotify();
        Container c = this.getParent();
        if (c instanceof JViewport) {
            JViewport viewport = (JViewport)c;
            viewport.addChangeListener(this);
        }
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getRowHeight(int row) {
        return this.table.getRowHeight(row);
    }

    public Object getValueAt(int row, int column) {
        return Integer.toString(row + 1);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JViewport viewport = (JViewport)e.getSource();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("rowHeight".equals(e.getPropertyName())) {
            this.updateRowHeight();
        }
        if ("selectionModel".equals(e.getPropertyName())) {
            this.updateSelectionModel();
        }
        if ("model".equals(e.getPropertyName())) {
            this.updateModel();
        }
    }

    private void updateRowHeight() {
        this.setRowHeight(this.table.getRowHeight());
    }

    private void updateModel() {
        this.setModel(this.table.getModel());
    }

    private void updateSelectionModel() {
        this.setSelectionModel(this.table.getSelectionModel());
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.table.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void terminate() {
        this.table.removePropertyChangeListener(this);
        this.column = null;
        this.removeAll();
    }
}

