/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.data.chart;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.gui.data.chart.EFCDefaultCategoryDataset;
import de.effectivecompany.gui.data.chart.EFCResourceDiagramChart;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.Range;

public class EFCDefaultBarChart
extends EFCDefaultCategoryDataset
implements LazyLoader,
EFCResourceDiagramChart {
    private static final long serialVersionUID = 1L;
    protected ReentrantLock lock = new ReentrantLock();
    protected boolean loaded = false;
    private String title;
    private String domainAxisLabel;
    private String rangeAxisLabel;
    private KeyToGroupMap keyToGroupMap;
    private boolean showLegend = true;
    private boolean showTooltips = true;
    private boolean showURLs = false;
    private SubCategoryAxis subCategoryAxis;
    private List<Color> barColors;
    private Dimension dimension;
    private CategoryLabelPositions categoryLabelPositions;
    private Font diagramLableFont;
    private Font diagramTitleFont;
    private Range range;
    private Integer xAxisValueInterval;
    private Integer initFirstValue = 0;
    private Integer visibleColumnCount;

    public EFCDefaultBarChart() {
        this.setDiagramLableFont(EFCLookAndFeelManager.FONT_DIAG_LABEL);
        this.setDiagramTitleFont(EFCLookAndFeelManager.FONT_DIAG_TITLE);
        this.setCategoryLabelPositions(EFCLookAndFeelManager.GRAPH_CAPPLN_LABELPOS_CAT);
        this.setDimension(new Dimension(1500, 250));
        this.setxAxisValueInterval(7);
        this.keyToGroupMap = new KeyToGroupMap();
        this.barColors = new ArrayList<Color>();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void mapKeyToGroup(String key, String group) {
        this.keyToGroupMap.mapKeyToGroup((Comparable)((Object)key), (Comparable)((Object)group));
    }

    public void addSeriesColor(Color color) {
        this.barColors.add(color);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
    }

    @Override
    public String getDomainAxisLabel() {
        return this.domainAxisLabel;
    }

    @Override
    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }

    @Override
    public String getRangeAxisLabel() {
        return this.rangeAxisLabel;
    }

    @Override
    public void setKeyToGroupMap(KeyToGroupMap keyToGroupMap) {
        this.keyToGroupMap = keyToGroupMap;
    }

    @Override
    public KeyToGroupMap getKeyToGroupMap() {
        return this.keyToGroupMap;
    }

    @Override
    public void setLegendVisible(boolean isVisible) {
        this.showLegend = isVisible;
    }

    @Override
    public boolean getLegendVisible() {
        return this.showLegend;
    }

    @Override
    public void setTooltipsVisible(boolean isVisible) {
        this.showTooltips = isVisible;
    }

    @Override
    public boolean getTooltipsVisible() {
        return this.showTooltips;
    }

    @Override
    public void setUrlVisible(boolean isVisible) {
        this.showURLs = isVisible;
    }

    @Override
    public boolean getUrlVisible() {
        return this.showURLs;
    }

    @Override
    public void setSubCategoryAxis(SubCategoryAxis subCategoryAxis) {
        this.subCategoryAxis = subCategoryAxis;
    }

    @Override
    public SubCategoryAxis getSubCategoryAxis() {
        return this.subCategoryAxis;
    }

    @Override
    public void setSeriesColors(List<Color> colors) {
        this.barColors = colors;
    }

    @Override
    public List<Color> getSeriesColors() {
        return this.barColors;
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public CategoryLabelPositions getCategoryLabelPositions() {
        return this.categoryLabelPositions;
    }

    public void setCategoryLabelPositions(CategoryLabelPositions categoryLabelPositions) {
        this.categoryLabelPositions = categoryLabelPositions;
    }

    public Font getDiagramLableFont() {
        return this.diagramLableFont;
    }

    public void setDiagramLableFont(Font diagramFont) {
        this.diagramLableFont = diagramFont;
    }

    public Font getDiagramTitleFont() {
        return this.diagramTitleFont;
    }

    public void setDiagramTitleFont(Font diagramTitleFont) {
        this.diagramTitleFont = diagramTitleFont;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(double min, double max) {
        this.range = new Range(min, max);
    }

    public Integer getxAxisValueInterval() {
        return this.xAxisValueInterval;
    }

    public void setxAxisValueInterval(Integer xAxisValueInterval) {
        this.xAxisValueInterval = xAxisValueInterval;
    }

    public Integer getInitFirstValue() {
        return this.initFirstValue;
    }

    public void setInitFirstValue(Integer initFirstValue) {
        this.initFirstValue = initFirstValue;
    }

    public Integer getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void setVisibleColumnCount(Integer visibleColumnCount) {
        this.visibleColumnCount = visibleColumnCount;
    }
}

