/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.events;

import de.effectivecompany.gui.events.EFCAbstractEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class UserInputEvent
extends EFCAbstractEvent {
    private static final long serialVersionUID = -2866971433933008658L;
    public static final int MOUSE_BUTTON_EVENT = 2059;
    public static final int MOUSE_WHEEL_EVENT = 2060;
    public static final int KEY_PRESS_EVENT = 2061;
    public static final int KEY_TYPE_EVENT = 2062;
    public static final int KEY_RELEASE_EVENT = 2063;
    private InputEvent parentEvent;

    public UserInputEvent(JComponent source, int type, InputEvent parentEvent, String componentIdent) {
        super(source, type);
        this.parentEvent = parentEvent;
        this.setIdent(componentIdent);
    }

    public UserInputEvent(UserInputEvent e) {
        this((JComponent)e.getSource(), e.getID(), e.getParentEvent(), e.getIdent());
    }

    public boolean isMouseEvent() {
        return this.getID() == 2059 || this.getID() == 2060;
    }

    public boolean isKeyboardEvent() {
        return this.getID() == 2061;
    }

    public Character getTypedChar() {
        if (this.parentEvent.getID() != 400) {
            return null;
        }
        return Character.valueOf(((KeyEvent)this.parentEvent).getKeyChar());
    }

    public Boolean isLeftMouseButton() {
        if (!(this.parentEvent instanceof MouseEvent)) {
            return false;
        }
        return SwingUtilities.isLeftMouseButton((MouseEvent)this.parentEvent);
    }

    public Boolean isRightMouseButton() {
        if (!(this.parentEvent instanceof MouseEvent)) {
            return false;
        }
        return SwingUtilities.isRightMouseButton((MouseEvent)this.parentEvent);
    }

    public Boolean isMiddleMouseButton() {
        if (!(this.parentEvent instanceof MouseEvent)) {
            return false;
        }
        return SwingUtilities.isMiddleMouseButton((MouseEvent)this.parentEvent);
    }

    public Boolean isPopupMouseButton() {
        if (!(this.parentEvent instanceof MouseEvent)) {
            return false;
        }
        return ((MouseEvent)this.parentEvent).isPopupTrigger();
    }

    public boolean isShiftDown() {
        return this.parentEvent.isShiftDown();
    }

    public boolean isCtrlDown() {
        return this.parentEvent.isControlDown();
    }

    public boolean isAltDown() {
        return this.parentEvent.isAltDown();
    }

    public boolean isAltGraphDown() {
        return this.parentEvent.isAltGraphDown();
    }

    public InputEvent getParentEvent() {
        return this.parentEvent;
    }
}

