/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.factory;

import de.effectivecompany.app.syscl.ClSysPrnSrv;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.gui.factory.EFCPrintDocument;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaTray;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPrintDocumentPDF
implements EFCPrintDocument {
    private static Logger logger = LoggerFactory.getLogger(EFCPrintDocumentPDF.class);
    private PDDocument pdDocument;

    public EFCPrintDocumentPDF(PDDocument pdDocument) {
        this.pdDocument = pdDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(ClSysPrnSrv clSysPrnSrv) {
        Integer copies = null;
        if (clSysPrnSrv != null) {
            copies = clSysPrnSrv.getPrncopy().getData();
        }
        if (copies == null) {
            copies = 1;
        }
        logger.debug("Number of pages: {}", (Object)copies);
        String printerName = clSysPrnSrv.getPrnprintername().getData();
        logger.debug("Printername: {}", (Object)printerName);
        EFCBoolean isPrinterSelection = clSysPrnSrv.getIsprnselect();
        if (isPrinterSelection.getBoolean() == null) {
            isPrinterSelection.setData(Boolean.valueOf(true));
        }
        logger.debug("Printer selected: {}", (Object)isPrinterSelection.getBoolean());
        int traySelected = -1;
        if (!clSysPrnSrv.getPrnprintersrc().toString().equals("")) {
            traySelected = Integer.parseInt(clSysPrnSrv.getPrnprintersrc().toString());
            logger.debug("Tray selected: {}", (Object)traySelected);
        }
        try {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            HashPrintRequestAttributeSet attrSet = new HashPrintRequestAttributeSet();
            if (traySelected == -1) {
                attrSet = null;
            } else {
                PrintService[] services;
                for (PrintService service : services = PrintServiceLookup.lookupPrintServices(null, null)) {
                    Media[] medias;
                    logger.debug(service.getName());
                    for (Media media : medias = (Media[])service.getSupportedAttributeValues(Media.class, null, null)) {
                        if (!service.getName().contains(printerName) || !media.getClass().isAssignableFrom(MediaTray.class) || media.getValue() != traySelected) continue;
                        logger.debug("Name : " + media.getClass() + " - Value : " + media.getValue() + " " + media.toString());
                        MediaTray mediaTray = (MediaTray)media;
                        attrSet.add(mediaTray);
                    }
                }
            }
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
            if (printerName != null) {
                for (PrintService ps : printServices) {
                    if (ps.getName().indexOf(printerName) == -1) continue;
                    printJob.setPrintService(ps);
                    break;
                }
            } else {
                printJob.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
            }
            printJob.setCopies(copies);
            printJob.setPageable((Pageable)new PDFPageable(this.pdDocument));
            if (isPrinterSelection.getBoolean().booleanValue()) {
                if (printJob.printDialog()) {
                    printJob.print();
                }
            } else {
                printJob.print();
            }
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
        }
        finally {
            if (this.pdDocument != null) {
                // empty if block
            }
        }
    }
}

