/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.manager;

import com.google.common.io.ByteSource;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCFileName;
import de.effectivecompany.base.datatypes.EFCFilePath;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.EFCFileChooser;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.constants.EFCConstants;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import javax.swing.JInternalFrame;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCFileManager {
    private static Logger logger = LoggerFactory.getLogger(EFCFileManager.class);

    public static void openFile(EFCFilePath filepath) {
        EFCFileManager.openFile(filepath.getData());
    }

    public static void openFile(String filepath) {
        try {
            File file = new File(filepath);
            Desktop.getDesktop().open(file);
        }
        catch (IllegalArgumentException e) {
            EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_FRAME_FILEOPEN_EXCEPTION_1", (Object)filepath));
            logger.error(e.getMessage());
        }
        catch (FileNotFoundException e) {
            EFCDesktop.reportError(e);
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            EFCDesktop.reportError(e);
            logger.error(e.getMessage());
        }
    }

    public static void saveDataByFileChooser(JInternalFrame parent, byte[] data, String fileName) {
        EFCFileChooser fc = new EFCFileChooser();
        if (fileName != null && !fileName.isEmpty()) {
            fc.setSelectedFile(new File(fileName));
        }
        if (fc.showSaveDialog(parent) == 0) {
            File target = fc.getSelectedFile();
            try {
                EFCFileManager.saveDataToFile(target.getAbsolutePath(), null, null, null, data);
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static void saveDataByFileChooser(JInternalFrame parent, byte[] data) {
        EFCFileManager.saveDataByFileChooser(parent, data, null);
    }

    public static void saveDataToFile(String path, String username, String filename, String password, byte[] data) throws FileNotFoundException {
        EFCFileManager.saveDataToFile(path, username, password, filename, data, null);
    }

    public static String saveTemporaryFile(EFCString filename, byte[] data) {
        String tempfileName = UUID.randomUUID().toString() + "-" + filename.getData();
        String tempfilepath = EFCConstants.TEMP_FOLDER + tempfileName;
        try {
            EFCFileManager.saveDataToFile(EFCConstants.TEMP_FOLDER, null, null, tempfileName, data, null);
        }
        catch (FileNotFoundException e) {
            EFCDesktop.reportError(e);
        }
        return tempfilepath;
    }

    public static void saveDataToFile(EFCString filepath, EFCString filename, byte[] data) throws FileNotFoundException {
        EFCFileManager.saveDataToFile(filepath.getData(), null, null, filename.getData(), data, null);
    }

    public static void saveDataToFile(EFCString filepath, EFCString filename, byte[] data, EFCOption ediCharsetType) throws FileNotFoundException {
        EFCFileManager.saveDataToFile(filepath.getData(), null, null, filename.getData(), data, ediCharsetType);
    }

    public static void saveDataToFile(EFCString filepath, EFCString username, EFCString password, EFCString filename, byte[] data) throws FileNotFoundException {
        EFCFileManager.saveDataToFile(filepath.getData(), username.getData(), password.getData(), filename.getData(), data, null);
    }

    public static void saveDataToFile(EFCString filepath, EFCString username, EFCString password, EFCString filename, byte[] data, EFCOption ediCharsetType) throws FileNotFoundException {
        EFCFileManager.saveDataToFile(filepath.getData(), username.getData(), password.getData(), filename.getData(), data, ediCharsetType);
    }

    public static void saveDataToFile(String target, String username, String password, String filename, byte[] data, EFCOption ediCharsetType) throws FileNotFoundException {
        if (data != null) {
            logger.info("saveDataToFile(): " + target);
            try {
                if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
                    EFCFileManager.writeToSmb(target, username, password, filename, data, ediCharsetType);
                } else {
                    Object path = target;
                    if (filename != null) {
                        path = (String)path + filename;
                    }
                    File targetFile = new File((String)path);
                    if (ediCharsetType != null) {
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile, false), EFCFileManager.getCharset(ediCharsetType));
                        byte[] encodedData = new String(data).getBytes(EFCFileManager.getCharset(ediCharsetType));
                        osw.write(new String(encodedData, EFCFileManager.getCharset(ediCharsetType)));
                        osw.flush();
                        osw.close();
                    } else {
                        FileOutputStream fow = new FileOutputStream(targetFile);
                        fow.write(data);
                        fow.flush();
                        fow.close();
                    }
                    if (((String)path).contains(EFCConstants.TEMP_FOLDER)) {
                        targetFile.deleteOnExit();
                    }
                }
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static void writeToSmb(String target, String username, String password, String filename, byte[] data, EFCOption ediCharsetType) throws IOException {
        Object path = target;
        if (filename != null) {
            path = (String)path + filename;
        }
        SmbFile smbRemoteFile = EFCFileManager.getSmbFile((String)path, username, password);
        if (ediCharsetType != null) {
            data = new String(data).getBytes(EFCFileManager.getCharset(ediCharsetType));
        }
        SmbFileOutputStream smbOut = new SmbFileOutputStream(smbRemoteFile);
        smbOut.write(data);
        smbOut.flush();
        smbOut.close();
    }

    public static SmbFile getSmbFile(String path, String username, String password) throws IOException {
        BaseContext baseCxt = null;
        Properties jcifsProperties = new Properties();
        jcifsProperties.setProperty("jcifs.smb.client.enableSMB2", "true");
        jcifsProperties.setProperty("jcifs.smb.client.dfs.disabled", "true");
        PropertyConfiguration config = new PropertyConfiguration(jcifsProperties);
        baseCxt = new BaseContext((Configuration)config);
        CIFSContext auth = baseCxt.withCredentials((Credentials)new NtlmPasswordAuthenticator(username, password));
        SmbFile smbRemoteFile = new SmbFile("smb:" + path.replace("\\", "/"), auth);
        return smbRemoteFile;
    }

    public static byte[] readFromSmb(SmbFile smbFile) throws SmbException, IOException {
        return IOUtils.toByteArray((InputStream)new SmbFileInputStream(smbFile));
    }

    public static void saveTextToFile(EFCString filepath, EFCString filename, byte[] data, EFCOption ediCharsetType) throws FileNotFoundException {
        String path = filepath.getData() + filename.getData();
        File target = new File(path);
        EFCFileManager.saveTextToFile(target, data, ediCharsetType);
    }

    public static void saveTextToFile(File target, byte[] data) throws FileNotFoundException {
        EFCFileManager.saveTextToFile(target, data, null);
    }

    public static void saveTextToFile(File target, byte[] data, EFCOption ediCharsetType) throws FileNotFoundException {
        if (data != null) {
            logger.info("saveTextToFile(): " + target.getPath());
            try {
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(target)));
                Scanner scanner = new Scanner(new ByteArrayInputStream(new String(data, EFCFileManager.getCharset(ediCharsetType)).getBytes()));
                while (scanner.hasNextLine()) {
                    bw.write(scanner.nextLine());
                    if (!scanner.hasNextLine()) continue;
                    bw.newLine();
                }
                bw.flush();
                bw.close();
                scanner.close();
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static Charset getCharset(EFCOption charsettype) {
        switch (charsettype.getData()) {
            case 0: {
                return StandardCharsets.UTF_8;
            }
            case 10: {
                return StandardCharsets.UTF_8;
            }
            case 90: {
                return Charset.forName("Cp1252");
            }
            case 100: {
                return StandardCharsets.ISO_8859_1;
            }
        }
        return StandardCharsets.UTF_8;
    }

    public static List<File> getFileList(EFCFilePath filepath, EFCFileName filenamefilter) {
        if (filepath.getData() == null) {
            return new ArrayList<File>();
        }
        if (filenamefilter.getData() == null) {
            filenamefilter = new EFCFileName("");
        }
        File filesystem = new File(filepath.getData());
        File[] files = filesystem.listFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        if (files == null) {
            return fileList;
        }
        String filefilter = filenamefilter.getData().toLowerCase();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            logger.debug("File found: " + files[i].getName() + " in path: " + filepath.getData());
            if (!files[i].getName().toLowerCase().matches(filefilter) && !filenamefilter.getData().isEmpty()) continue;
            fileList.add(files[i]);
        }
        return fileList;
    }

    public static File renameFileWithTimestamp(File origfile) {
        String path = origfile.getPath();
        String ext = EFCFileManager.getExtension(origfile);
        Object newfilepath = path.substring(0, path.length() - ext.length() - 1);
        newfilepath = (String)newfilepath + "." + EFCFileManager.getTimestamp();
        if (ext.length() > 0) {
            newfilepath = (String)newfilepath + "." + ext;
        }
        origfile.renameTo(new File((String)newfilepath));
        return origfile;
    }

    public static File moveFile(File origfile, String newpath) {
        String newfilepath = newpath + origfile.getName();
        try {
            if (!origfile.renameTo(new File(newfilepath))) {
                logger.error("can't do moveFile() to: " + newfilepath);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return origfile;
    }

    public static File moveFileWithTimestamp(File origfile, String newpath) {
        String name = origfile.getName();
        String ext = EFCFileManager.getExtension(origfile);
        String newfilepath = newpath + name.substring(0, name.length() - ext.length() - 1);
        newfilepath = newfilepath + "." + EFCFileManager.getTimestamp();
        if (ext.length() > 0) {
            newfilepath = newfilepath + "." + ext;
        }
        try {
            Files.move(origfile.toPath(), new File(newfilepath).toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            logger.error("can't do moveFile() " + origfile.getPath() + " to: " + newfilepath);
            logger.error(e.getMessage());
        }
        return origfile;
    }

    public void copyFile(File source, File destination) {
        try {
            FileInputStream fileInputStream = new FileInputStream(source);
            FileOutputStream fileOutputStream = new FileOutputStream(destination);
            FileChannel inputChannel = fileInputStream.getChannel();
            FileChannel outputChannel = fileOutputStream.getChannel();
            this.transfer(inputChannel, outputChannel, source.length(), false);
            fileInputStream.close();
            fileOutputStream.close();
            destination.setLastModified(source.lastModified());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void transfer(FileChannel fileChannel, ByteChannel byteChannel, long lengthInBytes, boolean verbose) throws IOException {
        long overallBytesTransfered = 0L;
        long chunckSizeInBytes = 0x100000L;
        long time = -System.currentTimeMillis();
        while (overallBytesTransfered < lengthInBytes) {
            long bytesTransfered = 0L;
            bytesTransfered = fileChannel.transferTo(overallBytesTransfered, Math.min(chunckSizeInBytes, lengthInBytes - overallBytesTransfered), byteChannel);
            logger.info("overall bytes transfered: " + (overallBytesTransfered += bytesTransfered) + " progress " + Math.round((double)overallBytesTransfered / (double)lengthInBytes * 100.0) + "%");
        }
        logger.info("Transfered: " + overallBytesTransfered + " bytes in: " + (time += System.currentTimeMillis()) / 1000L + " s -> " + (double)overallBytesTransfered / 1024.0 / ((double)time / 1000.0) + " kbytes/s");
    }

    public static String getExtension(File file) {
        return EFCFileManager.getExtensionString(file.getName());
    }

    public static String getExtension(EFCFilePath filepath) {
        return EFCFileManager.getExtensionString(filepath.getData());
    }

    public static String getExtension(EFCFileName filename) {
        return EFCFileManager.getExtensionString(filename.getData());
    }

    private static String getExtensionString(String filepath) {
        String extension = null;
        String string = filepath;
        int i = string.lastIndexOf(46);
        if (i > 0 && i < string.length() - 1) {
            extension = string.substring(i + 1).toLowerCase();
        }
        return extension;
    }

    private static String getTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public static Boolean lockFile(File file) throws SecurityException {
        return file.setWritable(false);
    }

    public static Boolean unLockFile(File file) throws SecurityException {
        return file.setWritable(true);
    }

    public static Boolean deleteFile(File file) throws SecurityException {
        return file.delete();
    }

    public static Boolean deleteFile(EFCString filepath, EFCString filename) throws SecurityException {
        String path = filepath.getData() + filename.getData();
        File target = new File(path);
        return EFCFileManager.deleteFile(target);
    }

    public static String readStringFromFile(File file) throws IOException {
        return new String(EFCFileManager.readByteArrayFromFile(file));
    }

    public static byte[] readByteArrayFromFile(File file) throws IOException {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        byte[] data = Files.readAllBytes(path);
        return data;
    }

    public static EFCBlob readEFCBlobFromFile(File file) throws IOException {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        byte[] data = Files.readAllBytes(path);
        return new EFCBlob(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EFCBlob readEFCBlobFromUri(String uri) throws ClientProtocolException, IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(uri);
        EFCBlob content = null;
        try (final CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet);){
            logger.info(response1.getStatusLine().toString());
            ByteSource byteSource = new ByteSource(){

                public InputStream openStream() throws IOException {
                    return response1.getEntity().getContent();
                }
            };
            content = new EFCBlob(byteSource.read());
        }
        return content;
    }
}

