/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.manager;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import de.effectivecompany.app.app.service.SvSysApp;
import de.effectivecompany.app.sys.MdSysXml;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.manager.EFCPropertyManager;
import de.effectivecompany.gui.util.ResourceLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import net.sf.jasperreports.engine.fonts.FontExtensionsRegistry;
import net.sf.jasperreports.engine.fonts.FontFamily;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;

public class EFCLookAndFeelManager {
    private static Logger logger = LoggerFactory.getLogger(EFCLookAndFeelManager.class);
    private static EFCLookAndFeelManager instance;
    public static Font FONT_EFC_STANDARD;
    public static Font FONT_MENU;
    public static Font FONT_FORM_LABEL;
    public static javafx.scene.text.Font FONT_FORM_LABEL_FX;
    public static Font FONT_FORM;
    public static javafx.scene.text.Font FONT_FORM_FX;
    public static Font FONT_FORM_INFOTEXT;
    public static Font FONT_GRAPH_LABEL;
    public static Font FONT_STATUSBAR;
    public static Font FONT_TABLE_HEADER;
    public static Font FONT_TABLE_CELLS;
    public static Font FONT_TABPAGE_HEADER;
    public static javafx.scene.text.Font FONT_NAVIGATOR;
    public static Font FONT_CODE;
    public static Character DECIMAL_SEPARATOR;
    public static Character GROUPING_SEPARATOR;
    public static Font FONT_DIAG_LABEL;
    public static Font FONT_DIAG_TITLE;
    public static Font FONT_GANTT_TITLE;
    public static Font FONT_GANTT_LABEL;
    public static Font FONT_FRAME_BACKGROUND;
    public static Map<String, Font> FONT_TABLE_CELLS_MAP;
    public static int PRIMARY_TABLE_WIDTH;
    public static int PRIMARY_TABLE_HEIGHT;
    public static int SECONDARY_TABLE_WIDTH;
    public static int SECONDARY_TABLE_HEIGHT;
    public static int SEARCH_TABLE_WIDTH;
    public static int SEARCH_TABLE_HEIGHT;
    public static int TAB_LAYOUT_POLICY;
    public static int SEARCH_POLICY;
    public static int size_col_label;
    private static final int size_col_labeldataspace = 1;
    private static final int size_col_data = 29;
    private static final int size_col_nextcolspace = 2;
    private static final int size_col_gap = 16;
    private static final int size_row_space = 2;
    private static final int size_row_data = 12;
    private static final int size_row_gap = 12;
    private static final String size_font_standard = "12";
    private static final String size_font_standard_tableheader = "10";
    private static final String size_font_standard_tabpagehheader = "10";
    private static final String size_font_standard_graohlabel = "8";
    public static boolean IS_REMOTE_DESKTOP_SESSION;
    public static boolean IS_TEST_VERSION;
    public static boolean isAdmin;
    public static final Double GRAPH_CAPPLN_LEVEL_FULL;
    public static final Double GRAPH_CAPPLN_LEVEL_OVER;
    public static final CategoryLabelPositions GRAPH_CAPPLN_LABELPOS_CAT;
    public static final Color GRAPH_CAPPLN_COLOR_LOAD_FULL;
    public static final Color GRAPH_CAPPLN_COLOR_LOAD_OVER;
    public static final Color GRAPH_CAPPLN_COLOR_LOAD_PARTIAL;
    public static final Color GRAPH_CAPPLN_COLOR_LOAD_ZERO;
    public static final Color GRAPH_CAPPLN_COLOR_LOAD_OLD;
    public static final Color GRAPH_CAPPLN_COLOR_PRD;
    public static final Color GRAPH_MATAVAIL_COLOR_ZERO;
    public static final Color GRAPH_MATAVAIL_COLOR_PARTIAL;
    public static final Color GRAPH_MATAVAIL_COLOR_FULL;
    public static final Color TERMINAL_BACKGROUND_CENTER;
    public static final String TERMINAL_BACKGROUND_ICON = "W\u00fchler & Gebauer EDV-Consulting GmbH";
    public static final String TERMINAL_BACKGROUND_INFO = "TERMINAL VERSION - \u00a9 2020 W\u00fchler & Gebauer EDV-Consulting GmbH - W&G effective company\u00ae - TERMINAL VERSION";
    public static final String TESTVERSION_BACKGROUND = "TEST VERSION";
    public static final javafx.scene.image.Image ICON_SPLASH;
    public static final ImageIcon ICON_BACKGROUND_CENTER;
    public static final ImageIcon ICON_BACKGROUND_ICON;
    public static final ImageIcon ICON_BACKGROUND_INFO;
    public static final javafx.scene.image.Image ICON_MENU_FOLDER_OPENED;
    public static final javafx.scene.image.Image ICON_MENU_FOLDER_CLOSED;
    public static final javafx.scene.image.Image ICON_MENU_LEAF;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_MASTER;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_STATISTIC;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_TRANSACTION;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_WORKFLOW;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_INFO;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_CHECKLIST;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_TERMINAL;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_EXTERNAL;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_EXTERNAL_EXE;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_EXTERNAL_OFFICE;
    public static final javafx.scene.image.Image ICON_MENU_LEAF_EXTERNAL_STATISTIC;
    public static final ImageIcon ICON_TOOLBAR_ACTUALIZE;
    public static final ImageIcon ICON_TOOLBAR_CALCULATOR;
    public static final ImageIcon ICON_TOOLBAR_EMAIL;
    public static final ImageIcon ICON_TOOLBAR_CANCEL;
    public static final ImageIcon ICON_TOOLBAR_COPY;
    public static final ImageIcon ICON_TOOLBAR_DATA_EXPORT;
    public static final ImageIcon ICON_TOOLBAR_DATA_EXPORT_HD;
    public static final ImageIcon ICON_TOOLBAR_DATA_EXPORT_CB;
    public static final ImageIcon ICON_TOOLBAR_DELETE;
    public static final ImageIcon ICON_TOOLBAR_DOCFLOW_CLOSE;
    public static final ImageIcon ICON_TOOLBAR_DOCFLOW_CONTINUE;
    public static final ImageIcon ICON_TOOLBAR_DOCFLOW_TAKEOVER;
    public static final ImageIcon ICON_TOOLBAR_EDITOR;
    public static final ImageIcon ICON_TOOLBAR_EXIT;
    public static final ImageIcon ICON_TOOLBAR_GO_NEXT;
    public static final ImageIcon ICON_TOOLBAR_GO_PREV;
    public static final ImageIcon ICON_TOOLBAR_HELP;
    public static final ImageIcon ICON_TOOLBAR_FRAMEINFO;
    public static final ImageIcon ICON_TOOLBAR_INFO_CUSTOMER;
    public static final ImageIcon ICON_TOOLBAR_INFO_MAT;
    public static final ImageIcon ICON_TOOLBAR_INFO_DOC;
    public static final ImageIcon ICON_TOOLBAR_INFO_INVDOC;
    public static final ImageIcon ICON_TOOLBAR_INFO_MRP;
    public static final ImageIcon ICON_TOOLBAR_INFO_PRDDOC;
    public static final ImageIcon ICON_TOOLBAR_INFO_INVSTK;
    public static final ImageIcon ICON_TOOLBAR_INFO_VENDOR;
    public static final ImageIcon ICON_TOOLBAR_LIST_ADD;
    public static final ImageIcon ICON_TOOLBAR_LIST_REMOVE;
    public static final ImageIcon ICON_TOOLBAR_NEW;
    public static final ImageIcon ICON_TOOLBAR_OPEN;
    public static final ImageIcon ICON_TOOLBAR_GOTO;
    public static final ImageIcon ICON_TOOLBAR_GOTOEDIT;
    public static final ImageIcon ICON_TOOLBAR_PRINT_DEFAULT;
    public static final ImageIcon ICON_TOOLBAR_PRINT_BATCH;
    public static final ImageIcon ICON_TOOLBAR_PRINT_DOC;
    public static final ImageIcon ICON_TOOLBAR_PRINT_LIST;
    public static final ImageIcon ICON_TOOLBAR_PRINT_LABEL;
    public static final ImageIcon ICON_TOOLBAR_PRINT_DIRECT;
    public static final ImageIcon ICON_TOOLBAR_RELATED_DOCS;
    public static final ImageIcon ICON_TOOLBAR_SAVE;
    public static final ImageIcon ICON_TOOLBAR_SEARCH;
    public static final ImageIcon ICON_TOOLBAR_SYSCONFIG;
    public static final ImageIcon ICON_TOOLBAR_DROPDOWN;
    public static final ImageIcon ICON_TOOLBAR_WINDOW_LOCK;
    public static final ImageIcon ICON_TOOLBAR_WINDOW_UNLOCK;
    public static final ImageIcon ICON_TOOLBAR_FORMAT_ITALIC;
    public static final ImageIcon ICON_TOOLBAR_FORMAT_UNDELINE;
    public static final ImageIcon ICON_TOOLBAR_FORMAT_BOLD;
    public static final ImageIcon ICON_TOOLBAR_FORMAT_CENTER;
    public static final ImageIcon ICON_TOOLBAR_FORMAT_LEFT;
    public static final ImageIcon ICON_TOOLBAR_FORMAT_RIGHT;
    public static List<Image> ICON_APP;
    public static List<javafx.scene.image.Image> ICON_APP_FX;
    public static final ImageIcon ICON_APP_WUG;
    public static final ImageIcon ICON_APP_MASTER;
    public static final ImageIcon ICON_APP_DIALOG;
    public static final ImageIcon ICON_APP_TRANSACTION;
    public static final ImageIcon ICON_APP_WORKFLOW;
    public static final ImageIcon ICON_APP_TERMINAL;
    public static final ImageIcon ICON_APP_STATISTIC;
    public static final ImageIcon ICON_APP_INFO;
    public static final ImageIcon ICON_APP_CHECKLIST;
    public static final ImageIcon ICON_APP_HELP_BROWSER;
    public static final ImageIcon ICON_APP_TEXT_EDITOR;
    public static final ImageIcon ICON_APP_CALCULATOR;
    public static final javafx.scene.image.Image ICON_TOOLBAR_ACTUALIZE_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_CALCULATOR_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_EMAIL_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_CANCEL_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_COPY_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DATA_EXPORT_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DATA_EXPORT_HD_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DATA_EXPORT_CB_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DELETE_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DOCFLOW_CLOSE_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DOCFLOW_CONTINUE_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DOCFLOW_TAKEOVER_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_EDITOR_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_EXIT_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_GO_NEXT_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_GO_PREV_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_HELP_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_FRAMEINFO_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_CUSTOMER_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_MAT_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_DOC_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_INVDOC_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_MRP_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_PRDDOC_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_INVSTK_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_INFO_VENDOR_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_LIST_ADD_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_LIST_REMOVE_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_NEW_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_OPEN_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_GOTO_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_GOTO_EDIT_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_PRINT_DEFAULT_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_PRINT_BATCH_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_PRINT_DOC_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_PRINT_LIST_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_PRINT_LABEL_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_PRINT_DIRECT_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_RELATED_DOCS_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_STARTBATCH_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_SAVE_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_SEARCH_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_SYSCONFIG_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_DROPDOWN_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_WINDOW_LOCK_FX;
    public static final javafx.scene.image.Image ICON_TOOLBAR_WINDOW_UNLOCK_FX;
    public static final javafx.scene.image.Image ICON_WFL_HIDE;
    public static final javafx.scene.image.Image ICON_APP_WUG_FX;
    public static final javafx.scene.image.Image ICON_APP_TITLE_FX;
    public static final javafx.scene.image.Image ICON_APP_MASTER_FX;
    public static final javafx.scene.image.Image ICON_APP_DIALOG_FX;
    public static final javafx.scene.image.Image ICON_APP_TRANSACTION_FX;
    public static final javafx.scene.image.Image ICON_APP_WORKFLOW_FX;
    public static final javafx.scene.image.Image ICON_APP_STATISTIC_FX;
    public static final javafx.scene.image.Image ICON_APP_INFO_FX;
    public static final javafx.scene.image.Image ICON_APP_CHECKLIST_FX;
    public static final javafx.scene.image.Image ICON_APP_HELP_BROWSER_FX;
    public static final javafx.scene.image.Image ICON_APP_TEXT_EDITOR_FX;
    public static final javafx.scene.image.Image ICON_APP_CALCULATOR_FX;
    public static final javafx.scene.image.Image ICON_APP_SENDMSG_FX;
    public static final javafx.scene.image.Image ICON_APP_EFC_LOGIN_FX;
    public static final ImageIcon ICON_FIELDINFO_SCROLL;
    public static final ImageIcon ICON_FIELDINFO_KEY;
    public static final ImageIcon ICON_FIELDINFO_ERROR;
    public static final ImageIcon ICON_FIELDINFO_SEARCH;
    public static final ImageIcon ICON_FIELDINFO_QUICKSEARCH;
    public static final ImageIcon ICON_FIELDINFO_WARNING;
    public static final ImageIcon ICON_BUTTON_POPUP_CALENDAR;
    public static final ImageIcon ICON_BUTTON_POPUP_DROPDOWN;
    public static final String SYSTEM_FRAME_TITLE = "effective company";
    public static final String SYSTEM_MENU_ROOT_TITLE = "effective company";
    public static final Color COLOR_WUG_LOGO;
    public static final Color COLOR_DESKTOP_BACKGROUND;
    public static final javafx.scene.paint.Color COLORFX_DESKTOP_BACKGROUND;
    public static final Color COLOR_STARTMENU_BACKGROUND;
    public static final Color COLOR_INFOTEXT_BACKGROUND;
    public static final Color COLOR_INFOTEXT_TEXT;
    public static final Color COLOR_TABPAGE_SELECTED;
    public static final Color COLOR_TABLE_TEXT_DELETEDROW;
    public static final Color COLOR_TABLE_TEXT_NEWROW;
    public static final Color COLOR_TABLE_TEXT_NEWROW_SELECTED;
    public static final Color COLOR_TABLE_GRID;
    public static final Color COLOR_TABLE_MSG_ERROR;
    public static final Color COLOR_TABLE_MSG_INFO;
    public static final Color COLOR_TABLE_MSG_WARNING;
    public static final Border STYLE_BUTTON_TOOLBAR_BORDER;
    public static final Border STYLE_DESKTOP_BORDER;
    public static final Border STYLE_INFOTEXT_BORDER;
    public static final Dimension SIZE_BUTTON_TOOLBAR;
    private static int size_col_sum;
    private static int size_row_sum;
    public static double SIZE_MULTIPLIER;
    public static Dimension SIZE_FRAME_STANDARD;
    public static Dimension SIZE_FRAME_STATISTIC;
    public static Dimension SIZE_FRAME_WORKFLOW;
    public static Dimension SIZE_FRAME_SUBDATA;
    public static Dimension SIZE_FRAME_SUBDATA_DMS;
    public static Dimension SIZE_FRAME_SUBDATA_MRP;
    public static Dimension SIZE_FRAME_CHECKLIST;
    public static Dimension SIZE_FRAME_CHECKLIST_LONG;
    public static Dimension SIZE_FRAME_FULL;
    public static Dimension SIZE_FRAME_DEFAULT;
    public static final Dimension SIZE_FRAME_SEARCH;
    public static final Dimension SIZE_FRAME_DYNAMIC;
    public static final Dimension SIZE_FRAME_PRINT_PREVIEW;
    public static final Dimension SIZE_FRAME_NAVIGATOR;
    public static final Dimension SIZE_FRAME_CODE_EDITOR;
    public static final Dimension SIZE_FRAME_FULLSIZE_GRAPH;
    public static final Dimension SIZE_FRAME_PRDNET;
    public static final Dimension SIZE_DIALOG_DEFAULT;
    public static final Dimension SIZE_DIALOG_SMALL;
    public static final Dimension SIZE_DIALOG_MEDIUM;
    public static final Dimension SIZE_DIALOG_COPY;
    public static final Dimension SIZE_DIALOG_WIDE;
    public static final Dimension SIZE_DIALOG_LARGE;
    public static final Dimension SIZE_DIALOG_DATA_EXPORT;
    public static final Dimension SIZE_DIALOG_PRINTSELECTION;
    public static final Dimension SIZE_DIALOG_FRAMEINFO;
    public static final Dimension SIZE_DIALOG_MESSAGELIST;
    public static final Border TABLE_BORRDER_OUTSIDE;
    public static final Border TABLE_BORRDER_EMPTYBORDER;
    public static final Border TABLE_CELL_BORRDER_OUTSIDE;
    public static final Border TABLE_CELL_BORRDER_EMPTYBORDER;
    public static final Border TABLE_CELL_BORRDER_INSIDE;
    public static final Border TABLE_CELL_BORRDER_HIGHLIGHT;
    public static final Border TABLE_CELL_EDITOR_NOFOCUSBORDER;
    public static ColumnSpec SIZE_COL_LABEL;
    public static ColumnSpec SIZE_COL_LABELDATASPACE;
    public static ColumnSpec SIZE_COL_DATA;
    public static ColumnSpec SIZE_COL_NEXTCOLSPACE;
    public static RowSpec SIZE_ROW_SPACE;
    public static RowSpec SIZE_ROW_DATA;
    public static final String SIZE_FRAME_BORDER_TOP = "3dlu";
    public static final String SIZE_FRAME_BORDER_LEFT = "3dlu";
    public static final int SIZE_CHAR_FIRSTCOL = 3;
    public static final int SIZE_CHAR_COL = 14;
    public static final int WEEKDAY_LABEL_WIDTH = 12;
    public static final Insets SIZE_TEXTFIELD_INSETS;
    public static List<Icon> EXPLORER_ICONS_OPEN;
    public static List<Icon> EXPLORER_ICONS_CLOSED;

    private EFCLookAndFeelManager() {
    }

    public static EFCLookAndFeelManager getInstance() {
        if (instance == null) {
            instance = new EFCLookAndFeelManager();
        }
        return instance;
    }

    public static Rectangle getVirtualScreenSize() {
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                virtualBounds = virtualBounds.union(gc[i].getBounds());
            }
        }
        return virtualBounds;
    }

    public static boolean locationInVirtualSize(int x, int y) {
        Rectangle virualSize = EFCLookAndFeelManager.getVirtualScreenSize();
        return virualSize.contains(x, y);
    }

    public static boolean locationInVirtualSize(Point location) {
        return EFCLookAndFeelManager.locationInVirtualSize(location.x, location.y);
    }

    public void initCustomClientProps() {
        Properties props;
        SvSysApp svSysApp = (SvSysApp)SpringHelper.getService(SvSysApp.class);
        IS_TEST_VERSION = svSysApp.getIsTestSystem().getBoolean();
        isAdmin = svSysApp.getMdSysUsrBas().getUsergrp().getData().equals(0);
        String usrName = svSysApp.getUsrName().getData();
        EFCList clientProps = svSysApp.getClientPropsList();
        String properties = null;
        String user = "*";
        for (MdSysXml mdSysXml : clientProps) {
            if (!mdSysXml.getUsername().toString().equals(usrName) || !"LAFDefaults".equals(mdSysXml.getSysprogcode().getData()) || mdSysXml == null || mdSysXml.getCode().getData() == null || mdSysXml.getCode().getData().trim().isEmpty()) continue;
            properties = mdSysXml.getCode().getData();
            user = usrName;
        }
        if (properties == null) {
            for (MdSysXml mdSysXml : clientProps) {
                if (properties != null || !mdSysXml.getUsername().toString().equals("*") || !"LAFDefaults".equals(mdSysXml.getSysprogcode().getData()) || mdSysXml == null || mdSysXml.getCode().getData() == null || mdSysXml.getCode().getData().trim().isEmpty()) continue;
                properties = mdSysXml.getCode().getData();
            }
        }
        if (properties == null) {
            props = EFCPropertyManager.getClientProperties();
            StringWriter writer = new StringWriter();
            props.list(new PrintWriter(writer));
            properties = writer.getBuffer().toString();
            logger.info("Standard Client Properties loaded");
        } else {
            logger.info("Custom Client Properties loaded for User: " + user);
        }
        if (properties != null && !properties.isEmpty()) {
            props = new Properties();
            try {
                props.load(new StringReader(properties));
            }
            catch (IOException e) {
                logger.error("Error loading Custom Client Properties", (Throwable)e);
            }
            EFCLookAndFeelManager.loadProperties(props);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                UIManager.put("TableHeader.font", FONT_TABLE_HEADER);
                UIManager.put("Table.gridColor", COLOR_TABLE_GRID);
                UIManager.put("PopupMenu.font", FONT_MENU);
                UIManager.put("Menu.font", FONT_MENU);
                UIManager.put("MenuBar.font", FONT_MENU);
                UIManager.put("MenuItem.font", FONT_MENU);
                UIManager.put("MenuItem.acceleratorFont", FONT_MENU.deriveFont(2));
                UIManager.put("TabbedPane.font", FONT_TABPAGE_HEADER);
                UIManager.put("TabbedPane.selected", COLOR_TABPAGE_SELECTED);
                UIManager.put("ToolTip.font", FONT_MENU.deriveFont(2));
                UIManager.put("Tree.font", FONT_MENU);
                UIManager.put("Tree.background", COLOR_STARTMENU_BACKGROUND);
                UIManager.put("Tree.textBackground", COLOR_STARTMENU_BACKGROUND);
                UIManager.put("Panel.font", FONT_FORM);
                UIManager.put("Button.font", FONT_FORM);
                UIManager.put("TextArea.font", FONT_FORM);
                UIManager.put("TextField.font", FONT_FORM);
                UIManager.put("Label.font", FONT_FORM_LABEL);
                UIManager.put("ComboBox.font", FONT_FORM);
                UIManager.put("OptionPane.font", FONT_FORM);
                UIManager.put("InternalFrame.titleFont", FONT_FORM);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadProperties(Properties props) {
        String fontName;
        double multiplier;
        String propValue = props.getProperty("multiplier", "1.0");
        SIZE_MULTIPLIER = multiplier = Double.parseDouble(propValue);
        propValue = props.getProperty("font.standard.size", size_font_standard);
        Integer standardFontSize = Integer.parseInt(propValue);
        int fontSize = Integer.parseInt(propValue);
        fontSize = (int)((double)fontSize * multiplier);
        String standardFontName = fontName = props.getProperty("font.standard.name", "Roboto");
        FONT_EFC_STANDARD = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: standard font: " + standardFontName + " " + standardFontSize);
        fontSize = Integer.parseInt(props.getProperty("font.menu.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.menu.name", standardFontName);
        FONT_MENU = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: menu font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.form.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.form.name", standardFontName);
        FONT_FORM = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: form (inputfield) font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.form_label.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.form_label.name", standardFontName);
        FONT_FORM_LABEL = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: form label font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.form_infotext.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.form_infotext.name", standardFontName);
        FONT_FORM_INFOTEXT = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: form infotext font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.graph_label.size", size_font_standard_graohlabel));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.graph_label.name", standardFontName);
        FONT_GRAPH_LABEL = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: graph label font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.statusbar.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.statusbar.name", standardFontName);
        FONT_STATUSBAR = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: form statusbar font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.table_header.size", "10"));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.table_header.name", standardFontName);
        FONT_TABLE_HEADER = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: table header font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.table_cells.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.table_cells.name", standardFontName);
        FONT_TABLE_CELLS = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: table cell font: " + fontName + " " + fontSize);
        FONT_TABLE_CELLS_MAP = new HashMap<String, Font>();
        propValue = props.getProperty("font.table_cells_map", "");
        if (!propValue.isEmpty()) {
            try {
                for (String font : propValue.split("\\|")) {
                    String colName = font.split(":")[0];
                    fontName = font.split(":")[1];
                    int fontStyle = font.split(":").length > 2 ? EFCLookAndFeelManager.getFontStyle(font.split(":")[2]) : 0;
                    int colFontSize = font.split(":").length > 3 ? Integer.parseInt(font.split(":")[3]) : fontSize;
                    FONT_TABLE_CELLS_MAP.put(colName, new Font(fontName, fontStyle, fontSize));
                    logger.info("Look+Feel: table cell font for column " + colName + ": " + fontName + " (" + fontStyle + ") " + colFontSize);
                }
            }
            catch (IndexOutOfBoundsException ex) {
                logger.error(ex.getMessage());
            }
        }
        fontSize = Integer.parseInt(props.getProperty("font.tabpage_header.size", "10"));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.tabpage_header.name", standardFontName);
        FONT_TABPAGE_HEADER = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: tabpage header font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.navigator.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.navigator.name", standardFontName);
        FONT_NAVIGATOR = new javafx.scene.text.Font(fontName, (double)fontSize);
        logger.info("Look+Feel: navigator font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.code.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.code.name", "Monospaced");
        FONT_CODE = new Font(fontName, 0, fontSize);
        logger.info("Look+Feel: code font: " + fontName + " " + fontSize);
        fontSize = Integer.parseInt(props.getProperty("font.terminal.size", standardFontSize.toString()));
        fontSize = (int)((double)fontSize * multiplier);
        fontName = props.getProperty("font.terminal.name", "SansSerif");
        FONT_FRAME_BACKGROUND = new Font(fontName, 1, fontSize);
        logger.info("Look+Feel: terminal font: " + fontName + " " + fontSize);
        FONT_DIAG_LABEL = FONT_FORM_LABEL.deriveFont(new Float(FONT_FORM_LABEL.getSize() - 4).floatValue());
        FONT_DIAG_TITLE = FONT_FORM_LABEL.deriveFont(1);
        FONT_GANTT_LABEL = FONT_FORM_LABEL.deriveFont(new Float(FONT_FORM_LABEL.getSize() - 4).floatValue());
        FONT_GANTT_TITLE = FONT_FORM_LABEL.deriveFont(1);
        propValue = props.getProperty("tab.layout.policy", "SCROLL");
        if (propValue.equalsIgnoreCase("SCROLL")) {
            TAB_LAYOUT_POLICY = 1;
            logger.info("Look+Feel: tab-layout policy: scroll");
        } else if (propValue.equalsIgnoreCase("WRAP")) {
            TAB_LAYOUT_POLICY = 0;
            logger.info("Look+Feel: tab-layout policy: wrap");
        } else {
            TAB_LAYOUT_POLICY = 1;
            logger.info("Look+Feel: tab-layout policy: scroll");
        }
        propValue = props.getProperty("search.policy", "CONTAINS");
        if (propValue.equalsIgnoreCase("CONTAINS")) {
            SEARCH_POLICY = 0;
            logger.info("Look+Feel: search policy: contains");
        } else if (propValue.equalsIgnoreCase("LIKE")) {
            SEARCH_POLICY = 1;
            logger.info("Look+Feel: search policy: like");
        } else {
            SEARCH_POLICY = 0;
            logger.info("Look+Feel: search policy: contains");
        }
        propValue = props.getProperty("size.col_label", "38");
        fontSize = (int)((double)Integer.parseInt(propValue) * multiplier);
        logger.info("Look+Feel: size for labels: " + fontSize + " (dlu)");
        size_col_label = fontSize;
        propValue = props.getProperty("decimal_separator", null);
        DECIMAL_SEPARATOR = propValue != null ? new Character(propValue.charAt(0)) : null;
        propValue = props.getProperty("grouping_separator", null);
        GROUPING_SEPARATOR = propValue != null ? new Character(propValue.charAt(0)) : null;
        propValue = props.getProperty("isterminal", "false");
        IS_REMOTE_DESKTOP_SESSION = Boolean.parseBoolean(propValue);
        size_col_sum = size_col_label + 1 + 29 + 2;
        size_row_sum = 14;
        SIZE_FRAME_STATISTIC = SIZE_FRAME_STANDARD = new Dimension(7 * size_col_sum + 16, 21 * size_row_sum + 12);
        SIZE_FRAME_WORKFLOW = SIZE_FRAME_STANDARD;
        SIZE_FRAME_SUBDATA = new Dimension(4 * size_col_sum + 16, 21 * size_row_sum + 12);
        SIZE_FRAME_SUBDATA_DMS = new Dimension(6 * size_col_sum + 16, 21 * size_row_sum + 12);
        SIZE_FRAME_SUBDATA_MRP = new Dimension(6 * size_col_sum + 16, 21 * size_row_sum + 12);
        SIZE_FRAME_CHECKLIST = new Dimension(4 * size_col_sum + 16, 17 * size_row_sum + 12);
        SIZE_FRAME_CHECKLIST_LONG = new Dimension(4 * size_col_sum + 16, 21 * size_row_sum + 12);
        SIZE_FRAME_FULL = new Dimension(10 * size_col_sum + 16, 21 * size_row_sum + 12);
        SIZE_FRAME_DEFAULT = SIZE_FRAME_STANDARD;
        SIZE_COL_LABEL = ColumnSpec.decode((String)("left:" + size_col_label + "dlu"));
        SIZE_COL_LABELDATASPACE = ColumnSpec.decode((String)"1dlu");
        SIZE_COL_DATA = ColumnSpec.decode((String)"29dlu");
        SIZE_COL_NEXTCOLSPACE = ColumnSpec.decode((String)"2dlu");
        FONT_FORM_LABEL_FX = new javafx.scene.text.Font(FONT_FORM_LABEL.getName(), (double)FONT_FORM_LABEL.getSize());
        FONT_FORM_FX = new javafx.scene.text.Font(FONT_FORM.getName(), (double)FONT_FORM.getSize());
        SIZE_ROW_SPACE = RowSpec.decode((String)"2dlu");
        SIZE_ROW_DATA = RowSpec.decode((String)"center:12dlu");
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }

    public static int getFontStyle(String colFontStyle) {
        int style = 0;
        switch (colFontStyle) {
            case "plain": {
                style = 0;
                break;
            }
            case "bold": {
                style = 1;
                break;
            }
            case "italic": {
                style = 2;
                break;
            }
            case "bolditalic": {
                style = 3;
            }
        }
        return style;
    }

    static {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<String> location = new ArrayList<String>();
        location.add("fontsfamily.xml");
        FontExtensionsRegistry extension = new FontExtensionsRegistry(location);
        extension.getExtensions(FontFamily.class).forEach(ext -> {
            if (ext.getNormalFace() != null && ext.getNormalFace().getFont() != null) {
                ge.registerFont(ext.getNormalFace().getFont());
            }
        });
        try {
            CefSettings settings = new CefSettings();
            settings.log_severity = CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
            Path tmpDir = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
            tmpDir.toFile().deleteOnExit();
            settings.root_cache_path = tmpDir.toString();
            settings.windowless_rendering_enabled = true;
            CefSettings cefSettings = settings;
            Objects.requireNonNull(cefSettings);
            settings.background_color = new CefSettings.ColorType(cefSettings, 1, 211, 211, 211);
            CefApp.startup((String[])new String[0]);
            CefApp.getInstance((CefSettings)settings);
        }
        catch (RuntimeException | UnsatisfiedLinkError e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FONT_EFC_STANDARD = new Font("Roboto", 0, 12);
        PRIMARY_TABLE_WIDTH = 400;
        PRIMARY_TABLE_HEIGHT = 250;
        SECONDARY_TABLE_WIDTH = 300;
        SECONDARY_TABLE_HEIGHT = 200;
        SEARCH_TABLE_WIDTH = 300;
        SEARCH_TABLE_HEIGHT = 200;
        isAdmin = false;
        UIManager.put("CalendarHeaderHandler", "de.effectivecompany.gui.components.jcalendar.calendar.EFCDatePickerHeader");
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        GRAPH_CAPPLN_LEVEL_FULL = 0.9;
        GRAPH_CAPPLN_LEVEL_OVER = 1.0;
        GRAPH_CAPPLN_LABELPOS_CAT = CategoryLabelPositions.DOWN_90;
        GRAPH_CAPPLN_COLOR_LOAD_FULL = Color.ORANGE;
        GRAPH_CAPPLN_COLOR_LOAD_OVER = Color.RED;
        GRAPH_CAPPLN_COLOR_LOAD_PARTIAL = Color.YELLOW;
        GRAPH_CAPPLN_COLOR_LOAD_ZERO = Color.GREEN;
        GRAPH_CAPPLN_COLOR_LOAD_OLD = Color.PINK;
        GRAPH_CAPPLN_COLOR_PRD = Color.BLUE;
        GRAPH_MATAVAIL_COLOR_ZERO = Color.RED;
        GRAPH_MATAVAIL_COLOR_PARTIAL = Color.YELLOW;
        GRAPH_MATAVAIL_COLOR_FULL = Color.GREEN;
        TERMINAL_BACKGROUND_CENTER = Color.BLACK;
        ICON_SPLASH = ResourceLoader.getImageFxResource("/png/splash.png");
        ICON_BACKGROUND_CENTER = ResourceLoader.getImageIconResource("/png/background_center.png");
        ICON_BACKGROUND_ICON = ResourceLoader.getImageIconResource("/png/background_icon.png");
        ICON_BACKGROUND_INFO = ResourceLoader.getImageIconResource("/png/background_info.png");
        ICON_MENU_FOLDER_OPENED = ResourceLoader.getImageFxResource("/png/icon_menu_folder_opened.png");
        ICON_MENU_FOLDER_CLOSED = ResourceLoader.getImageFxResource("/png/icon_menu_folder_closed.png");
        ICON_MENU_LEAF = ResourceLoader.getImageFxResource("/png/icon_app_efc_12x12.png");
        ICON_MENU_LEAF_MASTER = ResourceLoader.getImageFxResource("/png/icon_app_masterdata_12x12.png");
        ICON_MENU_LEAF_STATISTIC = ResourceLoader.getImageFxResource("/png/icon_app_statisticdata_12x12.png");
        ICON_MENU_LEAF_TRANSACTION = ResourceLoader.getImageFxResource("/png/icon_app_transactiondata_12x12.png");
        ICON_MENU_LEAF_WORKFLOW = ResourceLoader.getImageFxResource("/png/icon_app_workflow_12x12.png");
        ICON_MENU_LEAF_INFO = ResourceLoader.getImageFxResource("/png/icon_app_infomodule_12x12.png");
        ICON_MENU_LEAF_CHECKLIST = ResourceLoader.getImageFxResource("/png/icon_app_checklist_12x12.png");
        ICON_MENU_LEAF_TERMINAL = ResourceLoader.getImageFxResource("/png/icon_app_terminal_12x12.png");
        ICON_MENU_LEAF_EXTERNAL = ResourceLoader.getImageFxResource("/png/icon_app_external_12x12.png");
        ICON_MENU_LEAF_EXTERNAL_EXE = ResourceLoader.getImageFxResource("/png/icon_app_external_12x12.png");
        ICON_MENU_LEAF_EXTERNAL_OFFICE = ResourceLoader.getImageFxResource("/png/icon_app_external_12x12.png");
        ICON_MENU_LEAF_EXTERNAL_STATISTIC = ResourceLoader.getImageFxResource("/png/icon_app_external_12x12.png");
        ICON_TOOLBAR_ACTUALIZE = ResourceLoader.getImageIconResource("/png/button_data-actualize_22x22.png");
        ICON_TOOLBAR_CALCULATOR = ResourceLoader.getImageIconResource("/png/button_accessories-calculator_22x22.png");
        ICON_TOOLBAR_EMAIL = ResourceLoader.getImageIconResource("/png/button_accessories-email_22x22.png");
        ICON_TOOLBAR_CANCEL = ResourceLoader.getImageIconResource("/png/button_data-edit-cancel_22x22.png");
        ICON_TOOLBAR_COPY = ResourceLoader.getImageIconResource("/png/button_data-edit-copy_22x22.png");
        ICON_TOOLBAR_DATA_EXPORT = ResourceLoader.getImageIconResource("/png/button_system-data-export_22x22.png");
        ICON_TOOLBAR_DATA_EXPORT_HD = ResourceLoader.getImageIconResource("/png/button_system-data-export-harddisk_22x22.png");
        ICON_TOOLBAR_DATA_EXPORT_CB = ResourceLoader.getImageIconResource("/png/button_system-data-export-clipboard_22x22.png");
        ICON_TOOLBAR_DELETE = ResourceLoader.getImageIconResource("/png/button_data-edit-delete_22x22.png");
        ICON_TOOLBAR_DOCFLOW_CLOSE = ResourceLoader.getImageIconResource("/png/button_docflow-close_22x22.png");
        ICON_TOOLBAR_DOCFLOW_CONTINUE = ResourceLoader.getImageIconResource("/png/button_docflow-continue_22x22.png");
        ICON_TOOLBAR_DOCFLOW_TAKEOVER = ResourceLoader.getImageIconResource("/png/button_docflow-takeover_22x22.png");
        ICON_TOOLBAR_EDITOR = ResourceLoader.getImageIconResource("/png/button_accessories-text-editor_22x22.png");
        ICON_TOOLBAR_EXIT = ResourceLoader.getImageIconResource("/png/button_system-log-out_22x22.png");
        ICON_TOOLBAR_GO_NEXT = ResourceLoader.getImageIconResource("/png/button_system-go-next_22x22.png");
        ICON_TOOLBAR_GO_PREV = ResourceLoader.getImageIconResource("/png/button_system-go-previous_22x22.png");
        ICON_TOOLBAR_HELP = ResourceLoader.getImageIconResource("/png/button_system-help-browser_22x22.png");
        ICON_TOOLBAR_FRAMEINFO = ResourceLoader.getImageIconResource("/png/button_system-frame-info_22x22.png");
        ICON_TOOLBAR_INFO_CUSTOMER = ResourceLoader.getImageIconResource("/png/button_info-bupcus_22x22.png");
        ICON_TOOLBAR_INFO_MAT = ResourceLoader.getImageIconResource("/png/button_info-mat_22x22.png");
        ICON_TOOLBAR_INFO_DOC = ResourceLoader.getImageIconResource("/png/button_info-doc_22x22.png");
        ICON_TOOLBAR_INFO_INVDOC = ResourceLoader.getImageIconResource("/png/button_info-invdoc_22x22.png");
        ICON_TOOLBAR_INFO_MRP = ResourceLoader.getImageIconResource("/png/button_info-mrp_22x22.png");
        ICON_TOOLBAR_INFO_PRDDOC = ResourceLoader.getImageIconResource("/png/button_info-prddoc_22x22.png");
        ICON_TOOLBAR_INFO_INVSTK = ResourceLoader.getImageIconResource("/png/button_info-invstk_22x22.png");
        ICON_TOOLBAR_INFO_VENDOR = ResourceLoader.getImageIconResource("/png/button_info-bupven_22x22.png");
        ICON_TOOLBAR_LIST_ADD = ResourceLoader.getImageIconResource("/png/button_data-edit-list-add_22x22.png");
        ICON_TOOLBAR_LIST_REMOVE = ResourceLoader.getImageIconResource("/png/button_data-edit-list-remove_22x22.png");
        ICON_TOOLBAR_NEW = ResourceLoader.getImageIconResource("/png/button_data-edit-new_22x22.png");
        ICON_TOOLBAR_OPEN = ResourceLoader.getImageIconResource("/png/button_data-edit-open_22x22.png");
        ICON_TOOLBAR_GOTO = ResourceLoader.getImageIconResource("/png/button_system-goto_22x22.png");
        ICON_TOOLBAR_GOTOEDIT = ResourceLoader.getImageIconResource("/png/button_system-goto-edit_22x22.png");
        ICON_TOOLBAR_PRINT_DEFAULT = ResourceLoader.getImageIconResource("/png/button_print-default_22x22.png");
        ICON_TOOLBAR_PRINT_BATCH = ResourceLoader.getImageIconResource("/png/button_print-batch_22x22.png");
        ICON_TOOLBAR_PRINT_DOC = ResourceLoader.getImageIconResource("/png/button_print-doc_22x22.png");
        ICON_TOOLBAR_PRINT_LIST = ResourceLoader.getImageIconResource("/png/button_print-list_22x22.png");
        ICON_TOOLBAR_PRINT_LABEL = ResourceLoader.getImageIconResource("/png/button_print-label_22x22.png");
        ICON_TOOLBAR_PRINT_DIRECT = ResourceLoader.getImageIconResource("/png/button_print-direct_22x22.png");
        ICON_TOOLBAR_RELATED_DOCS = ResourceLoader.getImageIconResource("/png/button_system-dms_22x22.png");
        ICON_TOOLBAR_SAVE = ResourceLoader.getImageIconResource("/png/button_data-edit-save_22x22.png");
        ICON_TOOLBAR_SEARCH = ResourceLoader.getImageIconResource("/png/button_system-search_22x22.png");
        ICON_TOOLBAR_SYSCONFIG = ResourceLoader.getImageIconResource("/png/button_system-config_22x22.png");
        ICON_TOOLBAR_DROPDOWN = ResourceLoader.getImageIconResource("/png/button_dropdown.png");
        ICON_TOOLBAR_WINDOW_LOCK = ResourceLoader.getImageIconResource("/png/button_system-window-lock_22x22.png");
        ICON_TOOLBAR_WINDOW_UNLOCK = ResourceLoader.getImageIconResource("/png/button_system-window-unlock_22x22.png");
        ICON_TOOLBAR_FORMAT_ITALIC = ResourceLoader.getImageIconResource("/png/button_format-text-italic_22x22.png");
        ICON_TOOLBAR_FORMAT_UNDELINE = ResourceLoader.getImageIconResource("/png/button_format-text-underline_22x22.png");
        ICON_TOOLBAR_FORMAT_BOLD = ResourceLoader.getImageIconResource("/png/button_format-text-bold_22x22.png");
        ICON_TOOLBAR_FORMAT_CENTER = ResourceLoader.getImageIconResource("/png/button_format-text-center_22x22.png");
        ICON_TOOLBAR_FORMAT_LEFT = ResourceLoader.getImageIconResource("/png/button_format-text-left_22x22.png");
        ICON_TOOLBAR_FORMAT_RIGHT = ResourceLoader.getImageIconResource("/png/button_format-text-right_22x22.png");
        ICON_APP = Arrays.asList(ResourceLoader.getImageIconResource("/png/icon_app_efc_12x12.png").getImage(), ResourceLoader.getImageIconResource("/png/icon_app_efc_16x16.png").getImage(), ResourceLoader.getImageIconResource("/png/icon_app_efc_22x22.png").getImage(), ResourceLoader.getImageIconResource("/png/icon_app_efc_40x40.png").getImage());
        ICON_APP_FX = Arrays.asList(ResourceLoader.getImageFxResource("/png/icon_app_efc_12x12.png"), ResourceLoader.getImageFxResource("/png/icon_app_efc_16x16.png"), ResourceLoader.getImageFxResource("/png/icon_app_efc_22x22.png"), ResourceLoader.getImageFxResource("/png/icon_app_efc_40x40.png"));
        ICON_APP_WUG = ResourceLoader.getImageIconResource("/png/icon_app_efc_16x16.png");
        ICON_APP_MASTER = ResourceLoader.getImageIconResource("/png/icon_app_masterdata_16x16.png");
        ICON_APP_DIALOG = ResourceLoader.getImageIconResource("/png/icon_app_efc_16x16.png");
        ICON_APP_TRANSACTION = ResourceLoader.getImageIconResource("/png/icon_app_transactiondata_16x16.png");
        ICON_APP_WORKFLOW = ResourceLoader.getImageIconResource("/png/icon_app_workflow_16x16.png");
        ICON_APP_TERMINAL = ResourceLoader.getImageIconResource("/png/icon_app_terminal_16x16.png");
        ICON_APP_STATISTIC = ResourceLoader.getImageIconResource("/png/icon_app_statisticdata_16x16.png");
        ICON_APP_INFO = ResourceLoader.getImageIconResource("/png/icon_app_infomodule_16x16.png");
        ICON_APP_CHECKLIST = ResourceLoader.getImageIconResource("/png/icon_app_checklist_16x16.png");
        ICON_APP_HELP_BROWSER = ResourceLoader.getImageIconResource("/png/icon_app_help-browser_16x16.png");
        ICON_APP_TEXT_EDITOR = ResourceLoader.getImageIconResource("/png/icon_app_text-editor_16x16.png");
        ICON_APP_CALCULATOR = ResourceLoader.getImageIconResource("/png/icon_app_calculator_16x16.png");
        ICON_TOOLBAR_ACTUALIZE_FX = ResourceLoader.getImageFxResource("/png/button_data-actualize_22x22.png");
        ICON_TOOLBAR_CALCULATOR_FX = ResourceLoader.getImageFxResource("/png/button_accessories-calculator_22x22.png");
        ICON_TOOLBAR_EMAIL_FX = ResourceLoader.getImageFxResource("/png/button_accessories-email_22x22.png");
        ICON_TOOLBAR_CANCEL_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-cancel_22x22.png");
        ICON_TOOLBAR_COPY_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-copy_22x22.png");
        ICON_TOOLBAR_DATA_EXPORT_FX = ResourceLoader.getImageFxResource("/png/button_system-data-export_22x22.png");
        ICON_TOOLBAR_DATA_EXPORT_HD_FX = ResourceLoader.getImageFxResource("/png/button_system-data-export-harddisk_22x22.png");
        ICON_TOOLBAR_DATA_EXPORT_CB_FX = ResourceLoader.getImageFxResource("/png/button_system-data-export-clipboard_22x22.png");
        ICON_TOOLBAR_DELETE_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-delete_22x22.png");
        ICON_TOOLBAR_DOCFLOW_CLOSE_FX = ResourceLoader.getImageFxResource("/png/button_docflow-close_22x22.png");
        ICON_TOOLBAR_DOCFLOW_CONTINUE_FX = ResourceLoader.getImageFxResource("/png/button_docflow-continue_22x22.png");
        ICON_TOOLBAR_DOCFLOW_TAKEOVER_FX = ResourceLoader.getImageFxResource("/png/button_docflow-takeover_22x22.png");
        ICON_TOOLBAR_EDITOR_FX = ResourceLoader.getImageFxResource("/png/button_accessories-text-editor_22x22.png");
        ICON_TOOLBAR_EXIT_FX = ResourceLoader.getImageFxResource("/png/button_system-log-out_22x22.png");
        ICON_TOOLBAR_GO_NEXT_FX = ResourceLoader.getImageFxResource("/png/button_system-go-next_22x22.png");
        ICON_TOOLBAR_GO_PREV_FX = ResourceLoader.getImageFxResource("/png/button_system-go-previous_22x22.png");
        ICON_TOOLBAR_HELP_FX = ResourceLoader.getImageFxResource("/png/button_system-help-browser_22x22.png");
        ICON_TOOLBAR_FRAMEINFO_FX = ResourceLoader.getImageFxResource("/png/button_system-frame-info_22x22.png");
        ICON_TOOLBAR_INFO_CUSTOMER_FX = ResourceLoader.getImageFxResource("/png/button_info-bupcus_22x22.png");
        ICON_TOOLBAR_INFO_MAT_FX = ResourceLoader.getImageFxResource("/png/button_info-mat_22x22.png");
        ICON_TOOLBAR_INFO_DOC_FX = ResourceLoader.getImageFxResource("/png/button_info-doc_22x22.png");
        ICON_TOOLBAR_INFO_INVDOC_FX = ResourceLoader.getImageFxResource("/png/button_info-invdoc_22x22.png");
        ICON_TOOLBAR_INFO_MRP_FX = ResourceLoader.getImageFxResource("/png/button_info-mrp_22x22.png");
        ICON_TOOLBAR_INFO_PRDDOC_FX = ResourceLoader.getImageFxResource("/png/button_info-prddoc_22x22.png");
        ICON_TOOLBAR_INFO_INVSTK_FX = ResourceLoader.getImageFxResource("/png/button_info-invstk_22x22.png");
        ICON_TOOLBAR_INFO_VENDOR_FX = ResourceLoader.getImageFxResource("/png/button_info-bupven_22x22.png");
        ICON_TOOLBAR_LIST_ADD_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-list-add_22x22.png");
        ICON_TOOLBAR_LIST_REMOVE_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-list-remove_22x22.png");
        ICON_TOOLBAR_NEW_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-new_22x22.png");
        ICON_TOOLBAR_OPEN_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-open_22x22.png");
        ICON_TOOLBAR_GOTO_FX = ResourceLoader.getImageFxResource("/png/button_system-goto_22x22.png");
        ICON_TOOLBAR_GOTO_EDIT_FX = ResourceLoader.getImageFxResource("/png/button_system-goto-edit_22x22.png");
        ICON_TOOLBAR_PRINT_DEFAULT_FX = ResourceLoader.getImageFxResource("/png/button_print-default_22x22.png");
        ICON_TOOLBAR_PRINT_BATCH_FX = ResourceLoader.getImageFxResource("/png/button_print-batch_22x22.png");
        ICON_TOOLBAR_PRINT_DOC_FX = ResourceLoader.getImageFxResource("/png/button_print-doc_22x22.png");
        ICON_TOOLBAR_PRINT_LIST_FX = ResourceLoader.getImageFxResource("/png/button_print-list_22x22.png");
        ICON_TOOLBAR_PRINT_LABEL_FX = ResourceLoader.getImageFxResource("/png/button_print-list_22x22.png");
        ICON_TOOLBAR_PRINT_DIRECT_FX = ResourceLoader.getImageFxResource("/png/button_print-direct_22x22.png");
        ICON_TOOLBAR_RELATED_DOCS_FX = ResourceLoader.getImageFxResource("/png/button_system-dms_22x22.png");
        ICON_TOOLBAR_STARTBATCH_FX = ResourceLoader.getImageFxResource("/png/button_system-start-batch_22x22.png");
        ICON_TOOLBAR_SAVE_FX = ResourceLoader.getImageFxResource("/png/button_data-edit-save_22x22.png");
        ICON_TOOLBAR_SEARCH_FX = ResourceLoader.getImageFxResource("/png/button_system-search_22x22.png");
        ICON_TOOLBAR_SYSCONFIG_FX = ResourceLoader.getImageFxResource("/png/button_system-config_22x22.png");
        ICON_TOOLBAR_DROPDOWN_FX = ResourceLoader.getImageFxResource("/png/button_dropdown.png");
        ICON_TOOLBAR_WINDOW_LOCK_FX = ResourceLoader.getImageFxResource("/png/button_system-window-lock_22x22.png");
        ICON_TOOLBAR_WINDOW_UNLOCK_FX = ResourceLoader.getImageFxResource("/png/button_system-window-unlock_22x22.png");
        ICON_WFL_HIDE = ResourceLoader.getImageFxResource("/png/button_wfl_hide.png");
        ICON_APP_WUG_FX = ResourceLoader.getImageFxResource("/png/icon_app_efc_16x16.png");
        ICON_APP_TITLE_FX = ResourceLoader.getImageFxResource("/png/icon_app_efc_16x16.png");
        ICON_APP_MASTER_FX = ResourceLoader.getImageFxResource("/png/icon_app_masterdata_16x16.png");
        ICON_APP_DIALOG_FX = ResourceLoader.getImageFxResource("/png/icon_app_efc_16x16.png");
        ICON_APP_TRANSACTION_FX = ResourceLoader.getImageFxResource("/png/icon_app_transactiondata_16x16.png");
        ICON_APP_WORKFLOW_FX = ResourceLoader.getImageFxResource("/png/icon_app_workflow_16x16.png");
        ICON_APP_STATISTIC_FX = ResourceLoader.getImageFxResource("/png/icon_app_statisticdata_16x16.png");
        ICON_APP_INFO_FX = ResourceLoader.getImageFxResource("/png/icon_app_infomodule_16x16.png");
        ICON_APP_CHECKLIST_FX = ResourceLoader.getImageFxResource("/png/icon_app_checklist_16x16.png");
        ICON_APP_HELP_BROWSER_FX = ResourceLoader.getImageFxResource("/png/icon_app_help-browser_16x16.png");
        ICON_APP_TEXT_EDITOR_FX = ResourceLoader.getImageFxResource("/png/icon_app_text-editor_16x16.png");
        ICON_APP_CALCULATOR_FX = ResourceLoader.getImageFxResource("/png/icon_app_calculator_16x16.png");
        ICON_APP_SENDMSG_FX = ResourceLoader.getImageFxResource("/png/icon_app_email_40x40.png");
        ICON_APP_EFC_LOGIN_FX = ResourceLoader.getImageFxResource("/png/icon_app_efc_login.png");
        ICON_FIELDINFO_SCROLL = ResourceLoader.getImageIconResource("/png/fieldinfo_scroll.png");
        ICON_FIELDINFO_KEY = ResourceLoader.getImageIconResource("/png/fieldinfo_key.png");
        ICON_FIELDINFO_ERROR = ResourceLoader.getImageIconResource("/png/fieldinfo_error.png");
        ICON_FIELDINFO_SEARCH = ResourceLoader.getImageIconResource("/png/fieldinfo_search.png");
        ICON_FIELDINFO_QUICKSEARCH = ResourceLoader.getImageIconResource("/png/fieldinfo_search.png");
        ICON_FIELDINFO_WARNING = ResourceLoader.getImageIconResource("/png/fieldinfo_warning.png");
        ICON_BUTTON_POPUP_CALENDAR = ResourceLoader.getImageIconResource("/png/button_popup-calendar_16x16.png");
        ICON_BUTTON_POPUP_DROPDOWN = ResourceLoader.getImageIconResource("/png/button_popup-checklist_16x16.png");
        COLOR_WUG_LOGO = new Color(128, 0, 0);
        COLOR_DESKTOP_BACKGROUND = new Color(211, 211, 211);
        COLORFX_DESKTOP_BACKGROUND = javafx.scene.paint.Color.rgb((int)SystemColor.control.getRed(), (int)SystemColor.control.getGreen(), (int)SystemColor.control.getBlue(), (double)SystemColor.control.getTransparency());
        COLOR_STARTMENU_BACKGROUND = SystemColor.menu;
        COLOR_INFOTEXT_BACKGROUND = SystemColor.control;
        COLOR_INFOTEXT_TEXT = SystemColor.GRAY;
        COLOR_TABPAGE_SELECTED = SystemColor.WHITE;
        COLOR_TABLE_TEXT_DELETEDROW = SystemColor.LIGHT_GRAY;
        COLOR_TABLE_TEXT_NEWROW = new Color(0, 0, 255);
        COLOR_TABLE_TEXT_NEWROW_SELECTED = new Color(0, 238, 238);
        COLOR_TABLE_GRID = Color.BLACK;
        COLOR_TABLE_MSG_ERROR = Color.RED;
        COLOR_TABLE_MSG_INFO = Color.LIGHT_GRAY;
        COLOR_TABLE_MSG_WARNING = Color.YELLOW;
        STYLE_BUTTON_TOOLBAR_BORDER = new BevelBorder(0);
        STYLE_DESKTOP_BORDER = new LineBorder(Color.darkGray);
        STYLE_INFOTEXT_BORDER = new EmptyBorder(0, 3, 0, 0);
        SIZE_BUTTON_TOOLBAR = new Dimension(20, 20);
        SIZE_FRAME_SEARCH = new Dimension(400, 350);
        SIZE_FRAME_DYNAMIC = new Dimension(0, 0);
        SIZE_FRAME_PRINT_PREVIEW = new Dimension(620, 800);
        SIZE_FRAME_NAVIGATOR = new Dimension(300, 600);
        SIZE_FRAME_CODE_EDITOR = new Dimension(1000, 600);
        SIZE_FRAME_FULLSIZE_GRAPH = new Dimension(1000, 600);
        SIZE_FRAME_PRDNET = new Dimension(675, 575);
        SIZE_DIALOG_DEFAULT = new Dimension(400, 300);
        SIZE_DIALOG_SMALL = new Dimension(220, 120);
        SIZE_DIALOG_MEDIUM = new Dimension(300, 200);
        SIZE_DIALOG_COPY = new Dimension(300, 300);
        SIZE_DIALOG_WIDE = new Dimension(500, 300);
        SIZE_DIALOG_LARGE = new Dimension(500, 500);
        SIZE_DIALOG_DATA_EXPORT = new Dimension(800, 400);
        SIZE_DIALOG_PRINTSELECTION = new Dimension(300, 400);
        SIZE_DIALOG_FRAMEINFO = new Dimension(500, 200);
        SIZE_DIALOG_MESSAGELIST = new Dimension(400, 200);
        TABLE_BORRDER_OUTSIDE = new LineBorder(Color.BLACK, 1, true);
        TABLE_BORRDER_EMPTYBORDER = new EmptyBorder(1, 1, 1, 1);
        TABLE_CELL_BORRDER_OUTSIDE = new MatteBorder(2, 0, 2, 0, Color.BLUE);
        TABLE_CELL_BORRDER_EMPTYBORDER = new EmptyBorder(0, 5, 0, 5);
        TABLE_CELL_BORRDER_INSIDE = new EmptyBorder(0, 5, 0, 5);
        TABLE_CELL_BORRDER_HIGHLIGHT = new CompoundBorder(TABLE_CELL_BORRDER_OUTSIDE, TABLE_CELL_BORRDER_INSIDE);
        TABLE_CELL_EDITOR_NOFOCUSBORDER = new EmptyBorder(0, 5, 0, 5);
        SIZE_TEXTFIELD_INSETS = new Insets(0, 3, 0, 3);
        EXPLORER_ICONS_OPEN = Arrays.asList(ResourceLoader.getImageIconResource("/png/icon_explorer_component_closed.png"), ResourceLoader.getImageIconResource("/png/icon_explorer_bom_closed.png"), ResourceLoader.getImageIconResource("/png/icon_explorer_main_closed.png"), ResourceLoader.getImageIconResource("/png/icon_explorer_standard_closed.png"));
        EXPLORER_ICONS_CLOSED = Arrays.asList(ResourceLoader.getImageIconResource("/png/icon_explorer_component_closed.png"), ResourceLoader.getImageIconResource("/png/icon_explorer_bom_closed.png"), ResourceLoader.getImageIconResource("/png/icon_explorer_main_closed.png"), ResourceLoader.getImageIconResource("/png/icon_explorer_standard_closed.png"));
    }
}

