/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.util;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.model.MapComboBoxModel;
import de.effectivecompany.gui.components.model.table.BOTableModel;
import de.effectivecompany.gui.components.model.table.EFCColumnModel;
import de.effectivecompany.gui.components.model.table.ListTableModel;
import de.effectivecompany.gui.components.model.table.StatisticDataTableModel;
import de.effectivecompany.gui.constants.EFCConstants;
import de.effectivecompany.gui.util.EUFieldStyler;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.ClipboardContent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class ClipboardUtil {
    private static File tempFolder;

    public static void textToClipboard(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    public static void filesToClipboard(File ... files) {
        ArrayList<File> listOfFiles = new ArrayList<File>();
        for (File file : files) {
            listOfFiles.add(file);
        }
        FileTransferable ft = new FileTransferable(listOfFiles);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ft, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public static void filesToClipboardFX(File ... files) {
        javafx.scene.input.Clipboard clip = javafx.scene.input.Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putFiles(Arrays.asList(files));
        clip.setContent((Map)content);
    }

    public static void fileOpen(File file) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                System.out.println("Could not open " + file.getName());
            }
        } else {
            System.out.println("Desktop not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createFileInEFCTemp(String fileName, String fileExtension, byte[] data) throws IOException {
        File retFile = new File(tempFolder, fileName + fileExtension);
        retFile.deleteOnExit();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(retFile, false);
            outputStream.write(data);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return retFile;
    }

    public static void tableToClipboard(JTable model) {
        ClipboardUtil.tableToClipboard(model, 0, 0, model.getModel().getColumnCount(), model.getModel().getRowCount());
    }

    public static void tableToClipboardFX(TableView<SearchResult> table) {
        SimpleBooleanProperty isFirstColumn = new SimpleBooleanProperty(true);
        StringBuffer sb = new StringBuffer();
        ArrayList columns = new ArrayList();
        if (!table.getSelectionModel().getSelectedCells().isEmpty()) {
            table.getSelectionModel().getSelectedCells().forEach(tablePosition -> {
                TableColumn tableColumn = tablePosition.getTableColumn();
                if (tableColumn != null && tableColumn.getId() != null && !tableColumn.getText().equals("#") && !columns.contains("\"" + tableColumn.getText() + "\"")) {
                    columns.add("\"" + tableColumn.getText() + "\"");
                }
            });
            sb.append(String.join((CharSequence)"\t", columns));
            if (!columns.isEmpty()) {
                sb.append("\n");
            }
            isFirstColumn.set(true);
            AtomicReference lastTablePosition = new AtomicReference();
            table.getSelectionModel().getSelectedCells().forEach(arg_0 -> ClipboardUtil.lambda$tableToClipboardFX$1(lastTablePosition, (BooleanProperty)isFirstColumn, sb, arg_0));
        } else {
            table.getVisibleLeafColumns().forEach(arg_0 -> ClipboardUtil.lambda$tableToClipboardFX$2((BooleanProperty)isFirstColumn, sb, arg_0));
            isFirstColumn.set(true);
            sb.append("\n");
            table.getItems().forEach(arg_0 -> ClipboardUtil.lambda$tableToClipboardFX$4(table, (BooleanProperty)isFirstColumn, sb, arg_0));
        }
        javafx.scene.input.Clipboard clipboard = javafx.scene.input.Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(sb.toString());
        clipboard.setContent((Map)content);
    }

    public static void tableToClipboard(JTable table, int startx, int starty, int width, int height) {
        int i;
        int tmpWidth = width;
        boolean isFirstColumn = true;
        StringBuffer sb = new StringBuffer();
        for (i = startx; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumnExt colExt;
            if (table.getModel() instanceof BOTableModel && table.getColumnModel() instanceof EFCColumnModel && ((TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i)).isVisible()) {
                if (!isFirstColumn) {
                    sb.append("\t");
                }
                isFirstColumn = false;
                colExt = ((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i);
                sb.append(colExt.getHeaderValue());
                --width;
            } else if ((table.getModel() instanceof DefaultTableModel || table.getModel() instanceof StatisticDataTableModel || table.getModel() instanceof ListTableModel) && ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i).isVisible()) {
                if (!isFirstColumn) {
                    sb.append("\t");
                }
                isFirstColumn = false;
                colExt = ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i);
                sb.append(colExt.getHeaderValue());
                --width;
            }
            if (width == 0) break;
        }
        sb.append("\n");
        isFirstColumn = true;
        width = tmpWidth;
        for (int j = starty; j < starty + height; ++j) {
            for (i = startx; i < table.getColumnModel().getColumnCount(); ++i) {
                Object val;
                TableColumnExt colExt;
                if (table.getModel() instanceof BOTableModel && table.getColumnModel() instanceof EFCColumnModel && ((TableColumnExt)((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i)).isVisible()) {
                    if (!isFirstColumn) {
                        sb.append("\t");
                    }
                    isFirstColumn = false;
                    colExt = ((EFCColumnModel)((Object)table.getColumnModel())).getActColumns().get(i);
                    val = table.getModel().getValueAt(j, colExt.getModelIndex());
                    if (val != null && val instanceof EFCFloat && ((EFCFloat)val).getData() != null) {
                        val = NumberFormat.getInstance().format(((EFCFloat)val).getData());
                    }
                    if (val != null && val instanceof EFCOption) {
                        val = Translator.tr((String)MapComboBoxModel.genKeyShort(val.toString(), ((EFCOption)val).getOptionClass().getSimpleName().toUpperCase()));
                    }
                    if (val != null && val instanceof EFCBoolean && ((EFCBoolean)val).getData() != null) {
                        val = EUFieldStyler.getObjectAsString(val);
                    }
                    sb.append(val == null ? "" : val);
                    --width;
                } else if ((table.getModel() instanceof DefaultTableModel || table.getModel() instanceof StatisticDataTableModel || table.getModel() instanceof ListTableModel) && ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i).isVisible()) {
                    if (!isFirstColumn) {
                        sb.append("\t");
                    }
                    isFirstColumn = false;
                    colExt = ((DefaultTableColumnModelExt)table.getColumnModel()).getColumnExt(i);
                    val = table.getModel().getValueAt(j, colExt.getModelIndex());
                    if (val != null && val instanceof EFCFloat && ((EFCFloat)val).getData() != null) {
                        val = NumberFormat.getInstance().format(((EFCFloat)val).getData());
                    }
                    if (val != null && val instanceof EFCOption) {
                        val = Translator.tr((String)MapComboBoxModel.genKeyShort(val.toString(), ((EFCOption)val).getOptionClass().getSimpleName().toUpperCase()));
                    }
                    if (val != null && val instanceof EFCBoolean && ((EFCBoolean)val).getData() != null) {
                        val = EUFieldStyler.getObjectAsString(val);
                    }
                    sb.append(val == null ? "" : val);
                    --width;
                }
                if (width == 0) break;
            }
            width = tmpWidth;
            isFirstColumn = true;
            sb.append("\n");
        }
        StringSelection content = new StringSelection(sb.toString());
        sb = null;
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        clip.setContents(content, null);
    }

    private static String formatCellData(Object cellData) {
        if (cellData instanceof String) {
            String cd = ((String)cellData).replaceAll("\"", "'");
            return "\"" + EUFieldStyler.getObjectAsString(cd) + "\"";
        }
        return EUFieldStyler.getObjectAsString(cellData);
    }

    private static /* synthetic */ void lambda$tableToClipboardFX$4(TableView table, BooleanProperty isFirstColumn, StringBuffer sb, SearchResult item) {
        table.getVisibleLeafColumns().forEach(tableColumn -> {
            if (!tableColumn.getText().equals("#")) {
                if (!isFirstColumn.get()) {
                    sb.append("\t");
                }
                isFirstColumn.set(false);
                if (tableColumn.getId() != null && item.getData().containsKey(tableColumn.getId().toUpperCase())) {
                    sb.append(item.getData().get(tableColumn.getId().toUpperCase()) == null ? "" : ClipboardUtil.formatCellData(tableColumn.getCellData((Object)item)));
                }
            }
        });
        isFirstColumn.set(true);
        sb.append("\n");
    }

    private static /* synthetic */ void lambda$tableToClipboardFX$2(BooleanProperty isFirstColumn, StringBuffer sb, TableColumn col) {
        if (!col.getText().equals("#") && col instanceof TableColumn) {
            TableColumn tableColumn = col;
            if (!isFirstColumn.get()) {
                sb.append("\t");
            }
            isFirstColumn.set(false);
            sb.append("\"" + tableColumn.getText() + "\"");
        }
    }

    private static /* synthetic */ void lambda$tableToClipboardFX$1(AtomicReference lastTablePosition, BooleanProperty isFirstColumn, StringBuffer sb, TablePosition tablePosition) {
        if (tablePosition.getTableColumn().getId() != null) {
            if (lastTablePosition.get() != null && ((TablePosition)lastTablePosition.get()).getRow() != tablePosition.getRow()) {
                isFirstColumn.set(true);
                sb.append("\n");
            }
            TableColumn tableColumn = tablePosition.getTableColumn();
            if (!isFirstColumn.get()) {
                sb.append("\t");
            }
            isFirstColumn.set(false);
            if (tableColumn != null && tableColumn.getId() != null) {
                sb.append(tableColumn.getCellData(tablePosition.getRow()) == null ? "" : ClipboardUtil.formatCellData(tableColumn.getCellData(tablePosition.getRow())));
            }
            lastTablePosition.set(tablePosition);
        }
    }

    static {
        File file = new File(EFCConstants.CLIPBOARD_FOLDER);
        if (!file.exists()) {
            file.mkdir();
        }
        tempFolder = file;
    }

    private static class FileTransferable
    implements Transferable {
        private List<File> listOfFiles;

        public FileTransferable(List<File> listOfFiles) {
            this.listOfFiles = listOfFiles;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.listOfFiles;
        }
    }
}

