/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.util;

import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCCalMonth;
import de.effectivecompany.base.datatypes.EFCCalWeek;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCDuration;
import de.effectivecompany.base.datatypes.EFCFactor;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCMoney;
import de.effectivecompany.base.datatypes.EFCPercent;
import de.effectivecompany.base.datatypes.EFCQuantity;
import de.effectivecompany.base.datatypes.EFCTime;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class EUFieldStyler {
    protected static EUFieldStyler instance = new EUFieldStyler();
    private static SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected DecimalFormat numberFormat = (DecimalFormat)DecimalFormat.getInstance().clone();
    protected DecimalFormat quantiyFormat;
    protected DecimalFormat moneyFormat;
    protected NumberFormat factorFormat;
    protected NumberFormat durationFormat;
    protected NumberFormat percentFormat;
    protected DateFormat dateFormat;
    protected DateFormat timeFormat;
    protected DateFormat dateTimeFormat;
    protected DateFormat calMonthFormat;
    protected DateFormat calWeekFormat;

    protected EUFieldStyler() {
        DecimalFormatSymbols formatSymbols;
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(3);
        EFCPanelSingleton.getInstance();
        if (EFCPanelSingleton.DECIMAL_SEPARATOR != null) {
            formatSymbols = this.numberFormat.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(EFCPanelSingleton.DECIMAL_SEPARATOR.charValue());
            this.numberFormat.setDecimalFormatSymbols(formatSymbols);
        }
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            formatSymbols = this.numberFormat.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.numberFormat.setDecimalFormatSymbols(formatSymbols);
        }
        this.quantiyFormat = (DecimalFormat)DecimalFormat.getInstance().clone();
        this.quantiyFormat.setGroupingUsed(true);
        this.quantiyFormat.setMinimumFractionDigits(3);
        this.quantiyFormat.setMaximumFractionDigits(3);
        if (EFCPanelSingleton.DECIMAL_SEPARATOR != null) {
            formatSymbols = this.quantiyFormat.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(EFCPanelSingleton.DECIMAL_SEPARATOR.charValue());
            this.quantiyFormat.setDecimalFormatSymbols(formatSymbols);
        }
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            formatSymbols = this.quantiyFormat.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.quantiyFormat.setDecimalFormatSymbols(formatSymbols);
        }
        this.moneyFormat = (DecimalFormat)DecimalFormat.getInstance().clone();
        this.moneyFormat.setGroupingUsed(true);
        this.moneyFormat.setMinimumFractionDigits(2);
        this.moneyFormat.setMaximumFractionDigits(2);
        if (EFCPanelSingleton.DECIMAL_SEPARATOR != null) {
            formatSymbols = this.moneyFormat.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(EFCPanelSingleton.DECIMAL_SEPARATOR.charValue());
            this.moneyFormat.setDecimalFormatSymbols(formatSymbols);
        }
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            formatSymbols = this.moneyFormat.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.moneyFormat.setDecimalFormatSymbols(formatSymbols);
        }
        this.factorFormat = (NumberFormat)NumberFormat.getInstance().clone();
        this.factorFormat.setGroupingUsed(true);
        this.factorFormat.setMinimumFractionDigits(1);
        this.factorFormat.setMaximumFractionDigits(5);
        this.durationFormat = (NumberFormat)NumberFormat.getInstance().clone();
        this.durationFormat.setGroupingUsed(false);
        this.durationFormat.setMinimumFractionDigits(2);
        this.durationFormat.setMaximumFractionDigits(2);
        this.percentFormat = (NumberFormat)NumberFormat.getInstance().clone();
        this.percentFormat.setGroupingUsed(false);
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        this.dateFormat = DateFormat.getDateInstance();
        this.timeFormat = DateFormat.getTimeInstance();
        this.dateTimeFormat = DateFormat.getDateTimeInstance();
        this.calMonthFormat = new SimpleDateFormat("MM/yyyy");
        this.calWeekFormat = new SimpleDateFormat("k/yyyy");
    }

    public static EUFieldStyler getInstance() {
        return instance;
    }

    public static String getObjectAsString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Translator.tr((String)"_YES") : Translator.tr((String)"_NO");
        }
        if (value instanceof EFCBoolean) {
            Object v = ((BaseType)value).optainValue();
            return v == null ? null : (((EFCBoolean)value).getBoolean() != false ? Translator.tr((String)"_YES") : Translator.tr((String)"_NO"));
        }
        if (value instanceof EFCMoney) {
            Object v = ((BaseType)value).optainValue();
            return v == null ? null : EUFieldStyler.getInstance().moneyFormat.format(v);
        }
        if (value instanceof EFCQuantity) {
            Object v = ((BaseType)value).optainValue();
            return v == null ? null : EUFieldStyler.getInstance().quantiyFormat.format(v);
        }
        if (value instanceof EFCFactor) {
            Object v = ((BaseType)value).optainValue();
            return v == null ? null : EUFieldStyler.getInstance().factorFormat.format(v);
        }
        if (value instanceof EFCDuration) {
            Object v = ((BaseType)value).optainValue();
            return v == null ? null : EUFieldStyler.getInstance().durationFormat.format(v);
        }
        if (value instanceof EFCPercent) {
            Object v = ((BaseType)value).optainValue();
            return v == null ? null : EUFieldStyler.getInstance().percentFormat.format(v);
        }
        if (value instanceof EFCDate) {
            Date v = ((EFCDate)value).getDate();
            return v == null ? null : EUFieldStyler.getInstance().dateFormat.format(v);
        }
        if (value instanceof EFCCalMonth) {
            Integer calMonth = ((EFCCalMonth)value).getData();
            if (calMonth == null || calMonth < 100) {
                return null;
            }
            calMonth = calMonth % 100;
            Object month = "00" + calMonth.toString();
            month = ((String)month).substring(((String)month).length() - 2);
            calMonth = ((EFCCalMonth)value).getData();
            calMonth = calMonth / 100;
            Object year = "0000" + calMonth.toString();
            year = ((String)year).substring(((String)year).length() - 4);
            return (String)month + "/" + (String)year;
        }
        if (value instanceof EFCCalWeek) {
            Integer calWeek = ((EFCCalWeek)value).getData();
            if (calWeek == null || calWeek < 100) {
                return null;
            }
            calWeek = calWeek % 100;
            Object week = "00" + calWeek.toString();
            week = ((String)week).substring(((String)week).length() - 2);
            calWeek = ((EFCCalWeek)value).getData();
            calWeek = calWeek / 100;
            Object year = "0000" + calWeek.toString();
            year = ((String)year).substring(((String)year).length() - 4);
            return (String)week + "/" + (String)year;
        }
        if (value instanceof Date) {
            Date v = (Date)value;
            return v == null ? null : EUFieldStyler.getInstance().dateFormat.format(v);
        }
        if (value instanceof EFCTime) {
            Date v = ((EFCTime)value).getDate();
            return v == null ? null : EUFieldStyler.getInstance().timeFormat.format(v);
        }
        if (value instanceof EFCDateTime) {
            Date v = ((EFCDateTime)value).getDate();
            return v == null ? null : EUFieldStyler.getInstance().dateTimeFormat.format(v);
        }
        if (value instanceof EFCFloat || value instanceof EFCLong || value instanceof EFCInteger) {
            Object v = ((BaseType)value).optainValue();
            return v == null ? null : EUFieldStyler.getInstance().numberFormat.format(v);
        }
        if (value instanceof Number) {
            return EUFieldStyler.getInstance().numberFormat.format(((Number)value).doubleValue());
        }
        return value.toString();
    }

    public static String getStringForType(String value, Class<?> clazz) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (clazz.equals(Boolean.class)) {
            return value;
        }
        if (clazz.equals(EFCBoolean.class)) {
            return value;
        }
        if (clazz.equals(EFCMoney.class)) {
            return value == null ? null : EUFieldStyler.getInstance().moneyFormat.format(Double.valueOf(value));
        }
        if (clazz.equals(EFCQuantity.class)) {
            return value == null ? null : EUFieldStyler.getInstance().quantiyFormat.format(Double.valueOf(value));
        }
        if (clazz.equals(EFCFactor.class)) {
            return value == null ? null : EUFieldStyler.getInstance().factorFormat.format(Double.valueOf(value));
        }
        if (clazz.equals(EFCDuration.class)) {
            return value == null ? null : EUFieldStyler.getInstance().durationFormat.format(Double.valueOf(value));
        }
        if (clazz.equals(EFCPercent.class)) {
            return value == null ? null : EUFieldStyler.getInstance().percentFormat.format(Double.valueOf(value));
        }
        if (clazz.equals(EFCDate.class)) {
            try {
                value = DateFormat.getDateInstance().format(sdfDate.parse(value));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return value;
        }
        if (clazz.equals(EFCCalMonth.class)) {
            Integer calMonth = Integer.valueOf(value);
            if (calMonth == null || calMonth < 100) {
                return null;
            }
            calMonth = calMonth % 100;
            Object month = "00" + calMonth.toString();
            month = ((String)month).substring(((String)month).length() - 2);
            calMonth = Integer.valueOf(value);
            calMonth = calMonth / 100;
            Object year = "0000" + calMonth.toString();
            year = ((String)year).substring(((String)year).length() - 4);
            return (String)month + "/" + (String)year;
        }
        if (clazz.equals(EFCCalWeek.class)) {
            Integer calWeek = Integer.valueOf(value);
            if (calWeek == null || calWeek < 100) {
                return null;
            }
            calWeek = calWeek % 100;
            Object week = "00" + calWeek.toString();
            week = ((String)week).substring(((String)week).length() - 2);
            calWeek = Integer.valueOf(value);
            calWeek = calWeek / 100;
            Object year = "0000" + calWeek.toString();
            year = ((String)year).substring(((String)year).length() - 4);
            return (String)week + "/" + (String)year;
        }
        if (clazz.equals(EFCTime.class)) {
            try {
                value = value == null ? null : EUFieldStyler.getInstance().timeFormat.format(sdfTime.parse(value));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return value;
        }
        if (clazz.equals(EFCDateTime.class)) {
            try {
                value = DateFormat.getDateTimeInstance().format(sdfDateTime.parse(value));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return value;
        }
        if (clazz.equals(EFCFloat.class)) {
            return value == null ? null : EUFieldStyler.getInstance().numberFormat.format(Float.valueOf(value));
        }
        if (clazz.equals(EFCInteger.class)) {
            return value == null ? null : EUFieldStyler.getInstance().numberFormat.format(Integer.valueOf(value));
        }
        if (clazz.equals(EFCLong.class)) {
            return value == null ? null : EUFieldStyler.getInstance().numberFormat.format(Long.valueOf(value));
        }
        return value.toString();
    }

    public static Double getDoubleForNumberType(String value, Class<? extends NumberType> clazz) throws ParseException {
        if (clazz.equals(EFCMoney.class)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().moneyFormat.parse(value).doubleValue());
        }
        if (clazz.equals(EFCQuantity.class)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().quantiyFormat.parse(value).doubleValue());
        }
        if (clazz.equals(EFCFactor.class)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().factorFormat.parse(value).doubleValue());
        }
        if (clazz.equals(EFCDuration.class)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().durationFormat.parse(value).doubleValue());
        }
        if (clazz.equals(EFCPercent.class)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().percentFormat.parse(value).doubleValue());
        }
        if (EFCFloat.class.isAssignableFrom(clazz)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().numberFormat.parse(value).doubleValue());
        }
        if (EFCInteger.class.isAssignableFrom(clazz)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().numberFormat.parse(value).doubleValue());
        }
        if (EFCLong.class.isAssignableFrom(clazz)) {
            return value == null ? null : new Double(EUFieldStyler.getInstance().numberFormat.parse(value).doubleValue());
        }
        return null;
    }

    public static void styleTextComponent(JTextComponent c, Object value) {
        c.setText(EUFieldStyler.getObjectAsString(value));
        if (c instanceof JTextField) {
            ((JTextField)c).setHorizontalAlignment(2);
        }
        if ((value instanceof EFCInteger || value instanceof EFCFloat) && c instanceof JTextField) {
            ((JTextField)c).setHorizontalAlignment(4);
        }
    }

    public DecimalFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DecimalFormat getQuantiyFormat() {
        return this.quantiyFormat;
    }

    public DecimalFormat getMoneyFormat() {
        return this.moneyFormat;
    }

    public NumberFormat getFactorFormat() {
        return this.factorFormat;
    }

    public NumberFormat getDurationFormat() {
        return this.durationFormat;
    }

    public NumberFormat getPercentFormat() {
        return this.percentFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public DateFormat getCalMonthFormat() {
        return this.calMonthFormat;
    }

    public DateFormat getCalWeekFormat() {
        return this.calWeekFormat;
    }
}

