/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.thread;

import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.data.EFCReportSelectionListEntry;
import de.effectivecompany.gui.factory.EFCReportSingleton;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.report.jasper.ReportInfoVerifier;
import de.effectivecompany.thread.EFCPrintRunnable;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPrintTask
extends SwingWorker<Object, Object> {
    private static Logger logger = LoggerFactory.getLogger(EFCPrintTask.class);
    private EFCReportSelectionListEntry entry;
    private List<Key> keyList;
    private ReportInfoVerifier verifier;

    public EFCPrintTask(List<Key> keyList, EFCReportSelectionListEntry entry, ReportInfoVerifier verifier) {
        this.entry = entry;
        this.keyList = keyList;
        this.verifier = verifier;
    }

    @Override
    protected Object doInBackground() throws Exception {
        for (Key key : this.keyList) {
            EFCReportContainer efcReportContainer = null;
            efcReportContainer = EFCReportSingleton.getInstance().buildReport(this.entry, this.verifier, key);
            if (efcReportContainer != null) {
                EFCReportContainer finalEfcReportContainer = efcReportContainer;
                EFCThreadUtil.doLater(new EFCPrintRunnable(finalEfcReportContainer));
                continue;
            }
            logger.error("cannot display report: report document is null");
        }
        return null;
    }

    public EFCReportSelectionListEntry getEntry() {
        return this.entry;
    }

    public List<Key> getKeyList() {
        return this.keyList;
    }

    public ReportInfoVerifier getVerifier() {
        return this.verifier;
    }
}

