/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.xml;

import de.effectivecompany.app.sys.DcSysUsrRightsDetMapElm;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EFCXMLIncluder {
    private static Logger logger = LoggerFactory.getLogger(EFCXMLIncluder.class);
    private static final SAXBuilder builder = new SAXBuilder();
    private static final Lock builderLock = new ReentrantLock();

    public static Document replaceInStream2Doc(InputStream input) throws JDOMException, IOException {
        Document doc;
        try {
            builderLock.lock();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.contains("window.dtd")) {
                        return new InputSource(new StringReader(""));
                    }
                    return null;
                }
            });
            doc = builder.build(input);
        }
        finally {
            builderLock.unlock();
        }
        EFCXMLIncluder.replaceIncludes(doc.getRootElement());
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document replaceXmlFile2Doc(String fileName) throws JDOMException, IOException {
        Document doc = null;
        InputStream input = null;
        try {
            File srcFile;
            logger.debug("XML_layout: " + fileName);
            String rootDocFromDb = EFCXMLIncluder.getIncludeFromDatabase(fileName);
            input = rootDocFromDb != null && !rootDocFromDb.isEmpty() ? new ByteArrayInputStream(rootDocFromDb.getBytes(StandardCharsets.UTF_8)) : ((srcFile = new File("resources/forms/" + fileName)).exists() ? new FileInputStream(srcFile) : ClassLoader.getSystemResourceAsStream("forms/" + fileName));
            builderLock.lock();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.contains("window.dtd")) {
                        return new InputSource(new StringReader(""));
                    }
                    return null;
                }
            });
            doc = builder.build(input);
        }
        catch (Exception fnfex) {
            EFCDesktop.reportError(fnfex);
        }
        finally {
            builderLock.unlock();
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        EFCXMLIncluder.replaceIncludes(doc.getRootElement());
        return doc;
    }

    public static Reader replaceInStream(InputStream input) throws JDOMException, IOException {
        Document doc = EFCXMLIncluder.replaceInStream2Doc(input);
        String buffer = new XMLOutputter().outputString(doc);
        return new CharArrayReader(buffer.toCharArray());
    }

    private static void replaceIncludes(Element element) throws JDOMException, IOException {
        if (element == null) {
            return;
        }
        List childs = element.getChildren();
        String elementName = element.getName();
        if (childs.size() > 0) {
            for (int i = childs.size() - 1; i >= 0; --i) {
                EFCXMLIncluder.replaceIncludes((Element)childs.get(i));
            }
        } else if (elementName.equalsIgnoreCase("include") || elementName.equals("xinclude")) {
            String target = element.getAttributeValue("href");
            String param = element.getAttributeValue("param");
            if (target == null) {
                throw new JDOMException("include requires an href attribute");
            }
            String includeContent = EFCXMLIncluder.getIncludeFromDatabase(target);
            if (includeContent.equals("")) {
                includeContent = EFCXMLIncluder.getIncludeFromFile(target);
            }
            if (includeContent.equals("")) {
                if (elementName.equals("xinclude")) {
                    EFCXMLIncluder.removeEmptyIncludeElement(element);
                } else {
                    logger.error("XML_include: " + target + " does not exists!");
                    EFCXMLIncluder.removeEmptyIncludeElement(element);
                }
            } else {
                EFCXMLIncluder.createIncludeElement(element, param, includeContent);
            }
        }
    }

    private static String getIncludeFromFile(String target) throws FileNotFoundException, IOException {
        logger.debug("XML_include: " + target);
        InputStream resource = ClassLoader.getSystemResourceAsStream("forms/" + target);
        String fileContent = "";
        if (resource != null) {
            InputStreamReader inputReader = new InputStreamReader(resource);
            char[] charBuffer = new char[8192];
            StringBuffer buffer = new StringBuffer();
            int length = 0;
            while ((length = inputReader.read(charBuffer)) != -1) {
                buffer.append(charBuffer, 0, length);
            }
            fileContent = buffer.toString();
            ((Reader)inputReader).close();
            resource.close();
        }
        return fileContent;
    }

    private static String getIncludeFromDatabase(String target) {
        DcSysUsrRightsDetMapElm layout = EFCPanelSingleton.getInstance().getFrameLayout(target);
        String elmCode = "";
        if (layout != null && layout.getElmCode() != null && layout.getElmCode().getData() != null && !layout.getElmCode().getData().isEmpty()) {
            elmCode = layout.getElmCode().getData();
            if (elmCode.equals("")) {
                logger.error("Panel-Definition ist leer in: " + target);
            } else if (layout.getElmByAdmin().getData().booleanValue()) {
                logger.info("setzte Admin-definierte Panel-Definition in: " + target);
            } else {
                logger.info("setzte Benutzer-bezogene Panel-Definition in: " + target);
            }
        }
        return elmCode;
    }

    private static void removeEmptyIncludeElement(Element element) {
        Element parentElement = element.getParentElement();
        parentElement.removeContent((Content)element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createIncludeElement(Element element, String param, String content) throws JDOMException, IOException {
        Document doc;
        if (param != null) {
            content = content.replaceAll("\\?\\?", param);
        }
        try {
            builderLock.lock();
            doc = builder.build((Reader)new StringReader(content));
        }
        finally {
            builderLock.unlock();
        }
        Element resourceRoot = doc.getRootElement();
        EFCXMLIncluder.replaceIncludes(resourceRoot);
        Element parentElement = element.getParentElement();
        int index = parentElement.indexOf((Content)element);
        parentElement.removeContent((Content)element);
        List elements = resourceRoot.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            Element current = (Element)elements.get(i);
            current.detach();
            parentElement.addContent(index + i, (Content)current);
        }
    }
}

