/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanInfoTypeResolver;

public class DefaultBeanInfoTypeResolver
implements BeanInfoTypeResolver {
    public static final DefaultBeanInfoTypeResolver INSTANCE = new DefaultBeanInfoTypeResolver();

    @Override
    public Object[] resolve(Class<?> type, Method explicitMethod) {
        boolean changed = false;
        while (type.isSynthetic()) {
            changed = true;
            type = type.getSuperclass();
            if (explicitMethod == null) continue;
            try {
                explicitMethod = type.getDeclaredMethod(explicitMethod.getName(), explicitMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeCamelException("Unable to find a method " + explicitMethod + " on " + type, (Throwable)e);
            }
        }
        if (changed) {
            return new Object[]{type, explicitMethod};
        }
        return null;
    }
}

