/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.stage.Popup;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.internal.scene.control.skin.TextFieldSkin;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.CalendarTextField;
import jfxtras.scene.control.ImageViewButton;
import jfxtras.scene.control.LocalDatePicker;
import jfxtras.scene.control.LocalDateTextField;
import jfxtras.scene.control.LocalDateTimePicker;
import jfxtras.scene.control.LocalDateTimeTextField;
import jfxtras.scene.layout.VBox;
import jfxtras.util.NodeUtil;

public class CalendarTextFieldSkin
extends SkinBase<CalendarTextField>
implements TextFieldSkin {
    private TextField textField = null;
    private ImageView imageView = null;
    public final BooleanProperty focusForwardingProperty = new SimpleBooleanProperty();
    private Popup popup = null;
    private CalendarPicker calendarPicker = null;

    public CalendarTextFieldSkin(CalendarTextField control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTextField)this.getSkinnable()).calendarProperty().addListener((observableValue, oldValue, newValue) -> this.refreshValue());
        ((CalendarTextField)this.getSkinnable()).dateFormatProperty().addListener((observableValue, oldValue, newValue) -> this.refreshValue());
        this.textField.textProperty().bindBidirectional(((CalendarTextField)this.getSkinnable()).textProperty());
        this.textField.editableProperty().bindBidirectional((Property)((CalendarTextField)this.getSkinnable()).editableProperty());
        this.refreshValue();
        this.initFocusSimulation();
        ((CalendarTextField)this.getSkinnable()).pickerShowingProperty().addListener((observable, oldValue, showing) -> {
            if (showing.booleanValue()) {
                this.showPopup();
            } else if (this.popup != null) {
                this.popup.hide();
            }
        });
    }

    private void refreshValue() {
        Calendar c = ((CalendarTextField)this.getSkinnable()).getCalendar();
        String s = c == null ? "" : ((CalendarTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
        if (!s.equals(((CalendarTextField)this.getSkinnable()).getText())) {
            ((CalendarTextField)this.getSkinnable()).setText(s);
        }
    }

    private void initFocusSimulation() {
        ((CalendarTextField)this.getSkinnable()).focusedProperty().addListener((observableValue, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                this.textField.requestFocus();
            }
        });
    }

    @Override
    public void selectAll() {
        this.textField.selectAll();
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.setPrefColumnCount(10 + (((CalendarTextField)this.getSkinnable()).getShowTime() != false ? 10 : 0));
        this.textField.focusedProperty().addListener(observable -> {
            if (!this.textField.isFocused()) {
                this.parse();
            }
            this.focusForwardingProperty.set(this.textField.focusedProperty().get());
        });
        this.textField.setOnAction(actionEvent -> this.parse());
        this.textField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                this.parse();
                Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
                if (lCalendar == null) {
                    return;
                }
                lCalendar = (Calendar)lCalendar.clone();
                int lField = 5;
                if (!keyEvent.isShiftDown() && keyEvent.isControlDown()) {
                    lField = 2;
                }
                if (!keyEvent.isShiftDown() && keyEvent.isAltDown()) {
                    lField = 1;
                }
                if (keyEvent.isShiftDown() && keyEvent.isControlDown() && ((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                    lField = 11;
                }
                if (keyEvent.isShiftDown() && keyEvent.isAltDown() && ((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                    lField = 12;
                }
                lCalendar.add(lField, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
            }
        });
        this.textField.tooltipProperty().bindBidirectional((Property)((CalendarTextField)this.getSkinnable()).tooltipProperty());
        if (((CalendarTextField)this.getSkinnable()).getTooltip() == null) {
            ((CalendarTextField)this.getSkinnable()).setTooltip(new Tooltip("Type a date or use # for today, or +/-<number>[d|w|m|y] for delta's (for example: -3m for minus 3 months)\nUse cursor up and down plus optional shift (week), ctrl (month) or alt (year) for quick keyboard changes."));
        }
        this.textField.promptTextProperty().bind(((CalendarTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageViewButton();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked(evt -> {
            if (!this.textField.isEditable()) {
                return;
            }
            if (this.textField.focusedProperty().get()) {
                this.parse();
            }
            ((CalendarTextField)this.getSkinnable()).setPickerShowing(true);
        });
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)this.textField);
        borderPane.setRight((Node)this.imageView);
        this.getChildren().add((Object)borderPane);
        ((CalendarTextField)this.getSkinnable()).getStyleClass().add((Object)this.getClass().getSimpleName());
    }

    private void parse() {
        this.parse(this.textField.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String lText) {
        block19: {
            try {
                lText = lText.trim();
                if (lText.length() == 0) {
                    if (!((CalendarTextField)this.getSkinnable()).getAllowNull()) {
                        throw new IllegalArgumentException("Empty string would result in null and that is not allowed");
                    }
                    ((CalendarTextField)this.getSkinnable()).setCalendar(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("d")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 5;
                    }
                    if (lText.toLowerCase().endsWith("w")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 3;
                    }
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 2;
                    }
                    if (lText.toLowerCase().endsWith("y")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 1;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((CalendarTextField)this.getSkinnable()).getCalendar().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                    break block19;
                }
                if (lText.equals("#")) {
                    ((CalendarTextField)this.getSkinnable()).setCalendar(Calendar.getInstance(((CalendarTextField)this.getSkinnable()).getLocale()));
                    break block19;
                }
                try {
                    Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
                    Date lDate = null;
                    for (DateFormat lDateFormat : ((CalendarTextField)this.getSkinnable()).getDateFormats()) {
                        try {
                            lDate = lDateFormat.parse(lText);
                            break;
                        }
                        catch (ParseException | DateTimeParseException exception) {
                        }
                    }
                    if (lDate == null) {
                        lDate = ((CalendarTextField)this.getSkinnable()).getDateFormat().parse(lText);
                    }
                    lCalendar = Calendar.getInstance(((CalendarTextField)this.getSkinnable()).getLocale());
                    lCalendar.setTime(lDate);
                    ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                }
                finally {
                    this.refreshValue();
                }
            }
            catch (Throwable t) {
                if (((CalendarTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((CalendarTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t);
                }
                t.printStackTrace();
            }
        }
    }

    private void setupPopup() {
        this.calendarPicker = new CalendarPicker();
        this.calendarPicker.setMode(CalendarPicker.Mode.SINGLE);
        this.calendarPicker.localeProperty().set((Object)((Locale)((CalendarTextField)this.getSkinnable()).localeProperty().get()));
        this.calendarPicker.allowNullProperty().set(((CalendarTextField)this.getSkinnable()).allowNullProperty().get());
        this.calendarPicker.calendarProperty().set((Object)((Calendar)((CalendarTextField)this.getSkinnable()).calendarProperty().get()));
        DateTimeToCalendarHelper.sync(this.calendarPicker.disabledCalendars(), ((CalendarTextField)this.getSkinnable()).disabledCalendars());
        DateTimeToCalendarHelper.sync(this.calendarPicker.highlightedCalendars(), ((CalendarTextField)this.getSkinnable()).highlightedCalendars());
        this.calendarPicker.displayedCalendar().set((Object)((CalendarTextField)this.getSkinnable()).getDisplayedCalendar());
        this.calendarPicker.setCalendarRangeCallback(new Callback<CalendarPicker.CalendarRange, Void>(){

            public Void call(CalendarPicker.CalendarRange calendarRange) {
                Callback<CalendarPicker.CalendarRange, Void> lCallback = ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).getCalendarRangeCallback();
                if (lCallback == null) {
                    return null;
                }
                return (Void)lCallback.call((Object)calendarRange);
            }
        });
        this.calendarPicker.setValueValidationCallback(new Callback<Calendar, Boolean>(){

            public Boolean call(Calendar calendar) {
                Callback<Calendar, Boolean> lCallback = ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).getValueValidationCallback();
                if (lCallback == null) {
                    return true;
                }
                return (Boolean)lCallback.call((Object)calendar);
            }
        });
        this.popup = new Popup();
        this.popup.setAutoFix(true);
        this.popup.setAutoHide(true);
        this.popup.setHideOnEscape(true);
        BorderPane lBorderPane = new BorderPane(){

            public String getUserAgentStylesheet() {
                return ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).getUserAgentStylesheet();
            }
        };
        lBorderPane.getStyleClass().add((Object)(this.getClass().getSimpleName() + "_popup"));
        lBorderPane.setCenter((Node)this.calendarPicker);
        this.calendarPicker.showTimeProperty().set((Object)((CalendarTextField)this.getSkinnable()).getShowTime());
        if (((CalendarTextField)this.getSkinnable()).getStyleClass().contains((Object)LocalDateTextField.class.getSimpleName())) {
            this.calendarPicker.getStyleClass().addAll((Object[])new String[]{LocalDatePicker.class.getSimpleName()});
        }
        if (((CalendarTextField)this.getSkinnable()).getStyleClass().contains((Object)LocalDateTimeTextField.class.getSimpleName())) {
            this.calendarPicker.getStyleClass().addAll((Object[])new String[]{LocalDateTimePicker.class.getSimpleName()});
        }
        if (((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
            VBox lVBox = new VBox();
            lBorderPane.rightProperty().set((Object)lVBox);
            ImageViewButton lAcceptIconImageView = new ImageViewButton();
            lAcceptIconImageView.getStyleClass().addAll((Object[])new String[]{"accept-icon"});
            lAcceptIconImageView.setPickOnBounds(true);
            lAcceptIconImageView.setOnMouseClicked(mouseEvent -> {
                ((CalendarTextField)this.getSkinnable()).calendarProperty().set((Object)((Calendar)this.calendarPicker.calendarProperty().get()));
                if (this.popup != null) {
                    this.popup.hide();
                }
            });
            lVBox.add((Node)lAcceptIconImageView);
            ImageViewButton lCloseIconImageView = new ImageViewButton();
            lCloseIconImageView.getStyleClass().addAll((Object[])new String[]{"close-icon"});
            lCloseIconImageView.setPickOnBounds(true);
            lCloseIconImageView.setOnMouseClicked(mouseEvent -> this.popup.hide());
            if (!((CalendarTextField)this.getSkinnable()).isImmediate()) {
                lVBox.add((Node)lCloseIconImageView);
            }
        }
        this.calendarPicker.calendarProperty().addListener(observable -> {
            if (!((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue() && this.popup.isShowing()) {
                this.popup.hide();
            }
            if (((CalendarTextField)this.getSkinnable()).isImmediate()) {
                ((CalendarTextField)this.getSkinnable()).calendarProperty().set((Object)((Calendar)this.calendarPicker.calendarProperty().get()));
            }
        });
        this.popup.setOnHiding(windowEvent -> {
            if (!((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                ((CalendarTextField)this.getSkinnable()).calendarProperty().set((Object)((Calendar)this.calendarPicker.calendarProperty().get()));
            }
            this.textField.setDisable(false);
            this.textField.requestFocus();
        });
        this.popup.getContent().setAll((Object[])new Node[]{lBorderPane});
        this.textField.setDisable(true);
        this.popup.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean showing) {
                ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).setPickerShowing(showing);
                if (!showing.booleanValue()) {
                    CalendarTextFieldSkin.this.popup.showingProperty().removeListener((ChangeListener)this);
                    CalendarTextFieldSkin.this.popup = null;
                }
            }
        });
    }

    private void showPopup() {
        if (this.popup == null) {
            this.setupPopup();
        }
        double height = this.textField.getHeight() == 0.0 ? this.textField.prefHeight(-1.0) : this.textField.getHeight();
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + height);
        this.calendarPicker.requestFocus();
    }
}

