/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.builders;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import jfxtras.fxml.BuilderService;
import jfxtras.scene.control.CalendarTimeTextField;
import jfxtras.scene.control.builders.AbstractBuilder;

public class CalendarTimeTextFieldBuilder
extends AbstractBuilder
implements BuilderService<CalendarTimeTextField> {
    private Locale iLocale = null;
    private String iPromptText = null;
    private String iDateFormat = null;
    private List<String> iDateFormats = null;

    public String getLocale() {
        return null;
    }

    public void setLocale(String value) {
        this.iLocale = Locale.forLanguageTag(value);
    }

    public String getPromptText() {
        return null;
    }

    public void setPromptText(String value) {
        this.iPromptText = value;
    }

    public String getDateFormat() {
        return null;
    }

    public void setDateFormat(String value) {
        this.iDateFormat = value;
    }

    public String getDateFormats() {
        return null;
    }

    public void setDateFormats(String value) {
        String[] lParts = value.split(",");
        this.iDateFormats = new ArrayList<String>();
        for (String lPart : lParts) {
            this.iDateFormats.add(lPart.trim());
        }
    }

    public CalendarTimeTextField build() {
        Locale lLocale = this.iLocale == null ? Locale.getDefault() : this.iLocale;
        CalendarTimeTextField lCalendarTimeTextField = new CalendarTimeTextField();
        if (this.iDateFormat != null) {
            lCalendarTimeTextField.setDateFormat(new SimpleDateFormat(this.iDateFormat, lLocale));
        }
        if (this.iLocale != null) {
            lCalendarTimeTextField.setLocale(this.iLocale);
        }
        if (this.iPromptText != null) {
            lCalendarTimeTextField.setPromptText(this.iPromptText);
        }
        if (this.iDateFormats != null) {
            ObservableList lDateFormats = FXCollections.observableArrayList();
            for (String lPart : this.iDateFormats) {
                lDateFormats.add((Object)new SimpleDateFormat(lPart.trim(), lLocale));
            }
            lCalendarTimeTextField.setDateFormats((ObservableList<DateFormat>)lDateFormats);
        }
        this.applyCommonProperties((Node)lCalendarTimeTextField);
        return lCalendarTimeTextField;
    }

    public boolean isBuilderFor(Class<?> clazz) {
        return CalendarTimeTextField.class.isAssignableFrom(clazz);
    }
}

