/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.builders;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import jfxtras.fxml.BuilderService;
import jfxtras.scene.control.LocalDateTextField;
import jfxtras.scene.control.builders.AbstractLocalDateTimeAPITextFieldBuilder;

public class LocalDateTextFieldBuilder
extends AbstractLocalDateTimeAPITextFieldBuilder
implements BuilderService<LocalDateTextField> {
    public LocalDateTextField build() {
        Locale lLocale = this.iLocale == null ? Locale.getDefault() : this.iLocale;
        LocalDateTextField lLocalDateTextField = new LocalDateTextField();
        if (this.iDateTimeFormatter != null) {
            lLocalDateTextField.setDateTimeFormatter(DateTimeFormatter.ofPattern(this.iDateTimeFormatter).withLocale(lLocale));
        }
        if (this.iLocale != null) {
            lLocalDateTextField.setLocale(this.iLocale);
        }
        if (this.iPromptText != null) {
            lLocalDateTextField.setPromptText(this.iPromptText);
        }
        if (this.iDateTimeFormatters != null) {
            ObservableList lDateTimeFormatters = FXCollections.observableArrayList();
            for (String lPart : this.iDateTimeFormatters) {
                lDateTimeFormatters.add((Object)DateTimeFormatter.ofPattern(lPart.trim()).withLocale(lLocale));
            }
            lLocalDateTextField.setDateTimeFormatters((ObservableList<DateTimeFormatter>)lDateTimeFormatters);
        }
        this.applyCommonProperties((Node)lLocalDateTextField);
        return lLocalDateTextField;
    }

    public boolean isBuilderFor(Class<?> clazz) {
        return LocalDateTextField.class.isAssignableFrom(clazz);
    }
}

