/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.client.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import de.effectivecompany.client.serial.EFCSerialResponseHandler;
import de.effectivecompany.client.serial.EFCSerialResponseHandlerAdapter;
import de.effectivecompany.client.serial.EFCSerialResponseListener;
import de.effectivecompany.client.serial.SBIMessage;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCSerial {
    public static Logger logger = LoggerFactory.getLogger(EFCSerial.class);
    private SerialPort comPort;

    public EFCSerial(String comPortName) {
        this.comPort = SerialPort.getCommPort((String)comPortName);
        this.comPort.setComPortParameters(2400, 7, 1, 1);
        this.comPort.setFlowControl(0);
    }

    public boolean sendMessage(SBIMessage message, String optionalMsgText, EFCSerialResponseHandler res) {
        boolean succ = true;
        if (this.comPort.openPort()) {
            if (message.valueRequired() && (optionalMsgText == null || optionalMsgText.isEmpty())) {
                logger.error("sendMessage messageType " + message.name() + " optionalMsgText required!");
                succ = false;
            }
            if (succ) {
                this.comPort.removeDataListener();
                this.comPort.addDataListener((SerialPortDataListener)new EFCSerialResponseListener(this.comPort, res));
                String value = "\u001b" + message.value() + optionalMsgText + message.post();
                byte[] sendData = value.getBytes(StandardCharsets.US_ASCII);
                int ret = this.comPort.writeBytes(sendData, sendData.length);
                if (ret < 0) {
                    succ = false;
                }
            }
        }
        if (!succ) {
            logger.error("sendMessage error: " + message.toString());
        }
        return succ;
    }

    public Double sendMessageSync(SBIMessage message, String optionalMsgText) throws InterruptedException, ExecutionException, TimeoutException {
        final CompletableFuture completableFuture = new CompletableFuture();
        boolean ret = this.sendMessage(message, optionalMsgText, new EFCSerialResponseHandlerAdapter(){

            @Override
            public void onResponse(Double value, String uom) {
                completableFuture.complete(value);
            }

            @Override
            public void onErrorResponse(String error) {
                completableFuture.complete(null);
            }
        });
        if (!ret) {
            completableFuture.complete(null);
        }
        return (Double)completableFuture.get(1L, TimeUnit.SECONDS);
    }

    public boolean disconnect() {
        return this.comPort.closePort();
    }

    public SerialPort getSerialPort() {
        return this.comPort;
    }
}

