/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.client.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import de.effectivecompany.client.serial.EFCSerialResponseHandler;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCSerialResponseListener
implements SerialPortPacketListener {
    public static Logger logger = LoggerFactory.getLogger(EFCSerialResponseListener.class);
    private EFCSerialResponseHandler serialResponseHandler;
    private final int packetSize = 16;
    private SerialPort port;

    public EFCSerialResponseListener(SerialPort port, EFCSerialResponseHandler serialResponseHandler) {
        this.serialResponseHandler = serialResponseHandler;
        this.port = port;
    }

    public int getListeningEvents() {
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent event) {
        try {
            String value = new String(event.getReceivedData(), StandardCharsets.US_ASCII);
            if (value != null && !value.isEmpty()) {
                if (value.getBytes().length != 16 || value.contains("ERR") || value.substring(6, 7).contains("C") || value.substring(6, 7).contains("-") || value.substring(6, 7).contains("H") || value.substring(6, 7).contains("L")) {
                    this.serialResponseHandler.onErrorResponse(value);
                } else if (value.contains("OK")) {
                    this.serialResponseHandler.onConfirmResponse();
                } else {
                    String uom = "";
                    Double doubleValue = null;
                    doubleValue = Double.parseDouble(value.substring(0, 10).replaceAll(" ", "").replace("[", "").replace("]", ""));
                    uom = value.substring(11, 13);
                    this.serialResponseHandler.onResponse(doubleValue, uom);
                }
            }
        }
        catch (Throwable th) {
            logger.error("Interner Fehler:", th);
            this.serialResponseHandler.onErrorResponse("Interner Fehler:" + th.toString());
        }
        finally {
            this.port.removeDataListener();
        }
    }

    public int getPacketSize() {
        return 16;
    }
}

