/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.msg.Msg;
import de.effectivecompany.base.msg.MsgList;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.data.EFCReportSelectionListEntry;
import de.effectivecompany.gui.actions.EFCActionWindowLock;
import de.effectivecompany.gui.components.EFCBaseFrame;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.EFCDialog;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.frame.EFCFrameLayoutInfo;
import de.effectivecompany.gui.components.frame.EFCPDFViewer;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.swing.EFCMessageListDialog;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.enums.EFCWindowMode;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.factory.EFCPrintFactory;
import de.effectivecompany.gui.factory.EFCReportSingleton;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.frame.BaseDialog;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.report.jasper.ReportInfoVerifier;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

public abstract class EFCBaseDialog
extends EFCBaseFrame
implements ActionHandler,
BaseDialog {
    private EFCPanel basePanel;
    protected EFCBaseFrame parent;
    private String title;
    protected EFCDialog dlg;
    private Integer returnValue;
    private Dimension dialogSize;
    private Point location;
    protected boolean validateInputOutside = false;

    public EFCBaseDialog(EFCBaseFrame parent, String title, String layout, EnumSet<EFCAction> menu, Class<? extends BusinessObject> boClass) {
        this(parent, title, layout, menu, (Dimension)null, boClass, false);
    }

    public EFCBaseDialog(EFCBaseFrame parent, String title, String layout, EnumSet<EFCAction> menu, Dimension size, Class<? extends BusinessObject> boClass) {
        this(parent, title, layout, menu, size, boClass, false);
    }

    public EFCBaseDialog(EFCBaseFrame parent, String title, String layout, EnumSet<EFCAction> menu, Dimension size, Class<? extends BusinessObject> boClass, boolean validateInputOutside) {
        super((EFCController)parent, title, menu, size, null, null);
        try {
            this.setBusObj(boClass.newInstance());
            this.basePanel = EFCPanelSingleton.getInstance().generatePanel(layout, boClass, (ElementManager)this.getViewManager(), this.getDataChangeManager(), this.getBusinessObjectModel(), (EFCController)this);
        }
        catch (Exception ex) {
            EFCDesktop.reportError((Throwable)ex);
        }
        this.validateInputOutside = validateInputOutside;
        this.layoutFile = layout;
        this.businessObjectClass = boClass;
        this.setWindowMode(EFCWindowMode.MODE_EDIT);
        this.parent = parent;
        this.title = title;
        this.dialogSize = size;
        this.view.setDialogView(true);
        this.getViewManager().setToolbarButtonVisible(EFCAction.invert(menu), false);
        EFCFrameLayoutInfo posInfo = EFCPanelSingleton.getInstance().getFramePosition(((Object)((Object)this)).getClass().getSimpleName(), this.getParentController() != null ? this.getParentController().getClass().getSimpleName() : null);
        if (posInfo != null) {
            this.dialogSize = new Dimension(posInfo.getWidth(), posInfo.getHeight());
            this.location = new Point(posInfo.getLocationX(), posInfo.getLocationY());
            this.isWindowPositionLocked = true;
            this.logger.info("setzte Benutzer-bezogene Frame-Position in: " + ((Object)((Object)this)).getClass().getSimpleName() + (String)(this.getParentController() != null ? " - " + this.getParentController().getClass().getSimpleName() : ""));
        }
    }

    public void execute(BusinessObject input) {
        String[] answ = new String[]{Translator.tr((String)"_OK")};
        this.execute(input, answ);
    }

    public void execute(BusinessObject input, List<String> options) {
        this.execute(input, options.toArray(new String[options.size()]));
    }

    public void execute(BusinessObject input, List<String> options, String hideGroup) {
        this.execute(input, options.toArray(new String[options.size()]), hideGroup);
    }

    public void execute(BusinessObject input, List<String> options, String hideGroup, String defaultOption) {
        this.execute(input, options.toArray(new String[options.size()]), hideGroup, defaultOption);
    }

    public void execute(BusinessObject input, String[] options) {
        this.execute(input, options, "", "");
    }

    public void execute(BusinessObject input, String[] options, String hideGroup) {
        this.execute(input, options, hideGroup, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(BusinessObject input, String[] options, String hideGroup, String defaultOption) {
        try {
            this.init();
            this.setBusObj(input);
            this.loadFields();
            if (hideGroup != null && !hideGroup.isEmpty()) {
                this.getViewManager().setGroupVisible(hideGroup, false);
            }
            this.dlg = new EFCDialog((Window)EFCMainFrame.getInstance(), this, this.title, this.getMainMenu(), (JComponent)this.basePanel, true, this.dialogSize, this.location, this.isWindowPositionLocked, options, this.validateInputOutside, defaultOption);
            if (this.isObjLoaded()) {
                this.showMessageDlg(this.getBusObj().getCompleteMsgList(), false);
                this.getBusObj().clearCompleteMsgList();
            }
            if (this.progressDialog != null) {
                this.progressDialog.dispose();
            }
            this.dlg.showDialog();
        }
        catch (Throwable th) {
            EFCDesktop.reportError((Throwable)th);
        }
    }

    public void setTitle(String title) {
        this.dlg.setTitle(title);
    }

    @Override
    public void handleKey(int keyCode, String elementIdent, int modifier) {
        super.handleKey(keyCode, elementIdent, modifier);
        if (keyCode == 10 && this.viewManager.getAllFieldIdentsVisible().size() == 1 && this.viewManager.fieldExists(elementIdent) && !this.handleChangedFields.contains(elementIdent)) {
            this.logger.info("closing Dialog by ENTER in field: {}", (Object)elementIdent);
            this.getDialog().doClickDefaultOption();
        }
    }

    public void setLocation(Point location) {
        this.dlg.setLocation(location);
    }

    protected void lockWindowPosition(Boolean isLocked) {
        String frameName = ((Object)((Object)this)).getClass().getSimpleName();
        if (!isLocked.booleanValue()) {
            Dimension preferredSize = this.dlg.getSize();
            Point location = SwingUtilities.convertPoint(this.dlg, new Point(0, 0), (Component)EFCMainFrame.getInstance());
            EFCFrameLayoutInfo layoutInfo = new EFCFrameLayoutInfo(this.getLayoutFileName(), preferredSize.getSize().width, preferredSize.getSize().height, location.x, location.y, false);
            EFCPanelSingleton.getInstance().setFramePosition(frameName, this.getParentController() != null ? this.getParentController().getClass().getSimpleName() : null, layoutInfo);
        } else {
            EFCPanelSingleton.getInstance().removeFramePosition(frameName, this.getParentController() != null ? this.getParentController().getClass().getSimpleName() : null);
        }
    }

    public void initDialog() {
        if (this.dlg != null && this.getViewManager().getFirstFocusableField() != null && !this.getViewManager().getFirstFocusableField().isEditable()) {
            this.dlg.getDefaultOptionButton().requestFocusInWindow();
        }
    }

    public void checkLastInput() {
        String text;
        JComponent comp;
        String lastIdent = this.viewManager.getLastActiveIdent();
        if (lastIdent != null && !this.getHandleChangedFields().contains(lastIdent) && (comp = this.getViewManager().getField(lastIdent)) != null && comp instanceof EFCAbstractEditor && !(text = ((EFCAbstractEditor)comp).getValue() != null ? ((EFCAbstractEditor)comp).getValue().toString() : "").equals(((EFCAbstractEditor)comp).getOriginalValue() != null ? ((EFCAbstractEditor)comp).getOriginalValue().toString() : "")) {
            ((EFCAbstractEditor)comp).fireValueChangeEvent(((EFCAbstractEditor)comp).getIdent(), ((EFCAbstractEditor)comp).getOriginalValue(), ((EFCAbstractEditor)comp).getValue());
        }
        if (this.saveThreadUtil == null) {
            this.saveThreadUtil = EFCThreadUtil.builder();
        }
        if (this.getSaveWorker() == null || this.getSaveWorker().getState().equals((Object)Thread.State.TERMINATED)) {
            try {
                Thread worker = this.getActiveWorker();
                if (worker != null) {
                    worker.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean validateInput() {
        return true;
    }

    public EFCDialog getDialog() {
        return this.dlg;
    }

    public Integer getAnswer() {
        return this.dlg.getAnswer();
    }

    public void dispose() {
        this.terminate();
        this.basePanel.terminate();
        this.basePanel = null;
        this.dlg.setVisible(false);
        this.dlg.dispose();
    }

    @Override
    protected void init() {
        String searchListName;
        Key bk = null;
        try {
            bk = ((BusinessObject)this.getBusinessObjectClass().newInstance())._getKey();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (this.getBusObjKeyList().isEmpty() && bk != null && !bk.isEmpty()) {
            this.setBusObjKeyList(new ArrayList<String>(bk.getKeys().keySet()));
            if (!this.getBusObjKeyList().isEmpty() && (this.getOrderField() == null || this.getOrderField().isEmpty())) {
                this.setOrderField(this.getBusObjKeyList().get(this.getBusObjKeyList().size() - 1));
            }
        }
        if (this.getWindowMode() == null) {
            if (this.parentController == null) {
                if (this.getLaunchParam().containsKey("INFO")) {
                    this.setWindowMode(EFCWindowMode.MODE_INFO_SCROLL);
                    this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_INFO);
                } else {
                    this.setWindowMode(EFCWindowMode.MODE_SCROLL);
                }
            } else {
                this.setWindowMode(EFCWindowMode.MODE_INFO);
                this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_INFO);
            }
        }
        this.initForLayout();
        if (this.getLaunchParam().containsKey("SEARCH")) {
            searchListName = (String)this.getLaunchParam().get("SEARCH");
            if (searchListName != null) {
                if (this.getLaunchParam().containsKey("SEARCHAUTOSTART")) {
                    this.openStdSearchFrameAutoStart(searchListName, false);
                } else {
                    this.openStdSearchFrame(searchListName, false);
                }
            } else {
                this.openStdSearchFrame();
            }
        } else if (this.getLaunchParam().containsKey("SEARCHSAVED") && (searchListName = (String)this.getLaunchParam().get("SEARCHSAVED")) != null) {
            if (this.getLaunchParam().containsKey("SEARCHAUTOSTART")) {
                this.openStdSearchFrameAutoStart(searchListName, true);
            } else {
                this.openStdSearchFrame(searchListName, true);
            }
        }
        if (this.view.getEFCToolBar() != null) {
            for (Action action : this.view.getEFCToolBar().getActions()) {
                if (!(action instanceof EFCActionWindowLock)) continue;
                ((EFCActionWindowLock)action).setSelected(this.isWindowPositionLocked);
            }
        }
    }

    public void lockControl() {
        this.dlg.lockFrame();
    }

    public void lockControl(boolean lockChilds) {
        this.dlg.lockFrame();
    }

    public void unlockControl(boolean unlockParent) {
        this.dlg.unlockFrame();
    }

    public void unlockControl() {
        this.dlg.unlockFrame();
    }

    public void unLockFrame() {
        this.unLockFrame(true, true);
    }

    public void unLockFrame(boolean focusField, boolean unlockParent) {
        this.dlg.unlockFrame();
        if (focusField) {
            JTextField focusableField = null;
            if (this.viewManager != null) {
                focusableField = this.viewManager.getFocusableField();
            }
            if (focusableField != null && focusableField.isEditable()) {
                focusableField.requestFocusInWindow();
            } else {
                JComponent compo;
                Component comp = this.getFocusOwner();
                if (comp != null) {
                    comp.requestFocusInWindow();
                    if (comp instanceof JTextField) {
                        ((JTextField)comp).selectAll();
                    }
                } else if (this.viewManager != null && this.viewManager.getFocusableField() == null && (compo = this.viewManager.getField(this.viewManager.getLastActiveField())) != null && compo instanceof EditorComponent) {
                    ((EditorComponent)compo).getEditorComponent().requestFocusInWindow();
                    if (((EditorComponent)compo).getEditorComponent() instanceof JTextField) {
                        ((JTextField)((EditorComponent)compo).getEditorComponent()).selectAll();
                    }
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(compo);
                }
            }
        }
    }

    public void unLockFrame(boolean focusField) {
        this.unLockFrame(focusField, true);
    }

    public void lockFrame() {
        this.dlg.lockFrame();
    }

    public int showYesNoDlg(Object message, String title, int defaultButton) {
        Object[] options = Arrays.asList(UIManager.getString("OptionPane.yesButtonText"), UIManager.getString("OptionPane.noButtonText")).toArray();
        return JOptionPane.showOptionDialog(this.dlg, message, title, 0, 3, null, options, options[defaultButton]);
    }

    public void showErrorDlg(String message) {
        JOptionPane.showMessageDialog(this.dlg, message, this.title, 0);
    }

    public void showErrorDlg(String message, String title) {
        JOptionPane.showMessageDialog(this.dlg, message, title, 0);
    }

    public void showExceptionDlg(Throwable e) {
        JXErrorPane.showDialog((Component)this.dlg, (ErrorInfo)new ErrorInfo("Error", e.getClass().getSimpleName(), null, "some cat", e, Level.SEVERE, null));
    }

    public int showYesNoDlg(Object message, String title) {
        return this.showYesNoDlg(message, title, 0);
    }

    public int showYesNoCancelDlg(String message, String title, int defaultButton) {
        Object[] options = Arrays.asList(UIManager.getString("OptionPane.yesButtonText"), UIManager.getString("OptionPane.noButtonText"), UIManager.getString("OptionPane.cancelButtonText")).toArray();
        return JOptionPane.showOptionDialog(this.dlg, message, title, 1, 3, null, options, options[defaultButton]);
    }

    public int showYesNoCancelDlg(String message, String title) {
        return this.showYesNoCancelDlg(message, title, 0);
    }

    public void showExceptionDlg(String message, Throwable e) {
        JXErrorPane.showDialog((Component)this.dlg, (ErrorInfo)new ErrorInfo("Error", message, null, "some cat", e, Level.SEVERE, null));
    }

    public void showWarningDlg(Object message, String title) {
        JOptionPane.showMessageDialog(this.dlg, message, title, 2);
    }

    public void showInfoDlg(Object message, String title) {
        JOptionPane.showMessageDialog(this.dlg, message, title, 1);
    }

    public void showInfoDlg(Object message) {
        JOptionPane.showMessageDialog(this.dlg, message, Translator.tr((String)"DLG_TITLE_INFO"), 1);
    }

    public String showInputDlg(String label, String title) {
        return JOptionPane.showInputDialog(this.dlg, label, title, 3);
    }

    public boolean onValidateInput() {
        return true;
    }

    public Integer getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Integer returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    protected void onUpdateBusObjBySync(Key key) {
    }

    public void printReport(final EFCReportSelectionListEntry actualReport, final ReportInfoVerifier verifier) {
        this.lockFrame();
        if (actualReport == null) {
            this.showInfoDlg(Translator.tr((String)"MSG_FRAME_NO_REPORT_STANDARD_FOUND"));
            return;
        }
        if (this.getPrintSelectionDialog() != null) {
            this.getPrintSelectionDialog().setLocked(true);
        }
        new SwingWorker<EFCReportContainer, Object>(){

            @Override
            protected EFCReportContainer doInBackground() throws Exception {
                EFCReportContainer efcReportContainer = null;
                try {
                    efcReportContainer = EFCReportSingleton.getInstance().buildReport(actualReport, verifier);
                }
                catch (Throwable e) {
                    EFCBaseDialog.this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), e);
                    EFCBaseDialog.this.reportError(e);
                }
                return efcReportContainer;
            }

            @Override
            protected void done() {
                try {
                    EFCReportContainer efcReportContainer = (EFCReportContainer)this.get();
                    if (efcReportContainer != null) {
                        EFCReportContainer finalEfcReportContainer = efcReportContainer;
                        EFCThreadUtil.doLater(() -> {
                            boolean sendMail = false;
                            int selection = finalEfcReportContainer.getClSysPrnSrv().getPrnpreviewtype().getData() == 0 ? 1 : (finalEfcReportContainer.getClSysPrnSrv().getPrnpreviewtype().getData() == 2 ? 0 : EFCBaseDialog.this.showYesNoCancelDlg(Translator.tr((String)"MSG_FRAME_OPTIONDLG_PRINTPREVIEW_QUESTION"), Translator.tr((String)"MSG_FRAME_OPTIONDLG_PRINTPREVIEW_TITLE")));
                            if (selection != 2 && (finalEfcReportContainer.getClSysPrnSrv().getPrntype().getData() == 11 || finalEfcReportContainer.getClSysPrnSrv().getPrntype().getData() == 12)) {
                                sendMail = true;
                            }
                            if (selection == 0) {
                                EFCPDFViewer viewer = new EFCPDFViewer(finalEfcReportContainer, Translator.tr((String)"DLG_TITLE_REPORT_PREVIEW"));
                                EFCDesktop.getInstance().add((Component)viewer);
                            } else if (selection == 1 && !sendMail) {
                                new EFCPrintFactory().print(finalEfcReportContainer);
                            }
                            if (sendMail) {
                                EFCBaseDialog.this.onCreateMailDialogForPrint(finalEfcReportContainer, new EFCString(actualReport.getEmailAdr()), actualReport.getEmailAdrCcList(), actualReport.getEmailAdrBccList());
                            }
                        });
                    } else {
                        EFCBaseDialog.this.logger.error("cannot display report: report document is null");
                    }
                }
                catch (Exception ex) {
                    EFCDesktop.reportError((Throwable)ex);
                }
                EFCBaseDialog.this.unLockFrame();
            }
        }.execute();
    }

    public void reportError(Throwable e) {
        this.reportError(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
    }

    public void reportError(String message, Throwable e) {
        EFCThreadUtil.doLater(() -> JXErrorPane.showDialog((Component)this.dlg, (ErrorInfo)new ErrorInfo("Error", message, null, "some cat", e, Level.SEVERE, null)));
        this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), e);
    }

    public void showMessageDlg(Msg message) {
        if (message == null) {
            return;
        }
        String title = Translator.tr((String)"DLG_TITLE_INFO");
        if (message.getType() == MsgType.WARNING) {
            title = Translator.tr((String)"DLG_TITLE_WARNING");
            this.showWarningDlg(message.getMsg(), title);
        } else if (message.getType() == MsgType.ERROR) {
            title = Translator.tr((String)"DLG_TITLE_ERROR");
            this.showErrorDlg(message.getMsg().getMsg(), title);
        } else if (message.getType() == MsgType.FATAL) {
            title = Translator.tr((String)"DLG_TITLE_FATAL");
            this.showErrorDlg(message.getMsg().getMsg(), title);
        } else {
            this.showInfoDlg(message.getMsg(), title);
        }
    }

    public void showMessageDlg(List<Msg> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        EFCMessageListDialog messageDlg = new EFCMessageListDialog((Dialog)this.dlg, true);
        messageDlg.show(messages);
        if (this.getBusObj() != null) {
            this.getBusObj().clearCompleteMsgList();
        }
    }

    public void showMessageDlg(MsgList messages) {
        if (messages == null) {
            return;
        }
        if (!messages.hasMessages()) {
            return;
        }
        EFCMessageListDialog messageDlg = new EFCMessageListDialog((Dialog)this.dlg, true);
        messageDlg.show(messages.getMsgList());
        if (this.getBusObj() != null) {
            this.getBusObj().clearCompleteMsgList();
        }
    }

    public void showMessageDlg(MsgList messages, boolean modal) {
        if (messages == null) {
            return;
        }
        if (!messages.hasMessages()) {
            return;
        }
        EFCMessageListDialog messageDlg = new EFCMessageListDialog((Dialog)this.dlg, true);
        messageDlg.setModal(modal);
        messageDlg.show(messages.getMsgList());
        if (this.getBusObj() != null) {
            this.getBusObj().clearCompleteMsgList();
        }
    }

    public BusinessObject getBusObj() {
        return super.getBusObj();
    }

    public JButton getOptionButton(int index) {
        return this.dlg.getOptionButton(index);
    }
}

