/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import de.effectivecompany.app.doc.TdDoc;
import de.effectivecompany.app.doc.TdDocItem;
import de.effectivecompany.app.prd.BoPrdNetDoc;
import de.effectivecompany.app.prd.BoPrdNetPrdDoc;
import de.effectivecompany.app.prd.TdPrdDoc;
import de.effectivecompany.app.qlt.TdQltDoc;
import de.effectivecompany.app.scb.BoScbBas;
import de.effectivecompany.app.scb.ScbBase;
import de.effectivecompany.app.scbcl.ClScbScbKeyDet;
import de.effectivecompany.app.sst.DcPrdForCap;
import de.effectivecompany.app.sst.SoLiBomDocItemWul;
import de.effectivecompany.app.sst.SoLiDoc;
import de.effectivecompany.app.sst.SoLiDocItem;
import de.effectivecompany.app.sst.SoLiPrdDoc;
import de.effectivecompany.app.sst.SoLiQltDoc;
import de.effectivecompany.app.sst.SoLiRptGrid;
import de.effectivecompany.app.sys.SysObjRef;
import de.effectivecompany.app.sys.SysParam;
import de.effectivecompany.base.data.BusinessDataObject;
import de.effectivecompany.base.data.BusinessListEntry;
import de.effectivecompany.base.datatypes.EFCAlphaNumeric;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.filter.Filter;
import de.effectivecompany.base.gui.filter.FilterCriteria;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.gui.interfaces.SelectResult;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.meta.MetaInfo;
import de.effectivecompany.base.meta.TypeInfo;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.client.controller.XciActions;
import de.effectivecompany.data.DummyGuiService;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.data.EFCReportSelectionListEntry;
import de.effectivecompany.gui.components.EFCBaseDialog;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.EFCSearchDialog;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.EFCLabel;
import de.effectivecompany.gui.components.editor.EFCObjectListEditor;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchFrame;
import de.effectivecompany.gui.components.model.table.EFCBoModel;
import de.effectivecompany.gui.components.model.table.ScbTableModel;
import de.effectivecompany.gui.components.panel.EFCBOTablePanel;
import de.effectivecompany.gui.components.panel.EFCBusinessDataTablePanel;
import de.effectivecompany.gui.components.panel.EFCFormPanel;
import de.effectivecompany.gui.components.panel.EFCListTablePanel;
import de.effectivecompany.gui.components.panel.EFCScbTablePanel;
import de.effectivecompany.gui.components.panel.EFCSplitPanel;
import de.effectivecompany.gui.components.panel.EFCTabPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCBoCellRenderer;
import de.effectivecompany.gui.components.swing.model.explorer.ETreeElement;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.constants.EFCPredefinedMenu;
import de.effectivecompany.gui.constants.EFCPredefinedToolBar;
import de.effectivecompany.gui.enums.EFCAutostart;
import de.effectivecompany.gui.enums.EFCObjectState;
import de.effectivecompany.gui.enums.EFCSearchMode;
import de.effectivecompany.gui.enums.EFCWindowMode;
import de.effectivecompany.gui.events.UserInteractionEvent;
import de.effectivecompany.gui.exceptions.ActionNotAllowedException;
import de.effectivecompany.gui.exceptions.InvalidTableSelectionException;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.factory.EFCViewerFactory;
import de.effectivecompany.gui.frame.EFCFrSd;
import de.effectivecompany.gui.frame.EFCFrWf;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.element.PrimaryEditorComponent;
import de.effectivecompany.gui.interfaces.listeners.UserInteractionListener;
import de.effectivecompany.gui.manager.EFCFileManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCClosure;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.GuiTools;
import de.effectivecompany.gui.util.MailTools;
import de.effectivecompany.lock.ObjectAlreadyLockedException;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.util.Eval;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.RemoteAccessException;

public abstract class EFCBaseFrame
extends EFCController {
    public Logger logger;
    protected ArrayList<String> busObjKeyList;
    protected ArrayList<String> dmsKeyList;
    protected Boolean isSysObjRefFilled;
    private Key syncKey;
    private Timer timer;

    public EFCBaseFrame(EFCController parent, String title, EnumSet<EFCAction> menu, Dimension dimension) {
        this(parent, title, menu, null, null, dimension, null, null);
    }

    public EFCBaseFrame(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, null, null);
    }

    public EFCBaseFrame(String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension) {
        this(null, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, null, null);
    }

    public EFCBaseFrame(String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService) {
        this(null, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, null);
    }

    public EFCBaseFrame(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, null);
    }

    public EFCBaseFrame(EFCController parent, String title, EnumSet<EFCAction> menu, Dimension dimension, String mainService, Map<String, Object> param) {
        this(parent, title, menu, null, null, dimension, mainService, param, null);
    }

    public EFCBaseFrame(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService, Map<String, Object> param) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, param, null);
    }

    public EFCBaseFrame(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService, Map<String, Object> param, String[] buttonNames) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, param, null, buttonNames);
    }

    public EFCBaseFrame(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService, Map<String, Object> param, BusinessObject bo, String[] buttonNames) {
        block10: {
            super(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, param, bo, buttonNames);
            this.busObjKeyList = new ArrayList();
            this.dmsKeyList = new ArrayList();
            this.isSysObjRefFilled = false;
            this.syncKey = new Key();
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            this.setOrderField("COMPANY");
            if (EFCDesktop.getCompany() != null && !EFCDesktop.getCompany().isEmpty()) {
                this.baseFilter.addCriteria(new FilterCriteria("COMPANY", 0, (Object)EFCDesktop.getCompany()));
                this.scrollFilter.addCriteria(new FilterCriteria("COMPANY", 0, (Object)EFCDesktop.getCompany()));
            }
            if (param != null && param.containsKey("MAXIMIZE")) {
                try {
                    this.view.setMaximum(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
            Closure<?> outside = this.initOutside();
            if (param != null && param.containsKey("TIMER")) {
                try {
                    if (outside != null) {
                        this.handleOutside(new Closure[]{outside, new EFCClosure((Object)this){
                            private static final long serialVersionUID = 1L;

                            public EFCThreadUtil call(Object arguments) {
                                EFCThreadUtil sb = (EFCThreadUtil)arguments;
                                EFCBaseFrame.this.initTimer(Integer.parseInt(EFCBaseFrame.this.launchParam.get("TIMER").toString()));
                                return sb;
                            }
                        }});
                        break block10;
                    }
                    this.initTimer(Integer.parseInt(this.launchParam.get("TIMER").toString()));
                }
                catch (NumberFormatException nfe) {
                    this.logger.warn("initTimer fehlgeschlagen, NumberFormatException: " + nfe.getMessage());
                }
            } else if (outside != null) {
                this.handleOutside(new Closure[]{outside});
            }
        }
    }

    protected Closure<?> initOutside() {
        return null;
    }

    protected void onUpdateBusObjBySync(Key key) {
        this.updateBusObj(key);
    }

    protected void initForLayout() {
        switch (this.getWindowMode()) {
            case MODE_INFO_SCROLL: 
            case MODE_INFO: {
                this.viewManager.setMenuFunctionsVisible(Boolean.valueOf(false));
                this.viewManager.setMenuStatusVisible(Boolean.valueOf(false));
                this.viewManager.setMenuInventoryVisible(Boolean.valueOf(false));
                break;
            }
            default: {
                this.viewManager.setMenuListingVisible(Boolean.valueOf(false));
                this.viewManager.setMenuAnalysisVisible(Boolean.valueOf(false));
            }
        }
        this.viewManager.setFocusToFirstField();
    }

    protected void onSync(final SysParam valueObj, Map<String, Object> valueList, final CountDownLatch latch, ExecutorService executor) {
        if (!this.isObjSaved()) {
            return;
        }
        if (this.getWindowMode() == EFCWindowMode.MODE_EDIT) {
            this.setWindowMode(EFCWindowMode.MODE_SCROLL);
        }
        this.lockFrame(false);
        final AtomicBoolean done = new AtomicBoolean(false);
        this.handleOutside(false, new Closure[]{new EFCClosure((Object)this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)args;
                if (valueObj != null) {
                    Key newKey = GuiTools.fillNewKey(valueObj);
                    if (EFCBaseFrame.this.busObjKeyList != null && !EFCBaseFrame.this.busObjKeyList.isEmpty()) {
                        Key busObjKey = new Key();
                        for (String key2 : EFCBaseFrame.this.busObjKeyList) {
                            if (!newKey.containsKey((Object)key2)) continue;
                            busObjKey.addKeyValue(key2, (String)newKey.get((Object)key2));
                        }
                        newKey = busObjKey;
                    }
                    Key finalnewKey = newKey;
                    if (EFCBaseFrame.this.busObjKeyList == null || EFCBaseFrame.this.busObjKeyList.isEmpty() || EFCBaseFrame.this.syncKey.getKeys().isEmpty() || EFCBaseFrame.this.busObjKeyList.stream().filter(key -> EFCBaseFrame.this.syncKey.get(key) != null && !((String)EFCBaseFrame.this.syncKey.get(key)).equals(finalnewKey.get(key))).findAny().isPresent()) {
                        if (EFCBaseFrame.this.busObjKeyList != null && !EFCBaseFrame.this.busObjKeyList.isEmpty() && EFCBaseFrame.this.busObjKeyList.stream().filter(key -> key != "COMPANY" && finalnewKey.get(key) != null && !((String)finalnewKey.get(key)).isEmpty()).toArray().length == 0) {
                            EFCBaseFrame.this.logger.warn("No actualizing data (empty key) by method 'onSync' in frame: " + ((Object)((Object)this)).getClass().getSimpleName());
                        } else {
                            EFCBaseFrame.this.logger.debug("Actualizing data by method 'onSync' in frame: " + ((Object)((Object)this)).getClass().getSimpleName());
                            EFCBaseFrame.this.syncKey = finalnewKey;
                            EFCBaseFrame.this.onUpdateBusObjBySync(finalnewKey);
                            done.set(true);
                        }
                    } else {
                        EFCBaseFrame.this.logger.debug("No actualizing of data by method 'onSync' neccessary (no key changed) in frame: " + ((Object)((Object)this)).getClass().getSimpleName());
                    }
                } else {
                    EFCBaseFrame.this.logger.warn("No actualizing of data by method 'onSync' possible (no key) in frame: " + ((Object)((Object)this)).getClass().getSimpleName());
                }
                return sb;
            }
        }, new EFCClosure((Object)this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object arguments) {
                EFCThreadUtil sb = (EFCThreadUtil)arguments;
                sb.edt((Closure)new EFCClosure(sb){
                    private static final long serialVersionUID = 1L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)arguments;
                        try {
                            Component comp;
                            if (!EFCBaseFrame.this.isObjLoaded()) {
                                GuiTools.fillParamObj(EFCBaseFrame.this.sysParam, valueObj);
                            }
                            if (done.get()) {
                                EFCBaseFrame.this.updatePanelsBySync();
                            }
                            if (EFCBaseFrame.this.parentController != null && (comp = EFCBaseFrame.this.parentController.viewManager.getLastFocusOwner()) != null) {
                                comp.requestFocusInWindow();
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                        return sb;
                    }
                });
                return sb;
            }
        }});
    }

    protected void onSync(final Key key, Map<String, Object> valueList, final CountDownLatch latch, ExecutorService executor) {
        this.lockFrame(false);
        this.handleOutside(false, new Closure[]{new EFCClosure((Object)this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)args;
                if (key != null && key.entrySet().stream().filter(entry -> entry.getKey() != "COMPANY" && entry.getValue() != null).toArray().length > 0) {
                    EFCBaseFrame.this.logger.debug("Actualizing data by method 'onSync' in frame: " + ((Object)((Object)this)).getClass().getSimpleName());
                    EFCBaseFrame.this.onUpdateBusObjBySync(key);
                } else {
                    EFCBaseFrame.this.logger.debug("No actualizing of data by method 'onSync' possible (no key) in frame: " + ((Object)((Object)this)).getClass().getSimpleName());
                }
                return sb;
            }
        }, new EFCClosure((Object)this){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public EFCThreadUtil call(Object arguments) {
                EFCThreadUtil sb = (EFCThreadUtil)arguments;
                try {
                    Component comp;
                    if (!EFCBaseFrame.this.isObjLoaded()) {
                        // empty if block
                    }
                    EFCBaseFrame.this.updatePanelsBySync();
                    if (EFCBaseFrame.this.parentController != null && (comp = EFCBaseFrame.this.viewManager.getLastFocusOwner()) != null) {
                        comp.requestFocusInWindow();
                    }
                }
                finally {
                    latch.countDown();
                }
                return sb;
            }
        }});
    }

    protected void setBusObjKeyList(ArrayList<String> kList) {
        this.busObjKeyList = kList;
    }

    public ArrayList<String> getBusObjKeyList() {
        return this.busObjKeyList;
    }

    protected void updatePanelsBySync() {
    }

    public void onCreateMailViewer(EFCMap<EFCString, EFCString> contentParams, EFCBlob mail) {
        MailTools.createMailViewer(contentParams, mail);
    }

    protected void onCreateMailDialogForPrint(EFCReportContainer reportContainer, EFCString mailToAddress, List<String> mailToCcList, List<String> mailToBccList) {
        MailTools.createMailDialogForPrint(reportContainer, mailToAddress, null, null, mailToCcList, mailToBccList);
    }

    public void onCreateMailDialog(EFCMap<EFCString, EFCString> contentParams, EFCMap<EFCString, EFCBlob> attachments, EFCString mailToAddress, EFCList<String> mailToCcList, EFCList<String> mailToBccList) {
        MailTools.createMailDialog(contentParams, attachments, mailToAddress, null, null, mailToCcList, mailToBccList);
    }

    protected final void openStdSearchFrameAutoStart(String searchListName, Boolean isSavedSearch) {
        if (!this.isSearchAllowed(EFCSearchMode.MODE_FOR_SCROLL)) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (isSavedSearch.booleanValue()) {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, null, "", this.baseFilter, this.searchService, EFCAutostart.SEARCHSAVED, (Map)ImmutableMap.of((Object)"listname", (Object)searchListName), EFCSearchMode.MODE_FOR_SCROLL));
        } else {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, null, "", this.baseFilter, this.searchService, EFCAutostart.SEARCH, (Map)ImmutableMap.of((Object)"listname", (Object)searchListName), EFCSearchMode.MODE_FOR_SCROLL));
        }
    }

    protected boolean isSearchAllowed(EFCSearchMode mode) {
        for (EFCSearchFrame searchFrame : this.searchFrames) {
            if (!searchFrame.getSearchMode().equals((Object)mode)) continue;
            return false;
        }
        return true;
    }

    protected final void openStdSearchFrame() {
        this.openStdSearchFrame("", false);
    }

    protected final void openStdSearchFrame(String searchListName, Boolean isSavedSearch) {
        if (!this.isSearchAllowed(EFCSearchMode.MODE_FOR_SCROLL)) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (this.searchService.getSearchListCount() == 0) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_SEARCHSERVICE_DEFINED"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (searchListName != null) {
            if (isSavedSearch.booleanValue()) {
                EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, null, "", this.baseFilter, this.searchService, EFCAutostart.SELECTSAVED, (Map)ImmutableMap.of((Object)"listname", (Object)searchListName), EFCSearchMode.MODE_FOR_SCROLL));
            } else {
                EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, null, "", this.baseFilter, this.searchService, EFCAutostart.SELECT, (Map)ImmutableMap.of((Object)"listname", (Object)searchListName), EFCSearchMode.MODE_FOR_SCROLL));
            }
        } else {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, null, "", this.baseFilter, this.searchService, EFCAutostart.NOTHING, new HashMap(), EFCSearchMode.MODE_FOR_SCROLL));
        }
    }

    protected void init() {
        try {
            String searchListName;
            Key bk = ((BusinessObject)this.getBusinessObjectClass().newInstance())._getKey();
            if (bk != null && (this.busObjKeyList == null || this.busObjKeyList.isEmpty())) {
                this.setBusObjKeyList(new ArrayList<String>(bk.keySet()));
                if (this.busObjKeyList != null && !this.busObjKeyList.isEmpty() && this.getOrderField() != null) {
                    this.setOrderField((String)Iterables.getLast(this.busObjKeyList));
                }
            }
            if (this.getWindowMode() == null) {
                if (this.parentController == null) {
                    if (this.launchParam.containsKey("INFO")) {
                        this.setWindowMode(EFCWindowMode.MODE_INFO_SCROLL);
                        if (!(this instanceof EFCFrSd) && !(this instanceof EFCFrWf)) {
                            this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_INFO);
                        }
                    } else {
                        this.setWindowMode(EFCWindowMode.MODE_SCROLL);
                    }
                } else if (this.launchParam.containsKey("SCROLL")) {
                    this.setWindowMode(EFCWindowMode.MODE_SCROLL);
                    this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_TEXT_EDITOR);
                } else {
                    this.setWindowMode(EFCWindowMode.MODE_INFO);
                    this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_INFO);
                }
            }
            if (this.launchParam != null && this.launchParam.containsKey("PRINTLISTID")) {
                this.logger.error("Der Parameter PRINTLISTID ist 'deprecated' - PRNGRP benutzen!");
                this.setPrintListId((String)this.launchParam.get("PRINTLISTID"));
            }
            if (this.launchParam != null && this.launchParam.containsKey("PRNGRP")) {
                this.setPrintListId((String)this.launchParam.get("PRNGRP"));
            }
            super.init();
            this.initForLayout();
            if (this.launchParam.containsKey("SEARCH")) {
                String searchListName2 = (String)this.launchParam.get("SEARCH");
                if (searchListName2 != null) {
                    if (this.launchParam.containsKey("SEARCHAUTOSTART")) {
                        this.openStdSearchFrameAutoStart(searchListName2, false);
                    } else {
                        this.openStdSearchFrame(searchListName2, false);
                    }
                } else {
                    this.openStdSearchFrame();
                }
            } else if (this.launchParam.containsKey("SEARCHSAVED") && (searchListName = (String)this.launchParam.get("SEARCHSAVED")) != null) {
                if (this.launchParam.containsKey("SEARCHAUTOSTART")) {
                    this.openStdSearchFrameAutoStart(searchListName, true);
                } else {
                    this.openStdSearchFrame(searchListName, true);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void onActionActualizeObject() {
        if (this.guiService instanceof DummyGuiService) {
            return;
        }
        if (this.getWindowMode() == EFCWindowMode.MODE_NEW || this.getWindowMode() == EFCWindowMode.MODE_EDIT) {
            try {
                BusinessObject bo = this.guiService.actualizeObj(this.getBusObj());
                this.updateFields(bo);
            }
            catch (UnsupportedOperationException e) {
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
            }
            catch (NullPointerException e) {
                EFCDesktop.reportError((Throwable)e);
            }
        } else if (this.isObjLoaded()) {
            try {
                BusinessObject bo = this.guiService.getObj(this.getBusObjKey());
                this.updateBusObj(bo);
                this.fireChildWindowActionActualizeObject();
            }
            catch (UnsupportedOperationException e) {
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
            }
            catch (ObjectAlreadyLockedException e) {
                this.showMessageDlg(e.getMsgList());
                this.logger.error("EFCBaseFrame.onActionActualizeObject() gescheitert!", (Throwable)e);
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_OBJECT_IS_LOCKED", (Object)e.getUserName()), Translator.tr((String)"MSG_FRAME_ACTION_OPENOBJECT_NOT_POSSIBLE"));
            }
            catch (ApplicationException e) {
                this.showMessageDlg(e.getMsgList());
                this.logger.error("EFCBaseFrame.onActionActualizeObject() gescheitert!", (Throwable)e);
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_APPLICATION_EXCEPTION"), Translator.tr((String)"MSG_FRAME_ACTION_OPENOBJECT_NOT_POSSIBLE"));
            }
        } else {
            this.actionNext();
            this.loadFields();
        }
    }

    protected void onActionCancel() {
        if (!this.isObjSaved()) {
            return;
        }
        this.setModified(false);
        if (this.getWindowMode() == EFCWindowMode.MODE_NEW) {
            this.updateBusObj(new Key());
        } else {
            this.updateBusObj(this.getBusObjKey());
        }
        this.setWindowMode(EFCWindowMode.MODE_SCROLL);
    }

    protected void onActionCopyObject() {
        this.logger.debug("EFCBaseFrame.onActionCopyObject() Start");
        if (!this.isObjLoaded()) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_BO_LOADED"), Translator.tr((String)"MSG_FRAME_NO_BO_LOADED_TITLE"));
            return;
        }
        if (!this.isObjSaved()) {
            return;
        }
        try {
            BusinessObject bo = this.getBusObjForCopy();
            if (bo == null) {
                return;
            }
            this.setWindowMode(EFCWindowMode.MODE_NEW);
            this.viewManager.setFocusToFirstField();
            this.setModified(true);
            this.updateBusObj(bo);
            this.logger.debug("EFCBaseFrame.onActionCopyObject() Ende");
        }
        catch (Exception e) {
            this.logger.error("EFCBaseFrame.onActionCopyObject() gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
        }
    }

    protected void onActionDeleteObject() {
        int option = EFCDesktop.showYesNoDlg((Object)Translator.tr((String)"MSG_FRAME_OPTIONDLG_DELETE_OBJECT_QUESTION"), (String)Translator.tr((String)"MSG_FRAME_OPTIONDLG_DELETE_TITLE"), (int)1);
        if (option == 1) {
            return;
        }
        option = EFCDesktop.showOkCancelDlg((Object)Translator.tr((String)"MSG_FRAME_OPTIONDLG_DELETE_OBJECT_CONFIRMATION"), (String)Translator.tr((String)"MSG_FRAME_OPTIONDLG_DELETE_TITLE"), (int)1);
        if (option != 0) {
            return;
        }
        this.setModified(true);
        try {
            BusinessObject bo = this.guiService.deleteObj(this.getBusObj());
            if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                this.updateBusObj(bo);
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
            } else {
                this.showMessageDlg(bo.getCompleteMsgList());
                this.updateBusObj(this.getBusObjKey());
                this.setWindowMode(EFCWindowMode.MODE_SCROLL);
                this.setModified(false);
                EFCDesktop.showInfoDlg((Object)Translator.tr((String)"MSG_FRAME_SAVEDATA_DONE"));
            }
        }
        catch (ApplicationException e) {
            this.showMessageDlg(e.getMsgList());
            this.logger.error("EFCBaseFrame.onActionDeleteObject() [ApplicationException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (UnsupportedOperationException e) {
            this.logger.error("EFCBaseFrame.onActionDeleteObject() [UnsupportedOperationException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
        }
        catch (MissingPropertyException e) {
            EFCDesktop.reportError((Throwable)e);
            this.logger.error("EFCBaseFrame.onActionDeleteObject() [MissingPropertyException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (MissingMethodException e) {
            EFCDesktop.reportError((Throwable)e);
            this.logger.error("EFCBaseFrame.onActionDeleteObject() [MissingMethodException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (RemoteAccessException e) {
            this.logger.error("EFCBaseFrame.onActionDeleteObject() [RemoteAccessException] gescheitert Verbindung unterbrochen!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_ERROR_LAN"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (Exception e) {
            EFCDesktop.reportError((Throwable)e);
            this.logger.error("EFCBaseFrame.onActionDeleteObject() [Exception] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
    }

    protected void onActionOpenObject() {
        if (!this.isObjLoaded()) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_BO_LOADED"), Translator.tr((String)"MSG_FRAME_NO_BO_LOADED_TITLE"));
            return;
        }
        if (!this.isObjEditable()) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_OPENOBJECT_FORBIDDEN_BY_STATUS"), Translator.tr((String)"MSG_FRAME_ACTION_OPENOBJECT_NOT_POSSIBLE"));
            return;
        }
        try {
            BusinessObject bo = this.guiService.openObj(this.getBusObjKey());
            this.setWindowMode(EFCWindowMode.MODE_EDIT);
            this.updateBusObj(bo);
            this.setModified(false);
        }
        catch (UnsupportedOperationException e) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
        }
        catch (ObjectAlreadyLockedException e) {
            this.showMessageDlg(e.getMsgList());
            this.logger.error("EFCBaseFrame.onActionOpenObject() gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_OBJECT_IS_LOCKED", (Object)e.getUserName()), Translator.tr((String)"MSG_FRAME_ACTION_OPENOBJECT_NOT_POSSIBLE"));
        }
        catch (ApplicationException e) {
            this.showMessageDlg(e.getMsgList());
            this.logger.error("EFCBaseFrame.onActionOpenObject() gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_APPLICATION_EXCEPTION"), Translator.tr((String)"MSG_FRAME_ACTION_OPENOBJECT_NOT_POSSIBLE"));
        }
    }

    protected void onActionNewObject() throws ActionNotAllowedException {
        if (!this.isObjSaved()) {
            return;
        }
        try {
            BusinessObject bo = this.getBusObjForNew();
            if (bo == null) {
                return;
            }
            this.setWindowMode(EFCWindowMode.MODE_NEW);
            this.updateBusObj(bo);
            this.setModified(true);
            this.viewManager.setFocusToFirstField();
        }
        catch (UnsupportedOperationException e) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
        }
    }

    protected void onActionDocFlowTakeOver() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
    }

    protected void onActionDocFlowContinue() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
    }

    protected void onActionDocFlowClose() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
    }

    protected void onActionRelatedDocs() {
        if (!this.isSysObjRefFilled.booleanValue()) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_DMS_NOT_AVAILABLE"), Translator.tr((String)"MSG_FRAME_DMS_NOT_AVAILABLE_TITLE"));
            return;
        }
        HashMap myParamList = this.getParamList();
        myParamList.put("BUSOBJKEY", this.getBusObjKeyList());
        myParamList.put("DMSKEY", this.getDmsKeyList());
        myParamList.put("SYSOBJREF", this.getSysObjRef());
        this.openChildWindow("subframes.dms.SfBoDmsRef", myParamList);
    }

    public void onActionSaveObject(EFCThreadUtil th) {
        BusinessObject bo;
        this.logger.debug("EFCBaseFrame.onActionSaveObject() Start");
        try {
            bo = this.guiService.actualizeObj(this.getBusObj());
            if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                this.updateFields(bo);
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
                return;
            }
            if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.WARNING && this.isWarnMsg().booleanValue()) {
                this.updateFields(bo);
                if (this.showYesNoDlg(Translator.tr((String)"MSG_FRAME_OPTIONDLG_SAVEDATA_WITHWARN_QUESTION"), Translator.tr((String)"MSG_FRAME_OPTIONDLG_SAVE_TITLE")) != 0) {
                    return;
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (NullPointerException e) {
            EFCDesktop.reportError((Throwable)e);
        }
        try {
            bo = this.guiService.saveObj(this.getBusObj());
            if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                this.updateFields(bo);
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
            } else {
                this.showMessageDlg(bo.getCompleteMsgList());
                this.updateBusObj(this.getBusObjKey(bo));
                this.setWindowMode(EFCWindowMode.MODE_SCROLL);
                this.setModified(false);
                EFCDesktop.showInfoDlg((Object)Translator.tr((String)"MSG_FRAME_SAVEDATA_DONE"));
                this.logger.debug("EFCBaseFrame.onActionSaveObject() Ende");
            }
        }
        catch (ApplicationException e) {
            this.showMessageDlg(e.getMsgList());
            this.logger.error("EFCBaseFrame.onActionSaveObject() [ApplicationException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (UnsupportedOperationException e) {
            this.logger.error("EFCBaseFrame.onActionSaveObject() [UnsupportedOperationException] gescheitert!", (Throwable)e);
            this.showErrorDlg(e.toString(), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (MissingPropertyException e) {
            EFCDesktop.reportError((Throwable)e);
            this.logger.error("EFCBaseFrame.onActionSaveObject() [MissingPropertyException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (MissingMethodException e) {
            EFCDesktop.reportError((Throwable)e);
            this.logger.error("EFCBaseFrame.onActionSaveObject() [MissingMethodException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (RemoteAccessException e) {
            this.logger.error("EFCBaseFrame.onActionSaveObject() [RemoteAccessException] gescheitert Verbindung unterbrochen!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_ERROR_LAN"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
        catch (Exception e) {
            EFCDesktop.reportError((Throwable)e);
            this.logger.error("EFCBaseFrame.onActionSaveObject() [Exception] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
        }
    }

    protected String getDefaultListAddTablePanelId() {
        return null;
    }

    protected void onActionListAdd() {
        String addTableIdent = this.getDefaultListAddTablePanelId();
        if (addTableIdent != null && !addTableIdent.isEmpty()) {
            if (this.viewManager.getTablePanel(addTableIdent) == null) {
                addTableIdent = null;
            } else {
                this.logger.info("getDefaultListAddTablePanelId(): " + addTableIdent);
            }
        }
        if (addTableIdent == null && (addTableIdent = this.viewManager.getSelectedTablePanelId()) != null && addTableIdent.contains(".scbbasList")) {
            String newaddTableIdent = addTableIdent.replace(".scbbasList", "");
            this.logger.info("Anf\u00fcgen an " + addTableIdent + " nicht erlaubt -> onActionListAdd mit Ident " + newaddTableIdent + " ausgef\u00fchrt");
            addTableIdent = newaddTableIdent;
        }
        this.logger.debug("EFCBaseFrame.actionListAdd() {} Start", (Object)addTableIdent);
        if (addTableIdent == null) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LIST_SELECTED"));
        } else {
            BusinessObject bo;
            BusinessObject masterObj;
            EFCAbstractEditor editor;
            JComponent object = this.getElementManager().getField(this.viewManager.getActiveIdent());
            if (object != null && object instanceof EFCAbstractEditor && (editor = (EFCAbstractEditor)object).isModified() && (editor.getSimpleOriginalValue() == null || !editor.getSimpleOriginalValue().equals(editor.getSimpleValue()))) {
                this.handleElementDataChanged(this.viewManager.getActiveIdent(), editor.getOriginalValue(), editor.getValue(), false);
            }
            if (!this.isListAddAllowed(addTableIdent)) {
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_LISTADD_NOT_POSSIBLE"));
                return;
            }
            String masterTableIdent = "";
            if (addTableIdent.contains(".")) {
                masterObj = this.viewManager.getSelectedTablePanelBusObj(addTableIdent.substring(0, addTableIdent.lastIndexOf(".")));
                if (masterObj == null) {
                    masterObj = this.getBusObj(addTableIdent.substring(0, addTableIdent.lastIndexOf(".")));
                }
                if (masterObj == null) {
                    this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LISTENTRYMAIN_SELECTED"));
                    return;
                }
            } else {
                masterObj = this.getBusObj();
            }
            if (addTableIdent.contains(".") && this.viewManager.getTablePanel(masterTableIdent = addTableIdent.substring(0, addTableIdent.lastIndexOf("."))) == null) {
                masterTableIdent = "";
            }
            String newobjIdent = addTableIdent.contains(".") ? addTableIdent.substring(addTableIdent.lastIndexOf(".") + 1) : addTableIdent;
            String newobjClassName = ((TypeInfo)((MetaInfo)masterObj).fieldTypeMap().get(newobjIdent)).getSecondClassName();
            BusinessObject detObj = this.viewManager.getSelectedTablePanelBusObj(addTableIdent);
            if (detObj == null) {
                try {
                    detObj = (BusinessObject)ClassUtils.getClass((String)newobjClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.logger.error("EFCBaseFrame.onActionListAdd() via EFCBaseFrame failed! No detail object created!", (Throwable)e);
                }
            }
            try {
                bo = this.guiService.listAdd(this.getBusObj(), masterObj, detObj, addTableIdent);
            }
            catch (UnsupportedOperationException e) {
                this.logger.error("EFCBaseFrame.actionListAdd() via GuiService nicht implementiert", (Throwable)e);
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
                return;
            }
            if (bo != null) {
                this.logger.debug("EFCBaseFrame.actionListAdd() via GuiService {}, {}, {}", new Object[]{masterObj.getClass().getSimpleName().toString(), detObj != null && detObj.getClass().getSimpleName() != null ? detObj.getClass().getSimpleName() : "", addTableIdent});
                this.setBusObj(bo);
                this.loadFields();
                this.loadFieldsForListAdd(addTableIdent);
                this.showMessageDlg(bo.getCompleteMsgList());
            } else {
                try {
                    BusinessObject o = (BusinessObject)ClassUtils.getClass((String)newobjClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    ((EFCList)ObjectUtil2.getListByDomainName((String)newobjIdent, (Object)masterObj)).add((Object)o);
                }
                catch (Exception e) {
                    EFCDesktop.reportError((Throwable)e);
                    this.logger.error("EFCBaseFrame.onActionListAdd() via EFCBaseFrame failed!", (Throwable)e);
                    return;
                }
                this.logger.debug((String)("EFCBaseFrame.actionListAdd() via EFCBaseFrame " + masterObj.getClass().getSimpleName().toString() + "," + (detObj != null && detObj.getClass().getSimpleName() != null) != null ? detObj.getClass().getSimpleName() : "," + addTableIdent));
                this.loadFieldsForListAdd(addTableIdent);
            }
            this.setModified(true);
            this.viewManager.setFirstFocusField(addTableIdent);
            this.logger.debug("EFCBaseFrame.actionListAdd() End");
        }
    }

    protected void onActionListAdd(String tableIdent) {
        this.viewManager.setSelectedTablePanelId(tableIdent);
        this.viewManager.setLastActiveIdent(tableIdent);
        this.onActionListAdd();
    }

    protected String getDefaultListRemoveTablePanelId() {
        return null;
    }

    protected void onActionListRemove() {
        String detObjIdent = this.viewManager.getSelectedTablePanelId();
        if (detObjIdent == null) {
            detObjIdent = this.getDefaultListRemoveTablePanelId();
        }
        if (detObjIdent != null && detObjIdent.contains(".scbbasList")) {
            String newdetObjIdent = detObjIdent.replace(".scbbasList", "");
            this.logger.info("L\u00f6schen von " + detObjIdent + " nicht erlaubt -> onActionListRemove mit Ident " + detObjIdent + " ausgef\u00fchrt");
            detObjIdent = newdetObjIdent;
        }
        if (detObjIdent == null) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LIST_SELECTED"));
        } else {
            if (!this.isListRemoveAllowed(detObjIdent)) {
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_LISTREMOVE_NOT_POSSIBLE"));
                return;
            }
            BusinessObject detObj = this.viewManager.getSelectedTablePanelBusObj(detObjIdent);
            if (detObj != null && !detObj._isStored()) {
                if (detObj._isRemoved()) {
                    detObj._setIsRemoved(false);
                } else {
                    detObj._setIsRemoved(true);
                }
                this.loadFields(detObjIdent);
                this.setModified(true);
            } else {
                BusinessObject bo;
                try {
                    bo = this.guiService.listRemove(this.getBusObj(), detObj);
                }
                catch (UnsupportedOperationException e) {
                    this.logger.error("EFCBaseFrame.actionListRemove() via GuiService nicht implementiert", (Throwable)e);
                    this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
                    return;
                }
                if (bo != null) {
                    this.setBusObj(bo);
                    this.loadFields();
                    this.setModified(true);
                    this.showMessageDlg(bo.getCompleteMsgList());
                } else {
                    if (detObj != null) {
                        if (detObj._isRemoved()) {
                            detObj._setIsRemoved(false);
                        } else {
                            detObj._setIsRemoved(true);
                        }
                    }
                    this.loadFields(detObjIdent);
                    this.setModified(true);
                }
            }
        }
    }

    protected void onActionMarkAllFalse() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
    }

    protected void onActionMarkAllTrue() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
    }

    protected void onActionMarkAllInvert() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
    }

    protected void onActionMarkSelection() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
    }

    public void handleAction(String ident, Object param) {
        if (GuiTools.handleSubFrameAction(this, this.sysParam, ident, param).booleanValue()) {
            return;
        }
        if (ident.equals("related_docs")) {
            this.onActionRelatedDocs();
        }
        super.handleAction(ident, param);
    }

    public void handleKey(int keyCode, String elementIdent, int modifier) {
        JComponent editorComp;
        int rowCount;
        int newIndex;
        EFCBOTablePanel tablePanel;
        int idx;
        JPanel comp;
        String tableIdent;
        if (keyCode == 10 && this.viewManager.isScrollField(elementIdent) && this.getWindowMode().in(new EFCWindowMode[]{EFCWindowMode.MODE_SCROLL, EFCWindowMode.MODE_INFO_SCROLL})) {
            this.logger.debug("start scrolling by ENTER in field: {}", (Object)elementIdent);
            JComponent component = this.viewManager.getField(elementIdent);
            if (component instanceof EditorComponent) {
                EditorComponent editor = (EditorComponent)component;
                UserInteractionEvent sece = new UserInteractionEvent(component, 2044, editor.getIdent(), editor.getSimpleValue().toString());
                for (UserInteractionListener listener : editor.getUserInteractionListeners()) {
                    listener.onUserInteraction(sece);
                }
            }
            return;
        }
        if (keyCode == 40 && modifier == 512 && (tableIdent = this.viewManager.getSelectedTablePanelId()) != null && !tableIdent.isEmpty() && (comp = this.viewManager.getPanel(tableIdent)) != null && comp instanceof EFCBOTablePanel && (idx = (tablePanel = (EFCBOTablePanel)comp).getTable().getSelectedRow()) >= 0 && (newIndex = idx + 1) < (rowCount = tablePanel.getTableModel().getRowCount()) && elementIdent != null && !elementIdent.isEmpty()) {
            editorComp = this.viewManager.getField(elementIdent);
            this.newTableIndex.set(newIndex);
            if (editorComp instanceof EFCAbstractEditor) {
                if (!((EFCAbstractEditor)editorComp).handleDataChange()) {
                    this.changeBoTableSelection(this.newTableIndex);
                    if (editorComp instanceof EFCObjectListEditor) {
                        ((EFCObjectListEditor)editorComp).setDefaultPopupParams(this.getPopupParam(elementIdent));
                    }
                }
                if (((EFCAbstractEditor)editorComp).getEditorComponent() instanceof EITextField) {
                    ((EITextField)((EFCAbstractEditor)editorComp).getEditorComponent()).selectAll();
                }
                if (((EFCAbstractEditor)editorComp).getEditorComponent() instanceof JCheckBox) {
                    this.viewManager.setFocusToField(elementIdent);
                }
            }
        }
        if (keyCode == 38 && modifier == 512 && (tableIdent = this.viewManager.getSelectedTablePanelId()) != null && !tableIdent.isEmpty() && (comp = this.viewManager.getPanel(tableIdent)) != null && comp instanceof EFCBOTablePanel && (idx = (tablePanel = (EFCBOTablePanel)comp).getTable().getSelectedRow()) > 0 && (newIndex = idx - 1) < (rowCount = tablePanel.getTableModel().getRowCount()) && elementIdent != null && !elementIdent.isEmpty()) {
            editorComp = this.viewManager.getField(elementIdent);
            this.newTableIndex.set(newIndex);
            if (editorComp instanceof EFCAbstractEditor) {
                if (!((EFCAbstractEditor)editorComp).handleDataChange()) {
                    this.changeBoTableSelection(this.newTableIndex);
                    if (editorComp instanceof EFCObjectListEditor) {
                        ((EFCObjectListEditor)editorComp).setDefaultPopupParams(this.getPopupParam(elementIdent));
                    }
                }
                if (((EFCAbstractEditor)editorComp).getEditorComponent() instanceof EITextField) {
                    ((EITextField)((EFCAbstractEditor)editorComp).getEditorComponent()).selectAll();
                }
                if (((EFCAbstractEditor)editorComp).getEditorComponent() instanceof JCheckBox) {
                    this.viewManager.setFocusToField(elementIdent);
                }
            }
        }
        super.handleKey(keyCode, elementIdent, modifier);
    }

    public void handleElementGainedFocus(String ident) {
        super.handleElementGainedFocus(ident);
        JPanel pnl = this.viewManager.getPanel(ident);
        if (pnl instanceof EFCTabPanel) {
            this.onParamContextChanged(ident, null, null, null, ident);
        } else if (pnl instanceof EFCBOTablePanel || !(pnl instanceof EFCListTablePanel)) {
            // empty if block
        }
    }

    public void onParamContextChanged(String elementIdent, String tableIdent, String tableColName, BusinessObject selectedTableObject, String tabIdent) {
        this.logger.debug("onParamContextChanged:" + elementIdent + " - " + tableIdent + " - " + tableColName + " - " + tabIdent);
        this.setSysParamContextKey(elementIdent, tableIdent, tableColName, selectedTableObject, tabIdent);
        this.fireChildWindowSync(this.sysParam, this.paramList);
    }

    public void handleTabSelectionChanged(String tabIdent, String oldPanelIdent, String newPanelIdent) {
        this.logger.debug("handleTabSelectionChanged:" + tabIdent + " - " + oldPanelIdent + " - " + newPanelIdent);
        super.handleTabSelectionChanged(tabIdent, oldPanelIdent, newPanelIdent);
        this.onParamContextChanged(newPanelIdent, null, null, null, tabIdent);
    }

    public void handleListTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        this.logger.debug("handleListTableSelectionChanged:" + tableIdent + " - " + columnName + " - " + selectedObject.toString());
        super.handleListTableSelectionChanged(tableIdent, columnName, selectedObject);
        this.onParamContextChanged(null, tableIdent, columnName, selectedObject, null);
    }

    public void handleTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        this.logger.debug("handleTableSelectionChanged:" + tableIdent + " - " + columnName + " - " + (selectedObject != null ? selectedObject.toString() : ""));
        super.handleTableSelectionChanged(tableIdent, columnName, selectedObject);
        this.onParamContextChanged(null, tableIdent, columnName, selectedObject, null);
        if (selectedObject != null && this.getWindowMode() == EFCWindowMode.MODE_EDIT) {
            if (selectedObject._isStored()) {
                this.viewManager.setSubKeyFieldsEnabled(tableIdent, false);
            } else {
                this.viewManager.setSubKeyFieldsEnabled(tableIdent, true);
            }
        }
        this.updatePanels(tableIdent);
    }

    public void handleGridSelectionChanged(String gridIdent, BusinessObject selectedObject) {
        this.logger.debug("handleGridSelectionChanged:" + gridIdent + " - " + selectedObject.toString());
        super.handleGridSelectionChanged(gridIdent, selectedObject);
        if (selectedObject instanceof SoLiRptGrid) {
            this.sysParam.setCompany(((SoLiRptGrid)selectedObject).getCompany());
            this.sysParam.setBusarea(((SoLiRptGrid)selectedObject).getBusarea());
            this.sysParam.setDockey(((SoLiRptGrid)selectedObject).getDockey());
            this.sysParam.setDocnum(((SoLiRptGrid)selectedObject).getDocnum());
            this.sysParam.setDocitem(((SoLiRptGrid)selectedObject).getDocitem());
            this.sysParam.setPrddockey(((SoLiRptGrid)selectedObject).getPrddockey());
            this.sysParam.setPrddocnum(((SoLiRptGrid)selectedObject).getPrddocnum());
            this.sysParam.setPrddocitem(((SoLiRptGrid)selectedObject).getPrddocitem());
            this.sysParam.setMatnum(((SoLiRptGrid)selectedObject).getMatnum());
            this.sysParam.setVendor(((SoLiRptGrid)selectedObject).getVendor());
            this.sysParam.setCustomer(((SoLiRptGrid)selectedObject).getCustomer());
            this.sysParam.setBomdockey(((SoLiRptGrid)selectedObject).getBomdockey());
            this.sysParam.setBomdocnum(((SoLiRptGrid)selectedObject).getBomdocnum());
            this.sysParam.setBomdocitem(((SoLiRptGrid)selectedObject).getBomdocitem());
            this.sysParam.setRoudockey(((SoLiRptGrid)selectedObject).getRoudockey());
            this.sysParam.setRoudocnum(((SoLiRptGrid)selectedObject).getRoudocnum());
            this.sysParam.setRoudocitem(((SoLiRptGrid)selectedObject).getRoudocitem());
            this.sysParam.setWrh(((SoLiRptGrid)selectedObject).getWrh());
            this.sysParam.setWrharea(((SoLiRptGrid)selectedObject).getWrharea());
            this.sysParam.setStkplc(((SoLiRptGrid)selectedObject).getStkplc());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        }
    }

    public void handleBusinessTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        this.logger.debug("handleBusinessTableSelectionChanged:" + tableIdent + " - " + columnName + " - " + selectedObject.toString());
        super.handleBusinessTableSelectionChanged(tableIdent, columnName, selectedObject);
        this.onParamContextChanged(null, tableIdent, columnName, selectedObject, null);
    }

    public void handleChartSelectionChanged(BusinessObject businessObject) {
        super.handleChartSelectionChanged(businessObject);
        if (businessObject != null && businessObject instanceof DcPrdForCap) {
            this.sysParam.setPrddockey(((DcPrdForCap)businessObject).getPrddoc().getPrddockey().getPrddockey());
            this.sysParam.setPrddocnum(((DcPrdForCap)businessObject).getPrddoc().getPrddocnum());
            this.sysParam.setPrddocitem(((DcPrdForCap)businessObject).getPrdopr().getPrddocitem());
            this.fireChildWindowSync(this.sysParam, this.paramList);
            this.logger.debug("Chart: " + businessObject.toString());
        }
    }

    public void handleExplorerSelectionChanged(String ident, ETreeElement treeElement) {
        BusinessObject bo;
        super.handleExplorerSelectionChanged(ident, treeElement);
        if (treeElement != null && (bo = treeElement.getBusinessObject()) != null && bo instanceof SoLiBomDocItemWul) {
            this.sysParam.setBomdockey(((SoLiBomDocItemWul)bo).getBomdockey());
            this.sysParam.setBomdocnum(((SoLiBomDocItemWul)bo).getBomdocnum());
            this.sysParam.setMatnum(((SoLiBomDocItemWul)bo).getBommatnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
            this.logger.debug("Explorer: " + treeElement.getTitle());
        }
    }

    public void handleGanttSelectionChanged(BusinessObject businessObject) {
        super.handleGanttSelectionChanged(businessObject);
        if (businessObject != null && businessObject instanceof DcPrdForCap) {
            this.sysParam.setPrddockey(((DcPrdForCap)businessObject).getPrddoc().getPrddockey().getPrddockey());
            this.sysParam.setPrddocnum(((DcPrdForCap)businessObject).getPrddoc().getPrddocnum());
            this.sysParam.setPrddocitem(((DcPrdForCap)businessObject).getPrdopr().getPrddocitem());
            this.fireChildWindowSync(this.sysParam, this.paramList);
            this.logger.debug("Gantt: " + businessObject.toString());
        }
    }

    public void handleGanttElementDragEnd(BusinessObject draged, String label, Date start, Date end, Date min, Date max, Map<BusinessObject, List<Date>> listMovedElements) {
        super.handleGanttElementDragEnd(draged, label, start, end, min, max, listMovedElements);
    }

    public void handleGraphSelectionChanged(BusinessObject busObj) {
        super.handleGraphSelectionChanged(busObj);
        if (busObj instanceof SoLiDoc) {
            this.sysParam.setDockey(((SoLiDoc)busObj).getDockey());
            this.sysParam.setDocnum(((SoLiDoc)busObj).getDocnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof TdDoc) {
            this.sysParam.setDockey(((TdDoc)busObj).getDockey().getDockey());
            this.sysParam.setDocnum(((TdDoc)busObj).getDocnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof SoLiDocItem) {
            this.sysParam.setDockey(((SoLiDocItem)busObj).getDockey());
            this.sysParam.setDocnum(((SoLiDocItem)busObj).getDocnum());
            this.sysParam.setDocitem(((SoLiDocItem)busObj).getDocitem());
            this.sysParam.setMatnum(((SoLiDocItem)busObj).getMatnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof TdDocItem) {
            this.sysParam.setDockey(((TdDocItem)busObj).getDockey());
            this.sysParam.setDocnum(((TdDocItem)busObj).getDocnum());
            this.sysParam.setDocitem(((TdDocItem)busObj).getDocitem());
            this.sysParam.setMatnum(((TdDocItem)busObj).getMatnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof SoLiPrdDoc) {
            this.sysParam.setPrddockey(((SoLiPrdDoc)busObj).getPrddockey());
            this.sysParam.setPrddocnum(((SoLiPrdDoc)busObj).getPrddocnum());
            this.sysParam.setMatnum(((SoLiPrdDoc)busObj).getMatnum());
            this.sysParam.setBomdockey(((SoLiPrdDoc)busObj).getBomdockey());
            this.sysParam.setBomdocnum(((SoLiPrdDoc)busObj).getBomdocnum());
            this.sysParam.setRoudockey(((SoLiPrdDoc)busObj).getRoudockey());
            this.sysParam.setRoudocnum(((SoLiPrdDoc)busObj).getRoudocnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof TdPrdDoc) {
            this.sysParam.setPrddockey(((TdPrdDoc)busObj).getPrddockey().getPrddockey());
            this.sysParam.setPrddocnum(((TdPrdDoc)busObj).getPrddocnum());
            this.sysParam.setMatnum(((TdPrdDoc)busObj).getMatnum());
            this.sysParam.setBomdockey(((TdPrdDoc)busObj).getBomdockey().getBomdockey());
            this.sysParam.setBomdocnum(((TdPrdDoc)busObj).getBomdocnum());
            this.sysParam.setRoudockey(((TdPrdDoc)busObj).getRoudockey().getRoudockey());
            this.sysParam.setRoudocnum(((TdPrdDoc)busObj).getRoudocnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof SoLiQltDoc) {
            this.sysParam.setQltdockey(((SoLiQltDoc)busObj).getQltdockey());
            this.sysParam.setQltdocnum(((SoLiQltDoc)busObj).getQltdocnum());
            this.sysParam.setMatnum(((SoLiQltDoc)busObj).getMatnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof TdQltDoc) {
            this.sysParam.setQltdockey(((TdQltDoc)busObj).getQltdockey().getQltdockey());
            this.sysParam.setQltdocnum(((TdQltDoc)busObj).getQltdocnum());
            this.sysParam.setMatnum(((TdQltDoc)busObj).getMatnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof BoPrdNetPrdDoc) {
            this.sysParam.setCompany(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddoc().getCompany().getCompany());
            this.sysParam.setPrddockey(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddockey().getPrddockey());
            this.sysParam.setPrddocnum(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddocnum());
            this.sysParam.setPrddocobj(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddocobj());
            this.sysParam.setMatnum(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddoc().getMatnum());
            this.sysParam.setBomdockey(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddoc().getBomdockey().getBomdockey());
            this.sysParam.setBomdocnum(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddoc().getBomdocnum());
            this.sysParam.setRoudockey(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddoc().getRoudockey().getRoudockey());
            this.sysParam.setRoudocnum(((BoPrdNetPrdDoc)busObj).getBoPrdDoc().getPrddoc().getRoudocnum());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        } else if (busObj instanceof BoPrdNetDoc) {
            this.sysParam.setCompany(((BoPrdNetDoc)busObj).getTdDocItem().getCompany());
            this.sysParam.setDockey(((BoPrdNetDoc)busObj).getTdDocItem().getDockey());
            this.sysParam.setDocnum(((BoPrdNetDoc)busObj).getTdDocItem().getDocnum());
            this.sysParam.setDocitem(((BoPrdNetDoc)busObj).getTdDocItem().getDocitem());
            this.sysParam.setDocobj(((BoPrdNetDoc)busObj).getTdDocItem().getDocobj());
            this.sysParam.setMatnum(((BoPrdNetDoc)busObj).getTdDocItem().getMatnum());
            this.sysParam.setCustomer(((BoPrdNetDoc)busObj).getBoDoc().getCustomer());
            this.fireChildWindowSync(this.sysParam, this.paramList);
        }
    }

    public boolean isObjLoaded() {
        if (this.getBusObj() == null || this.getBusObj()._getKey() == null) {
            return false;
        }
        if (this.getBusObj()._getKey().isEmpty()) {
            return true;
        }
        return !this.getBusObj()._getKey().entrySet().stream().allMatch(entry -> entry.getValue() == null);
    }

    protected boolean isObjSaved() {
        if (this.isModified()) {
            int option = EFCDesktop.showYesNoCancelDlg((String)Translator.tr((String)"MSG_FRAME_OPTIONDLG_SAVEDATA_QUESTION"), (String)Translator.tr((String)"MSG_FRAME_OPTIONDLG_SAVE_TITLE"), (int)2);
            if (option == 2) {
                return false;
            }
            if (option == 0) {
                try {
                    this.actionSaveObject();
                    return false;
                }
                catch (Throwable e) {
                    EFCDesktop.reportError((Throwable)e);
                    return false;
                }
            }
        }
        if (this.getWindowMode() != null && this.getWindowMode().in(new EFCWindowMode[]{EFCWindowMode.MODE_EDIT, EFCWindowMode.MODE_NEW})) {
            try {
                BusinessObject bo = this.guiService.cancel(this.getBusObj());
                if (bo == null) {
                    return true;
                }
                this.updateBusObj(bo);
                return false;
            }
            catch (UnsupportedOperationException e) {
                this.logger.debug("EFCBaseFrame.onActionCancel() UnsupportedOperationException ignoriert!", (Throwable)e);
                return true;
            }
            catch (Exception e) {
                this.logger.error("EFCBaseFrame.onActionCancel() gescheitert!", (Throwable)e);
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_UNKNOWN_EXCEPTION"), Translator.tr((String)"MSG_FRAME_UNKNOWN_EXCEPTION_TITLE"));
                return true;
            }
        }
        return true;
    }

    public void setInitialPopUpValue(String ident) {
        JComponent jComponent = this.getElementManager().getField(ident);
        if (jComponent instanceof EFCObjectListEditor) {
            EFCObjectListEditor ole = (EFCObjectListEditor)jComponent;
            List popupList = new ArrayList();
            popupList = ole.getPrimaryPopupService().getElements((Map)this.getPopupParam(ident));
            if (popupList.size() == 1) {
                Object value = ole.getPrimaryPopupService().getObj(((SelectResult)popupList.get(0)).getKey());
                this.handleElementDataChanged(ident, null, value, true);
            }
        }
    }

    public void setActualTitleText() {
        EFCList titleList = new EFCList();
        this.viewManager.getAllScrollFieldIdents().forEach(ident -> {
            Object fieldValue = this.viewManager.getFieldValue(ident);
            if (!(ident == "company" || fieldValue == null || fieldValue instanceof Boolean || fieldValue instanceof Date || fieldValue instanceof BusinessObject || fieldValue.toString() == null || fieldValue.toString().isEmpty())) {
                titleList.add((Object)fieldValue.toString());
            }
        });
        Collections.reverse(titleList);
        EFCList reverseTitleList = new EFCList(titleList);
        this.setActualTitleText((List<String>)reverseTitleList);
    }

    public void setActualTitleText(List<String> titleList) {
        if (titleList == null || titleList.isEmpty()) {
            return;
        }
        this.setActualTitleText(titleList.stream().collect(Collectors.joining(" - ")));
    }

    public ArrayList<String> getDmsKeyList() {
        return this.dmsKeyList;
    }

    protected void setDmsKeyList(ArrayList<String> kList) {
        this.dmsKeyList = kList;
    }

    protected void setSysParamBaseKey() {
    }

    protected void setSysObjRefBaseKey() {
        this.isSysObjRefFilled = false;
    }

    public void setSysParamContextKey(String elementIdent, String tableIdent, String tableColName, BusinessObject selectedTableObject, String tabIdent) {
        BoScbBas scbbo;
        this.logger.debug("setSysParamContextKey: Element:" + elementIdent + " Tabelle: " + tableIdent + " Spalte: " + tableColName + " Objekt: " + (selectedTableObject != null ? selectedTableObject.toString() : "") + " Tab: " + tabIdent);
        this.resetSysParam();
        GuiTools.setSysParamContextKey(this.sysParam, elementIdent, tableIdent, tableColName, selectedTableObject, tabIdent);
        if (tableIdent != null && tableIdent.contains("scbbasList") && (scbbo = (BoScbBas)selectedTableObject) != null && scbbo.getScbchr() != null && scbbo.getScbchr().getScbchrtype().getData() == 20) {
            try {
                this.sysParam.setResource((EFCString)ObjectUtil2.getAttributeByDomainName((String)"scb_stringvalue", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setSysParamBaseKey();
    }

    protected void switchToEditMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.viewManager.setAllFieldsForEdit();
        if (this.getMainMenu() != null) {
            this.viewManager.setMenuActionsDisabled(new EnumSet[]{EFCAction.M_ALL});
            this.viewManager.setMenuActionsEnabled(new EnumSet[]{EFCAction.subset((EnumSet)EFCAction.ACTIONS_IN_EDITMODE, (EnumSet)this.getMenu())});
        }
        super.switchToEditMode(oldmode);
    }

    protected void switchToNewMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.viewManager.setAllFieldsForNew();
        if (this.getMainMenu() != null) {
            this.viewManager.setMenuActionsDisabled(new EnumSet[]{EFCAction.M_ALL});
            this.viewManager.setMenuActionsEnabled(new EnumSet[]{EFCAction.subset((EnumSet)EFCAction.ACTIONS_IN_NEWMODE, (EnumSet)this.getMenu())});
            this.viewManager.setMenuActionsDisabled(new EFCAction[]{EFCAction.A_REL_DOC});
        }
        super.switchToNewMode(oldmode);
    }

    protected void switchToInfoMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.viewManager.setAllFieldsForInfo();
        if (this.getMainMenu() != null) {
            this.viewManager.setMenuActionsDisabled(new EnumSet[]{EFCAction.M_ALL});
            this.viewManager.setMenuActionsEnabled(new EnumSet[]{EFCAction.subset((EnumSet)EFCAction.ACTIONS_IN_INFOMODE, (EnumSet)this.getMenu())});
        }
        super.switchToInfoMode(oldmode);
    }

    protected void switchToInfoScrollMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        Component c = this.getFocusOwner();
        this.getDataChangeManager().setFocusListening(false);
        this.viewManager.setAllFieldsForInfoScroll();
        if (c != null) {
            c.requestFocus();
        }
        this.getDataChangeManager().setFocusListening(true);
        if (this.getMainMenu() != null) {
            this.viewManager.setMenuActionsDisabled(new EnumSet[]{EFCAction.M_ALL});
            this.viewManager.setMenuActionsEnabled(new EnumSet[]{EFCAction.subset((EnumSet)EFCAction.ACTIONS_IN_SCROLLINFOMODE, (EnumSet)this.getMenu())});
        }
        super.switchToInfoScrollMode(oldmode);
    }

    protected void switchToScrollMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        Component c = this.getFocusOwner();
        this.getDataChangeManager().setFocusListening(false);
        this.viewManager.setAllFieldsForScroll();
        if (c != null) {
            c.requestFocus();
        }
        this.getDataChangeManager().setFocusListening(true);
        if (this.getMainMenu() != null) {
            this.viewManager.setMenuActionsDisabled(new EnumSet[]{EFCAction.M_ALL});
            this.viewManager.setMenuActionsEnabled(new EnumSet[]{EFCAction.subset((EnumSet)EFCAction.ACTIONS_IN_SCROLLMODE, (EnumSet)this.getMenu())});
        }
        super.switchToScrollMode(oldmode);
    }

    protected void updatePanels() {
    }

    protected void updatePanels(String tableIdent) {
    }

    protected void onFieldsUpdated() {
        if (this.isObjLoaded()) {
            this.showMessageDlg(this.getBusObj().getCompleteMsgList());
            this.getBusObj().clearCompleteMsgList();
        }
    }

    protected void onBusObjUpdated() {
        this.viewManager.setActiveIdent("");
        this.resetSysParam();
        this.resetSysObjRef();
        this.setSysParamBaseKey();
        this.isSysObjRefFilled = true;
        this.setSysObjRefBaseKey();
        this.updatePanels();
        this.setActualTitleText();
        this.fireChildWindowSync(this.sysParam, this.paramList);
        if (this.isObjLoaded()) {
            this.setObjectState(this.getBusObj()._isDeleted() ? EFCObjectState.DELETED : (this.timer != null ? EFCObjectState.TIMER : EFCObjectState.DEFAULT));
            this.showMessageDlg(this.getBusObj().getCompleteMsgList());
        } else if (this.timer != null) {
            this.setObjectState(EFCObjectState.TIMER);
        }
    }

    protected void onActionSearch() {
        if (this.getWindowMode() == EFCWindowMode.MODE_EDIT || this.getWindowMode() == EFCWindowMode.MODE_NEW) {
            this.onSearchStart();
            return;
        }
        this.openStdSearchFrame();
    }

    protected void onSearchBatch(String callingField, List<Key> keyList) {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_SEARCH_REACTION_DEFINED"), Translator.tr((String)"MSG_FRAME_NO_SEARCH_REACTION_DEFINED_TITLE"));
    }

    protected void onSearchStart() {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_SEARCH_DEFINED"), Translator.tr((String)"MSG_FRAME_NO_SEARCH_DEFINED_TITLE"));
    }

    protected void onSearchFinished(String searchServiceId, String callingField, Key resultKey, Filter scrollFilter) {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_SEARCH_REACTION_DEFINED"), Translator.tr((String)"MSG_FRAME_NO_SEARCH_REACTION_DEFINED_TITLE"));
    }

    protected void onSearchSync(String searchServiceId, String callingField, Key resultKey, Filter scrollFilter) {
        if (callingField == null) {
            if (!this.isObjSaved()) {
                return;
            }
            if (this.getWindowMode() == EFCWindowMode.MODE_EDIT) {
                this.setWindowMode(EFCWindowMode.MODE_SCROLL);
            }
            this.updateBusObj(resultKey);
            this.setStatusText("");
            return;
        }
        this.onSearchFinished(searchServiceId, callingField, resultKey, scrollFilter);
    }

    protected void onSearchFieldUpdate(EFCAbstractPrimaryEditor editor, Object oldValue, String newValue, Map<String, String> valueMap) {
        editor.setValue((Object)newValue);
        editor.fireValueChangeEvent(editor.getIdent(), oldValue, editor.getValue());
    }

    protected BusinessObject getBusObjForNew() throws ActionNotAllowedException {
        return this.guiService.newObj();
    }

    public void setBusObjForNew(BusinessObject bo) {
        this.setWindowMode(EFCWindowMode.MODE_NEW);
        this.updateBusObj(bo);
        this.setModified(true);
        this.viewManager.setFocusToFirstField();
    }

    public void setBusObjForEdit(BusinessObject bo) {
        this.setWindowMode(EFCWindowMode.MODE_EDIT);
        this.updateBusObj(bo);
        this.viewManager.setFocusToFirstField();
    }

    protected BusinessObject getBusObjForCopy() {
        return this.guiService.copyObj(this.getBusObj());
    }

    protected void onElementDataChanged(String ident, Object oldval, Object newval) {
        this.putValueInObject(ident, newval);
        this.logger.warn("unimplemented gui-method for field: " + ident + " called and 'putValueInObject()' executed instead!");
    }

    protected void onScrollStart(boolean rev) {
    }

    protected void onScrollFinished(boolean rev) {
        String ordercol = "UNNAMED";
        if (this.getOrderField() != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.getOrderField().replace(" ", ""), ",");
            EFCList orderColList = new EFCList();
            while (tokenizer.hasMoreTokens()) {
                String nToken = tokenizer.nextToken().toUpperCase();
                if (nToken.contains(".")) {
                    nToken = nToken.substring(nToken.lastIndexOf(".") + 1);
                }
                orderColList.add(Translator.tr((String)("FLD_" + nToken)));
            }
            ordercol = orderColList.stream().collect(Collectors.joining(", "));
        }
        EFCList values = this.baseScrollList != null ? new EFCList(Arrays.asList(ordercol, this.baseScrollList.getPosition() + 1, this.baseScrollList.size())) : new EFCList(Arrays.asList("-", 0, 0));
        ordercol = rev ? Translator.tr((String)"MSG_FRAME_STATUSBAR_SCROLLORDER_DESC_3", (List)values) : Translator.tr((String)"MSG_FRAME_STATUSBAR_SCROLLORDER_ASC_3", (List)values);
        this.setStatusText(ordercol);
    }

    public Key getPopupParam(String fieldident) {
        if (fieldident.matches(".*scbbasList.scb_scbchrdetvalue")) {
            BoScbBas bo;
            Key para = new Key();
            BusinessObject boObj = this.viewManager.getSelectedTablePanelBusObj(fieldident);
            if (boObj instanceof BoScbBas && (bo = (BoScbBas)boObj) != null) {
                if (bo.getScbkey() != null) {
                    para.put((Object)"SCBKEY", (Object)bo.getScbkey().getScbkey().getData());
                }
                if (bo.getScbchr() != null) {
                    para.put((Object)"SCBCHR", (Object)bo.getScbchr().getScbchr().getData());
                    if (bo.getScbchr().getCompany() != null && bo.getScbchr().getCompany().getCompany() != null && bo.getScbchr().getCompany().getCompany().getData() != null) {
                        para.put((Object)"COMPANY", (Object)bo.getScbchr().getCompany().getCompany().getData());
                    }
                }
            }
            this.logger.info("getPopupParam: " + para);
            return para;
        }
        return super.getPopupParam(fieldident);
    }

    public void openChildWindow(String childName) {
        try {
            this.openChildWindow(ClassUtils.getClass((String)(NS_BASE + "." + childName)));
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
        }
    }

    public void openChildWindow(String childName, Map<String, Object> param) {
        try {
            this.openChildWindow(ClassUtils.getClass((String)(NS_BASE + "." + childName)), param);
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
        }
    }

    public void openChildWindowForEdit(String childName) {
        try {
            this.openChildWindowForEdit(ClassUtils.getClass((String)(NS_BASE + "." + childName)));
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
        }
    }

    public void openWindow(String childName) {
        try {
            this.openWindow(ClassUtils.getClass((String)(NS_BASE + "." + childName)));
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
        }
    }

    protected void openViewer(EFCBlob blobdata) {
        this.openViewer(null, blobdata);
    }

    protected void openViewer(String filename, EFCBlob blobdata) {
        if (blobdata == null) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_OPENVIEWER_NOT_POSSIBLE"));
            return;
        }
        EFCViewerFactory.createViewer((EFCController)this, (String)filename, (EFCBlob)blobdata);
    }

    protected void saveFile(EFCBlob blobdata) {
        this.saveFile("", blobdata);
    }

    protected void saveFile(String filename, EFCBlob blobdata) {
        if (blobdata == null) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_OPENVIEWER_NOT_POSSIBLE"));
            return;
        }
        EFCFileManager.saveDataByFileChooser((JInternalFrame)this.getView(), (byte[])blobdata.getData(), (String)filename);
    }

    protected void openSearchFrameForBatch(String callingField, String i_serviceName) {
        this.openSearchFrameForBatch(new Filter(), callingField, i_serviceName);
    }

    protected void openSearchFrameForBatch(Filter filter, String callingField, String i_serviceName) {
        if (!this.isSearchAllowed(EFCSearchMode.MODE_FOR_EDIT)) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (this instanceof EFCBaseDialog) {
            EFCSearchDialog searchDialog = new EFCSearchDialog(this, callingField, filter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCSearchMode.MODE_FOR_BATCH);
            searchDialog.execute(null, "");
            searchDialog.dispose();
        } else if (this.launchParam.containsKey("SEARCHSAVEDBATCH")) {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, callingField, "", filter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCAutostart.SEARCHSAVED, (Map)ImmutableMap.of((Object)"listname", (Object)this.launchParam.get("SEARCHSAVEDBATCH").toString()), EFCSearchMode.MODE_FOR_BATCH));
        } else {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, callingField, filter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCSearchMode.MODE_FOR_BATCH));
        }
    }

    public void openSearchFrameForPrintBatch(EFCReportSelectionListEntry callingReport) {
        this.openSearchFrameForPrintBatch(this.baseFilter, callingReport, this.searchService, EFCAutostart.NOTHING, new HashMap<String, Object>());
    }

    public void openSearchFrameForPrintBatch(Filter filter, EFCReportSelectionListEntry callingReport, SearchService searchService, EFCAutostart autostart, Map<String, Object> param) {
        if (!this.isSearchAllowed(EFCSearchMode.MODE_FOR_EDIT)) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (param == null) {
            param = new HashMap<String, Object>();
        }
        param.put("CALLING_REPORT", callingReport);
        EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, null, "", filter, searchService, autostart, param, EFCSearchMode.MODE_FOR_PRINT));
    }

    protected void openSearchFrame(String callingField, String i_serviceName) {
        this.openSearchFrame(new Filter(), callingField, i_serviceName);
    }

    protected void openSearchFrame(Filter filter, String callingField, String i_serviceName) {
        if (!this.isSearchAllowed(EFCSearchMode.MODE_FOR_EDIT)) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (this instanceof EFCBaseDialog) {
            EFCSearchDialog searchDialog = new EFCSearchDialog(this, callingField, filter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCSearchMode.MODE_FOR_EDIT);
            searchDialog.execute(null, "");
            searchDialog.dispose();
        } else {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, callingField, filter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCSearchMode.MODE_FOR_EDIT));
        }
    }

    protected void openSearchFrame(Filter filter, String callingField, String i_serviceName, String searchListName) {
        if (!this.isSearchAllowed(EFCSearchMode.MODE_FOR_EDIT)) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (this instanceof EFCBaseDialog) {
            EFCSearchDialog searchDialog = new EFCSearchDialog(this, callingField, "", this.baseFilter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCAutostart.SELECT, (Map<String, Object>)ImmutableMap.of((Object)"listname", (Object)searchListName, (Object)"filter", (Object)filter), EFCSearchMode.MODE_FOR_EDIT);
            searchDialog.execute(null, "");
            searchDialog.dispose();
        } else {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, callingField, "", filter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCAutostart.SELECT, (Map)ImmutableMap.of((Object)"listname", (Object)searchListName), EFCSearchMode.MODE_FOR_EDIT));
        }
    }

    protected void openSearchFrameAutoStart(Filter basefilter, String callingField, String i_serviceName, String searchListName) {
        this.openSearchFrameAutoStart(basefilter, new Filter(), callingField, i_serviceName, searchListName);
    }

    protected void openSearchFrameAutoStart(Filter basefilter, Filter filter, String callingField, String i_serviceName, String searchListName) {
        if (!this.isSearchAllowed(EFCSearchMode.MODE_FOR_EDIT)) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE"), Translator.tr((String)"MSG_FRAME_ACTION_SEARCH_NOT_POSSIBLE_TITLE"));
            return;
        }
        if (this instanceof EFCBaseDialog) {
            EFCSearchDialog searchDialog = new EFCSearchDialog(this, callingField, "", this.baseFilter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCAutostart.SEARCH, (Map<String, Object>)ImmutableMap.of((Object)"listname", (Object)searchListName, (Object)"filter", (Object)filter), EFCSearchMode.MODE_FOR_EDIT);
            searchDialog.execute(null, "");
            searchDialog.dispose();
        } else {
            EFCDesktop.getInstance().add((Component)new EFCSearchFrame((EFCController)this, callingField, "", basefilter, (SearchService)SpringHelper.getBean((String)i_serviceName), EFCAutostart.SEARCH, (Map)ImmutableMap.of((Object)"listname", (Object)searchListName, (Object)"filter", (Object)filter), EFCSearchMode.MODE_FOR_EDIT));
        }
    }

    protected void resetSysParam() {
        this.sysParam = new SysParam();
    }

    protected void resetSysObjRef() {
        this.sysObjRef = new SysObjRef();
    }

    public void validateReportInfo(Map<String, Object> reportParamMap, Key key) {
        this.logger.info("validateReportInfo(Map, Key)");
        EFCBoolean paraDone = new EFCBoolean(Boolean.valueOf(false));
        reportParamMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("EFC_PARAM")).forEach(entry -> {
            String fetchinfo;
            if (entry.getValue() instanceof String && (fetchinfo = (String)entry.getValue()) != null && !fetchinfo.isEmpty()) {
                Object data;
                paraDone.setData(Boolean.valueOf(true));
                if (fetchinfo.startsWith("#")) {
                    fetchinfo = fetchinfo.substring(1);
                    if (key == null || key.isEmpty()) {
                        data = ObjectUtil2.getAttributeByDomainName((String)fetchinfo, (Object)this.sysParam) != null ? ObjectUtil2.getAttributeByDomainName((String)fetchinfo, (Object)this.sysParam).toString() : null;
                        this.logger.info("setting attribute " + (String)entry.getKey() + " by sysParam: " + fetchinfo + " to value: " + data);
                    } else {
                        data = key.getKeyValue(fetchinfo.toUpperCase());
                        this.logger.info("setting attribute " + (String)entry.getKey() + " by key: " + fetchinfo + " to value: " + data);
                    }
                } else {
                    data = this.paramList.get(fetchinfo);
                    this.logger.info("setting " + (String)entry.getKey() + " by paramList: " + fetchinfo + " to value: " + data);
                }
                reportParamMap.put((String)entry.getKey(), data);
            }
        });
        if (!paraDone.getBoolean().booleanValue()) {
            reportParamMap.put("EFC_BEAN_DATA", this.getBusObj());
            this.logger.info("setting actual BO");
        }
        reportParamMap.put("EFC_SYSPROGCLASS", ((Object)((Object)this)).getClass().getSimpleName().toString());
    }

    public void validateReportInfo(EFCReportSelectionListEntry prnSrv, Key key) {
        this.logger.info("validateReportInfo(EFCReportSelectionListEntry prnSrv, Key)");
    }

    public void validateReportInfo(EFCReportContainer reportContainer, Key key) {
        this.logger.info("validateReportInfo(EFCReportContainer reportContainer, Key)");
    }

    protected void refreshView(String ident) {
        EFCSplitPanel scbsplitformdetail = (EFCSplitPanel)this.viewManager.getPanel(ident + ".scbsplitformdetail");
        if (scbsplitformdetail != null) {
            scbsplitformdetail.setRelativeDividerLocation(100.0);
        }
        if (ident.endsWith("scbList")) {
            String domain = ident;
            EFCSplitPanel splitscbListTop = (EFCSplitPanel)this.viewManager.getPanel(ident + ".splitscblist_top");
            BusinessObject bo = this.viewManager.getSelectedTablePanelBusObj(ident);
            if (bo instanceof ScbBase && ((ScbBase)bo).getScbkey().getScbframelayouttype().getData() == 11 || bo instanceof ScbBase && ((ScbBase)bo).getScbkey().getScbframelayouttype().getData() == 10 || bo instanceof ScbBase && ((ScbBase)bo).getScbkey().getScbframelayouttype().getData() == 20) {
                final ScbBase scbbase = (ScbBase)bo;
                JPanel formdetailpanel = this.viewManager.getPanel(ident + ".formdetail");
                EFCSplitPanel splitscbListBottom = (EFCSplitPanel)this.viewManager.getPanel(ident + ".splitscblist_bottom");
                if (bo instanceof ScbBase && ((ScbBase)bo).getScbkey().getScbframelayouttype().getData() == 20 && splitscbListBottom != null) {
                    splitscbListTop.setVisible(false);
                    if (scbsplitformdetail != null) {
                        scbsplitformdetail.setRelativeDividerLocation(0.0);
                    }
                    splitscbListBottom.setVisible(true);
                    splitscbListBottom.setRelativeDividerLocation(0.0);
                    EFCScbTablePanel scbTablePanel = new EFCScbTablePanel(this.getElementManager(), this.getDataChangeManager(), "scblistTable", null, false, this.getBusinessObjectModel(), (EFCController)this, null);
                    this.getElementManager().addPanel(scbTablePanel.getIdent(), (JPanel)scbTablePanel);
                    splitscbListBottom.getPane().setRightComponent((Component)scbTablePanel);
                    Collections.sort(scbbase.getScbkey().getScbscbkeydetList(), (scbkeydet1, scbkeydet2) -> scbkeydet1.getFldposcol().getData().compareTo(scbkeydet2.getFldposcol().getData()));
                    ((ScbTableModel)scbTablePanel.getTableModel()).setScbkey(scbbase.getScbkey());
                    scbTablePanel.clearVisibleCols();
                    for (BoScbBas scb : scbbase.getScbbasList()) {
                        ClScbScbKeyDet clScbScbKeyDet = scb.getScbkey().getScbscbkeydetList().stream().filter(e -> e.getScbchr() != null && scb.getScbchr() != null && e.getScbchr().getScbchr().getData().equals(scb.getScbchr().getScbchr().getData())).findFirst().orElse(null);
                        scbTablePanel.addVisibleCol(clScbScbKeyDet.getScbchr().getScbchr().getData());
                    }
                    scbTablePanel.addColsToColumsModel(scbTablePanel.getVisibleCols());
                    scbTablePanel.setData((List)scbbase.getScbbasList());
                }
                if ((bo instanceof ScbBase && ((ScbBase)bo).getScbkey().getScbframelayouttype().getData() == 11 || bo instanceof ScbBase && ((ScbBase)bo).getScbkey().getScbframelayouttype().getData() == 10) && formdetailpanel instanceof EFCFormPanel) {
                    splitscbListBottom.setRelativeDividerLocation(100.0);
                    splitscbListTop.setVisible(false);
                    if (scbsplitformdetail != null) {
                        scbsplitformdetail.setRelativeDividerLocation(0.0);
                    }
                    EFCFormPanel formPanel = (EFCFormPanel)formdetailpanel;
                    int row = 1;
                    int col = 1;
                    formPanel.clearComponents();
                    Integer lastCol = 1;
                    if (scbbase.getScbkey().getScbframelayouttype().getData() == 11) {
                        Collections.sort(scbbase.getScbkey().getScbscbkeydetList(), (scbkeydet1, scbkeydet2) -> scbkeydet1.getFldposcol().getData().compareTo(scbkeydet2.getFldposcol().getData()));
                        Comparator<BoScbBas> compare = new Comparator<BoScbBas>(){

                            @Override
                            public int compare(BoScbBas v1, BoScbBas v2) {
                                ClScbScbKeyDet s1 = scbbase.getScbkey().getScbscbkeydetList().stream().filter(e -> e.getScbchr() != null && v1.getScbchr() != null && e.getScbchr().getScbchr().getData().equals(v1.getScbchr().getScbchr().getData())).findFirst().orElse(null);
                                ClScbScbKeyDet s2 = scbbase.getScbkey().getScbscbkeydetList().stream().filter(e -> e.getScbchr() != null && v2.getScbchr() != null && e.getScbchr().getScbchr().getData().equals(v2.getScbchr().getScbchr().getData())).findFirst().orElse(null);
                                return ComparisonChain.start().compare((Object)scbbase.getScbkey().getScbscbkeydetList().indexOf((Object)s1), (Object)scbbase.getScbkey().getScbscbkeydetList().indexOf((Object)s2), (Comparator)Ordering.natural().nullsLast()).result();
                            }
                        };
                        scbbase.getScbbasList().sort((Comparator)compare);
                    }
                    for (BoScbBas scb : scbbase.getScbbasList()) {
                        ClScbScbKeyDet clScbScbKeyDet = scb.getScbkey().getScbscbkeydetList().stream().filter(e -> e.getScbchr() != null && scb.getScbchr() != null && e.getScbchr().getScbchr().getData().equals(scb.getScbchr().getScbchr().getData())).findFirst().orElse(null);
                        int width = 2;
                        if (clScbScbKeyDet.getFldposwide().getData() != null) {
                            // empty if block
                        }
                        int tmpCol = 0;
                        if (scbbase.getScbkey().getScbframelayouttype().getData() == 10) {
                            Integer itemseq = 0;
                            if (clScbScbKeyDet.getItemseq().getData() != null) {
                                itemseq = clScbScbKeyDet.getItemseq().getData();
                            }
                            tmpCol = itemseq / 100;
                            ++tmpCol;
                        }
                        if (scbbase.getScbkey().getScbframelayouttype().getData() == 11) {
                            tmpCol = clScbScbKeyDet.getFldposcol().getData() != null ? clScbScbKeyDet.getFldposcol().getData() : 1;
                            int n = row = clScbScbKeyDet.getFldposrow().getData() != null ? clScbScbKeyDet.getFldposrow().getData() : 1;
                        }
                        if (lastCol != tmpCol) {
                            lastCol = tmpCol;
                            if (scbbase.getScbkey().getScbframelayouttype().getData() == 10) {
                                row = 1;
                                col += 4;
                            } else if (scbbase.getScbkey().getScbframelayouttype().getData() == 11) {
                                col += 2;
                            }
                        }
                        int finalcol = scbbase.getScbkey().getScbframelayouttype().getData() == 10 ? (col > 1 ? col + 1 : col) : col;
                        PrimaryEditorComponent editor = null;
                        switch (scb.getScbchr().getScbchrtype().getData()) {
                            case 0: 
                            case 20: {
                                switch (scb.getScbchr().getScbchrformat().getData()) {
                                    case 0: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_stringvalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_stringvalue());
                                        break;
                                    }
                                    case 2: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_moneyvalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_moneyvalue());
                                        break;
                                    }
                                    case 1: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_quantityvalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_quantityvalue());
                                        break;
                                    }
                                    case 3: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_percentvalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_percentvalue());
                                        break;
                                    }
                                    case 4: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_factorvalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_factorvalue());
                                        break;
                                    }
                                    case 5: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_integervalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_integervalue());
                                        break;
                                    }
                                    case 10: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_datevalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_datevalue());
                                        break;
                                    }
                                    case 11: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_datetimevalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_datetimevalue());
                                        break;
                                    }
                                    case 20: {
                                        EFCPanelSingleton.getInstance();
                                        editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_booleanvalue"), (String)("." + scb.getScbchr().getStext().getData()), (int)finalcol, (int)row, (int)width, (String)"", null, null, (boolean)false, (boolean)false, (String)scb.getScbchr().getScbchr().getData());
                                        editor.setValue((Object)scb.getScb_booleanvalue());
                                    }
                                }
                                break;
                            }
                            case 10: {
                                EFCPanelSingleton.getInstance();
                                editor = EFCPanelSingleton.createEditorForScb((EFCController)this, (EFCFormPanel)formPanel, (String)(domain + ".scbbasList.scb_scbchrdetvalue"), (String)scb.getScbchr().getStext().getData(), (int)finalcol, (int)row, (int)width, (String)(domain + ".scbbasList.scb_scbchrdetvalue"), (String)"scbvalue", (String)(domain + ".scbbasList.scb_scbchrdetvalue.sText"), (boolean)true, (boolean)true, (String)scb.getScbchr().getScbchr().getData());
                                editor.setInfotextVisible(true);
                                if (scb.getScb_scbchrdetvalue() != null) {
                                    editor.setInfotext(scb.getScb_scbchrdetvalue().getStext().getData());
                                }
                                editor.setValue((Object)scb.getScb_scbchrdetvalue());
                            }
                        }
                        if (editor == null) continue;
                        if (editor.getLinkedLabel() != null) {
                            editor.getLinkedLabel().setText(scb.getScbchr().getStext().getData());
                            editor.getLinkedLabel().setToolTipText(scb.getScbchr().getStext().getData());
                        }
                        editor.setEditable(this.getWindowMode() == EFCWindowMode.MODE_EDIT || this.getWindowMode() == EFCWindowMode.MODE_NEW);
                        editor.setEnabled(this.getWindowMode() == EFCWindowMode.MODE_EDIT || this.getWindowMode() == EFCWindowMode.MODE_NEW);
                        if (scbbase.getScbkey().getScbframelayouttype().getData() != 10) continue;
                        ++row;
                    }
                }
            } else {
                splitscbListTop.setVisible(true);
            }
        } else if (ident.contains("scbbasList")) {
            Object data;
            EFCObjectListEditor scbchrInfoObjList;
            String domain = "";
            if (ident.lastIndexOf(".") != -1) {
                domain = ident.substring(0, ident.lastIndexOf(".") + 1);
            }
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_scbchrdetvalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_stringvalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_integervalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_quantityvalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_moneyvalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_percentvalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_factorvalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_datetimevalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_datevalue", false);
            this.viewManager.setFieldVisible(domain + "scbbasList.scb_booleanvalue", false);
            JComponent scbchrInfo = this.viewManager.getField(domain + "scbbasList.scbchr");
            if (scbchrInfo != null && scbchrInfo instanceof EFCObjectListEditor && (scbchrInfoObjList = (EFCObjectListEditor)scbchrInfo).getInfotextComponent() instanceof EFCLabel) {
                ((EFCLabel)scbchrInfoObjList.getInfotextComponent()).setText("");
            }
            String domainIdent = "";
            if (domain.lastIndexOf(".") != -1) {
                domainIdent = ident.substring(0, ident.lastIndexOf("."));
            }
            Object domainObject = null;
            if (domainIdent.length() > 0) {
                StringTokenizer domainTokens = new StringTokenizer(domainIdent, ".");
                StringBuilder tmpDomain = new StringBuilder();
                while (domainTokens.hasMoreTokens()) {
                    tmpDomain.append(domainTokens.nextToken());
                    domainObject = this.getBusinessObjectModel().getValueFromObject(tmpDomain.toString());
                    if (domainObject != null && domainObject instanceof EFCList && ((EFCList)domainObject).isEmpty()) {
                        return;
                    }
                    tmpDomain.append(".");
                }
            }
            if ((data = this.getBusinessObjectModel().getValueFromObject(domain + "scbbasList")) instanceof EFCList && !((EFCList)data).isEmpty()) {
                BoScbBas scbbo = (BoScbBas)this.viewManager.getSelectedTablePanelBusObj(domain + "scbbasList");
                this.viewManager.setFieldVisible(domain + "scbbasList.scbchr", true);
                if (scbbo != null && scbbo.getScbchr() != null) {
                    block15 : switch (scbbo.getScbchr().getScbchrtype().getData()) {
                        case 0: 
                        case 20: {
                            switch (scbbo.getScbchr().getScbchrformat().getData()) {
                                case 0: {
                                    EFCAbstractPrimaryEditor inputField = (EFCAbstractPrimaryEditor)this.viewManager.getField(domain + "scbbasList.scb_stringvalue");
                                    if (scbbo.getScbchr().getScbchrtype().getData() == 20) {
                                        EFCPanelSingleton.addSearchService((EFCController)this, (PrimaryEditorComponent)inputField, (String)"rou.search.SvSearchMdRouResCompact", (String)"SEARCHLIST_SVSEARCHMDROURESCOMPACT_ROU_MDROURESCOMPACT", (String)"", (String)"V_SEARCHSTRING", (String)"resource");
                                    } else {
                                        inputField.removeSearchPopup();
                                    }
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_stringvalue", true, true);
                                    break block15;
                                }
                                case 2: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_moneyvalue", true, true);
                                    break block15;
                                }
                                case 1: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_quantityvalue", true, true);
                                    break block15;
                                }
                                case 3: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_percentvalue", true, true);
                                    break block15;
                                }
                                case 4: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_factorvalue", true, true);
                                    break block15;
                                }
                                case 5: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_integervalue", true, true);
                                    break block15;
                                }
                                case 10: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_datevalue", true, true);
                                    break block15;
                                }
                                case 11: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_datetimevalue", true, true);
                                    break block15;
                                }
                                case 20: {
                                    this.viewManager.setFieldVisible(domain + "scbbasList.scb_booleanvalue", true, true);
                                }
                            }
                            break;
                        }
                        case 10: {
                            this.viewManager.setFieldVisible(domain + "scbbasList.scb_scbchrdetvalue", true, true);
                        }
                    }
                }
            } else if (data instanceof EFCList && ((EFCList)data).isEmpty()) {
                this.viewManager.setFieldVisible(domain + "scbbasList.scbchr", false);
            }
        }
    }

    public void onSubPanelDataLoading(String ident) {
    }

    public void onSubPanelDataLoadFinished(String ident) {
    }

    public void resetPanels() {
        switch (this.getWindowMode()) {
            case MODE_INFO: {
                this.viewManager.setAllFieldsForInfo();
                break;
            }
            case MODE_EDIT: {
                this.viewManager.setAllFieldsForEdit();
                break;
            }
            case MODE_INFO_SCROLL: {
                this.viewManager.setAllFieldsForInfoScroll();
                break;
            }
            case MODE_NEW: {
                this.viewManager.setAllFieldsForNew();
                break;
            }
            case MODE_SCROLL: {
                this.viewManager.setAllFieldsForScroll();
            }
        }
    }

    public void onActualizeForScrollListReset(String orderfield) {
        this.setOrderField(orderfield);
        this.viewManager.setActiveField(orderfield);
        this.baseScrollList = this.guiService.getScrollList(orderfield, this.scrollFilter);
        this.actionPrevious();
    }

    protected void initTimer(Integer delayInSeconds) {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new ActualizeTask(), new Date(), (long)(delayInSeconds * 1000));
    }

    protected void terminate() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.terminate();
    }

    public void sortBusinessTable(String businessTableIdent, final String ident, final boolean ascending) {
        final EFCBusinessDataTablePanel businessTable = this.viewManager.getBusinessTablePanel(businessTableIdent);
        final BusinessDataObject data = ((EFCBoModel)businessTable.getTableModel()).getData();
        businessTable.setLocked(true);
        this.handleOutside(false, new Closure[]{new EFCClosure((Object)this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)args;
                LinkedList datasetsorted = new LinkedList();
                data.getDatasetnames().entrySet().stream().sorted((a, b) -> {
                    Object resultA = Eval.x(a.getValue(), (String)("x." + ident));
                    Object resultB = Eval.x(b.getValue(), (String)("x." + ident));
                    if (ascending) {
                        if (resultA instanceof EFCAlphaNumeric && resultB instanceof EFCAlphaNumeric) {
                            return ((EFCAlphaNumeric)resultA).compareTo((EFCAlphaNumeric)resultB);
                        }
                        if (resultA instanceof NumberType && resultB instanceof NumberType) {
                            return ((NumberType)resultA).compareTo((NumberType)resultB);
                        }
                        if (resultA instanceof EFCDateTime && resultB instanceof EFCDateTime) {
                            return ((EFCDateTime)resultA).compareTo((EFCDateTime)resultB);
                        }
                        if (resultA instanceof EFCDate && resultB instanceof EFCDate) {
                            return ((EFCDate)resultA).compareTo((EFCDate)resultB);
                        }
                    } else {
                        if (resultA instanceof EFCAlphaNumeric && resultB instanceof EFCAlphaNumeric) {
                            return ((EFCAlphaNumeric)resultB).compareTo((EFCAlphaNumeric)resultA);
                        }
                        if (resultA instanceof NumberType && resultB instanceof NumberType) {
                            return ((NumberType)resultB).compareTo((NumberType)resultA);
                        }
                        if (resultA instanceof EFCDateTime && resultB instanceof EFCDateTime) {
                            return ((EFCDateTime)resultB).compareTo((EFCDateTime)resultA);
                        }
                        if (resultA instanceof EFCDate && resultB instanceof EFCDate) {
                            return ((EFCDate)resultB).compareTo((EFCDate)resultA);
                        }
                    }
                    return 0;
                }).forEachOrdered(entry -> datasetsorted.add((String)entry.getKey()));
                data.setDataset(datasetsorted);
                data.getData().clear();
                ArrayList<String> tmpList = new ArrayList<String>();
                for (String e : datasetsorted) {
                    String comp = e;
                    if (tmpList.contains(comp)) continue;
                    tmpList.add(comp);
                    data.getData().add(new LinkedList());
                    int id = datasetsorted.indexOf(comp);
                    for (int i = 0; i < data.getGroups().size(); ++i) {
                        ((List)data.getData().get(id)).add(null);
                    }
                }
                for (BusinessListEntry entry2 : data.getOriginData()) {
                    int setid = datasetsorted.indexOf(entry2.getDataset());
                    int groupid = data.getGroups().indexOf(entry2.getGroup());
                    if (groupid < 0 || setid < 0) {
                        System.err.println("invalid group or dataset selected: g=" + entry2.getGroup() + " | d=" + entry2.getDataset());
                        continue;
                    }
                    ((List)data.getData().get(setid)).set(groupid, entry2.getValue());
                }
                return sb;
            }
        }, new EFCClosure((Object)this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)args;
                sb.edt((Closure)new EFCClosure(sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)arguments;
                        ((EFCBoCellRenderer)businessTable.getTable().getDefaultRenderer(BusinessObject.class)).clearPanels();
                        businessTable.updateTable(new EFCBoModel(data));
                        return sb;
                    }
                });
                return sb;
            }
        }});
    }

    public void handleElementDataChanged(String ident, Object oldval, Object newval, boolean doInBackground) {
        this.handleElementDataChanged(ident, oldval, newval, doInBackground, null);
    }

    public void handleElementDataChanged(final String ident, final Object oldval, final Object newval, boolean doInBackground, String scbchr) {
        block13: {
            boolean foundScbChr;
            BoScbBas selectedBoScbBas;
            String scbchrkey;
            block14: {
                String scbbasTableIdent;
                block15: {
                    ScbBase scbBase;
                    BoScbBas boscbbas;
                    this.refreshView(ident, oldval, newval);
                    int listIdentIndex = ident.indexOf(".");
                    if (listIdentIndex != -1) {
                        String listIdent = ident.substring(0, listIdentIndex);
                        if (this.getBusinessObjectModel().isLastSelectedListItemsEmpty()) {
                            this.getBusinessObjectModel().setLastSelectedListItemIndex(listIdent, 0);
                        }
                    }
                    scbchrkey = null;
                    selectedBoScbBas = null;
                    foundScbChr = false;
                    if (!ident.contains(".scbbasList.")) break block14;
                    scbbasTableIdent = ident.substring(0, ident.lastIndexOf("."));
                    if (scbchr == null) break block15;
                    String scbbasIdent = scbbasTableIdent.substring(0, scbbasTableIdent.lastIndexOf("."));
                    BusinessObject obj = this.viewManager.getSelectedTablePanelBusObj(scbbasIdent);
                    if (!(obj instanceof ScbBase) || (boscbbas = (BoScbBas)(scbBase = (ScbBase)obj).getScbbasList().stream().filter(scbbas -> scbbas.getScbchr().getScbchr().getData() != null && scbchr.equals(scbbas.getScbchr().getScbchr().getData())).findFirst().orElse(null)) == null) break block14;
                    this.getBusinessObjectModel().setLastSelectedListItemIndex(scbbasTableIdent, scbBase.getScbbasList().indexOf((Object)boscbbas));
                    break block14;
                }
                selectedBoScbBas = (BoScbBas)this.viewManager.getSelectedTablePanelBusObj(scbbasTableIdent);
                for (String field : this.handleChangedFields) {
                    if (!field.startsWith(ident) || !field.substring(field.lastIndexOf(".") + 1, field.length()).equals(selectedBoScbBas.getScbchr().getScbchr().getData())) continue;
                    foundScbChr = true;
                    scbchrkey = ident.concat("." + field.substring(field.lastIndexOf(".") + 1, field.length()));
                    break;
                }
            }
            final BoScbBas boScbBas = selectedBoScbBas;
            final boolean isScbDynamicChange = foundScbChr;
            if (this.handleChangedFields.contains(ident) || scbchrkey != null && this.handleChangedFields.contains(scbchrkey)) {
                this.viewManager.setFocusableField(null);
                if (this.getWindowMode() == EFCWindowMode.MODE_EDIT || this.getWindowMode() == EFCWindowMode.MODE_NEW) {
                    this.setModified(true);
                }
                try {
                    if (doInBackground) {
                        this.handleOutside(new Closure[]{new EFCClosure((Object)this){
                            private static final long serialVersionUID = 1L;

                            public EFCThreadUtil call(Object args) {
                                EFCThreadUtil sb = (EFCThreadUtil)args;
                                try {
                                    if (isScbDynamicChange) {
                                        HashMap<String, Object> bindings = new HashMap<String, Object>();
                                        bindings.put("context", (Object)this);
                                        bindings.put("boScbBas", boScbBas);
                                        bindings.put("ident", ident);
                                        bindings.put("oldVal", oldval);
                                        bindings.put("newVal", newval);
                                        Binding binding = new Binding(bindings);
                                        XciActions.executeXciEvent((EFCController)EFCBaseFrame.this, (Binding)binding, (String)((Object)((Object)EFCBaseFrame.this)).getClass().getSimpleName(), (String)"onElementDataChanged");
                                    } else {
                                        EFCBaseFrame.this.onElementDataChanged(ident, oldval, newval);
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    EFCBaseFrame.this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                                    EFCBaseFrame.this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROW_SELECTED"));
                                }
                                catch (InvalidTableSelectionException sel) {
                                    EFCBaseFrame.this.logger.error(sel.getMessage());
                                    EFCBaseFrame.this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROW_SELECTED"));
                                }
                                catch (UnsupportedOperationException uox) {
                                    EFCBaseFrame.this.logger.error(uox.getMessage());
                                    EFCBaseFrame.this.logger.warn("unimplemented service-method for field: " + ident + " called and 'putValueInObject()' executed instead!");
                                    EFCBaseFrame.this.putValueInObject(ident, newval);
                                }
                                return sb;
                            }
                        }, new EFCClosure((Object)this){
                            private static final long serialVersionUID = 1L;

                            public EFCThreadUtil call(Object arguments) {
                                EFCThreadUtil sb = (EFCThreadUtil)arguments;
                                sb.edt((Closure)new EFCClosure(sb){
                                    private static final long serialVersionUID = 1L;

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public EFCThreadUtil call(Object args) {
                                        EFCThreadUtil sb = (EFCThreadUtil)args;
                                        try {
                                            EFCBaseFrame.this.onElementDataChangedFinished(ident, oldval, newval);
                                        }
                                        catch (Exception e) {
                                            try {
                                                EFCBaseFrame.this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                                                if (e.getCause() != null) {
                                                    throw e.getCause();
                                                }
                                            }
                                            catch (ArrayIndexOutOfBoundsException ae) {
                                                EFCBaseFrame.this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)ae);
                                                EFCBaseFrame.this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROW_SELECTED"));
                                            }
                                            catch (InvalidTableSelectionException sel) {
                                                EFCBaseFrame.this.logger.error(sel.getMessage());
                                                EFCBaseFrame.this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROW_SELECTED"));
                                            }
                                            catch (UnsupportedOperationException uox) {
                                                EFCBaseFrame.this.logger.error(uox.getMessage());
                                                EFCBaseFrame.this.logger.warn("unimplemented service-method for field: " + ident);
                                            }
                                            catch (Throwable th) {
                                                EFCBaseFrame.this.logger.error(th.getMessage());
                                            }
                                        }
                                        finally {
                                            EFCBaseFrame.this.notifyCheckLastInputValueChanged();
                                        }
                                        return sb;
                                    }
                                });
                                return sb;
                            }
                        }});
                        break block13;
                    }
                    try {
                        this.onElementDataChanged(ident, oldval, newval);
                        this.onElementDataChangedFinished(ident, oldval, newval);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROW_SELECTED"));
                    }
                    catch (InvalidTableSelectionException sel) {
                        this.logger.error(sel.getMessage());
                        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROW_SELECTED"));
                    }
                    catch (UnsupportedOperationException uox) {
                        this.logger.error(uox.getMessage());
                        this.logger.warn("unimplemented service-method for field: " + ident + " called and 'putValueInObject()' executed instead!");
                        this.putValueInObject(ident, newval);
                    }
                }
                catch (Exception e) {
                    this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                }
            } else {
                this.putValueInObject(ident, newval);
                this.changeBoTableSelection(this.newTableIndex);
            }
        }
    }

    private void changeBoTableSelection(AtomicInteger newIndex) {
        JPanel comp;
        String tableIdent = this.viewManager.getSelectedTablePanelId();
        if (tableIdent != null && !tableIdent.isEmpty() && newIndex.get() != -1 && (comp = this.viewManager.getPanel(tableIdent)) != null && comp instanceof EFCBOTablePanel) {
            EFCBOTablePanel tablePanel = (EFCBOTablePanel)comp;
            tablePanel.getTable().changeSelection(newIndex.get(), tablePanel.getTable().getSelectedColumn(), true, false);
            tablePanel.setSelectedIndex(tablePanel.getTable().convertRowIndexToModel(newIndex.get()));
            newIndex.set(-1);
        }
    }

    protected void onElementDataChangedFinished(String ident, Object oldval, Object newval) {
        super.onElementDataChangedFinished(ident, oldval, newval);
        this.changeBoTableSelection(this.newTableIndex);
        JComponent compo = this.viewManager.getField(this.viewManager.getLastActiveField());
        if (compo != null && compo instanceof EFCObjectListEditor) {
            ((EFCObjectListEditor)compo).setDefaultPopupParams(this.getPopupParam(((EFCObjectListEditor)compo).getIdent()));
        }
    }

    private class ActualizeTask
    extends TimerTask {
        private ActualizeTask() {
        }

        @Override
        public void run() {
            try {
                if (!EFCBaseFrame.this.isControlLocked()) {
                    EFCBaseFrame.this.actionActualizeObject();
                }
            }
            catch (RemoteAccessException re) {
                EFCBaseFrame.this.logger.error(re.getMessage());
                EFCDesktop.showInfoDlg((Object)Translator.tr((String)"MSG_FRAME_EXCEPTION"), (String)Translator.tr((String)"DLG_TITLE_ERROR"), (Integer)20);
            }
        }
    }
}

