/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.gui.components.EFCBaseDialog;
import de.effectivecompany.gui.components.EFCMainMenu;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.swing.EFCLayoutFocusTraversalPolicy;
import de.effectivecompany.gui.interfaces.frame.BaseDialog;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EFCDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel basePanel = null;
    private Integer answer;
    private String[] options;
    private BaseDialog dialog;
    private EFCMainMenu mainMenu;
    private JPanel buttonPanel;
    private static final int PANEL_DIVIDER = 2;
    private Dimension size;
    private Point location;
    private boolean isWindowPositionLocked;
    protected boolean validateInputOutside = false;
    private Window parent;
    private boolean isForSearch = false;
    private int defaultOption = -1;
    private JPanel glass = new JPanel();

    public EFCDialog(Window parent, BaseDialog dialog, String title, EFCMainMenu menu, JComponent panel, boolean modal, Dimension size, Point location, boolean isWindowPositionLocked, String[] options, boolean validateInputOutside) {
        this(parent, dialog, title, menu, panel, modal, size, location, isWindowPositionLocked, options, validateInputOutside, null);
    }

    public EFCDialog(Window parent, BaseDialog dialog, String title, EFCMainMenu menu, JComponent panel, boolean modal, Dimension size, Point location, boolean isWindowPositionLocked, String[] options, boolean validateInputOutside, String defaultOption) {
        super(parent != null ? parent : EFCMainFrame.getInstance());
        this.setTitle(title);
        this.size = size;
        this.parent = parent;
        this.validateInputOutside = validateInputOutside;
        this.setIconImage(EFCLookAndFeelManager.ICON_APP_DIALOG.getImage());
        this.basePanel = new JPanel(new BorderLayout());
        this.options = options;
        this.dialog = dialog;
        this.mainMenu = menu;
        this.setDefaultCloseOperation(0);
        this.location = location;
        this.isWindowPositionLocked = isWindowPositionLocked;
        this.basePanel.add((Component)panel, "Center");
        this.buttonPanel = new JPanel();
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                JButton button = new JButton(options[i]);
                if (options[i] != null && !options[i].toString().isEmpty()) {
                    button.setMnemonic(options[i].toString().toLowerCase().charAt(0));
                }
                button.setFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
                button.addActionListener(this);
                if (defaultOption != null && defaultOption.equals(options[i])) {
                    button.setSelected(true);
                    this.defaultOption = i;
                }
                this.buttonPanel.add(button);
            }
            if (this.defaultOption == -1 && options.length == 1) {
                this.defaultOption = 0;
            }
        }
        this.basePanel.add((Component)this.buttonPanel, "South");
        if (menu != null) {
            this.setJMenuBar((JMenuBar)menu);
            if (dialog instanceof EFCBaseDialog) {
                menu.getToolBar().setFloatable(false);
                this.basePanel.add((Component)menu.getToolBar(), "North");
            }
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new EFCLayoutFocusTraversalPolicy());
        this.glass.setOpaque(false);
        this.glass.addMouseListener(new MouseAdapter(){});
        this.setGlassPane(this.glass);
        this.getContentPane().add(this.basePanel);
    }

    public void setIsForSearch(boolean forSearch) {
        this.isForSearch = forSearch;
    }

    public void showDialog() {
        this.setModal(true);
        this.pack();
        if (this.size != null) {
            if (this.isWindowPositionLocked) {
                this.setSize((Dimension)this.size.clone());
            } else {
                this.setSize(UnitConverter.sizeFromDLU((Dimension)this.size, (Component)EFCDesktop.getInstance()));
            }
            this.setPreferredSize((Dimension)this.size.clone());
        } else {
            this.setSize(new Dimension(this.basePanel.getWidth() / 2 + 100, this.basePanel.getHeight() + 60));
        }
        if (!this.isForSearch) {
            this.setLocation(this.location);
        }
        this.dialog.initDialog();
        this.setVisible(true);
    }

    @Override
    public void setLocation(Point location) {
        if (location != null) {
            Point loc = SwingUtilities.convertPoint(this, new Point(EFCMainFrame.getInstance().getBounds().x + location.x, EFCMainFrame.getInstance().getBounds().y + location.y), (Component)EFCMainFrame.getInstance());
            if (EFCLookAndFeelManager.locationInVirtualSize((Point)loc)) {
                this.setLocation(loc.x, loc.y);
            } else {
                this.setLocationRelativeTo(this.parent != null ? this.parent : EFCMainFrame.getInstance());
            }
        } else {
            this.setLocationRelativeTo(this.parent != null ? this.parent : EFCMainFrame.getInstance());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.answer = null;
        if (!(e.getSource() instanceof JButton)) {
            return;
        }
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].toString().equals(((JButton)e.getSource()).getText())) continue;
            this.answer = i;
            break;
        }
        if (this.answer == null) {
            return;
        }
        if (this.validateInputOutside) {
            this.lockFrame();
            EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
                this.dialog.checkLastInput();
                Boolean isInputValid = this.dialog.onValidateInput();
                th.edt(() -> {
                    if (isInputValid.booleanValue() && this.dialog.validateInput()) {
                        this.setVisible(false);
                    }
                    this.unlockFrame();
                });
            }));
        } else {
            this.dialog.checkLastInput();
            if (this.dialog.validateInput()) {
                this.setVisible(false);
            }
        }
    }

    public void setAnswer(Integer answer) {
        this.answer = answer;
    }

    public Integer getAnswer() {
        return this.answer;
    }

    public void lockFrame() {
        this.glass.setVisible(true);
        this.setCursor(new Cursor(3));
        if (this.mainMenu != null) {
            this.mainMenu.setMenusEnabled(false);
        }
    }

    public JButton getOptionButton(int index) {
        return (JButton)this.buttonPanel.getComponent(index);
    }

    public JButton getDefaultOptionButton() {
        if (this.defaultOption != -1) {
            return (JButton)this.buttonPanel.getComponent(this.defaultOption);
        }
        return (JButton)this.buttonPanel.getComponent(0);
    }

    public Boolean doClickDefaultOption() {
        if (this.defaultOption != -1) {
            this.getOptionButton(this.defaultOption).doClick();
            return true;
        }
        return false;
    }

    public void unlockFrame() {
        this.glass.setVisible(false);
        this.setCursor(new Cursor(0));
        if (this.mainMenu != null) {
            this.mainMenu.setMenusEnabled(true);
        }
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.mainMenu = null;
        this.glass = null;
        super.dispose();
    }
}

