/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.filter.Filter;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.EFCBaseDialog;
import de.effectivecompany.gui.components.EFCBaseFrame;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.EFCDialog;
import de.effectivecompany.gui.components.frame.EFCFrameLayoutInfo;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchFrame;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.enums.EFCAutostart;
import de.effectivecompany.gui.enums.EFCSearchMode;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.frame.BaseDialog;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class EFCSearchDialog
extends EFCSearchFrame
implements ActionHandler,
BaseDialog {
    private static final long serialVersionUID = 1L;
    protected EFCBaseFrame parent;
    private String title;
    protected EFCDialog dlg;
    private Dimension dialogSize;

    public EFCSearchDialog(EFCBaseFrame parent, String callingField, Filter filter, SearchService service, EFCSearchMode searchMode) {
        this(parent, callingField, "", filter, service, searchMode);
    }

    public EFCSearchDialog(EFCBaseFrame parent, String callingField, String title, Filter filter, SearchService service, EFCSearchMode searchMode) {
        this(parent, callingField, title, filter, service, EFCAutostart.NOTHING, null, searchMode);
    }

    public EFCSearchDialog(EFCBaseFrame parent, String callingField, String title, Filter filter, SearchService service, EFCAutostart autostart, Map<String, Object> param, EFCSearchMode searchMode) {
        super((EFCController)parent, callingField, title, filter, service, autostart, param, searchMode);
        this.parent = parent;
        this.title = this.getTitle();
        this.setDialogView(true);
        this.dialogSize = EFCLookAndFeelManager.SIZE_FRAME_SEARCH;
    }

    public void execute(String[] options) {
        this.execute(options, "");
    }

    public void execute(String[] options, String hideGroup) {
        this.dlg = new EFCDialog(this.parent instanceof EFCBaseDialog ? ((EFCBaseDialog)this.parent).getDialog() : null, this, this.title, this.getMainMenu(), (JComponent)this.getPanel(), true, this.dialogSize, null, false, options, false);
        this.dlg.setIsForSearch(true);
        this.dlg.setDefaultCloseOperation(2);
        this.initDialog();
        this.dlg.showDialog();
    }

    public void setLocation(Point location) {
        this.dlg.setLocation(location);
    }

    public void initDialog() {
    }

    public boolean validateInput() {
        return true;
    }

    public void checkLastInput() {
    }

    public EFCDialog getDialog() {
        return this.dlg;
    }

    public void dispose() {
        this.getParentController().removeSearchFrame((EFCSearchFrame)this);
        if (this.dlg.getComponents().length > 0) {
            this.dlg.setVisible(false);
            this.dlg.dispose();
        }
        super.dispose();
    }

    protected void init() {
    }

    public void lockControl() {
        this.dlg.lockFrame();
    }

    public void unlockControl() {
        this.dlg.unlockFrame();
    }

    public void lockFrame() {
        this.dlg.lockFrame();
    }

    public void unLockFrame() {
        this.dlg.unlockFrame();
    }

    public BusinessObject getBusObj() {
        return null;
    }

    public Integer getAnswer() {
        return 0;
    }

    public boolean onValidateInput() {
        return true;
    }

    protected void lockWindowPosition(Boolean isLocked) {
        if (!isLocked.booleanValue()) {
            String frameName = this.dcSearchMetaInfo.getId();
            Dimension preferredSize = this.getSize();
            Point location = SwingUtilities.convertPoint(this.dlg, new Point(0, 0), (Component)EFCMainFrame.getInstance());
            boolean isMaximized = this.isMaximum();
            EFCFrameLayoutInfo layoutInfo = new EFCFrameLayoutInfo(frameName, preferredSize.getSize().width, preferredSize.getSize().height, location.x, location.y, isMaximized);
            EFCPanelSingleton.getInstance().setFramePosition(frameName, this.parentController.getLayoutFileName(), layoutInfo);
        } else {
            EFCPanelSingleton.getInstance().removeFramePosition(this.dcSearchMetaInfo.getId(), this.parentController.getLayoutFileName());
        }
    }

    public JButton getOptionButton(int index) {
        return this.dlg.getOptionButton(index);
    }
}

