/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.frame;

import de.effectivecompany.app.app.service.SvSysMail;
import de.effectivecompany.app.sys.BoSysMail;
import de.effectivecompany.app.sys.DcSysMailAddress;
import de.effectivecompany.app.sys.DcSysMailAttachmentEntry;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.EFCBaseDialog;
import de.effectivecompany.gui.components.EFCBaseFrame;
import de.effectivecompany.gui.components.EFCFileChooser;
import de.effectivecompany.gui.components.panel.EFCPDFViewerPanel;
import de.effectivecompany.gui.components.panel.EFCTabPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.swing.EFCMessageListDialog;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.factory.EFCViewerFactory;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EFCMailDialog
extends EFCBaseDialog {
    private SvSysMail svSysMail = (SvSysMail)SpringHelper.getService(SvSysMail.class);

    public EFCMailDialog(EFCBaseFrame parent, Class<? extends BusinessObject> boClass, Map<String, Object> launchParam) {
        super(parent, Translator.tr((String)"DLG_TITLE_SYSMAIL"), "sys/BoSysMail.xml", EnumSet.of(EFCAction.A_DET_ADD, EFCAction.A_DET_DEL), new Dimension(750, 500), boClass, true);
        this.initHandleChangedFields();
        this.viewManager.getTablePanel("attachedFiles").setEmptySelectionAllowed(true);
        this.viewManager.getTablePanel("attachedFiles").setSelectedIndex(-1);
    }

    public void initPDFPreview(EFCBlob pdf) {
        JPanel panel;
        if (pdf != null && pdf.getData() != null && (panel = this.viewManager.getPanel("pdfpreview")) instanceof EFCPDFViewerPanel) {
            EFCPDFViewerPanel pdfviewer = (EFCPDFViewerPanel)panel;
            pdfviewer.initDoc(pdf);
        }
    }

    @Override
    public void execute(BusinessObject input, List<String> options) {
        this.checkTO((BoSysMail)input);
        this.checkCC((BoSysMail)input);
        this.checkBCC((BoSysMail)input);
        super.execute(input, options);
    }

    public BoSysMail getBusObj() {
        return (BoSysMail)super.getBusObj();
    }

    protected void initHandleChangedFields() {
        this.addHandleChangedFields(new String[]{"toList.address", "ccList.address", "bccList.address"});
    }

    protected boolean isListAddAllowed(String tableIdent) {
        return Arrays.asList("attachedFiles", "toList", "ccList", "bccList").contains(tableIdent);
    }

    @Override
    public void handleElementDataChanged(String ident, Object oldval, Object newval, boolean doInBackground) {
        super.handleElementDataChanged(ident, oldval, newval, doInBackground);
        switch (ident) {
            case "to": {
                EFCString adresses = (EFCString)newval;
                StringTokenizer st = new StringTokenizer(adresses.getData(), ",");
                EFCList adressList = new EFCList();
                while (st.hasMoreTokens()) {
                    DcSysMailAddress dcSysMailAddress = new DcSysMailAddress();
                    dcSysMailAddress.setAddress(st.nextToken().trim());
                    adressList.add((Object)dcSysMailAddress);
                }
                this.getBusObj().setToList(adressList);
                this.updateFields((BusinessObject)this.getBusObj());
            }
        }
    }

    @Override
    public void handleTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        super.handleTableSelectionChanged(tableIdent, columnName, selectedObject);
        switch (tableIdent) {
            case "attachedFiles": {
                if (!(selectedObject instanceof DcSysMailAttachmentEntry)) break;
                DcSysMailAttachmentEntry entry = (DcSysMailAttachmentEntry)selectedObject;
                EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
                    EFCBlob blob = this.svSysMail.getAttachmentForPreview(entry);
                    th.edt(() -> {
                        JPanel panel = this.viewManager.getPanel("tab_preview");
                        if (panel instanceof EFCTabPanel) {
                            ((EFCTabPanel)panel).getTabEntity("tp_preview").setComponent((JComponent)EFCViewerFactory.createPanel((String)entry.getFilename().getData(), (EFCBlob)blob));
                            ((EFCTabPanel)panel).updatePane();
                        }
                    });
                }));
            }
        }
    }

    private void checkTO(BoSysMail bo) {
        if (bo != null && !bo.getToList().isEmpty()) {
            bo.setTo(((DcSysMailAddress)bo.getToList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    private void checkCC(BoSysMail bo) {
        if (bo != null && !bo.getCcList().isEmpty()) {
            bo.setCc(((DcSysMailAddress)bo.getCcList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    private void checkBCC(BoSysMail bo) {
        if (bo != null && !bo.getBccList().isEmpty()) {
            bo.setBcc(((DcSysMailAddress)bo.getBccList().get(0)).getAddress());
            this.updateFields((BusinessObject)bo);
        }
    }

    @Override
    protected void onElementDataChanged(String ident, Object oldval, Object newval) {
        super.onElementDataChanged(ident, oldval, newval);
        switch (ident) {
            case "toList.address": {
                this.checkTO(this.getBusObj());
                break;
            }
            case "ccList.address": {
                this.checkCC(this.getBusObj());
                break;
            }
            case "bccList.address": {
                this.checkBCC(this.getBusObj());
            }
        }
    }

    protected boolean isListRemoveAllowed(String tableIdent) {
        return Arrays.asList("attachedFiles", "toList", "ccList", "bccList").contains(tableIdent);
    }

    @Override
    public boolean validateInput() {
        BoSysMail mailBo = this.getBusObj();
        try {
            if (this.getAnswer() == 0) {
                BoSysMail bo = this.svSysMail.sendMessage(mailBo);
                if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                    new EFCMessageListDialog((Frame)EFCMainFrame.getInstance(), true).show(bo.getCompleteMsgList().getMsgList());
                    return false;
                }
                EFCDesktop.showInfoDlg((Object)Translator.tr((String)"MSG_FRAME_MAIL_SEND"));
                return true;
            }
            if (this.getAnswer() == 1) {
                BoSysMail bo = this.svSysMail.saveDraft(mailBo);
                if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                    new EFCMessageListDialog((Frame)EFCMainFrame.getInstance(), true).show(bo.getCompleteMsgList().getMsgList());
                    return false;
                }
                EFCDesktop.showInfoDlg((Object)Translator.tr((String)"MSG_FRAME_MAIL_DRAFT_SAVED"));
                return true;
            }
            if (this.getAnswer() == 2) {
                BoSysMail bo = this.getBusObj();
                bo.getAttachedFiles().forEach(entry -> this.svSysMail.deleteAttachedFile(bo, entry.getUuid()));
                return true;
            }
        }
        catch (Throwable th) {
            this.handleException(th);
        }
        return super.validateInput();
    }

    @Override
    public void onActionListAdd() {
        String tableIdent;
        switch (tableIdent = this.viewManager.getSelectedTablePanelId()) {
            case "attachedFiles": {
                EFCFileChooser fc = new EFCFileChooser();
                File file = fc.getFileByOpenFileDialog((Component)this.getDialog());
                if (file == null) break;
                EFCThreadUtil.edtBuilder(th -> {
                    this.lockFrame();
                    th.doOutside(() -> {
                        EFCMap files = new EFCMap();
                        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
                        EFCBlob data = new EFCBlob();
                        try {
                            data.setData(Files.readAllBytes(path));
                        }
                        catch (IOException e) {
                            EFCDesktop.reportError((String)"Fehler beim Lesen der Datei", (Throwable)e);
                        }
                        th.edt(() -> {
                            if (data != null && data.getData().length > 0) {
                                files.put((Object)new EFCString(file.getName()), (Object)data);
                                this.updateFields((BusinessObject)this.svSysMail.attachFile(this.getBusObj(), files));
                            }
                        });
                    });
                });
                break;
            }
            case "toList": {
                BoSysMail bo = this.getBusObj();
                bo.getToList().add((Object)new DcSysMailAddress());
                this.updateFields((BusinessObject)bo);
                break;
            }
            case "ccList": {
                BoSysMail bo = this.getBusObj();
                bo.getCcList().add((Object)new DcSysMailAddress());
                this.updateFields((BusinessObject)bo);
                break;
            }
            case "bccList": {
                BoSysMail bo = this.getBusObj();
                bo.getBccList().add((Object)new DcSysMailAddress());
                this.updateFields((BusinessObject)bo);
                break;
            }
        }
    }

    @Override
    protected void onActionListRemove() {
        String tableIdent = this.viewManager.getSelectedTablePanelId();
        if (tableIdent == null) {
            return;
        }
        switch (tableIdent) {
            case "attachedFiles": {
                DcSysMailAttachmentEntry entry = (DcSysMailAttachmentEntry)this.viewManager.getSelectedTablePanelBusObj("attachedFiles");
                if (entry == null) break;
                this.updateFields((BusinessObject)this.svSysMail.deleteAttachedFile(this.getBusObj(), entry.getUuid()));
                break;
            }
            case "toList": {
                BoSysMail bo = this.getBusObj();
                DcSysMailAddress address = (DcSysMailAddress)this.viewManager.getSelectedTablePanelBusObj("toList");
                bo.getToList().remove((Object)address);
                if (!bo.getToList().isEmpty()) {
                    bo.setTo(((DcSysMailAddress)bo.getToList().get(0)).getAddress());
                } else {
                    bo.setTo((String)null);
                }
                this.updateFields((BusinessObject)bo);
                break;
            }
            case "ccList": {
                BoSysMail bo = this.getBusObj();
                DcSysMailAddress address = (DcSysMailAddress)this.viewManager.getSelectedTablePanelBusObj("ccList");
                bo.getCcList().remove((Object)address);
                if (!bo.getCcList().isEmpty()) {
                    bo.setCc(((DcSysMailAddress)bo.getCcList().get(0)).getAddress());
                } else {
                    bo.setCc((String)null);
                }
                this.updateFields((BusinessObject)bo);
                break;
            }
            case "bccList": {
                BoSysMail bo = this.getBusObj();
                DcSysMailAddress address = (DcSysMailAddress)this.viewManager.getSelectedTablePanelBusObj("bccList");
                bo.getBccList().remove((Object)address);
                if (!bo.getBccList().isEmpty()) {
                    bo.setBcc(((DcSysMailAddress)bo.getBccList().get(0)).getAddress());
                } else {
                    bo.setBcc((String)null);
                }
                this.updateFields((BusinessObject)bo);
                break;
            }
        }
    }

    @Override
    protected void terminate() {
        super.terminate();
    }
}

