/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.util;

import de.effectivecompany.app.sys.SysParam;
import de.effectivecompany.base.datatypes.EFCAutoNum;
import de.effectivecompany.base.datatypes.EFCBupNum;
import de.effectivecompany.base.datatypes.EFCDocItem;
import de.effectivecompany.base.datatypes.EFCDocKey;
import de.effectivecompany.base.datatypes.EFCDocNum;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCMatNum;
import de.effectivecompany.base.datatypes.EFCObjectId;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.OptionObject;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.gui.actions.EFCAdditionalActionInfo;
import de.effectivecompany.gui.components.EFCBaseFrame;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.swing.EFCBoCellComponent;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class GuiTools {
    public static Color getColorBlue(Color oldRgb) {
        int nextgreen;
        if (oldRgb == null) {
            oldRgb = new Color(0, 0, 255);
        }
        if ((nextgreen = oldRgb.getGreen() + 25) > 255) {
            nextgreen -= 255;
        }
        return new Color(0, nextgreen, 255);
    }

    public static ArrayList<String> getKeyTextList(ArrayList<String> keyList, SysParam myParamObj) {
        ArrayList<String> titleTextList = new ArrayList<String>();
        if (keyList == null) {
            titleTextList.add("ERROR: keyList is null!");
            return titleTextList;
        }
        if (myParamObj == null) {
            titleTextList.add("ERROR: sysParam is null!");
            return titleTextList;
        }
        if (keyList.contains("MATNUM") && myParamObj.getMatnum().getData() != null) {
            titleTextList.add(myParamObj.getMatnum().getData());
        }
        if (keyList.contains("WRH")) {
            if (myParamObj.getWrh().getData() != null) {
                titleTextList.add(myParamObj.getWrh().getData());
            }
            if (myParamObj.getWrhList().size() > 0) {
                titleTextList.add("div Lager");
            }
        }
        if (keyList.contains("WRHAREA") && myParamObj.getWrharea().getData() != null) {
            titleTextList.add(myParamObj.getWrharea().getData());
        }
        if (keyList.contains("STKPLC") && myParamObj.getStkplc().getData() != null) {
            titleTextList.add(myParamObj.getStkplc().getData());
        }
        if (keyList.contains("PCKREF") && myParamObj.getPckref().getData() != null) {
            titleTextList.add(myParamObj.getPckref().toString());
        }
        if (keyList.contains("CUSTOMER") && myParamObj.getCustomer().getData() != null) {
            titleTextList.add(myParamObj.getCustomer().getData());
        }
        if (keyList.contains("VENDOR") && myParamObj.getVendor().getData() != null) {
            titleTextList.add(myParamObj.getVendor().getData());
        }
        if (keyList.contains("DOCKEY") && myParamObj.getDockey().getData() != null) {
            titleTextList.add(myParamObj.getDockey().getData());
        }
        if (keyList.contains("DOCNUM") && myParamObj.getDocnum().getData() != null) {
            titleTextList.add(myParamObj.getDocnum().getData());
        }
        if (keyList.contains("DOCDATE") && myParamObj.getDocdate().getData() != null) {
            titleTextList.add(myParamObj.getDocdate().toString());
        }
        if (keyList.contains("PRDDOCKEY") && myParamObj.getPrddockey().getData() != null) {
            titleTextList.add(myParamObj.getPrddockey().getData());
        }
        if (keyList.contains("PRDDOCNUM") && myParamObj.getPrddocnum().getData() != null) {
            titleTextList.add(myParamObj.getPrddocnum().getData());
        }
        if (keyList.contains("BOMDOCKEY") && myParamObj.getBomdockey().getData() != null) {
            titleTextList.add(myParamObj.getBomdockey().getData());
        }
        if (keyList.contains("BOMDOCNUM") && myParamObj.getBomdocnum().getData() != null) {
            titleTextList.add(myParamObj.getBomdocnum().getData());
        }
        if (keyList.contains("ROUDOCKEY") && myParamObj.getRoudockey().getData() != null) {
            titleTextList.add(myParamObj.getRoudockey().getData());
        }
        if (keyList.contains("ROUDOCNUM") && myParamObj.getRoudocnum().getData() != null) {
            titleTextList.add(myParamObj.getRoudocnum().getData());
        }
        if (keyList.contains("RESOURCE") && myParamObj.getResource().getData() != null) {
            titleTextList.add(myParamObj.getResource().getData());
        }
        if (keyList.contains("QLTDOCKEY") && myParamObj.getQltdockey().getData() != null) {
            titleTextList.add(myParamObj.getQltdockey().getData());
        }
        if (keyList.contains("QLTDOCNUM") && myParamObj.getQltdocnum().getData() != null) {
            titleTextList.add(myParamObj.getQltdocnum().getData());
        }
        if (keyList.contains("PJMDOCKEY") && myParamObj.getPjmdockey().getData() != null) {
            titleTextList.add(myParamObj.getPjmdockey().getData());
        }
        if (keyList.contains("PJMDOCNUM") && myParamObj.getPjmdocnum().getData() != null) {
            titleTextList.add(myParamObj.getPjmdocnum().getData());
        }
        if (keyList.contains("EDIMSGNUM") && myParamObj.getEdimsgnum().getData() != null) {
            titleTextList.add(myParamObj.getEdimsgnum().toString());
        }
        if (keyList.contains("EDILOGNUM") && myParamObj.getEdilognum().getData() != null) {
            titleTextList.add(myParamObj.getEdilognum().toString());
        }
        if (keyList.contains("OPRCATNUM") && myParamObj.getOprcatnum().getData() != null) {
            titleTextList.add(myParamObj.getOprcatnum().toString());
        }
        return titleTextList;
    }

    public static void fillParamObj(SysParam sysParam, SysParam para) {
        try {
            sysParam.setCompany(para.getCompany());
            sysParam.setDockey(para.getDockey());
            sysParam.setDocnum(para.getDocnum());
            sysParam.setDocitem(para.getDocitem());
            sysParam.setDocobj(para.getDocobj());
            sysParam.setDoctype(para.getDoctype());
            sysParam.setDoctypefrom(para.getDoctypefrom());
            sysParam.setDoctypeuntil(para.getDoctypeuntil());
            sysParam.setCustomer(para.getCustomer());
            sysParam.setVendor(para.getVendor());
            sysParam.setFinacc(para.getFinacc());
            sysParam.setSaldept(para.getSaldept());
            sysParam.setPurdept(para.getPurdept());
            sysParam.setBusarea(para.getBusarea());
            sysParam.setMrpgrp(para.getMrpgrp());
            sysParam.setMrpdept(para.getMrpdept());
            sysParam.setDocdate(para.getDocdate());
            sysParam.setLangu(para.getLangu());
            sysParam.setCurrency(para.getCurrency());
            sysParam.setInvdockey(para.getInvdockey());
            sysParam.setInvdocnum(para.getInvdocnum());
            sysParam.setInvdocitem(para.getInvdocitem());
            sysParam.setInvdocobj(para.getInvdocobj());
            sysParam.setInvadjdockey(para.getInvadjdockey());
            sysParam.setInvadjdocnum(para.getInvadjdocnum());
            sysParam.setWrh(para.getWrh());
            sysParam.setWrharea(para.getWrharea());
            sysParam.setStkplc(para.getStkplc());
            sysParam.setWrhiss(para.getWrhiss());
            sysParam.setWrhrec(para.getWrhrec());
            sysParam.setWrhList(para.getWrhList());
            sysParam.setBatchnum(para.getBatchnum());
            sysParam.setSrlnum(para.getSrlnum());
            sysParam.setPckref(para.getPckref());
            sysParam.setMatnum(para.getMatnum());
            sysParam.setMatgrp(para.getMatgrp());
            sysParam.setMatobj(para.getMatobj());
            sysParam.setPrddockey(para.getPrddockey());
            sysParam.setPrddocnum(para.getPrddocnum());
            sysParam.setPrddocitem(para.getPrddocitem());
            sysParam.setPrddocobj(para.getPrddocobj());
            sysParam.setConfnum(para.getConfnum());
            sysParam.setConfitem(para.getConfitem());
            sysParam.setRoudockey(para.getRoudockey());
            sysParam.setRoudocnum(para.getRoudocnum());
            sysParam.setRoudocitem(para.getRoudocitem());
            sysParam.setRoudocobj(para.getRoudocobj());
            sysParam.setResource(para.getResource());
            sysParam.setOprcatnum(para.getOprcatnum());
            sysParam.setBomdockey(para.getBomdockey());
            sysParam.setBomdocnum(para.getBomdocnum());
            sysParam.setBomdocitem(para.getBomdocitem());
            sysParam.setBomdocobj(para.getBomdocobj());
            sysParam.setEdilognum(para.getEdilognum());
            sysParam.setEdimsgnum(para.getEdimsgnum());
            sysParam.setCaldockey(para.getCaldockey());
            sysParam.setCaldocnum(para.getCaldocnum());
            sysParam.setCaldocobj(para.getCaldocobj());
            sysParam.setQltdockey(para.getQltdockey());
            sysParam.setQltdocnum(para.getQltdocnum());
            sysParam.setQltdocobj(para.getQltdocobj());
            sysParam.setPjmdockey(para.getPjmdockey());
            sysParam.setPjmdocnum(para.getPjmdocnum());
            sysParam.setPjmdocobj(para.getPjmdocobj());
            sysParam.setMrpdockey(para.getMrpdockey());
            sysParam.setMrpdocnum(para.getMrpdocnum());
            sysParam.setMrpdocobj(para.getMrpdocobj());
            sysParam.setPricelist(para.getPricelist());
            sysParam.setEdilognum(para.getEdilognum());
            sysParam.setEdimsgnum(para.getEdimsgnum());
            sysParam.setDmstisdockey(para.getDmstisdockey());
            sysParam.setDmstisdocnum(para.getDmstisdocnum());
            sysParam.setTisdocobj(para.getTisdocobj());
            sysParam.setItem(para.getItem());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static Key fillNewKey(Map<String, Object> values) {
        Key syncKey = new Key();
        values.entrySet().forEach(entry -> syncKey.addKeyValue(((String)entry.getKey()).toString(), entry.getValue().toString()));
        return syncKey;
    }

    public static Key fillNewKey(SysParam para) {
        Key syncKey = new Key();
        syncKey.addKeyValue("COMPANY", para.getCompany().toString());
        syncKey.addKeyValue("DOCTYPE", para.getDoctype().toString());
        syncKey.addKeyValue("DOCKEY", para.getDockey().toString());
        syncKey.addKeyValue("DOCNUM", para.getDocnum().toString());
        syncKey.addKeyValue("DOCITEM", para.getDocitem().toString());
        syncKey.addKeyValue("DOCDATE", para.getDocdate().toString());
        syncKey.addKeyValue("CUSTOMER", para.getCustomer().toString());
        syncKey.addKeyValue("VENDOR", para.getVendor().toString());
        syncKey.addKeyValue("SALDEPT", para.getSaldept().toString());
        syncKey.addKeyValue("PURDEPT", para.getPurdept().toString());
        syncKey.addKeyValue("BUSAREA", para.getBusarea().toString());
        syncKey.addKeyValue("MRPGRP", para.getMrpgrp().toString());
        syncKey.addKeyValue("MRPDEPT", para.getMrpdept().toString());
        syncKey.addKeyValue("FINACC", para.getFinacc().toString());
        syncKey.addKeyValue("INVDOCKEY", para.getInvdockey().toString());
        syncKey.addKeyValue("INVDOCNUM", para.getInvdocnum().toString());
        syncKey.addKeyValue("INVDOCITEM", para.getInvdocitem().toString());
        syncKey.addKeyValue("INVADJDOCKEY", para.getInvadjdockey().toString());
        syncKey.addKeyValue("INVADJDOCNUM", para.getInvadjdocnum().toString());
        syncKey.addKeyValue("WRH", para.getWrh().toString());
        syncKey.addKeyValue("WRHAREA", para.getWrharea().toString());
        syncKey.addKeyValue("STKPLC", para.getStkplc().toString());
        syncKey.addKeyValue("BATCHNUM", para.getBatchnum().toString());
        syncKey.addKeyValue("SRLNUM", para.getSrlnum().toString());
        syncKey.addKeyValue("PCKREF", para.getPckref().toString());
        syncKey.addKeyValue("MATNUM", para.getMatnum().toString());
        syncKey.addKeyValue("MATGRP", para.getMatgrp().toString());
        syncKey.addKeyValue("MATOBJ", para.getMatobj().toString());
        syncKey.addKeyValue("PRDDOCKEY", para.getPrddockey().toString());
        syncKey.addKeyValue("PRDDOCNUM", para.getPrddocnum().toString());
        syncKey.addKeyValue("PRDDOCITEM", para.getPrddocitem().toString());
        syncKey.addKeyValue("CONFNUM", para.getConfnum().toString());
        syncKey.addKeyValue("CONFITEM", para.getConfitem().toString());
        syncKey.addKeyValue("ROUDOCKEY", para.getRoudockey().toString());
        syncKey.addKeyValue("ROUDOCNUM", para.getRoudocnum().toString());
        syncKey.addKeyValue("ROUDOCITEM", para.getRoudocitem().toString());
        syncKey.addKeyValue("RESOURCE", para.getResource().toString());
        syncKey.addKeyValue("OPRCATNUM", para.getOprcatnum().toString());
        syncKey.addKeyValue("BOMDOCKEY", para.getBomdockey().toString());
        syncKey.addKeyValue("BOMDOCNUM", para.getBomdocnum().toString());
        syncKey.addKeyValue("BOMDOCITEM", para.getBomdocitem().toString());
        syncKey.addKeyValue("EDILOGNUM", para.getEdilognum().toString());
        syncKey.addKeyValue("EDIMSGNUM", para.getEdimsgnum().toString());
        syncKey.addKeyValue("CALDOCKEY", para.getCaldockey().toString());
        syncKey.addKeyValue("CALDOCNUM", para.getCaldocnum().toString());
        syncKey.addKeyValue("QLTDOCKEY", para.getQltdockey().toString());
        syncKey.addKeyValue("QLTDOCNUM", para.getQltdocnum().toString());
        syncKey.addKeyValue("PJMDOCKEY", para.getPjmdockey().toString());
        syncKey.addKeyValue("PJMDOCNUM", para.getPjmdocnum().toString());
        syncKey.addKeyValue("MRPDOCKEY", para.getMrpdockey().toString());
        syncKey.addKeyValue("MRPDOCNUM", para.getMrpdocnum().toString());
        syncKey.addKeyValue("PRICELIST", para.getPricelist().toString());
        syncKey.addKeyValue("EDILOGNUM", para.getEdilognum().toString());
        syncKey.addKeyValue("EDIMSGNUM", para.getEdimsgnum().toString());
        syncKey.addKeyValue("DMSTISDOCKEY", para.getDmstisdockey().toString());
        syncKey.addKeyValue("DMSTISDOCNUM", para.getDmstisdocnum().toString());
        syncKey.addKeyValue("ITEM", para.getItem().toString());
        return syncKey;
    }

    public static String getOptionText(Class<? extends OptionObject> optClass, int optValue) {
        Map tmpList = OptionObject.getValues(optClass);
        Object translatedTitle = "ERROR in option-translation (" + optClass.getSimpleName() + ")";
        if (tmpList.containsValue(optValue)) {
            String testString = tmpList.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), optValue)).map(Map.Entry::getKey).findFirst().get();
            String keyString = "OPT_" + optClass.getSimpleName().toUpperCase() + "_" + testString.toUpperCase();
            translatedTitle = Translator.tr((String)keyString);
        }
        return translatedTitle;
    }

    public static void setSysParamContextKey(SysParam sysParam, String elementIdent, String tableIdent, String tableColName, BusinessObject selectedTableObject, String tabIdent) {
        if (tableIdent != null) {
            try {
                sysParam.setMatnum((EFCMatNum)ObjectUtil2.getAttributeByDomainName((String)"altmatnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setMatnum((EFCMatNum)ObjectUtil2.getAttributeByDomainName((String)"submatnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!tableColName.equals("altmatnum") && !tableColName.equals("submatnum")) {
                    sysParam.setMatnum((EFCMatNum)ObjectUtil2.getAttributeByDomainName((String)"matnum", (Object)selectedTableObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setMatgrp((EFCString)ObjectUtil2.getAttributeByDomainName((String)"matgrp", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setCustomer((EFCBupNum)ObjectUtil2.getAttributeByDomainName((String)"customer", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setVendor((EFCBupNum)ObjectUtil2.getAttributeByDomainName((String)"vendor", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"saldept", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setSaldept((EFCString)ObjectUtil2.getAttributeByDomainName((String)"saldept", (Object)selectedTableObject));
                } else {
                    sysParam.setSaldept((EFCString)ObjectUtil2.getAttributeByDomainName((String)"saldept.saldept", (Object)selectedTableObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"purdept", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setPurdept((EFCString)ObjectUtil2.getAttributeByDomainName((String)"purdept", (Object)selectedTableObject));
                } else {
                    sysParam.setPurdept((EFCString)ObjectUtil2.getAttributeByDomainName((String)"purdept.purdept", (Object)selectedTableObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"mpdept", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setPurdept((EFCString)ObjectUtil2.getAttributeByDomainName((String)"mrpdept", (Object)selectedTableObject));
                } else {
                    sysParam.setPurdept((EFCString)ObjectUtil2.getAttributeByDomainName((String)"mrpdept.mrpdept", (Object)selectedTableObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"wrh", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setWrh((EFCString)ObjectUtil2.getAttributeByDomainName((String)"wrh", (Object)selectedTableObject));
                } else {
                    sysParam.setWrh((EFCString)ObjectUtil2.getAttributeByDomainName((String)"wrh.wrh", (Object)selectedTableObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"wrharea", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setWrharea((EFCString)ObjectUtil2.getAttributeByDomainName((String)"wrharea", (Object)selectedTableObject));
                } else {
                    sysParam.setWrharea((EFCString)ObjectUtil2.getAttributeByDomainName((String)"wrharea.wrharea", (Object)selectedTableObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"stkplc", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setStkplc((EFCString)ObjectUtil2.getAttributeByDomainName((String)"stkplc", (Object)selectedTableObject));
                } else {
                    sysParam.setStkplc((EFCString)ObjectUtil2.getAttributeByDomainName((String)"stkplc.stkplc", (Object)selectedTableObject));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setBatchnum((EFCString)ObjectUtil2.getAttributeByDomainName((String)"batchnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setSrlnum((EFCString)ObjectUtil2.getAttributeByDomainName((String)"srlnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setInvstkref((EFCAutoNum)ObjectUtil2.getAttributeByDomainName((String)"invstkref", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setPckref((EFCAutoNum)ObjectUtil2.getAttributeByDomainName((String)"pckref", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setDocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"refdocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"refdockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setDockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refdockey", (Object)selectedTableObject));
                } else {
                    sysParam.setDockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refdockey.dockey", (Object)selectedTableObject));
                }
                sysParam.setDocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"refdocnum", (Object)selectedTableObject));
                sysParam.setDocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"refdocitem", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setDocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"docobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"dockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setDockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"dockey", (Object)selectedTableObject));
                } else {
                    sysParam.setDockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"dockey.dockey", (Object)selectedTableObject));
                }
                sysParam.setDocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"docnum", (Object)selectedTableObject));
                sysParam.setDocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"docitem", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setInvdocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"invdocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"invdockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setInvdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"invdockey", (Object)selectedTableObject));
                } else {
                    sysParam.setInvdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"invdockey.invdockey", (Object)selectedTableObject));
                }
                sysParam.setInvdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"invdocnum", (Object)selectedTableObject));
                sysParam.setInvdocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"invdocitem", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"invadjdockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setInvadjdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"invadjdockey", (Object)selectedTableObject));
                } else {
                    sysParam.setInvadjdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"invadjdockey.invadjdockey", (Object)selectedTableObject));
                }
                sysParam.setInvadjdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"invadjdocnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setPrddocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"prddocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"refprddockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setPrddockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refprddockey", (Object)selectedTableObject));
                } else {
                    sysParam.setPrddockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refprddockey.prddockey", (Object)selectedTableObject));
                }
                sysParam.setPrddocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"refprddocnum", (Object)selectedTableObject));
                sysParam.setPrddocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"refprddocitem", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sysParam != null && (sysParam.getPrddockey() == null || sysParam.getPrddockey().getData() == null || sysParam.getPrddockey().getData().isEmpty())) {
                try {
                    if (ObjectUtil2.getAttributeByDomainName((String)"prddockey", (Object)selectedTableObject) instanceof EFCString) {
                        sysParam.setPrddockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"prddockey", (Object)selectedTableObject));
                    } else {
                        sysParam.setPrddockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"prddockey.prddockey", (Object)selectedTableObject));
                    }
                    sysParam.setPrddocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"prddocnum", (Object)selectedTableObject));
                    sysParam.setPrddocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"prddocitem", (Object)selectedTableObject));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                sysParam.setConfnum((EFCAutoNum)ObjectUtil2.getAttributeByDomainName((String)"confnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setConfitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"confitem", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"bombasedockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setBomdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"bombasedockey", (Object)selectedTableObject));
                } else {
                    sysParam.setBomdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"bombasedockey.bomdockey", (Object)selectedTableObject));
                }
                sysParam.setBomdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"bombasedocnum", (Object)selectedTableObject));
                sysParam.setBomdocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"bombasedocitem", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sysParam != null && (sysParam.getBomdockey() == null || sysParam.getBomdockey().getData() == null || sysParam.getBomdockey().getData().isEmpty())) {
                try {
                    if (ObjectUtil2.getAttributeByDomainName((String)"bomsubdockey", (Object)selectedTableObject) instanceof EFCString) {
                        sysParam.setBomdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"bomsubdockey", (Object)selectedTableObject));
                    } else {
                        sysParam.setBomdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"bomsubdockey.bomdockey", (Object)selectedTableObject));
                    }
                    sysParam.setBomdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"bomsubdocnum", (Object)selectedTableObject));
                    sysParam.setBomdocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"bomsubdocitem", (Object)selectedTableObject));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (sysParam != null && (sysParam.getBomdockey() == null || sysParam.getBomdockey().getData() == null || sysParam.getBomdockey().getData().isEmpty())) {
                try {
                    if (ObjectUtil2.getAttributeByDomainName((String)"bomdockey", (Object)selectedTableObject) instanceof EFCString) {
                        sysParam.setBomdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"bomdockey", (Object)selectedTableObject));
                    } else {
                        sysParam.setBomdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"bomdockey.bomdockey", (Object)selectedTableObject));
                    }
                    sysParam.setBomdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"bomdocnum", (Object)selectedTableObject));
                    sysParam.setBomdocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"bomdocitem", (Object)selectedTableObject));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"roubasedockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setRoudockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"roubasedockey", (Object)selectedTableObject));
                } else {
                    sysParam.setRoudockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"roubasedockey.roudockey", (Object)selectedTableObject));
                }
                sysParam.setRoudocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"roubasedocnum", (Object)selectedTableObject));
                sysParam.setRoudocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"roubasedocitem", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sysParam != null && (sysParam.getRoudockey() == null || sysParam.getRoudockey().getData() == null || sysParam.getRoudockey().getData().isEmpty())) {
                try {
                    if (ObjectUtil2.getAttributeByDomainName((String)"roudockey", (Object)selectedTableObject) instanceof EFCString) {
                        sysParam.setRoudockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"roudockey", (Object)selectedTableObject));
                    } else {
                        sysParam.setRoudockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"roudockey.roudockey", (Object)selectedTableObject));
                    }
                    sysParam.setRoudocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"roudocnum", (Object)selectedTableObject));
                    sysParam.setRoudocitem((EFCDocItem)ObjectUtil2.getAttributeByDomainName((String)"roudocitem", (Object)selectedTableObject));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                sysParam.setOprcatnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"oprcatnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setResource((EFCString)ObjectUtil2.getAttributeByDomainName((String)"resource", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"caldockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setCaldockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"caldockey", (Object)selectedTableObject));
                } else {
                    sysParam.setCaldockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"caldockey.caldockey", (Object)selectedTableObject));
                }
                sysParam.setCaldocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"caldocnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setCaldocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"caldocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"refcaldockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setCaldockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refcaldockey", (Object)selectedTableObject));
                } else {
                    sysParam.setCaldockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refcaldockey.caldockey", (Object)selectedTableObject));
                }
                sysParam.setCaldocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"refcaldocnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setCaldocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"refcaldocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"qltdockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setQltdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"qltdockey", (Object)selectedTableObject));
                } else {
                    sysParam.setQltdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"qltdockey.qltdockey", (Object)selectedTableObject));
                }
                sysParam.setQltdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"qltdocnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setQltdocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"qltdocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"pjmdockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setPjmdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"pjmdockey", (Object)selectedTableObject));
                } else {
                    sysParam.setPjmdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"pjmdockey.pjmdockey", (Object)selectedTableObject));
                }
                sysParam.setPjmdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"pjmdocnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setPjmdocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"pjmdocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"mrpdockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setMrpdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"mrpdockey", (Object)selectedTableObject));
                } else {
                    sysParam.setMrpdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"mrpdockey.mrpdockey", (Object)selectedTableObject));
                }
                sysParam.setMrpdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"mrpdocnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setMrpdocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"mrpdocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ObjectUtil2.getAttributeByDomainName((String)"refmrpdockey", (Object)selectedTableObject) instanceof EFCString) {
                    sysParam.setMrpdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refmrpdockey", (Object)selectedTableObject));
                } else {
                    sysParam.setMrpdockey((EFCDocKey)ObjectUtil2.getAttributeByDomainName((String)"refmrpdockey.mrpdockey", (Object)selectedTableObject));
                }
                sysParam.setMrpdocnum((EFCDocNum)ObjectUtil2.getAttributeByDomainName((String)"refmrpdocnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setMrpdocobj((EFCObjectId)ObjectUtil2.getAttributeByDomainName((String)"refmrpdocobj", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setPricelist((EFCString)ObjectUtil2.getAttributeByDomainName((String)"pricelist", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setEdilognum((EFCAutoNum)ObjectUtil2.getAttributeByDomainName((String)"edilognum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setEdimsgnum((EFCAutoNum)ObjectUtil2.getAttributeByDomainName((String)"edimsgnum", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sysParam.setItem((EFCInteger)ObjectUtil2.getAttributeByDomainName((String)"item", (Object)selectedTableObject));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Boolean handleSubFrameAction(EFCBaseFrame parent, SysParam sysParam, String ident, Object param) {
        Boolean ret = true;
        switch (ident) {
            case "info_customer": {
                if (sysParam == null || sysParam.getCustomer() == null || sysParam.getCustomer().toString() == null || sysParam.getCustomer().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_CUSTOMER_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.bup.FrBupCus");
                break;
            }
            case "info_vendor": {
                if (sysParam == null || sysParam.getVendor() == null || sysParam.getVendor().toString() == null || sysParam.getVendor().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_VENDOR_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.bup.FrBupVen");
                break;
            }
            case "info_mat": {
                if (sysParam == null || sysParam.getMatnum() == null || sysParam.getMatnum().getData() == null || sysParam.getMatnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MATERIAL_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.mat.FrBoMat");
                break;
            }
            case "info_stock": {
                if (sysParam == null || sysParam.getMatnum() == null || sysParam.getMatnum().getData() == null || sysParam.getMatnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_INVENTORYKEY_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("subframes.inv.SfSoInvStkMat");
                break;
            }
            case "info_mrp": {
                if (sysParam == null || sysParam.getMatnum() == null || sysParam.getMatnum().getData() == null || sysParam.getMatnum().getData().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MATERIAL_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("subframes.mrp.SfBoMrpBasic");
                break;
            }
            case "info_doc": {
                if (sysParam == null || sysParam.getDockey() == null || sysParam.getDockey().getData() == null || sysParam.getDockey().toString().isEmpty() || sysParam.getDocnum() == null || sysParam.getDocnum().getData() == null || sysParam.getDocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_DOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.doc.FrBoDoc");
                break;
            }
            case "info_prddoc": {
                if (sysParam == null || sysParam.getPrddockey() == null || sysParam.getPrddockey().getData() == null || sysParam.getPrddockey().toString().isEmpty() || sysParam.getPrddocnum() == null || sysParam.getPrddocnum().getData() == null || sysParam.getPrddocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PRDDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.prd.FrBoPrdDoc");
                break;
            }
            case "info_pjmdoc": {
                if (sysParam == null || sysParam.getPjmdockey() == null || sysParam.getPjmdockey().toString() == null || sysParam.getPjmdockey().toString().isEmpty() || sysParam.getPjmdocnum() == null || sysParam.getPjmdocnum().getData() == null || sysParam.getPjmdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PJMDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.pjm.FrBoPjmDoc");
                break;
            }
            case "info_mrpdoc": {
                if (sysParam == null || sysParam.getMrpdockey() == null || sysParam.getMrpdockey().getData() == null || sysParam.getMrpdockey().toString().isEmpty() || sysParam.getMrpdocnum() == null || sysParam.getMrpdocnum().getData() == null || sysParam.getMrpdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MRPDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.mrp.FrBoMrpDoc");
                break;
            }
            case "info_qltdoc": {
                if (sysParam == null || sysParam.getQltdockey() == null || sysParam.getQltdockey().getData() == null || sysParam.getQltdockey().toString().isEmpty() || sysParam.getQltdocnum() == null || sysParam.getQltdocnum().getData() == null || sysParam.getQltdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_QLTDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.qlt.FrBoQltDoc");
                break;
            }
            case "info_bomdoc": {
                if (sysParam == null || sysParam.getBomdockey() == null || sysParam.getBomdockey().getData() == null || sysParam.getBomdockey().toString().isEmpty() || sysParam.getBomdocnum() == null || sysParam.getBomdocnum().getData() == null || sysParam.getBomdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_BOMDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.bom.FrBoBomDoc");
                break;
            }
            case "info_roudoc": {
                if (sysParam == null || sysParam.getRoudockey() == null || sysParam.getRoudockey().getData() == null || sysParam.getRoudockey().toString().isEmpty() || sysParam.getRoudocnum() == null || sysParam.getRoudocnum().getData() == null || sysParam.getRoudocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROUDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.rou.FrBoRouDoc");
                break;
            }
            case "info_roures": {
                if (sysParam == null || sysParam.getResource() == null || sysParam.getResource().getData() == null || sysParam.getResource().toString().isEmpty() || sysParam.getResource() == null || sysParam.getResource().getData() == null || sysParam.getResource().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROURES_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.rou.FrMdRouRes");
                break;
            }
            case "info_prdconf": {
                if (sysParam == null || sysParam.getConfnum() == null || sysParam.getConfnum().getData() == null) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PRDCONF_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                if (sysParam == null || sysParam.getConfitem() == null || sysParam.getConfitem().getData() == null) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PRDCONFITEM_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.prd.FrBoPrdConf");
                break;
            }
            case "info_invdoc": {
                if (sysParam == null || sysParam.getInvdockey() == null || sysParam.getInvdockey().getData() == null || sysParam.getInvdockey().toString().isEmpty() || sysParam.getInvdocnum() == null || sysParam.getInvdocnum().getData() == null || sysParam.getInvdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_INVDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.inv.FrBoInvDoc");
                break;
            }
            case "info_invadjdoc": {
                if (sysParam == null || sysParam.getInvadjdockey() == null || sysParam.getInvadjdockey().getData() == null || sysParam.getInvadjdockey().toString().isEmpty() || sysParam.getInvadjdocnum() == null || sysParam.getInvadjdocnum().getData() == null || sysParam.getInvadjdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_INVADJDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindow("forms.inv.FrBoInvAdjDoc");
                break;
            }
            case "goto_mat": {
                if (sysParam == null || sysParam.getMatnum() == null || sysParam.getMatnum().getData() == null || sysParam.getMatnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MATERIAL_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.mat.FrBoMat");
                break;
            }
            case "gotoedit_mat": {
                if (sysParam == null || sysParam.getMatnum() == null || sysParam.getMatnum().getData() == null || sysParam.getMatnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MATERIAL_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.mat.FrBoMat");
                break;
            }
            case "goto_cus": {
                if (sysParam == null || sysParam.getCustomer() == null || sysParam.getCustomer().getData() == null || sysParam.getCustomer().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_CUSTOMER_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.bup.FrBupCus");
                break;
            }
            case "gotoedit_cus": {
                if (sysParam == null || sysParam.getCustomer() == null || sysParam.getCustomer().getData() == null || sysParam.getCustomer().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_CUSTOMER_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.bup.FrBupCus");
                break;
            }
            case "goto_ven": {
                if (sysParam == null || sysParam.getVendor() == null || sysParam.getVendor().getData() == null || sysParam.getVendor().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_VENDOR_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.bup.FrBupVen");
                break;
            }
            case "gotoedit_ven": {
                if (sysParam == null || sysParam.getVendor() == null || sysParam.getVendor().getData() == null || sysParam.getVendor().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_VENDOR_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.bup.FrBupVen");
                break;
            }
            case "goto_doc": {
                if (sysParam == null || sysParam.getDockey() == null || sysParam.getDockey().getData() == null || sysParam.getDockey().toString().isEmpty() || sysParam.getDocnum() == null || sysParam.getDocnum().getData() == null || sysParam.getDocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_DOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.doc.FrBoDoc");
                break;
            }
            case "gotoedit_doc": {
                if (sysParam == null || sysParam.getDockey() == null || sysParam.getDockey().getData() == null || sysParam.getDockey().toString().isEmpty() || sysParam.getDocnum() == null || sysParam.getDocnum().getData() == null || sysParam.getDocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_DOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.doc.FrBoDoc");
                break;
            }
            case "goto_prddoc": {
                if (sysParam == null || sysParam.getPrddockey() == null || sysParam.getPrddockey().getData() == null || sysParam.getPrddockey().toString().isEmpty() || sysParam.getPrddocnum() == null || sysParam.getPrddocnum().getData() == null || sysParam.getPrddocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PRDDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.prd.FrBoPrdDoc");
                break;
            }
            case "gotoedit_prddoc": {
                if (sysParam == null || sysParam.getPrddockey() == null || sysParam.getPrddockey().getData() == null || sysParam.getPrddockey().toString().isEmpty() || sysParam.getPrddocnum() == null || sysParam.getPrddocnum().getData() == null || sysParam.getPrddocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PRDDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.prd.FrBoPrdDoc");
                break;
            }
            case "goto_prdnet": {
                if (sysParam == null || (sysParam.getPrddockey() == null || sysParam.getPrddockey().getData() == null || sysParam.getPrddockey().toString().isEmpty() || sysParam.getPrddocnum() == null || sysParam.getPrddocnum().getData() == null || sysParam.getPrddocnum().toString().isEmpty()) && (sysParam.getDockey() == null || sysParam.getDockey().getData() == null || sysParam.getDockey().toString().isEmpty() || sysParam.getDocnum() == null || sysParam.getDocnum().getData() == null || sysParam.getDocnum().toString().isEmpty() || sysParam.getDocitem() == null || sysParam.getDocitem().getData() == null || sysParam.getDocitem().toString().isEmpty())) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_DOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.prd.FrBoPrdNet");
                break;
            }
            case "gotoedit_prdnet": {
                if (sysParam == null || (sysParam.getPrddockey() == null || sysParam.getPrddockey().getData() == null || sysParam.getPrddockey().toString().isEmpty() || sysParam.getPrddocnum() == null || sysParam.getPrddocnum().getData() == null || sysParam.getPrddocnum().toString().isEmpty()) && (sysParam.getDockey() == null || sysParam.getDockey().getData() == null || sysParam.getDockey().toString().isEmpty() || sysParam.getDocnum() == null || sysParam.getDocnum().getData() == null || sysParam.getDocnum().toString().isEmpty() || sysParam.getDocitem() == null || sysParam.getDocitem().getData() == null || sysParam.getDocitem().toString().isEmpty())) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_DOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.prd.FrBoPrdNet");
                break;
            }
            case "goto_prdconf": {
                if (sysParam == null || sysParam.getConfnum() == null || sysParam.getConfnum().getData() == null || sysParam.getConfnum().toString().isEmpty() || sysParam.getConfitem() == null || sysParam.getConfitem().getData() == null || sysParam.getConfitem().getData() == 0) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PRDCONF_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.prd.FrBoPrdConf");
                break;
            }
            case "goto_pjmdoc": {
                if (sysParam == null || sysParam.getPjmdockey() == null || sysParam.getPjmdockey().getData() == null || sysParam.getPjmdockey().toString().isEmpty() || sysParam.getPjmdocnum() == null || sysParam.getPjmdocnum().getData() == null || sysParam.getPjmdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PJMDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.pjm.FrBoPjmDoc");
                break;
            }
            case "goto_mrpdoc": {
                if (sysParam == null || sysParam.getMrpdockey() == null || sysParam.getMrpdockey().getData() == null || sysParam.getMrpdockey().toString().isEmpty() || sysParam.getMrpdocnum() == null || sysParam.getMrpdocnum().getData() == null || sysParam.getMrpdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MRPDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.mrp.FrBoMrpDoc");
                break;
            }
            case "goto_qltdoc": {
                if (sysParam == null || sysParam.getQltdockey() == null || sysParam.getQltdockey().getData() == null || sysParam.getQltdockey().toString().isEmpty() || sysParam.getQltdocnum() == null || sysParam.getQltdocnum().getData() == null || sysParam.getQltdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_QLTDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.qlt.FrBoQltDoc");
                break;
            }
            case "goto_bomdoc": {
                if (sysParam == null || sysParam.getBomdockey() == null || sysParam.getBomdockey().getData() == null || sysParam.getBomdockey().toString().isEmpty() || sysParam.getBomdocnum() == null || sysParam.getBomdocnum().getData() == null || sysParam.getBomdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_BOMDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.bom.FrBoBomDoc");
                break;
            }
            case "gotoedit_bomdoc": {
                if (sysParam == null || sysParam.getBomdockey() == null || sysParam.getBomdockey().getData() == null || sysParam.getBomdockey().toString().isEmpty() || sysParam.getBomdocnum() == null || sysParam.getBomdocnum().getData() == null || sysParam.getBomdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_BOMDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.bom.FrBoBomDoc");
                break;
            }
            case "goto_roudoc": {
                if (sysParam == null || sysParam.getRoudockey() == null || sysParam.getRoudockey().getData() == null || sysParam.getRoudockey().toString().isEmpty() || sysParam.getRoudocnum() == null || sysParam.getRoudocnum().getData() == null || sysParam.getRoudocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROUDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.rou.FrBoRouDoc");
                break;
            }
            case "gotoedit_roudoc": {
                if (sysParam == null || sysParam.getRoudockey() == null || sysParam.getRoudockey().getData() == null || sysParam.getRoudockey().toString().isEmpty() || sysParam.getRoudocnum() == null || sysParam.getRoudocnum().getData() == null || sysParam.getRoudocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROUDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.rou.FrBoRouDoc");
                break;
            }
            case "goto_roures": {
                if (sysParam == null || sysParam.getResource() == null || sysParam.getResource().getData() == null || sysParam.getResource().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROURES_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.rou.FrMdRouRes");
                break;
            }
            case "gotoedit_roures": {
                if (sysParam == null || sysParam.getResource() == null || sysParam.getResource().getData() == null || sysParam.getResource().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROURES_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openChildWindowForEdit("forms.rou.FrMdRouRes");
                break;
            }
            case "goto_invadjdoc": {
                if (sysParam == null || sysParam.getInvadjdockey() == null || sysParam.getInvadjdockey().getData() == null || sysParam.getInvadjdockey().toString().isEmpty() || sysParam.getInvadjdocnum() == null || sysParam.getInvadjdocnum().getData() == null || sysParam.getInvadjdocnum().toString().isEmpty()) {
                    parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_INVADJDOC_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
                    break;
                }
                parent.openWindow("forms.inv.FrBoInvAdjDoc");
            }
        }
        if (EFCAdditionalActionInfo.INFO_INVPCKREF.getIdent().equals(ident)) {
            parent.openChildWindow("forms.sst.FrSoInvPckRef");
        } else if (EFCAdditionalActionInfo.INFO_INVSRLNUM.getIdent().equals(ident)) {
            parent.openChildWindow("forms.sst.FrSoInvSrlNum");
        } else if (EFCAdditionalActionInfo.INFO_INVBATCHNUM.getIdent().equals(ident)) {
            parent.openChildWindow("forms.sst.FrSoInvBatchNum");
        } else if (EFCAdditionalActionInfo.LIST_INVSTK.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvStk");
        } else if (EFCAdditionalActionInfo.LIST_INVSTK_NEGATIVE.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvStkNeg");
        } else if (EFCAdditionalActionInfo.LIST_INVSTK_PCKREF.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvStkForPckref");
        } else if (EFCAdditionalActionInfo.LIST_INVSTK_VALUE.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getWrh() == null || sysParam.getWrh().getData() == null || sysParam.getWrh().toString().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_WRH_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSoInvStkValue");
        } else if (EFCAdditionalActionInfo.LIST_INVSTK_STKPLCFORMAT.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getMatnum() == null || sysParam.getMatnum().getData() == null || sysParam.getMatnum().toString().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MATERIAL_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSdListInvStkPlcForMat");
        } else if (EFCAdditionalActionInfo.LIST_INVSTK_STKRESFORMAT.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getMatnum() == null || sysParam.getMatnum().getData() == null || sysParam.getMatnum().toString().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_MATERIAL_SELECTED"), Translator.tr((String)"MSG_FRAME_DLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSdListInvStkResForMat");
        } else if (EFCAdditionalActionInfo.LIST_INVDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvDoc");
        } else if (EFCAdditionalActionInfo.LIST_INVADJDOCITEM.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvAdjDocItem");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvDocItem");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_STKPLC.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getWrh() == null || sysParam.getWrh().getData() == null || sysParam.getWrh().getData().isEmpty() || sysParam.getStkplc() == null || sysParam.getStkplc().getData() == null || sysParam.getStkplc().getData().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_WRH_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemForStkplc");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemTop");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_TOP_STKPLC.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getWrh() == null || sysParam.getWrh().getData() == null || sysParam.getWrh().getData().isEmpty() || sysParam.getStkplc() == null || sysParam.getStkplc().getData() == null || sysParam.getStkplc().getData().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_WRH_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemTopForStkplc");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHACT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemDateRangeMonthAct");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHACT_STKPLC.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getWrh() == null || sysParam.getWrh().getData() == null || sysParam.getWrh().getData().isEmpty() || sysParam.getStkplc() == null || sysParam.getStkplc().getData() == null || sysParam.getStkplc().getData().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_WRH_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemDateRangeMonthActForStkplc");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHPRE.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemDateRangeMonthPre");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_MONTHPRE_STKPLC.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getWrh() == null || sysParam.getWrh().getData() == null || sysParam.getWrh().getData().isEmpty() || sysParam.getStkplc() == null || sysParam.getStkplc().getData() == null || sysParam.getStkplc().getData().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_WRH_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemDateRangeMonthPreForStkplc");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_WEEKSACT4.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemDateRangeWeeksAct4");
        } else if (EFCAdditionalActionInfo.LIST_INVDOCITEM_WEEKSACT4_STKPLC.getIdent().equals(ident)) {
            if (sysParam == null || sysParam.getWrh() == null || sysParam.getWrh().getData() == null || sysParam.getWrh().getData().isEmpty() || sysParam.getStkplc() == null || sysParam.getStkplc().getData() == null || sysParam.getStkplc().getData().isEmpty()) {
                parent.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_WRH_SELECTED"), Translator.tr((String)"MSG_FRAME_INFODLG_NOT_STARTABLE_TITLE"));
            }
            parent.openChildWindow("subframes.inv.SfSdListInvDocItemDateRangeWeeksAct4ForStkplc");
        } else if (EFCAdditionalActionInfo.LIST_INVCDNJHR.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.invcdn.SfSdListInvCdnJhr");
        } else if (EFCAdditionalActionInfo.LIST_MRPBASIC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mrp.SfSdListMrpBasic");
        } else if (EFCAdditionalActionInfo.LIST_MRPBASIC_PURIN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mrp.SfSdListMrpBasicPurIn");
        } else if (EFCAdditionalActionInfo.LIST_MRPBASIC_SALOUT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mrp.SfSdListMrpBasicSalOut");
        } else if (EFCAdditionalActionInfo.LIST_MRPMATAVAIL_PRDDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mrp.SfSoMrpMatAvailForPrdDoc");
        } else if (EFCAdditionalActionInfo.LIST_MRPMATAVAIL_PRDNET.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mrp.SfSoMrpMatAvailForPrdNet");
        } else if (EFCAdditionalActionInfo.LIST_MRPMATAVAIL_DOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mrp.SfSoMrpMatAvailForDoc");
        } else if (EFCAdditionalActionInfo.LIST_BOMDOCITEM_WULFORMAT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.bom.SfSdListBomDocItemWulForMat");
        } else if (EFCAdditionalActionInfo.LIST_BOMDOCITEM_WULFORMATEXPL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.bom.SfSdListBomDocItemWulForMatExpl");
        } else if (EFCAdditionalActionInfo.LIST_BOMDOCITEM_WULFORSUBBOM.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.bom.SfSdListBomDocItemWulForSubBom");
        } else if (EFCAdditionalActionInfo.LIST_BOMDOCITEM_EXPLOSION.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.bom.SfSdListBomDocItemExpl");
        } else if (EFCAdditionalActionInfo.LIST_BOMDOC_WULFORBASEBOM.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.bom.SfSdListBomDocWulForBaseBom");
        } else if (EFCAdditionalActionInfo.LIST_ROUDOC_WULFORBASEROU.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.rou.SfSdListRouDocWulForBaseRou");
        } else if (EFCAdditionalActionInfo.LIST_ROURES_WUL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.rou.SfSdListRouResWul");
        } else if (EFCAdditionalActionInfo.LIST_ROUOPR_WUL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.rou.SfSdListRouOprWul");
        } else if (EFCAdditionalActionInfo.LIST_MATPRC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mat.SfSdListMatPrc");
        } else if (EFCAdditionalActionInfo.LIST_MATPRCACT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mat.SfSdListMatPrcAct");
        } else if (EFCAdditionalActionInfo.LIST_MATBUP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mat.SfSdListMatBup");
        } else if (EFCAdditionalActionInfo.LIST_MATBUPACT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.mat.SfSdListMatBupAct");
        } else if (EFCAdditionalActionInfo.LIST_DOCINTERNAL_COO.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocIntOrdCoo");
        } else if (EFCAdditionalActionInfo.LIST_DOCINTERNAL_COO_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocIntOrdCooOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCINTERNAL_COO_COMPLETED.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocIntOrdCooCompleted");
        } else if (EFCAdditionalActionInfo.LIST_DOCDIV_FWD_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocDivFwdTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCDIV_FWD_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocDivFwdOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCDIV_FWD.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocDivFwd");
        } else if (EFCAdditionalActionInfo.LIST_DOCDIV_LONGTERMDEC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocDivLongTermDec");
        } else if (EFCAdditionalActionInfo.LIST_DOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDoc");
        } else if (EFCAdditionalActionInfo.LIST_DOC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSAL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSal");
        } else if (EFCAdditionalActionInfo.LIST_DOCSAL_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALINVTRN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalInvTrnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALINQ.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalInq");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALINQ_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalInqOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALOFF.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalOff");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALOFF_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalOffOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALDLC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalDlc");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALDLC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalDlcOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALCTT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalCtt");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALCTT_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalCttOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALORD.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalOrd");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALORD_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalOrdOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALDLN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalDln");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALDLN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalDlnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALDLN_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalDlnTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALIVC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalIvc");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALIVC_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalIvcTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALIVC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalIvcOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALCPL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalCpl");
        } else if (EFCAdditionalActionInfo.LIST_DOCSALCPL_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocSalCplOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPUR.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPur");
        } else if (EFCAdditionalActionInfo.LIST_DOCPUR_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURINVTRN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurInvTrnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURINQ.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurInq");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURINQ_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurInqOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPUROFF.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurOff");
        } else if (EFCAdditionalActionInfo.LIST_DOCPUROFF_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurOffOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURDLC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurDlc");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURDLC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurDlcOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURCTT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurCtt");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURCTT_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurCttOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURORD.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurOrd");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURORD_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurOrdOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURDLN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurDln");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURDLN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurDlnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURDLN_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurDlnTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURIVC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurIvc");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURIVC_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurIvcTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURIVC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurIvcOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURCPL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurCpl");
        } else if (EFCAdditionalActionInfo.LIST_DOCPURCPL_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocPurCplOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEM.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItem");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEM_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemIntOrdCoo");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemIntOrdCooOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO_DEFICIT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemIntOrdCooDeficit");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMINTERNAL_COO_COMPLETED.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemIntOrdCooCompleted");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMDIV_LONGTERMDEC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemDivLongTermDec");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSAL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSal");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSAL_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALINVTRN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalInvTrnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALINQ.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalInq");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALINQ_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalInqOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALOFF.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalOff");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALOFF_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalOffOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALCTT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalCtt");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALCTT_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalCttOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALORD.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalOrd");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALORD_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalOrdOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALDLN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalDln");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALDLN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalDlnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALDLN_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalDlnTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALIVC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalIvc");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALIVC_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalIvcTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALIVC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalIvcOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALCPL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalCpl");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMSALCPL_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemSalCplOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPUR.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPur");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPUR_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURINVTRN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurInvTrnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURINQ.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurInq");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURINQ_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurInqOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPUROFF.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurOff");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPUROFF_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurOffOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURCTT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurCtt");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURCTT_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurCttOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURORD.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurOrd");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURORD_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurOrdOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURDLN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurDln");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURDLN_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurDlnOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURDLN_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurDlnTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURIVC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurIvc");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURIVC_TOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurIvcTop");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURIVC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurIvcOpen");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURCPL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurCpl");
        } else if (EFCAdditionalActionInfo.LIST_DOCITEMPURCPL_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.doc.SfSdListDocItemPurCplOpen");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDoc");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCCPLDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocCplDoc");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCERRCOL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocErrCollect");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCINSPCERT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocInspCert");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCRELEASEDRAW.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocReleaseDraw");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCRELEASEMAT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocReleaseMat");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCRELEASESAMPLE.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocReleaseSample");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCRELEASESPECIAL.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocReleaseSpecial");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCRELEASEPRDLOT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocReleasePrdLot");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCREPORT8D.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocReport8D");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCTESTDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocTestDoc");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCTESTINST.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocTestInst");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCTESTORD.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocTestOrder");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCVENRATINGBAT.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocVenRatingBatch");
        } else if (EFCAdditionalActionInfo.LIST_QLTDOCVENRATINGDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.qlt.SfSdListQltDocVenRatingDoc");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDoc");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOC_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocOpen");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOC_WULFORBOMDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocWulForBomDoc");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOC_OPEN_WULFORBOMDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocOpenWulForBomDoc");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOC_WULFORROUDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocWulForRouDoc");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOC_OPEN_WULFORROUDOC.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocOpenWulForRouDoc");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOCITEM.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocItem");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOCITEM_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocItemOpen");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOCOPR.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocOpr");
        } else if (EFCAdditionalActionInfo.LIST_PRDDOCOPR_OPEN.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdDocOprOpen");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONF.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConf");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONFTOP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConfTop");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONF_WITHQTY.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConfWithConfQty");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONFTOP_WITHQTY.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConfWithConfQtyTop");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONF_WITHSCRAP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConfWithConfScrap");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONFTOP_WITHSCRAP.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConfWithConfScrapTop");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONF_WITHTIME.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConfWithConfTime");
        } else if (EFCAdditionalActionInfo.LIST_PRDCONFTOP_WITHTIME.getIdent().equals(ident)) {
            parent.openChildWindow("subframes.prd.SfSdListPrdConfWithConfTimeTop");
        } else {
            ret = false;
        }
        return ret;
    }

    public static void setTableCellFontBold(JTable tab, List<TableCellIdent> cells) {
        EFCBoCellComponent cell;
        JPanel panel;
        Component comp;
        TableCellRenderer renderer;
        for (int rowCount = 0; rowCount < tab.getRowCount(); ++rowCount) {
            for (int columnCount = 0; columnCount < tab.getColumnCount(); ++columnCount) {
                renderer = tab.getCellRenderer(rowCount, columnCount);
                comp = renderer.getTableCellRendererComponent(tab, null, false, false, rowCount, columnCount);
                if (!(comp instanceof EFCBoCellComponent) || (panel = (cell = (EFCBoCellComponent)comp).getBoCellComponent()) == null) continue;
                for (Component component : panel.getComponents()) {
                    if (!(component instanceof EFCAbstractPrimaryEditor) || ((EFCAbstractPrimaryEditor)component).getInfotextComponent().getFont().getStyle() != 1) continue;
                    ((EFCAbstractPrimaryEditor)component).getInfotextComponent().setFont(((EFCAbstractPrimaryEditor)component).getInfotextComponent().getFont().deriveFont(0, ((EFCAbstractPrimaryEditor)component).getInfotextComponent().getFont().getSize2D() - 2.0f));
                }
            }
        }
        if (!cells.isEmpty()) {
            for (TableCellIdent item : cells) {
                renderer = tab.getCellRenderer(item.row, item.col);
                comp = renderer.getTableCellRendererComponent(tab, null, false, false, item.row, item.col);
                if (!(comp instanceof EFCBoCellComponent) || (panel = (cell = (EFCBoCellComponent)comp).getBoCellComponent()) == null) continue;
                for (Component component : panel.getComponents()) {
                    if (!(component instanceof EFCAbstractPrimaryEditor)) continue;
                    ((EFCAbstractPrimaryEditor)component).getInfotextComponent().setFont(((EFCAbstractPrimaryEditor)component).getInfotextComponent().getFont().deriveFont(1, ((EFCAbstractPrimaryEditor)component).getInfotextComponent().getFont().getSize2D() + 2.0f));
                }
            }
        }
    }

    public static class TableCellIdent {
        private int row;
        private int col;

        public TableCellIdent(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }
    }
}

