/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatalFallbackErrorHandler
extends DelegateAsyncProcessor
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FatalFallbackErrorHandler.class);
    private boolean deadLetterChannel;

    public FatalFallbackErrorHandler(Processor processor) {
        this(processor, false);
    }

    public FatalFallbackErrorHandler(Processor processor, boolean isDeadLetterChannel) {
        super(processor);
        this.deadLetterChannel = isDeadLetterChannel;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final String id = (String)ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class);
        ArrayDeque<String> fatals = (ArrayDeque<String>)exchange.getProperty(ExchangePropertyKey.FATAL_FALLBACK_ERROR_HANDLER, Deque.class);
        if (fatals == null) {
            fatals = new ArrayDeque<String>();
            exchange.setProperty(ExchangePropertyKey.FATAL_FALLBACK_ERROR_HANDLER, fatals);
        }
        if (fatals.contains(id)) {
            LOG.warn("Circular error-handler detected at route: {} - breaking out processing Exchange: {}", (Object)id, (Object)exchange);
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setErrorHandlerHandled(Boolean.valueOf(false));
            exchange.setProperty(ExchangePropertyKey.ERRORHANDLER_CIRCUIT_DETECTED, (Object)true);
            callback.done(true);
            return true;
        }
        fatals.push(id);
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(boolean doneSync) {
                try {
                    if (exchange.getException() != null) {
                        Throwable previous = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
                        if (previous != null && previous == exchange.getException()) {
                            previous = null;
                            if (exchange.getException().getSuppressed().length > 0) {
                                previous = exchange.getException().getSuppressed()[0];
                            }
                        }
                        String msg = "Exception occurred while trying to handle previously thrown exception on exchangeId: " + exchange.getExchangeId() + " using: [" + FatalFallbackErrorHandler.this.processor + "].";
                        if (previous != null) {
                            msg = msg + " The previous and the new exception will be logged in the following.";
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> Previous exception on exchangeId: " + exchange.getExchangeId(), previous);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                        } else {
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                        }
                        if (previous != null) {
                            Throwable[] suppressed = exchange.getException().getSuppressed();
                            boolean found = false;
                            for (Throwable t : suppressed) {
                                if (t != previous) continue;
                                found = true;
                            }
                            if (!found) {
                                exchange.getException().addSuppressed(previous);
                            }
                        }
                        exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)exchange.getException());
                        if (FatalFallbackErrorHandler.this.deadLetterChannel) {
                            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setErrorHandlerHandled(null);
                        } else {
                            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setErrorHandlerHandled(Boolean.valueOf(false));
                        }
                    }
                }
                finally {
                    Deque fatals = (Deque)exchange.getProperty(ExchangePropertyKey.FATAL_FALLBACK_ERROR_HANDLER, Deque.class);
                    if (fatals != null) {
                        fatals.removeLastOccurrence(id);
                    }
                    callback.done(doneSync);
                }
            }
        });
        return sync;
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable t) {
        if (this.deadLetterChannel) {
            if (t != null) {
                LOG.warn(message, t);
            } else {
                LOG.warn(message);
            }
        } else if (t != null) {
            LOG.error(message, t);
        } else {
            LOG.error(message);
        }
    }

    public String toString() {
        return "FatalFallbackErrorHandler[" + this.processor + "]";
    }
}

