/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout.responsivepane;

import java.util.List;
import java.util.TreeMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Window;
import jfxtras.scene.layout.responsivepane.Device;
import jfxtras.scene.layout.responsivepane.Diagonal;
import jfxtras.scene.layout.responsivepane.Layout;
import jfxtras.scene.layout.responsivepane.Orientation;
import jfxtras.scene.layout.responsivepane.Size;
import jfxtras.scene.layout.responsivepane.Stylesheet;

public class ResponsivePane
extends StackPane {
    private final SimpleObjectProperty<Boolean> debugProperty = new SimpleObjectProperty((Object)this, "debug", (Object)Boolean.FALSE);
    private final SimpleObjectProperty<Boolean> traceProperty = new SimpleObjectProperty((Object)this, "trace", (Object)Boolean.FALSE);
    private final ObservableList<Node> reusableNodes = FXCollections.observableArrayList();
    private final ObservableList<Layout> layouts = FXCollections.observableArrayList();
    private final SimpleObjectProperty<Layout> activeLayoutProperty = new SimpleObjectProperty((Object)this, "activeLayout", null);
    private final ObservableList<Stylesheet> sceneStylesheets = FXCollections.observableArrayList();
    private final SimpleObjectProperty<Stylesheet> activeSceneStylesheetProperty = new SimpleObjectProperty((Object)this, "activeSceneStylesheet", null);
    private final ObservableList<Stylesheet> myStylesheets = FXCollections.observableArrayList();
    private final SimpleObjectProperty<Stylesheet> activeMyStylesheetProperty = new SimpleObjectProperty((Object)this, "activeMyStylesheet", null);
    final ObservableMap<String, Size> deviceSizes = FXCollections.observableMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
    Double ppi;
    public static final String PPI_SYSTEM_PROPERTY = ResponsivePane.class.getSimpleName() + ".ppi";
    private final Layout SINGULARITY_LAYOUT = new Layout(Size.ZERO, (Node)new Label("?"));
    private final Stylesheet SINGULAR_STYLESHEET = new Stylesheet(Size.ZERO, null);

    public ResponsivePane() {
        this.SINGULARITY_LAYOUT.getRoot().setId("ResponsivePane.emptyLayout");
        this.setDeviceSize(Device.PHONE, (Size)Diagonal.inch(3.5));
        this.setDeviceSize(Device.TABLET, (Size)Diagonal.inch(7.0));
        this.setDeviceSize(Device.DESKTOP, (Size)Diagonal.inch(13.0));
        this.layouts.addListener(c -> {
            if (this.getTrace().booleanValue()) {
                System.out.println(">>> requestLayout from changes in layouts, size=" + this.layouts.size());
            }
            this.requestLayout();
        });
        this.sceneStylesheets.addListener(c -> {
            if (this.getTrace().booleanValue()) {
                System.out.println(">>> requestLayout from changes in scene stylesheets, size=" + this.sceneStylesheets.size());
            }
            this.requestLayout();
        });
        this.myStylesheets.addListener(c -> {
            if (this.getTrace().booleanValue()) {
                System.out.println(">>> requestLayout from changes in my stylesheets, size=" + this.myStylesheets.size());
            }
            this.requestLayout();
        });
    }

    public ResponsivePane withId(String v) {
        this.setId(v);
        return this;
    }

    public ObjectProperty<Boolean> debugProperty() {
        return this.debugProperty;
    }

    public Boolean getDebug() {
        return (Boolean)this.debugProperty.getValue();
    }

    public void setDebug(Boolean value) {
        this.debugProperty.setValue((Object)value);
    }

    public ResponsivePane withDebug(Boolean value) {
        this.setDebug(value);
        return this;
    }

    public ObjectProperty<Boolean> traceProperty() {
        return this.traceProperty;
    }

    public Boolean getTrace() {
        return (Boolean)this.traceProperty.getValue();
    }

    public void setTrace(Boolean value) {
        this.traceProperty.setValue((Object)value);
    }

    public ResponsivePane withTrace(Boolean value) {
        this.setTrace(value);
        return this;
    }

    public ObservableList<Node> getReusableNodes() {
        return this.reusableNodes;
    }

    public Node addReusableNode(String id, Node node) {
        node.setId(id);
        this.getReusableNodes().add((Object)node);
        return node;
    }

    public Node addReusableNode(Node node) {
        if (node.getId() == null || node.getId().trim().length() == 0) {
            throw new IllegalArgumentException("A reusable node must have an id");
        }
        this.getReusableNodes().add((Object)node);
        return node;
    }

    Node findResuableNode(String refId) {
        for (Node lNode : this.reusableNodes) {
            if (!refId.equals(lNode.getId())) continue;
            return lNode;
        }
        System.err.println("Could not find reference " + refId);
        return null;
    }

    public ObservableList<Layout> getLayouts() {
        return this.layouts;
    }

    public void addLayout(Device device, Node root) {
        this.addLayout(device.toString(), root);
    }

    public void addLayout(String device, Node root) {
        this.addLayout((Size)this.deviceSizes.get((Object)device), root);
    }

    public void addLayout(Size sizeAtLeast, Node root) {
        this.layouts.add((Object)new Layout(sizeAtLeast, root));
    }

    public void addLayout(Device device, Orientation orientation, Node root) {
        this.addLayout(device.toString(), orientation, root);
    }

    public void addLayout(String device, Orientation orientation, Node root) {
        this.addLayout((Size)this.deviceSizes.get((Object)device), orientation, root);
    }

    public void addLayout(Size sizeAtLeast, Orientation orientation, Node root) {
        this.layouts.add((Object)new Layout(sizeAtLeast, orientation, root));
    }

    public ObjectProperty<Layout> activeLayoutProperty() {
        return this.activeLayoutProperty;
    }

    public Layout getActiveLayout() {
        return (Layout)this.activeLayoutProperty.getValue();
    }

    public void setActiveLayout(Layout value) {
        this.activeLayoutProperty.setValue((Object)value);
    }

    public ResponsivePane withActiveLayout(Layout value) {
        this.setActiveLayout(value);
        return this;
    }

    public ObservableList<Stylesheet> getSceneStylesheets() {
        return this.sceneStylesheets;
    }

    public void addSceneStylesheet(Device device, String file) {
        this.addSceneStylesheet(device.toString(), file);
    }

    public void addSceneStylesheet(String device, String file) {
        this.addSceneStylesheet((Size)this.deviceSizes.get((Object)device), file);
    }

    public void addSceneStylesheet(Size sizeAtLeast, String file) {
        this.sceneStylesheets.add((Object)new Stylesheet(sizeAtLeast, file));
    }

    public ObjectProperty<Stylesheet> activeSceneStylesheetProperty() {
        return this.activeSceneStylesheetProperty;
    }

    public Stylesheet getActiveSceneStylesheet() {
        return (Stylesheet)this.activeSceneStylesheetProperty.getValue();
    }

    public void setActiveSceneStylesheet(Stylesheet value) {
        this.activeSceneStylesheetProperty.setValue((Object)value);
    }

    public ResponsivePane withActiveSceneStylesheet(Stylesheet value) {
        this.setActiveSceneStylesheet(value);
        return this;
    }

    public ObservableList<Stylesheet> getMyStylesheets() {
        return this.myStylesheets;
    }

    public void addMyStylesheet(Device device, String file) {
        this.addMyStylesheet(device.toString(), file);
    }

    public void addMyStylesheet(String device, String file) {
        this.addMyStylesheet((Size)this.deviceSizes.get((Object)device), file);
    }

    public void addMyStylesheet(Size sizeAtLeast, String file) {
        this.myStylesheets.add((Object)new Stylesheet(sizeAtLeast, file));
    }

    public ObjectProperty<Stylesheet> activeMyStylesheetProperty() {
        return this.activeMyStylesheetProperty;
    }

    public Stylesheet getActiveMyStylesheet() {
        return (Stylesheet)this.activeMyStylesheetProperty.getValue();
    }

    public void setActiveMyStylesheet(Stylesheet value) {
        this.activeMyStylesheetProperty.setValue((Object)value);
    }

    public ResponsivePane withActiveMyStylesheet(Stylesheet value) {
        this.setActiveMyStylesheet(value);
        return this;
    }

    public final ObservableMap<String, Size> getDeviceSizes() {
        return this.deviceSizes;
    }

    public void setDeviceSize(Device device, Size size) {
        this.setDeviceSize(device.toString(), size);
    }

    public void setDeviceSize(String device, Size size) {
        this.deviceSizes.put((Object)device, (Object)size);
    }

    public Size getDeviceSize(Device device) {
        return this.getDeviceSize(device.toString());
    }

    public Size getDeviceSize(String device) {
        return (Size)this.deviceSizes.get((Object)device);
    }

    protected void layoutChildren() {
        this.setupLayout();
        super.layoutChildren();
    }

    void setupLayout() {
        Stylesheet lStylesheet;
        Layout lLayout;
        this.ppi = null;
        if (this.getTrace().booleanValue()) {
            System.out.println("====================================================");
        }
        if (!(lLayout = this.determineBestFittingLayout()).equals(this.getActiveLayout())) {
            if (this.getDebug().booleanValue() || this.getTrace().booleanValue()) {
                System.out.println("Activating layout " + lLayout);
            }
            this.setActiveLayout(lLayout);
            this.getChildren().clear();
            this.getChildren().add((Object)lLayout.getRoot());
        }
        if (this.getTrace().booleanValue()) {
            System.out.println("----------------------------------------------------");
        }
        if (!(lStylesheet = this.determineBestFittingStylesheet((List<Stylesheet>)this.sceneStylesheets)).equals(this.getActiveSceneStylesheet())) {
            this.setActiveSceneStylesheet(lStylesheet);
            this.load(lStylesheet, (List<Stylesheet>)this.sceneStylesheets, (List<String>)this.getScene().getStylesheets());
        }
        if (this.getTrace().booleanValue()) {
            System.out.println("----------------------------------------------------");
        }
        if (!(lStylesheet = this.determineBestFittingStylesheet((List<Stylesheet>)this.myStylesheets)).equals(this.getActiveMyStylesheet())) {
            this.setActiveMyStylesheet(lStylesheet);
            this.load(lStylesheet, (List<Stylesheet>)this.myStylesheets, (List<String>)this.getStylesheets());
        }
        if (this.getTrace().booleanValue()) {
            System.out.println("====================================================");
        }
    }

    double determinePPI() {
        if (this.ppi != null) {
            return this.ppi;
        }
        if (System.getProperties().containsKey(PPI_SYSTEM_PROPERTY)) {
            this.ppi = Double.valueOf(System.getProperty(PPI_SYSTEM_PROPERTY));
            if (this.getTrace().booleanValue()) {
                System.out.println("Using command line " + PPI_SYSTEM_PROPERTY + "=" + this.ppi);
            }
            return this.ppi;
        }
        this.ppi = 100.0;
        Window window = this.getScene().getWindow();
        ObservableList screensForRectangle = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)window.getWidth(), (double)window.getHeight());
        if (screensForRectangle.size() > 0) {
            Screen lScreen = (Screen)screensForRectangle.get(0);
            this.ppi = lScreen.getDpi();
            if (this.getTrace().booleanValue()) {
                System.out.println("screens of scene: " + screensForRectangle + ", using the first then PPI=" + this.ppi);
            }
        }
        return this.ppi;
    }

    double determineActualDiagonalInInches() {
        Scene lScene = this.getScene();
        double lPPI = this.determinePPI();
        double lWidthInInches = lScene.getWidth() / lPPI;
        double lHeightInInches = lScene.getHeight() / lPPI;
        double lDiagonalInInches = Math.sqrt(lWidthInInches * lWidthInInches + lHeightInInches * lHeightInInches);
        if (this.getTrace().booleanValue()) {
            System.out.println("Actual scene size=" + lScene.getWidth() + "x" + lScene.getHeight() + "px, scene diagonal in inches=" + lDiagonalInInches + " (ppi=" + lPPI + ")");
        }
        return lDiagonalInInches;
    }

    Layout determineBestFittingLayout() {
        double actualDiagonalInInches = this.determineActualDiagonalInInches();
        Scene lScene = this.getScene();
        Orientation lSceneOrientation = lScene.getWidth() > lScene.getHeight() ? Orientation.LANDSCAPE : Orientation.PORTRAIT;
        Layout lBestFittingLayout = null;
        for (Layout lLayout : this.layouts) {
            double lBestFittingLayoutSizeAtLeast;
            double lLayoutSizeAtLeast;
            if (this.getTrace().booleanValue()) {
                System.out.println("determineBestFittingLayout, examining layout: " + lLayout.describeSizeConstraints());
            }
            if (!(actualDiagonalInInches >= (lLayoutSizeAtLeast = lLayout.getSizeAtLeast().toInches(this)))) continue;
            if (this.getTrace().booleanValue()) {
                System.out.println("determineBestFittingLayout, layout " + lLayout.describeSizeConstraints() + " is candidate based on scene diagonal: " + actualDiagonalInInches + "in");
            }
            double d = lBestFittingLayoutSizeAtLeast = lBestFittingLayout == null ? -1.0 : lBestFittingLayout.getSizeAtLeast().toInches(this);
            if (this.getTrace().booleanValue()) {
                System.out.println("determineBestFittingLayout, comparing best fitting layout " + (lBestFittingLayout == null ? "null" : lBestFittingLayout.describeSizeConstraints()) + " (" + lBestFittingLayoutSizeAtLeast + ") with " + lLayout.describeSizeConstraints() + " (" + lLayoutSizeAtLeast + ")");
            }
            if (lBestFittingLayout != null && !(lBestFittingLayoutSizeAtLeast <= lLayoutSizeAtLeast)) continue;
            if (this.getTrace().booleanValue()) {
                System.out.println("determineBestFittingLayout, layout " + lLayout.describeSizeConstraints() + " is a better or equal candidate based on diagonal vs best fitting so far: " + (lBestFittingLayout == null ? "null" : lBestFittingLayout.describeSizeConstraints()));
            }
            Orientation lBestFittingLayoutOrientation = lBestFittingLayout == null ? null : lBestFittingLayout.getOrientation();
            Orientation lLayoutOrientation = lLayout.getOrientation();
            if (lBestFittingLayout != null && lLayoutOrientation != null && !lSceneOrientation.equals((Object)lLayoutOrientation)) continue;
            if (this.getTrace().booleanValue()) {
                System.out.println("determineBestFittingLayout, layout " + lLayout.describeSizeConstraints() + " is also candidate based on orientation");
            }
            if ((lBestFittingLayoutOrientation != null || lLayoutOrientation != null) && (lBestFittingLayoutOrientation != null || lLayoutOrientation == null)) continue;
            if (this.getTrace().booleanValue()) {
                System.out.println("determineBestFittingLayout, layout " + lLayout.describeSizeConstraints() + " is also a better candidate based on orientation vs best fitting so far: " + (lBestFittingLayout == null ? "null" : lBestFittingLayout.describeSizeConstraints()));
            }
            lBestFittingLayout = lLayout;
            if (!this.getTrace().booleanValue()) continue;
            System.out.println("determineBestFittingLayout, best fitting so far: " + lBestFittingLayout.describeSizeConstraints());
        }
        if (lBestFittingLayout == null) {
            lBestFittingLayout = this.SINGULARITY_LAYOUT;
        }
        if (this.getTrace().booleanValue()) {
            System.out.println("determineBestFittingLayout=" + lBestFittingLayout.describeSizeConstraints());
        }
        return lBestFittingLayout;
    }

    Stylesheet determineBestFittingStylesheet(List<Stylesheet> availableStylesheets) {
        double actualSizeInInches = this.determineActualDiagonalInInches();
        Stylesheet lBestFittingStylesheet = null;
        for (Stylesheet lStylesheet : availableStylesheets) {
            if (!(actualSizeInInches >= lStylesheet.getSizeAtLeast().toInches(this)) || lBestFittingStylesheet != null && !(lBestFittingStylesheet.getSizeAtLeast().toInches(this) < lStylesheet.getSizeAtLeast().toInches(this))) continue;
            lBestFittingStylesheet = lStylesheet;
        }
        if (lBestFittingStylesheet == null) {
            lBestFittingStylesheet = this.SINGULAR_STYLESHEET;
        }
        if (this.getTrace().booleanValue()) {
            System.out.println("determineBestFittingStylesheet=" + lBestFittingStylesheet.describeSizeConstraints() + " -> " + lBestFittingStylesheet.getFile());
        }
        return lBestFittingStylesheet;
    }

    void load(Stylesheet stylesheet, List<Stylesheet> availableStylesheets, List<String> activeStylesheetUrls) {
        String lStylesheetFile = stylesheet.getFile();
        for (Stylesheet lStylesheet : availableStylesheets) {
            String lActiveStylesheetUrl = lStylesheet.getFile();
            if (!activeStylesheetUrls.remove(lActiveStylesheetUrl) || !this.getDebug().booleanValue() && !this.getTrace().booleanValue()) continue;
            System.out.println("Removed stylesheet " + lStylesheet.getSizeAtLeast() + " -> " + lActiveStylesheetUrl);
        }
        if (lStylesheetFile != null) {
            if (this.getDebug().booleanValue() || this.getTrace().booleanValue()) {
                System.out.println("Loading stylesheet " + stylesheet.getSizeAtLeast() + " -> " + lStylesheetFile);
            }
            activeStylesheetUrls.add(lStylesheetFile);
        }
    }
}

