/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout.responsivepane;

import jfxtras.scene.layout.responsivepane.Diagonal;
import jfxtras.scene.layout.responsivepane.ResponsivePane;
import jfxtras.scene.layout.responsivepane.Unit;
import jfxtras.scene.layout.responsivepane.Width;

public abstract class Size {
    public static final Diagonal ZERO = new Diagonal(0.0, Unit.INCH);

    abstract double toInches(ResponsivePane var1);

    public static Size valueOf(String s) {
        if (s.startsWith("w:")) {
            return Width.valueOf(s.substring("w:".length()));
        }
        if (s.startsWith("width:")) {
            return Width.valueOf(s.substring("width:".length()));
        }
        if (Character.isDigit(s.charAt(0))) {
            return Diagonal.valueOf(s);
        }
        return new DeviceSizePlaceHolder(s);
    }

    public static class DeviceSizePlaceHolder
    extends Size {
        final String device;
        Size size;

        DeviceSizePlaceHolder(String device) {
            this.device = device;
        }

        @Override
        double toInches(ResponsivePane responsivePane) {
            this.size = (Size)responsivePane.getDeviceSizes().get((Object)this.device);
            return this.size.toInches(responsivePane);
        }

        public String toString() {
            return this.size == null ? "null" : this.size.toString();
        }
    }
}

