/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.IpAddressable;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.comm.internal.ConnectionAttributeProvider;
import com.zebra.sdk.comm.internal.ConnectionAttributes;
import com.zebra.sdk.comm.snmp.internal.OidNotFoundException;
import com.zebra.sdk.comm.snmp.internal.Snmp;
import com.zebra.sdk.comm.snmp.internal.SnmpTimeoutException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.SnmpException;
import com.zebra.sdk.settings.internal.SettingType;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpPrinter {
    private Connection connection;
    private String getCommunityName;
    private String setCommunityName;

    public SnmpPrinter(String string) throws SnmpException {
        this(string, "public", "public");
    }

    public SnmpPrinter(String string, String string2, String string3) throws SnmpException {
        this.getCommunityName = string2;
        this.setCommunityName = string3;
        try {
            this.init(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SnmpException("Could not resolve DNS name to IP Address.");
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            throw new SnmpException(zebraIllegalArgumentException.getLocalizedMessage());
        }
    }

    protected Connection getConnection(String string) throws UnknownHostException {
        return new TcpConnection(InetAddress.getByName(string).getHostAddress(), 0);
    }

    private void init(String string) throws SnmpException, UnknownHostException, ZebraIllegalArgumentException {
        this.connection = this.getConnection(string);
        this.initConnectionAttributes();
    }

    private void initConnectionAttributes() {
        ConnectionAttributeProvider connectionAttributeProvider = new ConnectionAttributeProvider();
        ConnectionAttributes connectionAttributes = connectionAttributeProvider.getAttributes(this.connection);
        connectionAttributes.snmpGetCommunityName = this.getGetCommunityName();
        connectionAttributes.snmpSetCommunityName = this.getSetCommunityName();
    }

    protected int getDiscoTimeoutInMSec() {
        return 10000;
    }

    protected Snmp getSnmpImpl(String string, String string2, SettingType settingType) {
        return new Snmp(this.getGetCommunityName(), this.getSetCommunityName(), settingType);
    }

    public String getOidValue(String string) throws SnmpException {
        try {
            return this.getSnmpImpl(this.getGetCommunityName(), this.getSetCommunityName(), SettingType.STRING).get(((IpAddressable)((Object)this.connection)).getAddress(), string);
        }
        catch (OidNotFoundException oidNotFoundException) {
            throw new SnmpException("oid " + string + " not found.");
        }
        catch (SnmpTimeoutException snmpTimeoutException) {
            throw new SnmpException("Timed out retrieving " + string);
        }
    }

    public void setOidValue(String string, String string2) throws SnmpException {
        try {
            this.getSnmpImpl(this.getGetCommunityName(), this.getSetCommunityName(), SettingType.STRING).set(((IpAddressable)((Object)this.connection)).getAddress(), string, string2);
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            throw new SnmpException(zebraIllegalArgumentException.getLocalizedMessage());
        }
        catch (OidNotFoundException oidNotFoundException) {
            throw new SnmpException("oid " + string + " not found.");
        }
        catch (SnmpTimeoutException snmpTimeoutException) {
            throw new SnmpException("Timed out setting " + string);
        }
    }

    public void setOidValue(String string, int n) throws SnmpException {
        try {
            String string2 = String.valueOf(n);
            this.getSnmpImpl(this.getGetCommunityName(), this.getSetCommunityName(), SettingType.INTEGER).set(((IpAddressable)((Object)this.connection)).getAddress(), string, string2);
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            throw new SnmpException(zebraIllegalArgumentException.getLocalizedMessage());
        }
        catch (OidNotFoundException oidNotFoundException) {
            throw new SnmpException("oid " + string + " not found.");
        }
        catch (SnmpTimeoutException snmpTimeoutException) {
            throw new SnmpException("Timed out setting " + string);
        }
    }

    public String getGetCommunityName() {
        return this.getCommunityName;
    }

    public String getSetCommunityName() {
        return this.setCommunityName;
    }
}

