/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import java.util.EnumSet;
import java.util.Set;

public enum NetworkProtocol {
    NONE(0, "None"),
    FTP(1, "FTP"),
    LPD(2, "LPD"),
    TCP_RAW(4, "TCP"),
    UDP_RAW(8, "UDP"),
    HTTP(16, "HTTP"),
    SMTP(32, "SMTP"),
    POP3(64, "POP3"),
    SNMP(128, "SNMP"),
    TELNET(256, "Telnet"),
    WEBLINK(512, "Weblink"),
    TLS(1024, "TLS"),
    HTTPS(2048, "HTTPS"),
    MQTTS(4096, "MQTTS"),
    IPV4(8192, "IPV4"),
    IPV6(16384, "IPV6"),
    IPSEC(32768, "IPSEC");

    private final int bitFieldValue;
    private final String networkProtocolString;

    private NetworkProtocol(int n2, String string2) {
        this.bitFieldValue = n2;
        this.networkProtocolString = string2;
    }

    public int bitFieldValue() {
        return this.bitFieldValue;
    }

    public String toString() {
        return this.networkProtocolString;
    }

    public static NetworkProtocol intToEnum(int n) {
        NetworkProtocol[] networkProtocolArray;
        NetworkProtocol networkProtocol = NONE;
        for (NetworkProtocol networkProtocol2 : networkProtocolArray = NetworkProtocol.values()) {
            if (networkProtocol2.bitFieldValue() != n) continue;
            networkProtocol = networkProtocol2;
            break;
        }
        return networkProtocol;
    }

    public static Set<NetworkProtocol> getEnumSetFromBitmask(int n) {
        NetworkProtocol[] networkProtocolArray = NetworkProtocol.values();
        EnumSet<NetworkProtocol> enumSet = EnumSet.noneOf(NetworkProtocol.class);
        for (NetworkProtocol networkProtocol : networkProtocolArray) {
            if ((n & networkProtocol.bitFieldValue()) == 0) continue;
            enumSet.add(networkProtocol);
        }
        return enumSet;
    }
}

