/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.internal.BroadcastA;
import com.zebra.sdk.printer.discovery.internal.ZebraDiscoSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubnetSearch
extends BroadcastA {
    private static final int IP_SEARCH_RANGE_LOW = 0;
    private static final int IP_SEARCH_RANGE_HIGH = 255;
    private static final String EXCEPTION_STRING = "Malformed subnet search address";

    public SubnetSearch(String string) throws DiscoveryException {
        this(string, 6000);
    }

    public SubnetSearch(String string, int n) throws DiscoveryException {
        super(n);
        this.broadcastIpAddresses = SubnetSearch.getAddressesToSearch(string);
    }

    private static InetAddress[] getAddressesToSearch(String string) throws DiscoveryException {
        if (string == null) {
            throw new DiscoveryException(EXCEPTION_STRING);
        }
        Pattern pattern = Pattern.compile("^([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})\\.?((([0-9]{1,3})(\\-([0-9]{1,3}|\\*))?)|\\*)?$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return SubnetSearch.createSearchList(matcher);
        }
        throw new DiscoveryException(EXCEPTION_STRING);
    }

    private static InetAddress[] createSearchList(Matcher matcher) throws DiscoveryException {
        String string = matcher.group(2);
        if (string == null) {
            throw new DiscoveryException(EXCEPTION_STRING);
        }
        int n = 0;
        int n2 = 255;
        if (!string.equals("*") && !SubnetSearch.isRangeValid(n = SubnetSearch.setLowValue(matcher.group(4)), n2 = SubnetSearch.setHighValue(matcher.group(6), n))) {
            throw new DiscoveryException(EXCEPTION_STRING);
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (int i = n; i <= n2; ++i) {
            try {
                arrayList.add(InetAddress.getByName(matcher.group(1) + "." + i));
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                throw new DiscoveryException(EXCEPTION_STRING);
            }
        }
        return arrayList.toArray(new InetAddress[0]);
    }

    private static int setHighValue(String string, int n) {
        int n2 = SubnetSearch.isHighValueIsPresent(string) ? SubnetSearch.setHighValueWhichIsPresent(string) : n;
        return n2;
    }

    private static int setLowValue(String string) throws DiscoveryException {
        if (string == null) {
            throw new DiscoveryException(EXCEPTION_STRING);
        }
        return Integer.valueOf(string);
    }

    private static boolean isHighValueIsPresent(String string) {
        return string != null && string.length() > 0;
    }

    private static int setHighValueWhichIsPresent(String string) {
        int n = string.equals("*") ? 255 : Integer.valueOf(string);
        return n;
    }

    private static boolean isRangeValid(int n, int n2) {
        return n >= 0 && n <= 255 && n2 >= 0 && n2 <= 255 && n <= n2;
    }

    @Override
    protected void setSocketOptions(ZebraDiscoSocket zebraDiscoSocket) throws DiscoveryException {
    }
}

