/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.printer.FieldDescriptionData;
import com.zebra.sdk.printer.internal.UseDefaultMappingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CsvPrinterHelper {
    public static Map<String, String> parseSingleLineFormat(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("(.+)\"(.+)\"");
        for (String string : stringArray) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find() || matcher.groupCount() != 2) continue;
            hashMap.put(matcher.group(2), matcher.group(1));
        }
        return hashMap;
    }

    public static int[] extractFdsByColumnHeading(FieldDescriptionData[] fieldDescriptionDataArray, String[] stringArray, int[] nArray) throws UseDefaultMappingException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], i);
            if (!stringArray[i].toLowerCase().equals("quantity")) continue;
            nArray[0] = i;
        }
        int[] nArray2 = new int[fieldDescriptionDataArray.length];
        for (int i = 0; i < fieldDescriptionDataArray.length; ++i) {
            Integer n = (Integer)hashMap.get(fieldDescriptionDataArray[i].fieldName);
            if (n == null) {
                throw new UseDefaultMappingException("Column headings do not match data...cannot sort.");
            }
            nArray2[i] = n;
        }
        return nArray2;
    }
}

