/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.internal.LinkOsPrinterCreatorSgdOrJson;
import com.zebra.sdk.printer.internal.ZebraPrinterA;
import com.zebra.sdk.printer.internal.ZebraPrinterCpcl;
import com.zebra.sdk.printer.internal.ZebraPrinterZpl;
import com.zebra.sdk.settings.internal.ConnectionUtil;
import com.zebra.sdk.util.internal.CPCLUtilities;
import com.zebra.sdk.util.internal.StringUtilities;

public class ZebraPrinterFactoryHelper {
    private ZebraPrinterFactoryHelper() {
    }

    public static ZebraPrinter getInstance(Connection connection) throws ConnectionException, ZebraPrinterLanguageUnknownException {
        return ZebraPrinterFactoryHelper.getInstance(CPCLUtilities.VERSION_PREFIXES, connection);
    }

    public static ZebraPrinter getInstance(String[] stringArray, Connection connection) throws ConnectionException, ZebraPrinterLanguageUnknownException {
        PrinterLanguage printerLanguage = ZebraPrinterFactoryHelper.getLanguage(connection, stringArray);
        return ZebraPrinterFactoryHelper.getInstance(printerLanguage, connection);
    }

    public static ZebraPrinter getInstance(PrinterLanguage printerLanguage, Connection connection) throws ConnectionException {
        return ZebraPrinterFactoryHelper.getPrinterInstance(connection, printerLanguage);
    }

    private static ZebraPrinter getPrinterInstance(Connection connection, PrinterLanguage printerLanguage) {
        ZebraPrinterA zebraPrinterA = printerLanguage == PrinterLanguage.CPCL || printerLanguage == PrinterLanguage.LINE_PRINT ? new ZebraPrinterCpcl(connection, printerLanguage) : new ZebraPrinterZpl(connection);
        return zebraPrinterA;
    }

    private static PrinterLanguage getLanguage(Connection connection, String[] stringArray) throws ZebraPrinterLanguageUnknownException, ConnectionException {
        PrinterLanguage printerLanguage = PrinterLanguage.ZPL;
        if (!(connection = ConnectionUtil.selectConnection(connection)).isConnected()) {
            throw new ConnectionException("Connection is not open.");
        }
        String string = ZebraPrinterFactoryHelper.getApplNameHocusPocus(connection);
        if (string.length() == 0) {
            throw new ZebraPrinterLanguageUnknownException("");
        }
        if (StringUtilities.doesPrefixExistInArray(stringArray, string)) {
            printerLanguage = PrinterLanguage.CPCL;
        }
        return printerLanguage;
    }

    private static String getApplNameHocusPocus(Connection connection) throws ConnectionException {
        int n = 0;
        String string = "";
        while (string.length() == 0 && n++ < 10) {
            string = SGD.GET("appl.name", connection);
        }
        String string2 = SGD.GET("appl.name", connection);
        return string2.length() > 0 ? string2 : string;
    }

    public static ZebraPrinterLinkOs createLinkOsPrinter(ZebraPrinter zebraPrinter) throws ConnectionException {
        if (zebraPrinter instanceof ZebraPrinterCpcl) {
            return null;
        }
        return new LinkOsPrinterCreatorSgdOrJson(zebraPrinter.getPrinterControlLanguage()).create(zebraPrinter);
    }

    public static ZebraPrinterLinkOs createLinkOsPrinter(ZebraPrinter zebraPrinter, LinkOsInformation linkOsInformation) throws ConnectionException {
        return new LinkOsPrinterCreatorSgdOrJson(linkOsInformation).create(zebraPrinter);
    }

    public static ZebraPrinterLinkOs createLinkOsPrinter(ZebraPrinter zebraPrinter, PrinterLanguage printerLanguage) throws ConnectionException {
        return new LinkOsPrinterCreatorSgdOrJson(printerLanguage).create(zebraPrinter);
    }

    public static ZebraPrinterLinkOs createLinkOsPrinter(ZebraPrinter zebraPrinter, LinkOsInformation linkOsInformation, PrinterLanguage printerLanguage) throws ConnectionException {
        if (zebraPrinter instanceof ZebraPrinterCpcl && zebraPrinter.getPrinterControlLanguage() == PrinterLanguage.CPCL) {
            return null;
        }
        return new LinkOsPrinterCreatorSgdOrJson(linkOsInformation, printerLanguage).create(zebraPrinter);
    }

    public static ZebraPrinterLinkOs getLinkOsPrinter(Connection connection) throws ConnectionException {
        return new LinkOsPrinterCreatorSgdOrJson((PrinterLanguage)null).create(connection);
    }

    public static ZebraPrinterLinkOs getLinkOsPrinter(Connection connection, LinkOsInformation linkOsInformation) throws ConnectionException {
        return new LinkOsPrinterCreatorSgdOrJson(linkOsInformation).create(connection);
    }

    public static ZebraPrinterLinkOs getLinkOsPrinter(Connection connection, PrinterLanguage printerLanguage) throws ConnectionException {
        return new LinkOsPrinterCreatorSgdOrJson(printerLanguage).create(connection);
    }

    public static ZebraPrinterLinkOs getLinkOsPrinter(Connection connection, LinkOsInformation linkOsInformation, PrinterLanguage printerLanguage) throws ConnectionException {
        return new LinkOsPrinterCreatorSgdOrJson(linkOsInformation, printerLanguage).create(connection);
    }
}

