/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.util.fileConversion.internal.PrinterFileType;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.fileConversion.internal.StreamDecoratorBase;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.PrinterFilePath;
import com.zebra.sdk.util.internal.ZCRC16;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MPF_UnwrapperStream
extends StreamDecoratorBase {
    private StringBuffer readAheadBuffer = new StringBuffer();
    private String boundary;
    private boolean readingDataBody = false;
    private String fileName = "UNKNOWN.GRF";
    private long size = 0L;
    private String status;
    private String crc32 = "00000000";
    private long unwrappedFileSize = 0L;
    private char crc16 = '\u0000';
    private char sum = '\u0000';

    public MPF_UnwrapperStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("input stream is null");
        }
        this.sourceStream = inputStream;
    }

    @Override
    public PrinterFileMetadata getPrinterFileMetadata() {
        String string = String.format("%04X", this.crc16);
        String string2 = String.format("%04X", (this.sum ^ 0xFFFF) + 1);
        PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(this.unwrappedFileSize, string, string2, this.fileName, this.size, this.status, this.crc32);
        printerFileMetadata.setPrinterFileType(this.getFileType());
        printerFileMetadata.setPrinterWrappingType(PrinterWrappingType.MPF);
        return printerFileMetadata;
    }

    private PrinterFileType getFileType() {
        PrinterFileType printerFileType = PrinterFileType.UNSUPPORTED;
        try {
            PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(this.fileName);
            printerFileType = PrinterFileType.getUnwrappedType(printerFilePath.getExtension());
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            printerFileType = PrinterFileType.UNSUPPORTED;
        }
        return printerFileType;
    }

    @Override
    public int read() throws IOException {
        int n;
        if (!this.readingDataBody) {
            this.extractBoundary();
            this.extractFileNameFromHeader();
            this.preloadReadAheadBuffer();
            this.readingDataBody = true;
        }
        if ((n = this.getNextCharacter()) != -1) {
            ++this.unwrappedFileSize;
            this.sum = (char)(this.sum + n);
            this.crc16 = ZCRC16.addCrc16Byte_cpcl(this.crc16, n);
        }
        return n;
    }

    private int getNextCharacter() throws IOException {
        int n;
        if (this.readAheadBuffer.length() == 0 || this.readAheadBuffer.toString().equals(this.boundary)) {
            n = -1;
        } else {
            n = this.readAheadBuffer.charAt(0);
            this.readAheadBuffer.deleteCharAt(0);
            int n2 = this.sourceStream.read();
            if (n2 != -1) {
                this.readAheadBuffer.append((char)n2);
                if (this.readAheadBuffer.toString().equals(this.boundary)) {
                    this.readAheadBuffer.delete(0, this.readAheadBuffer.length());
                }
            } else {
                throw new IOException("Malformed Multipart Form Data");
            }
        }
        return n;
    }

    private void extractFileNameFromHeader() throws IOException {
        int n = this.sourceStream.read();
        while (n != -1) {
            this.readAheadBuffer.append((char)n);
            if (this.readAheadBuffer.toString().endsWith("\r\n\r\n")) {
                Pattern pattern = Pattern.compile("\\s+(filename|status|size|crc32)\\s*=\\s*\"([^\"]+)");
                Matcher matcher = pattern.matcher(this.readAheadBuffer.toString());
                while (matcher.find()) {
                    if (matcher.groupCount() != 2) continue;
                    if (matcher.group(1).equalsIgnoreCase("filename")) {
                        this.fileName = matcher.group(2);
                        continue;
                    }
                    if (matcher.group(1).equalsIgnoreCase("status")) {
                        this.status = matcher.group(2);
                        continue;
                    }
                    if (matcher.group(1).equalsIgnoreCase("size")) {
                        this.size = Long.parseLong(matcher.group(2));
                        continue;
                    }
                    if (!matcher.group(1).equalsIgnoreCase("crc32")) continue;
                    this.crc32 = matcher.group(2);
                }
                break;
            }
            n = this.sourceStream.read();
        }
    }

    private void preloadReadAheadBuffer() throws IOException {
        if (this.boundary != null) {
            this.readAheadBuffer.delete(0, this.readAheadBuffer.length());
            while (this.readAheadBuffer.length() != this.boundary.length()) {
                this.readAheadBuffer.append((char)this.sourceStream.read());
            }
        }
    }

    private void extractBoundary() throws IOException {
        int n = this.sourceStream.read();
        while (n != -1) {
            this.readAheadBuffer.append((char)n);
            Pattern pattern = Pattern.compile("^[\\s]*--([^\\s|^-]+)\\r\\n");
            Matcher matcher = pattern.matcher(this.readAheadBuffer.toString());
            if (matcher.find()) {
                this.boundary = String.format("\r\n--%s--\r\n", matcher.group(1));
                this.readAheadBuffer.delete(0, this.readAheadBuffer.length());
                break;
            }
            n = this.sourceStream.read();
        }
    }
}

