/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import com.calendarfx.model.Calendar;
import com.calendarfx.util.LoggingDomain;
import java.util.logging.Level;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class CalendarSource {
    private final StringProperty name = new SimpleStringProperty((Object)this, "name", "Untitled");
    private final ObservableList<Calendar> calendars = FXCollections.observableArrayList();

    public CalendarSource() {
        if (LoggingDomain.MODEL.isLoggable(Level.FINE)) {
            this.getCalendars().addListener(change -> {
                while (change.next()) {
                    if (change.wasAdded()) {
                        for (Calendar calendar : change.getAddedSubList()) {
                            LoggingDomain.MODEL.fine("added calendar " + calendar.getName() + " to source " + this.getName());
                        }
                        continue;
                    }
                    if (!change.wasRemoved()) continue;
                    for (Calendar calendar : change.getRemoved()) {
                        LoggingDomain.MODEL.fine("removed calendar " + calendar.getName() + " from source " + this.getName());
                    }
                }
            });
        }
    }

    public CalendarSource(String name) {
        this();
        this.setName(name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final void setName(String name) {
        LoggingDomain.MODEL.fine("changing name to " + name);
        this.nameProperty().set((Object)name);
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final ObservableList<Calendar> getCalendars() {
        return this.calendars;
    }

    public String toString() {
        return "CalendarSource [name=" + this.getName() + ", calendars=" + this.calendars + "]";
    }
}

