/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.DeveloperConsole;
import com.calendarfx.view.SearchResultView;
import com.calendarfx.view.SourceView;
import com.calendarfx.view.YearMonthView;
import com.calendarfx.view.page.DayPage;
import com.calendarfx.view.page.MonthPage;
import com.calendarfx.view.page.PageBase;
import com.calendarfx.view.page.WeekPage;
import com.calendarfx.view.page.YearPage;
import com.calendarfx.view.print.PrintView;
import impl.com.calendarfx.view.CalendarViewSkin;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.control.textfield.TextFields;

public class CalendarView
extends DateControl {
    private static final String DEFAULT_STYLE_CLASS = "calendar-view";
    private static final String SELECTED_PAGE = "com.calendarfx.selectedPage";
    private final SourceView sourceView;
    private final SearchResultView searchResultView;
    private final YearMonthView yearMonthView;
    private DayPage dayPage;
    private WeekPage weekPage;
    private MonthPage monthPage;
    private YearPage yearPage;
    private DeveloperConsole developerConsole;
    private final CustomTextField searchField;
    private PrintView printView;
    private final ObservableList<Page> availablePages = FXCollections.observableArrayList();
    private final BooleanProperty showDevoloperConsole = new SimpleBooleanProperty((Object)this, "showDevoloperConsole", false);
    private final BooleanProperty showSourceTray = new SimpleBooleanProperty((Object)this, "showSourceTray", false);
    private final BooleanProperty showSearchResultsTray = new SimpleBooleanProperty((Object)this, "showSearchResultsTray", false);
    private final ReadOnlyObjectWrapper<Page> selectedPage = new ReadOnlyObjectWrapper((Object)this, "selectedPage");
    private final ObjectProperty<Node> header = new SimpleObjectProperty((Object)this, "header", null);
    private final ObjectProperty<Node> footer = new SimpleObjectProperty((Object)this, "footer", null);
    private final BooleanProperty traysAnimated = new SimpleBooleanProperty((Object)this, "traysAnimated", true);
    private final BooleanProperty showSearchField = new SimpleBooleanProperty((Object)this, "showSearchField", true);
    private final BooleanProperty showSourceTrayButton = new SimpleBooleanProperty((Object)this, "showSourceTrayButton", true);
    private final BooleanProperty showAddCalendarButton = new SimpleBooleanProperty((Object)this, "showAddCalendarButton", true);
    private final BooleanProperty showPrintButton = new SimpleBooleanProperty((Object)this, "showPrintButton", true);
    private final BooleanProperty showPageToolBarControls = new SimpleBooleanProperty((Object)this, "showPageToolBarControls", true);
    private final BooleanProperty showPageSwitcher = new SimpleBooleanProperty((Object)this, "showPageSwitcher", true);
    private final BooleanProperty showToolBar = new SimpleBooleanProperty((Object)this, "showToolBar", true);
    private final String CALENDAR_VIEW_CATEGORY = "Calendar View";

    public CalendarView() {
        this(Page.values());
    }

    public CalendarView(Page ... availablePages) {
        Objects.requireNonNull(availablePages, "available pages can not be null");
        if (availablePages.length == 0) {
            throw new IllegalArgumentException("no available page passed to constructor");
        }
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.getAvailablePages().setAll((Object[])availablePages);
        this.searchField = (CustomTextField)TextFields.createClearableTextField();
        this.sourceView = new SourceView();
        this.searchResultView = new SearchResultView();
        this.yearMonthView = new YearMonthView();
        if (Boolean.getBoolean("calendarfx.developer")) {
            this.developerConsole = new DeveloperConsole();
            this.developerConsole.setDateControl(this);
        }
        this.selectedPage.set((Object)availablePages[0]);
        Bindings.bindBidirectional((Property)this.searchField.visibleProperty(), (Property)this.showSearchFieldProperty());
        this.getStylesheets().add((Object)CalendarView.class.getResource("calendar.css").toExternalForm());
        this.getProperties().addListener(change -> {
            if (change.getKey().equals(SELECTED_PAGE) && change.getValueAdded() != null) {
                Page page = (Page)((Object)((Object)change.getValueAdded()));
                this.selectedPage.set((Object)page);
                this.getProperties().remove((Object)SELECTED_PAGE);
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new CalendarViewSkin(this);
    }

    public PageBase getPageView(Page page) {
        switch (page) {
            case DAY: {
                return this.getDayPage();
            }
            case WEEK: {
                return this.getWeekPage();
            }
            case MONTH: {
                return this.getMonthPage();
            }
            case YEAR: {
                return this.getYearPage();
            }
        }
        throw new IllegalArgumentException("unknown page: " + page);
    }

    public final ObservableList<Page> getAvailablePages() {
        return this.availablePages;
    }

    public final DeveloperConsole getDeveloperConsole() {
        return this.developerConsole;
    }

    public final DayPage getDayPage() {
        if (this.dayPage == null) {
            this.dayPage = new DayPage();
            this.bind(this.dayPage, true);
        }
        return this.dayPage;
    }

    public final WeekPage getWeekPage() {
        if (this.weekPage == null) {
            this.weekPage = new WeekPage();
            this.bind(this.weekPage, true);
        }
        return this.weekPage;
    }

    public final MonthPage getMonthPage() {
        if (this.monthPage == null) {
            this.monthPage = new MonthPage();
            this.bind(this.monthPage, true);
        }
        return this.monthPage;
    }

    public final YearPage getYearPage() {
        if (this.yearPage == null) {
            this.yearPage = new YearPage();
            this.bind(this.yearPage, true);
        }
        return this.yearPage;
    }

    public final CustomTextField getSearchField() {
        return this.searchField;
    }

    public final SearchResultView getSearchResultView() {
        return this.searchResultView;
    }

    public final SourceView getSourceView() {
        return this.sourceView;
    }

    public final YearMonthView getYearMonthView() {
        return this.yearMonthView;
    }

    public final PrintView getPrintView() {
        if (this.printView == null) {
            this.printView = new PrintView();
        }
        return this.printView;
    }

    public final BooleanProperty showDeveloperConsoleProperty() {
        return this.showDevoloperConsole;
    }

    public final void setShowDeveloperConsole(boolean show) {
        this.showDeveloperConsoleProperty().set(show);
    }

    public final boolean isShowDeveloperConsole() {
        return this.showDeveloperConsoleProperty().get();
    }

    public final BooleanProperty showSourceTrayProperty() {
        return this.showSourceTray;
    }

    public final void setShowSourceTray(boolean show) {
        this.showSourceTray.set(show);
    }

    public final boolean isShowSourceTray() {
        return this.showSourceTray.get();
    }

    public final BooleanProperty showSearchResultsTrayProperty() {
        return this.showSearchResultsTray;
    }

    public final void setShowSearchResultsTray(boolean show) {
        this.showSearchResultsTray.set(show);
    }

    public final boolean isShowSearchResultsTray() {
        return this.showSearchResultsTray.get();
    }

    public final ReadOnlyObjectProperty<Page> selectedPageProperty() {
        return this.selectedPage.getReadOnlyProperty();
    }

    public final Page getSelectedPage() {
        return (Page)((Object)this.selectedPageProperty().get());
    }

    public final PageBase getSelectedPageView() {
        return this.getPageView(this.getSelectedPage());
    }

    public final ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public final Node getHeader() {
        return (Node)this.headerProperty().get();
    }

    public final void setHeader(Node node) {
        this.headerProperty().set((Object)node);
    }

    public final ObjectProperty<Node> footerProperty() {
        return this.footer;
    }

    public final Node getFooter() {
        return (Node)this.footerProperty().get();
    }

    public final void setFooter(Node node) {
        this.footerProperty().set((Object)node);
    }

    public final BooleanProperty traysAnimatedProperty() {
        return this.traysAnimated;
    }

    public final boolean isTraysAnimated() {
        return this.traysAnimatedProperty().get();
    }

    public final void setTraysAnimated(boolean animated) {
        this.traysAnimatedProperty().set(animated);
    }

    public final BooleanProperty showSearchFieldProperty() {
        return this.showSearchField;
    }

    public final boolean isShowSearchField() {
        return this.showSearchField.get();
    }

    public final void setShowSearchField(boolean show) {
        this.showSearchField.set(show);
    }

    public final BooleanProperty showSourceTrayButtonProperty() {
        return this.showSourceTrayButton;
    }

    public final boolean isShowSourceTrayButton() {
        return this.showSourceTrayButton.get();
    }

    public final void setShowSourceTrayButton(boolean show) {
        this.showSourceTrayButton.set(show);
    }

    public final BooleanProperty showAddCalendarButtonProperty() {
        return this.showAddCalendarButton;
    }

    public final boolean isShowAddCalendarButton() {
        return this.showAddCalendarButton.get();
    }

    public final void setShowAddCalendarButton(boolean show) {
        this.showAddCalendarButton.set(show);
    }

    public final BooleanProperty showPrintButtonProperty() {
        return this.showPrintButton;
    }

    public final boolean isShowPrintButton() {
        return this.showPrintButton.get();
    }

    public final void setShowPrintButton(boolean show) {
        this.showPrintButton.set(show);
    }

    public final BooleanProperty showPageToolBarControlsProperty() {
        return this.showPageToolBarControls;
    }

    public final boolean isShowPageToolBarControls() {
        return this.showPageToolBarControls.get();
    }

    public final void setShowPageToolBarControls(boolean show) {
        this.showPageToolBarControls.set(show);
    }

    public final BooleanProperty showPageSwitcherProperty() {
        return this.showPageSwitcher;
    }

    public final boolean isShowPageSwitcher() {
        return this.showPageSwitcher.get();
    }

    public final void setShowPageSwitcher(boolean show) {
        this.showPageSwitcher.set(show);
    }

    public final BooleanProperty showToolBarProperty() {
        return this.showToolBar;
    }

    public final boolean isShowToolBar() {
        return this.showToolBar.get();
    }

    public final void setShowToolBar(boolean show) {
        this.showToolBar.set(show);
    }

    public final void showDayPage() {
        if (!this.getAvailablePages().contains((Object)Page.DAY)) {
            throw new UnsupportedOperationException("calendar does not support day view");
        }
        this.selectedPage.set((Object)Page.DAY);
    }

    public final void showWeekPage() {
        if (!this.getAvailablePages().contains((Object)Page.WEEK)) {
            throw new UnsupportedOperationException("calendar does not support week view");
        }
        this.selectedPage.set((Object)Page.WEEK);
    }

    public final void showMonthPage() {
        if (!this.getAvailablePages().contains((Object)Page.MONTH)) {
            throw new UnsupportedOperationException("calendar does not support month view");
        }
        this.selectedPage.set((Object)Page.MONTH);
    }

    public final void showYearPage() {
        if (!this.getAvailablePages().contains((Object)Page.YEAR)) {
            throw new UnsupportedOperationException("calendar does not support year view");
        }
        this.selectedPage.set((Object)Page.YEAR);
    }

    public final void showDate(LocalDate date) {
        Objects.requireNonNull(date);
        if (this.getAvailablePages().contains((Object)Page.DAY)) {
            this.selectedPage.set((Object)Page.DAY);
        } else if (this.getAvailablePages().contains((Object)Page.WEEK)) {
            this.selectedPage.set((Object)Page.WEEK);
        } else if (this.getAvailablePages().contains((Object)Page.MONTH)) {
            this.selectedPage.set((Object)Page.MONTH);
        } else if (this.getAvailablePages().contains((Object)Page.YEAR)) {
            this.selectedPage.set((Object)Page.YEAR);
        }
        this.setDate(date);
    }

    public final void showWeek(Year year, int weekOfYear) {
        Objects.requireNonNull(year);
        if (weekOfYear < 1) {
            throw new IllegalArgumentException("illegal value for week of year: " + weekOfYear);
        }
        if (this.getAvailablePages().contains((Object)Page.WEEK)) {
            this.selectedPage.set((Object)Page.WEEK);
        } else if (this.getAvailablePages().contains((Object)Page.MONTH)) {
            this.selectedPage.set((Object)Page.MONTH);
        } else if (this.getAvailablePages().contains((Object)Page.YEAR)) {
            this.selectedPage.set((Object)Page.YEAR);
        }
        this.setDate(LocalDate.of(year.getValue(), 1, 1).plusWeeks(weekOfYear));
    }

    public final void showDateTime(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime);
        if (this.getAvailablePages().contains((Object)Page.DAY)) {
            this.selectedPage.set((Object)Page.DAY);
        } else if (this.getAvailablePages().contains((Object)Page.WEEK)) {
            this.selectedPage.set((Object)Page.WEEK);
        } else if (this.getAvailablePages().contains((Object)Page.MONTH)) {
            this.selectedPage.set((Object)Page.MONTH);
        } else if (this.getAvailablePages().contains((Object)Page.YEAR)) {
            this.selectedPage.set((Object)Page.YEAR);
        }
        this.setDate(dateTime.toLocalDate());
        this.setRequestedTime(dateTime.toLocalTime());
    }

    public final void showYearMonth(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth);
        if (this.getAvailablePages().contains((Object)Page.MONTH)) {
            this.selectedPage.set((Object)Page.MONTH);
        } else if (this.getAvailablePages().contains((Object)Page.YEAR)) {
            this.selectedPage.set((Object)Page.YEAR);
        }
        this.setDate(yearMonth.atDay(1));
    }

    public final void showYear(Year year) {
        Objects.requireNonNull(year);
        if (this.getAvailablePages().contains((Object)Page.YEAR)) {
            this.selectedPage.set((Object)Page.YEAR);
            this.setDate(year.atDay(1));
        }
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showSourceTrayProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowSourceTray((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowSourceTray();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Calendar Tray";
            }

            public String getDescription() {
                return "Show or hide the calendar tray on the left";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showSearchResultsTrayProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowSearchResultsTray((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowSearchResultsTray();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Search Results Tray";
            }

            public String getDescription() {
                return "Show or hide the search results tray on the right";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showSearchFieldProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowSearchField((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowSearchField();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Search Field";
            }

            public String getDescription() {
                return "Can the user access the search field or not.";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showSourceTrayButtonProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowSourceTrayButton((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowSourceTrayButton();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Source Tray Button";
            }

            public String getDescription() {
                return "Can the user access the source tray button or not.";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showAddCalendarButtonProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowAddCalendarButton((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowAddCalendarButton();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Add Calendar Button";
            }

            public String getDescription() {
                return "Can the user access the button to add new calendars or not.";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showPrintButtonProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowPrintButton((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowPrintButton();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Print Button";
            }

            public String getDescription() {
                return "Can the user access the button to print calendars or not.";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showPageToolBarControlsProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowPageToolBarControls((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowPageToolBarControls();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Page Controls";
            }

            public String getDescription() {
                return "Can the user access the page-specific toolbar controls or not.";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showPageSwitcherProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowPageSwitcher((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowPageSwitcher();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Page Switcher";
            }

            public String getDescription() {
                return "Visibility of the switcher.";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(CalendarView.this.showToolBarProperty());
            }

            public void setValue(Object value) {
                CalendarView.this.setShowToolBar((Boolean)value);
            }

            public Object getValue() {
                return CalendarView.this.isShowToolBar();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show ToolBar";
            }

            public String getDescription() {
                return "Visibility of the toolbar.";
            }

            public String getCategory() {
                return "Calendar View";
            }
        });
        return items;
    }

    public static enum Page {
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

