/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.Messages;
import com.calendarfx.view.VirtualGrid;
import com.calendarfx.view.WeekDayView;
import com.calendarfx.view.WeekView;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.util.Callback;

public class ContextMenuProvider
implements Callback<DateControl.ContextMenuParameter, ContextMenu> {
    public ContextMenu call(DateControl.ContextMenuParameter param) {
        DateControl control = param.getDateControl();
        ContextMenu contextMenu = null;
        if (control instanceof WeekDayView) {
            contextMenu = this.getWeekDayViewMenu(param);
        } else if (control instanceof DayView) {
            contextMenu = this.getDayViewMenu(param);
        } else if (control instanceof AllDayView) {
            contextMenu = this.getAllDayViewMenu(param);
        }
        if (contextMenu == null || contextMenu.getItems().isEmpty()) {
            return null;
        }
        return contextMenu;
    }

    protected ContextMenu getDayViewMenu(DateControl.ContextMenuParameter param) {
        return this.getDayViewBaseMenu(param);
    }

    protected ContextMenu getWeekDayViewMenu(DateControl.ContextMenuParameter param) {
        int[] days;
        ContextMenu contextMenu = this.getDayViewBaseMenu(param);
        WeekDayView weekDayView = (WeekDayView)param.getDateControl();
        WeekView weekView = weekDayView.getWeekView();
        Menu daysMenu = new Menu(Messages.getString("ContextMenuProvider.SHOW_DAYS"));
        for (int d : days = new int[]{5, 7, 14, 21, 28}) {
            String itemText = MessageFormat.format(Messages.getString("ContextMenuProvider.DAYS"), d);
            MenuItem item = new MenuItem(itemText);
            item.setOnAction(evt -> weekView.setNumberOfDays(d));
            daysMenu.getItems().add((Object)item);
        }
        contextMenu.getItems().add((Object)daysMenu);
        return contextMenu;
    }

    private ContextMenu getDayViewBaseMenu(DateControl.ContextMenuParameter param) {
        ContextMenu contextMenu = new ContextMenu();
        DateControl control = param.getDateControl();
        if (control instanceof DayView) {
            int[] hours;
            int[] grids;
            DayViewBase dayView = (DayViewBase)control;
            MenuItem newEntry = new MenuItem(Messages.getString("ContextMenuProvider.ADD_NEW_EVENT"));
            newEntry.setOnAction(evt -> {
                if (control.getLayout().equals((Object)DateControl.Layout.SWIMLANE)) {
                    Calendar calendar = control.getCalendarAt(param.getContextMenuEvent().getX(), param.getContextMenuEvent().getY()).orElse(null);
                    control.createEntryAt(param.getZonedDateTime(), calendar);
                } else {
                    control.createEntryAt(param.getZonedDateTime());
                }
                contextMenu.hide();
            });
            contextMenu.getItems().add((Object)newEntry);
            if (!dayView.getStartTime().equals(LocalTime.MIN) || !dayView.getEndTime().equals(LocalTime.MAX)) {
                Menu earlyLateHoursMenu = new Menu(Messages.getString("ContextMenuProvider.EARLY_LATE_HOURS"));
                RadioMenuItem hideItem = new RadioMenuItem(Messages.getString("ContextMenuProvider.EARLY_LATE_HOURS_HIDE"));
                RadioMenuItem showItem = new RadioMenuItem(Messages.getString("ContextMenuProvider.EARLY_LATE_HOURS_SHOW"));
                RadioMenuItem radioMenuItem = new RadioMenuItem(Messages.getString("ContextMenuProvider.EARLY_LATE_HOURS_COMPRESSED"));
                hideItem.setOnAction(evt -> dayView.setEarlyLateHoursStrategy(DayViewBase.EarlyLateHoursStrategy.HIDE));
                showItem.setOnAction(evt -> dayView.setEarlyLateHoursStrategy(DayViewBase.EarlyLateHoursStrategy.SHOW));
                radioMenuItem.setOnAction(evt -> dayView.setEarlyLateHoursStrategy(DayViewBase.EarlyLateHoursStrategy.SHOW_COMPRESSED));
                switch (dayView.getEarlyLateHoursStrategy()) {
                    case HIDE: {
                        hideItem.setSelected(true);
                        break;
                    }
                    case SHOW: {
                        showItem.setSelected(true);
                        break;
                    }
                    case SHOW_COMPRESSED: {
                        radioMenuItem.setSelected(true);
                        break;
                    }
                }
                ToggleGroup group = new ToggleGroup();
                group.getToggles().setAll((Object[])new Toggle[]{hideItem, showItem, radioMenuItem});
                earlyLateHoursMenu.getItems().setAll((Object[])new MenuItem[]{hideItem, showItem, radioMenuItem});
                contextMenu.getItems().add((Object)earlyLateHoursMenu);
            }
            Menu gridMenu = new Menu(Messages.getString("ContextMenuProvider.GRID"));
            MenuItem gridOff = new MenuItem(Messages.getString("ContextMenuProvider.GRID_OFF"));
            gridOff.setOnAction(evt -> control.setVirtualGrid(VirtualGrid.OFF));
            gridMenu.getItems().add((Object)gridOff);
            gridMenu.getItems().add((Object)new SeparatorMenuItem());
            for (int grid : grids = new int[]{5, 10, 15, 30, 60}) {
                String itemText = MessageFormat.format(Messages.getString("ContextMenuProvider.MINUTES"), grid);
                String itemTextShort = MessageFormat.format(Messages.getString("ContextMenuProvider.MINUTES_SHORT"), grid);
                MenuItem gridItem = new MenuItem(itemText);
                gridMenu.getItems().add((Object)gridItem);
                gridItem.setOnAction(evt -> control.setVirtualGrid(new VirtualGrid(itemText, itemTextShort, ChronoUnit.MINUTES, grid)));
            }
            contextMenu.getItems().add((Object)gridMenu);
            Menu menu = new Menu(Messages.getString("ContextMenuProvider.SHOW_HOURS"));
            Slider slider = new Slider(40.0, 200.0, 50.0);
            slider.setPrefWidth(100.0);
            slider.setValue(dayView.getHourHeight());
            slider.valueProperty().addListener(it -> {
                dayView.setHoursLayoutStrategy(DayViewBase.HoursLayoutStrategy.FIXED_HOUR_HEIGHT);
                dayView.setHourHeight(slider.getValue());
            });
            CustomMenuItem hourHeight = new CustomMenuItem((Node)slider);
            hourHeight.setHideOnClick(false);
            menu.getItems().add((Object)hourHeight);
            menu.getItems().add((Object)new SeparatorMenuItem());
            for (int h : hours = new int[]{4, 6, 8, 10, 12, 18, 24}) {
                String labelText = MessageFormat.format(Messages.getString("ContextMenuProvider.HOURS"), h);
                MenuItem item = new MenuItem(labelText);
                item.setOnAction(evt -> {
                    dayView.setEarlyLateHoursStrategy(DayViewBase.EarlyLateHoursStrategy.SHOW);
                    dayView.setHoursLayoutStrategy(DayViewBase.HoursLayoutStrategy.FIXED_HOUR_COUNT);
                    dayView.setVisibleHours(h);
                });
                menu.getItems().add((Object)item);
            }
            contextMenu.getItems().add((Object)menu);
        }
        return contextMenu;
    }

    protected ContextMenu getAllDayViewMenu(DateControl.ContextMenuParameter param) {
        ContextMenu contextMenu = new ContextMenu();
        DateControl control = param.getDateControl();
        if (control instanceof AllDayView) {
            MenuItem newEntry = new MenuItem(Messages.getString("ContextMenuProvider.ADD_NEW_EVENT"));
            newEntry.setOnAction(evt -> {
                control.createEntryAt(param.getZonedDateTime());
                contextMenu.hide();
            });
            contextMenu.getItems().add((Object)newEntry);
        }
        if (contextMenu.getItems().isEmpty()) {
            return null;
        }
        return contextMenu;
    }
}

