/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.DeleteHandler;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.ZonedDateTimeProvider;
import java.time.ZonedDateTime;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.EventTarget;
import javafx.scene.control.Alert;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

class CreateAndDeleteHandler
extends DeleteHandler {
    public CreateAndDeleteHandler(DateControl control) {
        super(control);
        this.dateControl.addEventHandler(MouseEvent.MOUSE_CLICKED, this::createEntry);
    }

    private void createEntry(MouseEvent evt) {
        if (evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getClickCount() == this.dateControl.getCreateEntryClickCount()) {
            DayViewBase dayViewBase;
            if (!evt.isStillSincePress()) {
                return;
            }
            if (this.dateControl instanceof DayViewBase && (dayViewBase = (DayViewBase)this.dateControl).isEditAvailability()) {
                LoggingDomain.VIEW.fine("no new entry created because day view is currently editing availability");
                return;
            }
            LoggingDomain.VIEW.fine("create entry mouse event received inside control: " + ((Object)((Object)this.dateControl)).getClass().getSimpleName());
            ZonedDateTime time = ZonedDateTime.now().withZoneSameInstant(this.dateControl.getZoneId());
            if (this.dateControl instanceof ZonedDateTimeProvider) {
                ZonedDateTimeProvider provider = (ZonedDateTimeProvider)((Object)this.dateControl);
                time = provider.getZonedDateTimeAt(evt.getX(), evt.getY(), this.dateControl.getZoneId());
            }
            if (this.dateControl.getCalendars().isEmpty()) {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle(Messages.getString("DateControl.TITLE_CALENDAR_PROBLEM"));
                alert.setHeaderText(Messages.getString("DateControl.HEADER_TEXT_NO_CALENDARS_DEFINED"));
                alert.setContentText(Messages.getString("DateControl.CONTENT_TEXT_NO_CALENDARS_DEFINED"));
                alert.show();
            } else {
                Optional<Calendar> calendar = this.dateControl.getCalendarAt(evt.getX(), evt.getY());
                if (time != null) {
                    Entry<?> entry = this.dateControl.createEntryAt(time, calendar.orElse(null));
                    if (this.dateControl.isShowDetailsUponEntryCreation()) {
                        Platform.runLater(() -> this.dateControl.fireEvent(new RequestEvent((Object)this.dateControl, (EventTarget)this.dateControl, entry)));
                    }
                }
            }
            evt.consume();
        }
    }
}

