/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.DeleteHandler;
import impl.com.calendarfx.view.DayViewSkin;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class DayView
extends DayViewBase {
    private static final String DAY_VIEW = "day-view";
    private static final String DAY_VIEW_TODAY = "today";
    private static final String DAY_VIEW_WEEKEND_DAY = "weekend-day";
    private final ObjectProperty<Callback<Entry<?>, DayEntryView>> entryViewFactory = new SimpleObjectProperty((Object)this, "entryViewFactory");

    public DayView() {
        this.getStyleClass().add((Object)DAY_VIEW);
        InvalidationListener updateStyleClassListener = it -> this.updateStyleClasses();
        this.showTodayProperty().addListener(updateStyleClassListener);
        this.todayProperty().addListener(updateStyleClassListener);
        this.dateProperty().addListener(updateStyleClassListener);
        this.getWeekendDays().addListener(updateStyleClassListener);
        this.updateStyleClasses();
        this.selectionModeProperty().addListener(evt -> this.getSelections().clear());
        this.setEntryViewFactory(DayEntryView::new);
        this.setMinWidth(0.0);
        new DeleteHandler(this);
    }

    protected Skin<?> createDefaultSkin() {
        return new DayViewSkin<DayView>(this);
    }

    private void updateStyleClasses() {
        LocalDate date = this.getDate();
        if (date.equals(this.getToday()) && this.isShowToday()) {
            if (!this.getStyleClass().contains((Object)DAY_VIEW_TODAY)) {
                this.getStyleClass().add((Object)DAY_VIEW_TODAY);
            }
        } else {
            this.getStyleClass().remove((Object)DAY_VIEW_TODAY);
        }
        if (this.getWeekendDays().contains((Object)date.getDayOfWeek())) {
            if (!this.getStyleClass().contains((Object)DAY_VIEW_WEEKEND_DAY)) {
                this.getStyleClass().add((Object)DAY_VIEW_WEEKEND_DAY);
            }
        } else {
            this.getStyleClass().remove((Object)DAY_VIEW_WEEKEND_DAY);
        }
    }

    @Override
    public Optional<Calendar> getCalendarAt(double x, double y) {
        if (this.getLayout().equals((Object)DateControl.Layout.SWIMLANE)) {
            FilteredList visibleCalendars = this.getCalendars().filtered(this::isCalendarVisible);
            double calendarWidth = this.getWidth() / (double)visibleCalendars.size();
            int index = (int)(x / calendarWidth);
            if (index < visibleCalendars.size()) {
                return Optional.of((Calendar)visibleCalendars.get(index));
            }
        }
        return Optional.empty();
    }

    public final ObjectProperty<Callback<Entry<?>, DayEntryView>> entryViewFactoryProperty() {
        return this.entryViewFactory;
    }

    public final Callback<Entry<?>, DayEntryView> getEntryViewFactory() {
        return (Callback)this.entryViewFactoryProperty().get();
    }

    public final void setEntryViewFactory(Callback<Entry<?>, DayEntryView> factory) {
        Objects.requireNonNull(factory);
        this.entryViewFactoryProperty().set(factory);
    }
}

