/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.util.ViewHelper;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.VirtualGrid;
import com.calendarfx.view.WeekDayView;
import com.calendarfx.view.ZonedDateTimeProvider;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.controlsfx.control.PropertySheet;

public abstract class DayViewBase
extends DateControl
implements ZonedDateTimeProvider {
    private final ObjectProperty<GridType> gridType = new SimpleObjectProperty((Object)this, "gridType", (Object)GridType.STANDARD);
    private final ObjectProperty<VirtualGrid> gridLines = new SimpleObjectProperty((Object)this, "virtualGrid", (Object)new VirtualGrid("Grid Lines", "Grid", ChronoUnit.MINUTES, 30));
    private final ObjectProperty<Paint> gridLineColor = new SimpleObjectProperty((Object)this, "gridLineColor", (Object)Color.LIGHTGRAY);
    private final ObjectProperty<AvailabilityEditingEntryBehaviour> entryViewAvailabilityEditingBehaviour = new SimpleObjectProperty((Object)this, "entryViewAvailabilityEditingBehaviour", (Object)AvailabilityEditingEntryBehaviour.OPACITY);
    private final DoubleProperty entryViewAvailabilityEditingOpacity = new SimpleDoubleProperty((Object)this, "entryViewAvailabilityEditingOpacity", 0.25);
    private final ObjectProperty<ZonedDateTime> scrollTime = new SimpleObjectProperty((Object)this, "scrollTime", (Object)ZonedDateTime.of(LocalDate.now(), LocalTime.MIN, ZoneId.systemDefault()));
    private final BooleanProperty scrollingEnabled = new SimpleBooleanProperty((Object)this, "scrollingEnabled", false);
    private final DoubleProperty entryWidthPercentage = new SimpleDoubleProperty(this, "entryWidthPercentage", 100.0){

        public void set(double newValue) {
            if (newValue < 10.0 || newValue > 100.0) {
                throw new IllegalArgumentException("percentage width must be between 10 and 100 but was " + newValue);
            }
            super.set(newValue);
        }
    };
    public static final double MILLIS_PER_HOUR = 3600000.0;
    private final ObjectProperty<OverlapResolutionStrategy> overlapResolutionStrategy = new SimpleObjectProperty((Object)this, "overlapCriteria", (Object)OverlapResolutionStrategy.TIME_BOUNDS);
    private final ObjectProperty<EarlyLateHoursStrategy> earlyLateHoursStrategy = new SimpleObjectProperty((Object)this, "earlyLateHoursStrategy", (Object)EarlyLateHoursStrategy.SHOW);
    private final ObjectProperty<HoursLayoutStrategy> hoursLayoutStrategy = new SimpleObjectProperty((Object)this, "hoursLayoutStrategy", (Object)HoursLayoutStrategy.FIXED_HOUR_COUNT);
    private final IntegerProperty visibleHours = new SimpleIntegerProperty((Object)this, "visibleHours", 10);
    private final DoubleProperty minHourHeight = new SimpleDoubleProperty((Object)this, "hourHeight", 20.0);
    private final DoubleProperty maxHourHeight = new SimpleDoubleProperty((Object)this, "hourHeight", 200.0);
    private final DoubleProperty hourHeight = new SimpleDoubleProperty((Object)this, "hourHeight", 70.0);
    private final DoubleProperty hourHeightCompressed = new SimpleDoubleProperty((Object)this, "hourHeightCompressed", 10.0);
    private final ReadOnlyBooleanWrapper showCurrentTimeMarker = new ReadOnlyBooleanWrapper((Object)this, "showCurrentTimeMarker", false);
    private final ReadOnlyBooleanWrapper showCurrentTimeTodayMarker = new ReadOnlyBooleanWrapper((Object)this, "showCurrentTimeTodayMarker", false);
    private final BooleanProperty enableCurrentTimeCircle = new SimpleBooleanProperty((Object)this, "enableCurrentTimeCircle", true);
    private final BooleanProperty enableCurrentTimeMarker = new SimpleBooleanProperty((Object)this, "enableCurrentTimeMarker", true);
    private final ReadOnlyObjectWrapper<LocalTime> earliestTimeUsed = new ReadOnlyObjectWrapper((Object)this, "earliestTimeUsed");
    private final ReadOnlyObjectWrapper<LocalTime> latestTimeUsed = new ReadOnlyObjectWrapper((Object)this, "latestTimeUsed");
    private final BooleanProperty trimTimeBounds = new SimpleBooleanProperty((Object)this, "timTimeBounds", false);
    private final ObjectProperty<BiConsumer<Instant, Instant>> onLassoFinished = new SimpleObjectProperty((Object)this, "onLassoFinished", (start, end) -> {});
    private final ObjectProperty<Paint> lassoColor = new SimpleObjectProperty((Object)this, "lassoColor", (Object)Color.GREY);
    private final ObjectProperty<Instant> lassoStart = new SimpleObjectProperty((Object)this, "lassoStart");
    private final ObjectProperty<Instant> lassoEnd = new SimpleObjectProperty((Object)this, "lassoEnd");
    private final BooleanProperty enableStartAndEndTimesFlip = new SimpleBooleanProperty((Object)this, "enableStartAndEndTimesFlip", false);
    private static final String DAY_VIEW_BASE_CATEGORY = "Date View Base";

    public DayViewBase() {
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded()) {
                if (change.getKey().equals("show.current.time.marker")) {
                    Boolean show = (Boolean)change.getValueAdded();
                    this.showCurrentTimeMarker.set(show.booleanValue());
                } else if (change.getKey().equals("show.current.time.today.marker")) {
                    Boolean show = (Boolean)change.getValueAdded();
                    this.showCurrentTimeTodayMarker.set(show.booleanValue());
                } else if (change.getKey().equals("earliest.time.used")) {
                    LocalTime time = (LocalTime)change.getValueAdded();
                    this.earliestTimeUsed.set((Object)time);
                } else if (change.getKey().equals("latest.time.used")) {
                    LocalTime time = (LocalTime)change.getValueAdded();
                    this.latestTimeUsed.set((Object)time);
                }
            }
        };
        this.getProperties().addListener(propertiesListener);
        InvalidationListener trimListener = it -> {
            if (this.isTrimTimeBounds()) {
                this.trimTimeBounds();
            }
        };
        this.earliestTimeUsedProperty().addListener(trimListener);
        this.latestTimeUsedProperty().addListener(trimListener);
        this.trimTimeBoundsProperty().addListener(trimListener);
        this.installDefaultLassoFinishedBehaviour();
    }

    public final GridType getGridType() {
        return (GridType)((Object)this.gridType.get());
    }

    public final ObjectProperty<GridType> gridTypeProperty() {
        return this.gridType;
    }

    public final void setGridType(GridType gridType) {
        this.gridType.set((Object)gridType);
    }

    public final VirtualGrid getGridLines() {
        return (VirtualGrid)this.gridLines.get();
    }

    public final ObjectProperty<VirtualGrid> gridLinesProperty() {
        return this.gridLines;
    }

    public final void setGridLines(VirtualGrid gridLines) {
        this.gridLines.set((Object)gridLines);
    }

    public final Paint getGridLineColor() {
        return (Paint)this.gridLineColor.get();
    }

    public final ObjectProperty<Paint> gridLineColorProperty() {
        return this.gridLineColor;
    }

    public final void setGridLineColor(Paint gridLineColor) {
        this.gridLineColor.set((Object)gridLineColor);
    }

    public final AvailabilityEditingEntryBehaviour getEntryViewAvailabilityEditingBehaviour() {
        return (AvailabilityEditingEntryBehaviour)((Object)this.entryViewAvailabilityEditingBehaviour.get());
    }

    public final ObjectProperty<AvailabilityEditingEntryBehaviour> entryViewAvailabilityEditingBehaviourProperty() {
        return this.entryViewAvailabilityEditingBehaviour;
    }

    public final void setEntryViewAvailabilityEditingBehaviour(AvailabilityEditingEntryBehaviour behaviour) {
        this.entryViewAvailabilityEditingBehaviour.set((Object)behaviour);
    }

    public final double getEntryViewAvailabilityEditingOpacity() {
        return this.entryViewAvailabilityEditingOpacity.get();
    }

    public final DoubleProperty entryViewAvailabilityEditingOpacityProperty() {
        return this.entryViewAvailabilityEditingOpacity;
    }

    public final void setEntryViewAvailabilityEditingOpacity(double entryViewAvailabilityEditingOpacity) {
        this.entryViewAvailabilityEditingOpacity.set(entryViewAvailabilityEditingOpacity);
    }

    public void installDefaultLassoFinishedBehaviour() {
        this.setOnLassoFinished((start, end) -> {
            if (start == null || end == null) {
                return;
            }
            if (this.isEditAvailability()) {
                if (start.isAfter((Instant)end)) {
                    Instant tmp = start;
                    start = end;
                    end = tmp;
                }
                Entry entry = new Entry("Availability Entry", new Interval((Instant)start, (Instant)end, this.getZoneId()));
                Calendar availabilityCalendar = this.getAvailabilityCalendar();
                availabilityCalendar.addEntry(entry);
            }
        });
    }

    public final ZonedDateTime getZonedDateTimeStart() {
        return ZonedDateTime.of(this.getDate(), this.getStartTime(), this.getZoneId());
    }

    public final ZonedDateTime getZonedDateTimeMin() {
        return ZonedDateTime.of(this.getDate(), LocalTime.MIN, this.getZoneId());
    }

    public final ZonedDateTime getZonedDateTimeEnd() {
        return ZonedDateTime.of(this.getDate(), this.getEndTime(), this.getZoneId());
    }

    public final ZonedDateTime getZonedDateTimeMax() {
        return ZonedDateTime.of(this.getDate(), LocalTime.MAX, this.getZoneId());
    }

    public final ZonedDateTime getScrollTime() {
        return (ZonedDateTime)this.scrollTime.get();
    }

    public final ObjectProperty<ZonedDateTime> scrollTimeProperty() {
        return this.scrollTime;
    }

    public final void setScrollTime(ZonedDateTime scrollTime) {
        this.scrollTime.set((Object)scrollTime);
    }

    public final boolean isScrollingEnabled() {
        return this.scrollingEnabled.get();
    }

    public final BooleanProperty scrollingEnabledProperty() {
        return this.scrollingEnabled;
    }

    public final void setScrollingEnabled(boolean scrollingEnabled) {
        this.scrollingEnabled.set(scrollingEnabled);
    }

    public final DoubleProperty entryWidthPercentageProperty() {
        return this.entryWidthPercentage;
    }

    public final void setEntryWidthPercentage(double percentage) {
        this.entryWidthPercentage.set(percentage);
    }

    public double getEntryWidthPercentage() {
        return this.entryWidthPercentage.get();
    }

    public Instant getInstantAt(MouseEvent evt) {
        return this.getInstantAt(evt.getX(), evt.getY());
    }

    public Instant getInstantAt(double x, double y) {
        return this.getZonedDateTimeAt(x, y).toInstant();
    }

    public ZonedDateTime getZonedDateTimeAt(double x, double y) {
        return this.getZonedDateTimeAt(x, y, this.getZoneId());
    }

    @Override
    public ZonedDateTime getZonedDateTimeAt(double x, double y, ZoneId zoneId) {
        if (this.isScrollingEnabled()) {
            double mpp = 3600000.0 / this.getHourHeight();
            long millis = (long)(y * mpp);
            return this.getScrollTime().plus(millis, ChronoUnit.MILLIS);
        }
        return ZonedDateTime.ofInstant(ViewHelper.getInstantAt(this, y), this.getZoneId());
    }

    public final ZonedDateTime getZonedDateTime(LocalTime time) {
        return ZonedDateTime.of(this.getDate(), time, this.getZoneId());
    }

    public final double getLocation(Instant instant) {
        return ViewHelper.getTimeLocation(this, instant);
    }

    public final double getLocation(ZonedDateTime time) {
        return ViewHelper.getTimeLocation(this, time);
    }

    public final ObjectProperty<OverlapResolutionStrategy> overlapResolutionStrategyProperty() {
        return this.overlapResolutionStrategy;
    }

    public final OverlapResolutionStrategy getOverlapResolutionStrategy() {
        return (OverlapResolutionStrategy)((Object)this.overlapResolutionStrategy.get());
    }

    public final void setOverlapResolutionStrategy(OverlapResolutionStrategy strategy) {
        this.overlapResolutionStrategy.set((Object)strategy);
    }

    public final ObjectProperty<EarlyLateHoursStrategy> earlyLateHoursStrategyProperty() {
        return this.earlyLateHoursStrategy;
    }

    public final void setEarlyLateHoursStrategy(EarlyLateHoursStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.earlyLateHoursStrategy.set((Object)strategy);
    }

    public final EarlyLateHoursStrategy getEarlyLateHoursStrategy() {
        return (EarlyLateHoursStrategy)((Object)this.earlyLateHoursStrategy.get());
    }

    public final ObjectProperty<HoursLayoutStrategy> hoursLayoutStrategyProperty() {
        return this.hoursLayoutStrategy;
    }

    public final void setHoursLayoutStrategy(HoursLayoutStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.hoursLayoutStrategy.set((Object)strategy);
    }

    public final HoursLayoutStrategy getHoursLayoutStrategy() {
        return (HoursLayoutStrategy)((Object)this.hoursLayoutStrategy.get());
    }

    public final IntegerProperty visibleHoursProperty() {
        return this.visibleHours;
    }

    public final void setVisibleHours(int hours) {
        this.visibleHoursProperty().set(hours);
    }

    public final int getVisibleHours() {
        return this.visibleHoursProperty().get();
    }

    public final double getMinHourHeight() {
        return this.minHourHeight.get();
    }

    public final DoubleProperty minHourHeightProperty() {
        return this.minHourHeight;
    }

    public final void setMinHourHeight(double minHourHeight) {
        this.minHourHeight.set(minHourHeight);
    }

    public final double getMaxHourHeight() {
        return this.maxHourHeight.get();
    }

    public final DoubleProperty maxHourHeightProperty() {
        return this.maxHourHeight;
    }

    public final void setMaxHourHeight(double maxHourHeight) {
        this.maxHourHeight.set(maxHourHeight);
    }

    public final DoubleProperty hourHeightProperty() {
        return this.hourHeight;
    }

    public final void setHourHeight(double height) {
        if (height < 1.0) {
            throw new IllegalArgumentException("height must be larger than 0 but was " + height);
        }
        this.hourHeightProperty().set(height);
    }

    public final double getHourHeight() {
        return this.hourHeightProperty().get();
    }

    public final DoubleProperty hourHeightCompressedProperty() {
        return this.hourHeightCompressed;
    }

    public final void setHourHeightCompressed(double height) {
        if (height < 1.0) {
            throw new IllegalArgumentException("height must be larger than 0 but was " + height);
        }
        this.hourHeightCompressedProperty().set(height);
    }

    public final double getHourHeightCompressed() {
        return this.hourHeightCompressedProperty().get();
    }

    public final ReadOnlyBooleanProperty showCurrentTimeMarkerProperty() {
        return this.showCurrentTimeMarker;
    }

    public final boolean isShowCurrentTimeMarker() {
        return this.showCurrentTimeMarker.get();
    }

    public final ReadOnlyBooleanProperty showCurrentTimeTodayMarkerProperty() {
        return this.showCurrentTimeTodayMarker;
    }

    public final boolean isShowCurrentTimeTodayMarker() {
        return this.showCurrentTimeTodayMarker.get();
    }

    public final BooleanProperty enableCurrentTimeCircleProperty() {
        return this.enableCurrentTimeCircle;
    }

    public final boolean isEnableCurrentCircleMarker() {
        return this.enableCurrentTimeCircle.get();
    }

    public final void setEnableCurrentTimeCircle(boolean enable) {
        this.enableCurrentTimeCircle.set(enable);
    }

    public final BooleanProperty enableCurrentTimeMarkerProperty() {
        return this.enableCurrentTimeMarker;
    }

    public final boolean isEnableCurrentTimeMarker() {
        return this.enableCurrentTimeMarker.get();
    }

    public final void setEnableCurrentTimeMarker(boolean enable) {
        this.enableCurrentTimeMarker.set(enable);
    }

    public final ReadOnlyObjectProperty<LocalTime> earliestTimeUsedProperty() {
        return this.earliestTimeUsed.getReadOnlyProperty();
    }

    public final LocalTime getEarliestTimeUsed() {
        return (LocalTime)this.earliestTimeUsed.get();
    }

    public final ReadOnlyObjectProperty<LocalTime> latestTimeUsedProperty() {
        return this.latestTimeUsed.getReadOnlyProperty();
    }

    public final LocalTime getLatestTimeUsed() {
        return (LocalTime)this.latestTimeUsed.get();
    }

    public final BooleanProperty trimTimeBoundsProperty() {
        return this.trimTimeBounds;
    }

    public final boolean isTrimTimeBounds() {
        return this.trimTimeBounds.get();
    }

    public final void setTrimTimeBounds(boolean trimTimeBounds) {
        this.trimTimeBounds.set(trimTimeBounds);
    }

    private void trimTimeBounds() {
        if (this instanceof WeekDayView) {
            return;
        }
        LoggingDomain.PRINTING.fine("trimming hours");
        LocalTime st = LocalTime.of(8, 0);
        LocalTime et = LocalTime.of(19, 0);
        LocalTime etu = this.getEarliestTimeUsed();
        LocalTime ltu = this.getLatestTimeUsed();
        LoggingDomain.PRINTING.fine("earliest time: " + etu + ", latest time: " + ltu);
        this.setEarlyLateHoursStrategy(EarlyLateHoursStrategy.HIDE);
        if (etu != null && ltu != null && ltu.isAfter(etu)) {
            etu = !etu.isBefore(LocalTime.of(1, 0)) ? etu.minusHours(1L) : LocalTime.MIN;
            ltu = !ltu.isAfter(LocalTime.of(23, 0)) ? ltu.plusHours(1L) : LocalTime.MAX;
            if (etu.isBefore(st.plusHours(1L))) {
                this.setStartTime(etu);
            } else {
                this.setStartTime(st);
            }
            if (ltu.isAfter(et.minusHours(1L))) {
                this.setEndTime(ltu);
            } else {
                this.setEndTime(et);
            }
        } else {
            this.setStartTime(st);
            this.setEndTime(et);
        }
        this.setVisibleHours(Math.min(24, (int)this.getStartTime().until(this.getEndTime(), ChronoUnit.HOURS)));
    }

    public final BiConsumer<Instant, Instant> getOnLassoFinished() {
        return (BiConsumer)this.onLassoFinished.get();
    }

    public final ObjectProperty<BiConsumer<Instant, Instant>> onLassoFinishedProperty() {
        return this.onLassoFinished;
    }

    public final void setOnLassoFinished(BiConsumer<Instant, Instant> onLassoFinished) {
        this.onLassoFinished.set(onLassoFinished);
    }

    public final Paint getLassoColor() {
        return (Paint)this.lassoColor.get();
    }

    public final ObjectProperty<Paint> lassoColorProperty() {
        return this.lassoColor;
    }

    public final void setLassoColor(Paint lassoColor) {
        this.lassoColor.set((Object)lassoColor);
    }

    public final Instant getLassoStart() {
        return (Instant)this.lassoStart.get();
    }

    public final ObjectProperty<Instant> lassoStartProperty() {
        return this.lassoStart;
    }

    public final void setLassoStart(Instant lassoStart) {
        this.lassoStart.set((Object)lassoStart);
    }

    public final Instant getLassoEnd() {
        return (Instant)this.lassoEnd.get();
    }

    public final ObjectProperty<Instant> lassoEndProperty() {
        return this.lassoEnd;
    }

    public final void setLassoEnd(Instant lassoEnd) {
        this.lassoEnd.set((Object)lassoEnd);
    }

    public final boolean isEnableStartAndEndTimesFlip() {
        return this.enableStartAndEndTimesFlip.get();
    }

    public final BooleanProperty enableStartAndEndTimesFlipProperty() {
        return this.enableStartAndEndTimesFlip;
    }

    public final void setEnableStartAndEndTimesFlip(boolean enableStartAndEndTimesFlip) {
        this.enableStartAndEndTimesFlip.set(enableStartAndEndTimesFlip);
    }

    public final void bind(DayViewBase otherControl, boolean bindDate) {
        super.bind(otherControl, bindDate);
        Bindings.bindBidirectional(otherControl.earlyLateHoursStrategyProperty(), this.earlyLateHoursStrategyProperty());
        Bindings.bindBidirectional(otherControl.hoursLayoutStrategyProperty(), this.hoursLayoutStrategyProperty());
        Bindings.bindBidirectional((Property)otherControl.hourHeightProperty(), (Property)this.hourHeightProperty());
        Bindings.bindBidirectional((Property)otherControl.hourHeightCompressedProperty(), (Property)this.hourHeightCompressedProperty());
        Bindings.bindBidirectional((Property)otherControl.visibleHoursProperty(), (Property)this.visibleHoursProperty());
        Bindings.bindBidirectional((Property)otherControl.enableCurrentTimeMarkerProperty(), (Property)this.enableCurrentTimeMarkerProperty());
        Bindings.bindBidirectional((Property)otherControl.enableCurrentTimeCircleProperty(), (Property)this.enableCurrentTimeCircleProperty());
        Bindings.bindBidirectional((Property)otherControl.trimTimeBoundsProperty(), (Property)this.trimTimeBoundsProperty());
        Bindings.bindBidirectional((Property)otherControl.scrollingEnabledProperty(), (Property)this.scrollingEnabledProperty());
        Bindings.bindBidirectional(otherControl.scrollTimeProperty(), this.scrollTimeProperty());
        Bindings.bindBidirectional(otherControl.overlapResolutionStrategyProperty(), this.overlapResolutionStrategyProperty());
        Bindings.bindBidirectional(otherControl.lassoStartProperty(), this.lassoStartProperty());
        Bindings.bindBidirectional(otherControl.lassoEndProperty(), this.lassoEndProperty());
        Bindings.bindBidirectional(otherControl.onLassoFinishedProperty(), this.onLassoFinishedProperty());
        Bindings.bindBidirectional(otherControl.startTimeProperty(), this.startTimeProperty());
        Bindings.bindBidirectional(otherControl.endTimeProperty(), this.endTimeProperty());
        Bindings.bindBidirectional(otherControl.entryViewAvailabilityEditingBehaviourProperty(), this.entryViewAvailabilityEditingBehaviourProperty());
        Bindings.bindBidirectional((Property)otherControl.entryViewAvailabilityEditingOpacityProperty(), (Property)this.entryViewAvailabilityEditingOpacityProperty());
        Bindings.bindBidirectional(otherControl.gridLinesProperty(), this.gridLinesProperty());
        Bindings.bindBidirectional(otherControl.gridLineColorProperty(), this.gridLineColorProperty());
        Bindings.bindBidirectional(otherControl.gridTypeProperty(), this.gridTypeProperty());
        Bindings.bindBidirectional((Property)otherControl.enableStartAndEndTimesFlipProperty(), (Property)this.enableStartAndEndTimesFlipProperty());
    }

    public final void unbind(DayViewBase otherControl) {
        super.unbind(otherControl);
        Bindings.unbindBidirectional(otherControl.earlyLateHoursStrategyProperty(), this.earlyLateHoursStrategyProperty());
        Bindings.unbindBidirectional(otherControl.hoursLayoutStrategyProperty(), this.hoursLayoutStrategyProperty());
        Bindings.unbindBidirectional((Property)otherControl.hourHeightProperty(), (Property)this.hourHeightProperty());
        Bindings.unbindBidirectional((Property)otherControl.hourHeightCompressedProperty(), (Property)this.hourHeightCompressedProperty());
        Bindings.unbindBidirectional((Property)otherControl.visibleHoursProperty(), (Property)this.visibleHoursProperty());
        Bindings.unbindBidirectional((Property)otherControl.enableCurrentTimeMarkerProperty(), (Property)this.enableCurrentTimeMarkerProperty());
        Bindings.unbindBidirectional((Property)otherControl.enableCurrentTimeCircleProperty(), (Property)this.enableCurrentTimeCircleProperty());
        Bindings.unbindBidirectional((Property)otherControl.trimTimeBoundsProperty(), (Property)this.trimTimeBoundsProperty());
        Bindings.unbindBidirectional((Property)otherControl.scrollingEnabledProperty(), (Property)this.scrollingEnabledProperty());
        Bindings.unbindBidirectional(otherControl.scrollTimeProperty(), this.scrollTimeProperty());
        Bindings.unbindBidirectional(otherControl.overlapResolutionStrategyProperty(), this.overlapResolutionStrategyProperty());
        Bindings.unbindBidirectional(otherControl.lassoStartProperty(), this.lassoStartProperty());
        Bindings.unbindBidirectional(otherControl.lassoEndProperty(), this.lassoEndProperty());
        Bindings.unbindBidirectional(otherControl.onLassoFinishedProperty(), this.onLassoFinishedProperty());
        Bindings.unbindBidirectional(otherControl.startTimeProperty(), this.startTimeProperty());
        Bindings.unbindBidirectional(otherControl.endTimeProperty(), this.endTimeProperty());
        Bindings.unbindBidirectional(otherControl.entryViewAvailabilityEditingBehaviourProperty(), this.entryViewAvailabilityEditingBehaviourProperty());
        Bindings.unbindBidirectional((Property)otherControl.entryViewAvailabilityEditingOpacityProperty(), (Property)this.entryViewAvailabilityEditingOpacityProperty());
        Bindings.unbindBidirectional(otherControl.gridLinesProperty(), this.gridLinesProperty());
        Bindings.unbindBidirectional(otherControl.gridLineColorProperty(), this.gridLineColorProperty());
        Bindings.unbindBidirectional(otherControl.gridTypeProperty(), this.gridTypeProperty());
        Bindings.unbindBidirectional((Property)otherControl.enableStartAndEndTimesFlipProperty(), (Property)this.enableStartAndEndTimesFlipProperty());
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.scrollingEnabledProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setScrollingEnabled((Boolean)value);
            }

            public Object getValue() {
                return DayViewBase.this.isScrollingEnabled();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Enable Scrolling";
            }

            public String getDescription() {
                return "Support scrolling to previous or next days";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.enableCurrentTimeMarkerProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setEnableCurrentTimeMarker((Boolean)value);
            }

            public Object getValue() {
                return DayViewBase.this.isEnableCurrentTimeMarker();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Current time marker";
            }

            public String getDescription() {
                return "Show current time marker.";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.enableCurrentTimeCircleProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setEnableCurrentTimeCircle((Boolean)value);
            }

            public Object getValue() {
                return DayViewBase.this.isEnableCurrentCircleMarker();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Current time circle";
            }

            public String getDescription() {
                return "Show current time circle.";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.earlyLateHoursStrategyProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setEarlyLateHoursStrategy((EarlyLateHoursStrategy)((Object)value));
            }

            public Object getValue() {
                return DayViewBase.this.getEarlyLateHoursStrategy();
            }

            public Class<?> getType() {
                return EarlyLateHoursStrategy.class;
            }

            public String getName() {
                return "Early / Late Hours";
            }

            public String getDescription() {
                return "Early / Late Hours Layout Strategy";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.visibleHoursProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setVisibleHours((Integer)value);
            }

            public Object getValue() {
                return DayViewBase.this.getVisibleHours();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Visible Hours";
            }

            public String getDescription() {
                return "Number of visible hours";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.hourHeightProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setHourHeight((Double)value);
            }

            public Object getValue() {
                return DayViewBase.this.getHourHeight();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Hour Height";
            }

            public String getDescription() {
                return "Height of one hour";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.hourHeightCompressedProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setHourHeightCompressed((Double)value);
            }

            public Object getValue() {
                return DayViewBase.this.getHourHeightCompressed();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Hour Height Compressed";
            }

            public String getDescription() {
                return "Height of one hour when shown compressed (early / late hours).";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.hoursLayoutStrategyProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setHoursLayoutStrategy((HoursLayoutStrategy)((Object)value));
            }

            public Object getValue() {
                return DayViewBase.this.getHoursLayoutStrategy();
            }

            public Class<?> getType() {
                return HoursLayoutStrategy.class;
            }

            public String getName() {
                return "Layout Strategy";
            }

            public String getDescription() {
                return "Layout Strategy";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.trimTimeBoundsProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setTrimTimeBounds((Boolean)value);
            }

            public Object getValue() {
                return DayViewBase.this.isTrimTimeBounds();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Trim Time Bounds";
            }

            public String getDescription() {
                return "Adjust earliest / latest times shown";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.earliestTimeUsedProperty());
            }

            public void setValue(Object value) {
            }

            public Object getValue() {
                return DayViewBase.this.getEarliestTimeUsed();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Earliest Time Used";
            }

            public String getDescription() {
                return "Earliest start time of any entry view";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.latestTimeUsedProperty());
            }

            public void setValue(Object value) {
            }

            public Object getValue() {
                return DayViewBase.this.getLatestTimeUsed();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Latest Time Used";
            }

            public String getDescription() {
                return "Latest end time of any entry view";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.overlapResolutionStrategyProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setOverlapResolutionStrategy((OverlapResolutionStrategy)((Object)value));
            }

            public Object getValue() {
                return DayViewBase.this.getOverlapResolutionStrategy();
            }

            public Class<?> getType() {
                return OverlapResolutionStrategy.class;
            }

            public String getName() {
                return "Overlap Resolution";
            }

            public String getDescription() {
                return "Controls when entries are considered overlapping";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.entryViewAvailabilityEditingBehaviourProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setEntryViewAvailabilityEditingBehaviour((AvailabilityEditingEntryBehaviour)((Object)value));
            }

            public Object getValue() {
                return DayViewBase.this.getEntryViewAvailabilityEditingBehaviour();
            }

            public Class<?> getType() {
                return AvailabilityEditingEntryBehaviour.class;
            }

            public String getName() {
                return "Availability Editing Entry Behaviour";
            }

            public String getDescription() {
                return "Determines how an entry view will be shown during availability editing.";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.gridLinesProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setGridLines((VirtualGrid)value);
            }

            public Object getValue() {
                return DayViewBase.this.getGridLines();
            }

            public Class<?> getType() {
                return VirtualGrid.class;
            }

            public String getName() {
                return "Grid used for drawing grid lines";
            }

            public String getDescription() {
                return "Specifies the grid size.";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.gridLineColorProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setGridLineColor((Paint)value);
            }

            public Object getValue() {
                return DayViewBase.this.getGridLineColor();
            }

            public Class<?> getType() {
                return Paint.class;
            }

            public String getName() {
                return "Color used for drawing grid lines";
            }

            public String getDescription() {
                return "Specifies the grid line color.";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.gridTypeProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setGridType((GridType)((Object)value));
            }

            public Object getValue() {
                return DayViewBase.this.getGridType();
            }

            public Class<?> getType() {
                return GridType.class;
            }

            public String getName() {
                return "Grid Type";
            }

            public String getDescription() {
                return "Specifies the grid type.";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DayViewBase.this.entryViewAvailabilityEditingOpacityProperty());
            }

            public void setValue(Object value) {
                DayViewBase.this.setEntryViewAvailabilityEditingOpacity((Double)value);
            }

            public Object getValue() {
                return DayViewBase.this.getEntryViewAvailabilityEditingOpacity();
            }

            public Class<?> getType() {
                return Double.class;
            }

            public String getName() {
                return "Availability Editing Entry Opacity";
            }

            public String getDescription() {
                return "Determines how opaque an entry view will be shown during availability editing.";
            }

            public String getCategory() {
                return DayViewBase.DAY_VIEW_BASE_CATEGORY;
            }

            public boolean isEditable() {
                return true;
            }
        });
        return items;
    }

    public static enum GridType {
        STANDARD,
        CUSTOM;

    }

    public static enum AvailabilityEditingEntryBehaviour {
        SHOW,
        HIDE,
        OPACITY;

    }

    public static enum OverlapResolutionStrategy {
        TIME_BOUNDS,
        VISUAL_BOUNDS,
        OFF;

    }

    public static enum EarlyLateHoursStrategy {
        SHOW,
        SHOW_COMPRESSED,
        HIDE;

    }

    public static enum HoursLayoutStrategy {
        FIXED_HOUR_HEIGHT,
        FIXED_HOUR_COUNT;

    }
}

