/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.DateControl;
import java.util.Objects;
import javafx.scene.input.KeyEvent;

class DeleteHandler {
    protected final DateControl dateControl;

    public DeleteHandler(DateControl control) {
        this.dateControl = Objects.requireNonNull(control);
        this.dateControl.addEventHandler(KeyEvent.KEY_PRESSED, this::deleteEntries);
    }

    private void deleteEntries(KeyEvent evt) {
        switch (evt.getCode()) {
            case DELETE: 
            case BACK_SPACE: {
                for (Entry entry : this.dateControl.getSelections()) {
                    Calendar calendar;
                    if (!((Boolean)this.dateControl.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dateControl, entry, DateControl.EditOperation.DELETE))).booleanValue()) continue;
                    if (entry.isRecurrence()) {
                        entry = entry.getRecurrenceSourceEntry();
                    }
                    if (!((Boolean)this.dateControl.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dateControl, entry, DateControl.EditOperation.DELETE))).booleanValue() || (calendar = entry.getCalendar()) == null || calendar.isReadOnly()) continue;
                    entry.removeFromCalendar();
                }
                this.dateControl.clearSelection();
                break;
            }
            case F5: {
                this.dateControl.refreshData();
            }
        }
    }
}

