/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.AllDayView;
import com.calendarfx.view.CalendarHeaderView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.WeekDayHeaderView;
import com.calendarfx.view.WeekTimeScaleView;
import com.calendarfx.view.WeekView;
import impl.com.calendarfx.view.DetailedWeekViewSkin;
import java.time.LocalDate;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import org.controlsfx.control.PropertySheet;

public class DetailedWeekView
extends DayViewBase {
    private static final String DEFAULT_STYLE_CLASS = "detailed-week-view";
    private final WeekDayHeaderView weekDayHeaderView;
    private final WeekView weekView;
    private final AllDayView allDayView;
    private final WeekTimeScaleView timeScaleView;
    private final CalendarHeaderView calendarHeaderView;
    private final IntegerProperty numberOfDays = new SimpleIntegerProperty((Object)this, "numberOfDays", 7);
    private final BooleanProperty adjustToFirstDayOfWeek = new SimpleBooleanProperty((Object)this, "adjustToFirstDayOfWeek", true);
    private final BooleanProperty showAllDayView = new SimpleBooleanProperty((Object)this, "showAllDayView", true);
    private final BooleanProperty showTimeScaleView = new SimpleBooleanProperty((Object)this, "showTimeScaleView", true);
    private final BooleanProperty showWeekDayHeaderView = new SimpleBooleanProperty((Object)this, "showWeekDayHeaderView", true);
    private final BooleanProperty showScrollBar = new SimpleBooleanProperty((Object)this, "showScrollBar", true);
    private final ReadOnlyObjectWrapper<LocalDate> startDate = new ReadOnlyObjectWrapper((Object)this, "startDate");
    private final ReadOnlyObjectWrapper<LocalDate> endDate = new ReadOnlyObjectWrapper((Object)this, "endDate");
    private static final String WEEK_VIEW_CATEGORY = "Week View";

    public DetailedWeekView() {
        this(7);
    }

    public DetailedWeekView(int numberOfDays) {
        this.setNumberOfDays(numberOfDays);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.calendarHeaderView = new CalendarHeaderView();
        this.calendarHeaderView.numberOfDaysProperty().bindBidirectional((Property)this.numberOfDaysProperty());
        this.calendarHeaderView.bind(this);
        this.weekDayHeaderView = new WeekDayHeaderView();
        this.weekDayHeaderView.showTodayProperty().bindBidirectional((Property)this.showTodayProperty());
        this.bind(this.weekDayHeaderView, true);
        Bindings.bindBidirectional((Property)this.weekDayHeaderView.numberOfDaysProperty(), (Property)this.numberOfDaysProperty());
        Bindings.bindBidirectional((Property)this.weekDayHeaderView.adjustToFirstDayOfWeekProperty(), (Property)this.adjustToFirstDayOfWeekProperty());
        this.allDayView = new AllDayView(this.getNumberOfDays());
        this.bind(this.allDayView, true);
        Bindings.bindBidirectional((Property)this.allDayView.numberOfDaysProperty(), (Property)this.numberOfDaysProperty());
        Bindings.bindBidirectional((Property)this.allDayView.adjustToFirstDayOfWeekProperty(), (Property)this.adjustToFirstDayOfWeekProperty());
        this.weekView = new WeekView();
        this.bind(this.weekView, true);
        Bindings.bindBidirectional((Property)this.weekView.numberOfDaysProperty(), (Property)this.numberOfDaysProperty());
        Bindings.bindBidirectional((Property)this.weekView.adjustToFirstDayOfWeekProperty(), (Property)this.adjustToFirstDayOfWeekProperty());
        this.timeScaleView = new WeekTimeScaleView();
        this.bind(this.timeScaleView, true);
        this.startDate.bind(this.weekView.startDateProperty());
        this.endDate.bind(this.weekView.endDateProperty());
    }

    protected Skin<?> createDefaultSkin() {
        return new DetailedWeekViewSkin(this);
    }

    public final CalendarHeaderView getCalendarHeaderView() {
        return this.calendarHeaderView;
    }

    public final WeekDayHeaderView getWeekDayHeaderView() {
        return this.weekDayHeaderView;
    }

    public final AllDayView getAllDayView() {
        return this.allDayView;
    }

    public final WeekTimeScaleView getTimeScaleView() {
        return this.timeScaleView;
    }

    public final WeekView getWeekView() {
        return this.weekView;
    }

    public final IntegerProperty numberOfDaysProperty() {
        return this.numberOfDays;
    }

    public final int getNumberOfDays() {
        return this.numberOfDaysProperty().get();
    }

    public final void setNumberOfDays(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("invalid number of days, must be larger than 0 but was " + number);
        }
        this.numberOfDaysProperty().set(number);
    }

    public final BooleanProperty adjustToFirstDayOfWeekProperty() {
        return this.adjustToFirstDayOfWeek;
    }

    public final boolean isAdjustToFirstDayOfWeek() {
        return this.adjustToFirstDayOfWeekProperty().get();
    }

    public final void setAdjustToFirstDayOfWeek(boolean adjust) {
        this.adjustToFirstDayOfWeekProperty().set(adjust);
    }

    public final BooleanProperty showAllDayViewProperty() {
        return this.showAllDayView;
    }

    public final boolean isShowAllDayView() {
        return this.showAllDayViewProperty().get();
    }

    public final void setShowAllDayView(boolean show) {
        this.showAllDayViewProperty().set(show);
    }

    public final BooleanProperty showTimeScaleViewProperty() {
        return this.showTimeScaleView;
    }

    public final boolean isShowTimeScaleView() {
        return this.showTimeScaleViewProperty().get();
    }

    public final void setShowTimeScaleView(boolean show) {
        this.showTimeScaleViewProperty().set(show);
    }

    public final BooleanProperty showWeekDayHeaderViewProperty() {
        return this.showWeekDayHeaderView;
    }

    public final boolean isShowWeekDayHeaderView() {
        return this.showWeekDayHeaderViewProperty().get();
    }

    public final void setShowWeekDayHeaderView(boolean show) {
        this.showWeekDayHeaderViewProperty().set(show);
    }

    public final BooleanProperty showScrollBarProperty() {
        return this.showScrollBar;
    }

    public final void setShowScrollBar(boolean show) {
        this.showScrollBar.set(show);
    }

    public final boolean isShowScrollBar() {
        return this.showScrollBar.get();
    }

    public final ReadOnlyObjectProperty<LocalDate> startDateProperty() {
        return this.startDate;
    }

    public final LocalDate getStartDate() {
        return (LocalDate)this.startDate.get();
    }

    public final ReadOnlyObjectProperty<LocalDate> endDateProperty() {
        return this.endDate;
    }

    public final LocalDate getEndDate() {
        return (LocalDate)this.endDate.get();
    }

    @Override
    public void goForward() {
        this.setDate(this.getDate().plusDays(this.getNumberOfDays()));
    }

    @Override
    public void goBack() {
        this.setDate(this.getDate().minusDays(this.getNumberOfDays()));
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedWeekView.this.numberOfDaysProperty());
            }

            public void setValue(Object value) {
                DetailedWeekView.this.setNumberOfDays((Integer)value);
            }

            public Object getValue() {
                return DetailedWeekView.this.getNumberOfDays();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Number of Days";
            }

            public String getDescription() {
                return "Number of Days";
            }

            public String getCategory() {
                return DetailedWeekView.WEEK_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getCategory() {
                return DetailedWeekView.WEEK_VIEW_CATEGORY;
            }

            public String getName() {
                return "Show All Day View";
            }

            public String getDescription() {
                return "Show All Day View";
            }

            public Object getValue() {
                return DetailedWeekView.this.isShowAllDayView();
            }

            public void setValue(Object value) {
                DetailedWeekView.this.setShowAllDayView((Boolean)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedWeekView.this.showAllDayViewProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getCategory() {
                return DetailedWeekView.WEEK_VIEW_CATEGORY;
            }

            public String getName() {
                return "Show Time Scale View";
            }

            public String getDescription() {
                return "Show Time Scale View";
            }

            public Object getValue() {
                return DetailedWeekView.this.isShowTimeScaleView();
            }

            public void setValue(Object value) {
                DetailedWeekView.this.setShowTimeScaleView((Boolean)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedWeekView.this.showTimeScaleViewProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getCategory() {
                return DetailedWeekView.WEEK_VIEW_CATEGORY;
            }

            public String getName() {
                return "Show Weekday Header View";
            }

            public String getDescription() {
                return "Show Weekday Header View";
            }

            public Object getValue() {
                return DetailedWeekView.this.isShowWeekDayHeaderView();
            }

            public void setValue(Object value) {
                DetailedWeekView.this.setShowWeekDayHeaderView((Boolean)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedWeekView.this.showWeekDayHeaderViewProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getCategory() {
                return DetailedWeekView.WEEK_VIEW_CATEGORY;
            }

            public String getName() {
                return "Show ScrollBar";
            }

            public String getDescription() {
                return "Show ScrollBar";
            }

            public Object getValue() {
                return DetailedWeekView.this.isShowScrollBar();
            }

            public void setValue(Object value) {
                DetailedWeekView.this.setShowScrollBar((Boolean)value);
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedWeekView.this.showScrollBarProperty());
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DetailedWeekView.this.adjustToFirstDayOfWeekProperty());
            }

            public void setValue(Object value) {
                DetailedWeekView.this.setAdjustToFirstDayOfWeek((Boolean)value);
            }

            public Object getValue() {
                return DetailedWeekView.this.isAdjustToFirstDayOfWeek();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Adjust to first day of week";
            }

            public String getDescription() {
                return "Adjust to first day of week";
            }

            public String getCategory() {
                return DetailedWeekView.WEEK_VIEW_CATEGORY;
            }
        });
        return items;
    }
}

