/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Entry;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;

public final class RequestEvent
extends Event {
    private static final long serialVersionUID = -5343700719205046646L;
    public static final EventType<RequestEvent> REQUEST = new EventType(ANY, "REQUEST");
    public static final EventType<RequestEvent> REQUEST_DATE = new EventType(REQUEST, "REQUEST_DATE");
    public static final EventType<RequestEvent> REQUEST_DATE_TIME = new EventType(REQUEST, "REQUEST_DATE_TIME");
    public static final EventType<RequestEvent> REQUEST_YEAR_MONTH = new EventType(REQUEST, "REQUEST_YEAR_MONTH");
    public static final EventType<RequestEvent> REQUEST_YEAR = new EventType(REQUEST, "REQUEST_YEAR");
    public static final EventType<RequestEvent> REQUEST_WEEK = new EventType(REQUEST, "REQUEST_WEEK");
    public static final EventType<RequestEvent> REQUEST_ENTRY = new EventType(REQUEST, "REQUEST_ENTRY");
    private LocalDate date;
    private LocalDateTime dateTime;
    private YearMonth yearMonth;
    private Year year;
    private Entry<?> entry;
    private int weekOfYear;

    public RequestEvent(Object source, EventTarget target, LocalDate date) {
        super(source, target, REQUEST_DATE);
        this.date = Objects.requireNonNull(date);
    }

    public RequestEvent(Object source, EventTarget target, LocalDateTime dateTime) {
        super(source, target, REQUEST_DATE_TIME);
        this.dateTime = Objects.requireNonNull(dateTime);
    }

    public RequestEvent(Object source, EventTarget target, Year year, int weekOfYear) {
        super(source, target, REQUEST_WEEK);
        this.year = Objects.requireNonNull(year);
        this.weekOfYear = weekOfYear;
    }

    public RequestEvent(Object source, EventTarget target, YearMonth yearMonth) {
        super(source, target, REQUEST_YEAR_MONTH);
        this.yearMonth = Objects.requireNonNull(yearMonth);
    }

    public RequestEvent(Object source, EventTarget target, Year year) {
        super(source, target, REQUEST_YEAR);
        this.year = Objects.requireNonNull(year);
    }

    public RequestEvent(Object source, EventTarget target, Entry<?> entry) {
        super(source, target, REQUEST_ENTRY);
        this.entry = Objects.requireNonNull(entry);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public YearMonth getYearMonth() {
        return this.yearMonth;
    }

    public Year getYear() {
        return this.year;
    }

    public Entry<?> getEntry() {
        return this.entry;
    }

    public int getWeekOfYear() {
        return this.weekOfYear;
    }

    public String toString() {
        return "RequestEvent [date=" + this.date + ", dateTime=" + this.dateTime + ", yearMonth=" + this.yearMonth + ", year=" + this.year + ", entry=" + this.entry + ", weekOfYear" + this.weekOfYear + ", eventType=" + this.eventType + ", target=" + this.target + ", consumed=" + this.consumed + ", source=" + this.source + "]";
    }
}

