/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Marker;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import impl.com.calendarfx.view.ResourceCalendarViewSkin;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class ResourceCalendarView<T>
extends DayViewBase {
    private final BooleanProperty showTimeScale = new SimpleBooleanProperty((Object)this, "showTimeScale", true);
    private final ObservableList<Marker> markers = FXCollections.observableArrayList();
    private final BooleanProperty showScrollBar = new SimpleBooleanProperty((Object)this, "showScrollBar", true);
    private final ObjectProperty<Callback<T, Node>> headerFactory = new SimpleObjectProperty((Object)this, "headerFactory", it -> new Label("Header"));
    private final ReadOnlyMapProperty<T, DayView> dayViewMap = new ReadOnlyMapWrapper((Object)this, "dayViewMap", FXCollections.observableHashMap());
    private final ObservableList<T> resources = FXCollections.observableArrayList();

    public ResourceCalendarView() {
        this.getStyleClass().add((Object)"resource-calendar-view");
        this.setEnableCurrentTimeMarker(false);
        this.setScrollingEnabled(true);
        this.setHourHeight(40.0);
        this.setHoursLayoutStrategy(DayViewBase.HoursLayoutStrategy.FIXED_HOUR_HEIGHT);
        ListChangeListener l = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(resource -> {
                        DayView dayView = new DayView();
                        this.bind(dayView, true);
                        this.partialUnbinding(dayView);
                        this.dayViewMap.put(resource, (Object)dayView);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(resource -> this.dayViewMap.remove(resource));
            }
        };
        this.resources.addListener(l);
    }

    protected Skin<?> createDefaultSkin() {
        return new ResourceCalendarViewSkin(this);
    }

    public BooleanProperty showTimeScaleProperty() {
        return this.showTimeScale;
    }

    public boolean isShowTimeScale() {
        return this.showTimeScale.get();
    }

    public void setShowTimeScale(boolean showTimeScale) {
        this.showTimeScale.set(showTimeScale);
    }

    public final ObservableList<Marker> getMarkers() {
        return this.markers;
    }

    private void partialUnbinding(DayView otherControl) {
        Bindings.unbindBidirectional(otherControl.draggedEntryProperty(), this.draggedEntryProperty());
        Bindings.unbindContentBidirectional(otherControl.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        Bindings.unbindContentBidirectional(otherControl.getCalendarSources(), this.getCalendarSources());
    }

    public final boolean isShowScrollBar() {
        return this.showScrollBar.get();
    }

    public final BooleanProperty showScrollBarProperty() {
        return this.showScrollBar;
    }

    public final void setShowScrollBar(boolean showScrollBar) {
        this.showScrollBar.set(showScrollBar);
    }

    public final Callback<T, Node> getHeaderFactory() {
        return (Callback)this.headerFactory.get();
    }

    public final ObjectProperty<Callback<T, Node>> headerFactoryProperty() {
        return this.headerFactory;
    }

    public final void setHeaderFactory(Callback<T, Node> headerFactory) {
        this.headerFactory.set(headerFactory);
    }

    public final ObservableMap getDayViewMap() {
        return (ObservableMap)this.dayViewMap.get();
    }

    public final ReadOnlyMapProperty<T, DayView> dayViewMapProperty() {
        return this.dayViewMap;
    }

    public final DayView getDayView(T resource) {
        return (DayView)this.dayViewMap.get(resource);
    }

    public final ObservableList<T> getResources() {
        return this.resources;
    }
}

