/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Resource;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.VirtualGrid;
import com.calendarfx.view.WeekDayHeaderView;
import com.calendarfx.view.WeekView;
import impl.com.calendarfx.view.ResourcesViewSkin;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class ResourcesView<T extends Resource<?>>
extends DayViewBase {
    private static final String DEFAULT_STYLE = "resources-view";
    private final ObjectProperty<Type> type = new SimpleObjectProperty((Object)this, "type", (Object)Type.RESOURCES_OVER_DATES);
    private final BooleanProperty adjustToFirstDayOfWeek = new SimpleBooleanProperty((Object)this, "adjustToFirstDayOfWeek", true);
    private final ObjectProperty<Callback<T, AllDayView>> allDayViewFactory = new SimpleObjectProperty((Object)this, "allDayViewFactory", it -> new AllDayView(this.getNumberOfDays()));
    private final ObjectProperty<Callback<T, WeekDayHeaderView>> weekDayHeaderViewFactory = new SimpleObjectProperty((Object)this, "weekDayHeaderViewFactory", it -> new WeekDayHeaderView(this.getNumberOfDays()));
    private final IntegerProperty numberOfDays = new SimpleIntegerProperty((Object)this, "numberOfDays", 7);
    private final ObjectProperty<Callback<T, Node>> resourceHeaderFactory = new SimpleObjectProperty((Object)this, "headerFactory", resource -> {
        Label label = new Label(resource.toString());
        label.setAlignment(Pos.CENTER);
        label.getStyleClass().add((Object)"resource-header");
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return label;
    });
    private final ObservableList<T> resources = FXCollections.observableArrayList();
    private final BooleanProperty showAllDayView = new SimpleBooleanProperty((Object)this, "showAllDayView", true);
    private final BooleanProperty showTimeScaleView = new SimpleBooleanProperty((Object)this, "showTimeScaleView", true);
    private final BooleanProperty showScrollBar = new SimpleBooleanProperty((Object)this, "showScrollBar", true);
    private final ObjectProperty<Callback<T, WeekView>> weekViewFactory = new SimpleObjectProperty((Object)this, "weekViewFactory", resource -> new WeekView(this.getNumberOfDays()));
    private final ObjectProperty<Callback<T, DayView>> dayViewFactory = new SimpleObjectProperty((Object)this, "dayViewFactory", resource -> new DayView());
    private final ObjectProperty<Node> upperLeftCorner = new SimpleObjectProperty((Object)this, "upperLeftCorner");
    private final ObjectProperty<Node> upperRightCorner = new SimpleObjectProperty((Object)this, "upperRightCorner", (Object)new Region());
    private final ObjectProperty<Callback<ResourcesView<T>, Region>> smallSeparatorFactory = new SimpleObjectProperty((Object)this, "smallSeparatorFactory", it -> {
        Region region = new Region();
        region.getStyleClass().add((Object)"small-separator");
        return region;
    });
    private final ObjectProperty<Callback<ResourcesView<T>, Region>> largeSeparatorFactory = new SimpleObjectProperty((Object)this, "largeSeparatorFactory", it -> {
        Region region = new Region();
        region.getStyleClass().add((Object)"large-separator");
        return region;
    });

    public ResourcesView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        this.setShowToday(false);
        this.setGridType(DayViewBase.GridType.CUSTOM);
        this.addEventHandler(RequestEvent.REQUEST_ENTRY, evt -> this.maybeRunAndConsume((RequestEvent)evt, e -> this.editEntry(evt.getEntry(), false)));
        VirtualGrid grid = new VirtualGrid("Editing Grid", "Editing Grid", ChronoUnit.MINUTES, 20);
        this.setVirtualGrid(grid);
        this.setAvailabilityGrid(grid);
        this.setGridLines(grid);
        Label weekNumberLabel = new Label();
        weekNumberLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        weekNumberLabel.getStyleClass().add((Object)"week-number-label");
        weekNumberLabel.setAlignment(Pos.CENTER);
        weekNumberLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> DateTimeFormatter.ofPattern("w").format(this.getDate()), (Observable[])new Observable[]{this.dateProperty()}));
        this.setUpperLeftCorner((Node)weekNumberLabel);
        InvalidationListener adjustListener = it -> this.maybeAdjustToFirstDayOfWeek();
        this.dateProperty().addListener(adjustListener);
        this.adjustToFirstDayOfWeekProperty().addListener(adjustListener);
        this.maybeAdjustToFirstDayOfWeek();
    }

    protected Skin<?> createDefaultSkin() {
        return new ResourcesViewSkin(this);
    }

    private void maybeAdjustToFirstDayOfWeek() {
        if (this.isAdjustToFirstDayOfWeek()) {
            this.setDate(this.getDate().with(TemporalAdjusters.previousOrSame(this.getFirstDayOfWeek())));
        }
    }

    public final Type getType() {
        return (Type)((Object)this.type.get());
    }

    public final ObjectProperty<Type> typeProperty() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type.set((Object)type);
    }

    private void maybeRunAndConsume(RequestEvent evt, Consumer<RequestEvent> consumer) {
        if (!evt.isConsumed()) {
            consumer.accept(evt);
            evt.consume();
        }
    }

    public final BooleanProperty adjustToFirstDayOfWeekProperty() {
        return this.adjustToFirstDayOfWeek;
    }

    public final boolean isAdjustToFirstDayOfWeek() {
        return this.adjustToFirstDayOfWeekProperty().get();
    }

    public final void setAdjustToFirstDayOfWeek(boolean adjust) {
        this.adjustToFirstDayOfWeekProperty().set(adjust);
    }

    public final Callback<T, AllDayView> getAllDayViewFactory() {
        return (Callback)this.allDayViewFactory.get();
    }

    public final ObjectProperty<Callback<T, AllDayView>> allDayViewFactoryProperty() {
        return this.allDayViewFactory;
    }

    public final void setAllDayViewFactory(Callback<T, AllDayView> allDayViewFactory) {
        this.allDayViewFactory.set(allDayViewFactory);
    }

    public final Callback<T, WeekDayHeaderView> getWeekDayHeaderViewFactory() {
        return (Callback)this.weekDayHeaderViewFactory.get();
    }

    public final ObjectProperty<Callback<T, WeekDayHeaderView>> weekDayHeaderViewFactoryProperty() {
        return this.weekDayHeaderViewFactory;
    }

    public final void setWeekDayHeaderViewFactory(Callback<T, WeekDayHeaderView> factory) {
        this.weekDayHeaderViewFactory.set(factory);
    }

    public final IntegerProperty numberOfDaysProperty() {
        return this.numberOfDays;
    }

    public final int getNumberOfDays() {
        return this.numberOfDaysProperty().get();
    }

    public final void setNumberOfDays(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("invalid number of days, must be larger than 0 but was " + number);
        }
        this.numberOfDaysProperty().set(number);
    }

    public final Callback<T, Node> getResourceHeaderFactory() {
        return (Callback)this.resourceHeaderFactory.get();
    }

    public final ObjectProperty<Callback<T, Node>> resourceHeaderFactoryProperty() {
        return this.resourceHeaderFactory;
    }

    public final void setResourceHeaderFactory(Callback<T, Node> resourceHeaderFactory) {
        this.resourceHeaderFactory.set(resourceHeaderFactory);
    }

    public final ObservableList<T> getResources() {
        return this.resources;
    }

    public final BooleanProperty showAllDayViewProperty() {
        return this.showAllDayView;
    }

    public final boolean isShowAllDayView() {
        return this.showAllDayViewProperty().get();
    }

    public final void setShowAllDayView(boolean show) {
        this.showAllDayViewProperty().set(show);
    }

    public final BooleanProperty showTimeScaleViewProperty() {
        return this.showTimeScaleView;
    }

    public final boolean isShowTimeScaleView() {
        return this.showTimeScaleViewProperty().get();
    }

    public final void setShowTimeScaleView(boolean show) {
        this.showTimeScaleViewProperty().set(show);
    }

    public final BooleanProperty showScrollBarProperty() {
        return this.showScrollBar;
    }

    public final void setShowScrollBar(boolean showScrollBar) {
        this.showScrollBar.set(showScrollBar);
    }

    public final boolean isShowScrollBar() {
        return this.showScrollBar.get();
    }

    public final Callback<T, WeekView> getWeekViewFactory() {
        return (Callback)this.weekViewFactory.get();
    }

    public final ObjectProperty<Callback<T, WeekView>> weekViewFactoryProperty() {
        return this.weekViewFactory;
    }

    public void setWeekViewFactory(Callback<T, WeekView> weekViewFactory) {
        this.weekViewFactory.set(weekViewFactory);
    }

    public final Callback<T, DayView> getDayViewFactory() {
        return (Callback)this.dayViewFactory.get();
    }

    public final ObjectProperty<Callback<T, DayView>> dayViewFactoryProperty() {
        return this.dayViewFactory;
    }

    public void setDayViewFactory(Callback<T, DayView> dayViewFactory) {
        this.dayViewFactory.set(dayViewFactory);
    }

    public final Node getUpperLeftCorner() {
        return (Node)this.upperLeftCorner.get();
    }

    public final ObjectProperty<Node> upperLeftCornerProperty() {
        return this.upperLeftCorner;
    }

    public final void setUpperLeftCorner(Node upperLeftCorner) {
        this.upperLeftCorner.set((Object)upperLeftCorner);
    }

    public final Node getUpperRightCorner() {
        return (Node)this.upperRightCorner.get();
    }

    public final ObjectProperty<Node> upperRightCornerProperty() {
        return this.upperRightCorner;
    }

    public final void setUpperRightCorner(Node upperRightCorner) {
        this.upperRightCorner.set((Object)upperRightCorner);
    }

    public final Callback<ResourcesView<T>, Region> getSmallSeparatorFactory() {
        return (Callback)this.smallSeparatorFactory.get();
    }

    public final ObjectProperty<Callback<ResourcesView<T>, Region>> smallSeparatorFactoryProperty() {
        return this.smallSeparatorFactory;
    }

    public final void setSmallSeparatorFactory(Callback<ResourcesView<T>, Region> smallSeparatorFactory) {
        this.smallSeparatorFactory.set(smallSeparatorFactory);
    }

    public final Callback<ResourcesView<T>, Region> getLargeSeparatorFactory() {
        return (Callback)this.largeSeparatorFactory.get();
    }

    public final ObjectProperty<Callback<ResourcesView<T>, Region>> largeSeparatorFactoryProperty() {
        return this.largeSeparatorFactory;
    }

    public final void setLargeSeparatorFactory(Callback<ResourcesView<T>, Region> largeSeparatorFactory) {
        this.largeSeparatorFactory.set(largeSeparatorFactory);
    }

    public static enum Type {
        RESOURCES_OVER_DATES,
        DATES_OVER_RESOURCES;

    }
}

