/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import impl.com.calendarfx.view.WeekDayHeaderViewSkin;
import impl.com.calendarfx.view.util.Util;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class WeekDayHeaderView
extends DateControl {
    private static final String DEFAULT_STYLE_CLASS = "weekday-header-view";
    private final ObjectProperty<Callback<WeekDayHeaderView, WeekDayHeaderCell>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final ObjectProperty<Callback<WeekDayHeaderView, Region>> separatorFactory = new SimpleObjectProperty((Object)this, "separatorFactory", it -> {
        Region region = new Region();
        region.getStyleClass().add((Object)"weekday-separator");
        return region;
    });
    private final IntegerProperty numberOfDays = new SimpleIntegerProperty((Object)this, "numberOfDays", 7);
    private final BooleanProperty adjustToFirstDayOfWeek = new SimpleBooleanProperty((Object)this, "adjustToFirstDayOfWeek", true);
    private final ReadOnlyObjectWrapper<LocalDate> startDate = new ReadOnlyObjectWrapper((Object)this, "startDate");
    private final ReadOnlyObjectWrapper<LocalDate> endDate = new ReadOnlyObjectWrapper((Object)this, "endDate");
    private static final String WEEK_DAY_HEADER_VIEW_CATEGORY = "Week Day Header View";

    public WeekDayHeaderView(int numberOfDays) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setNumberOfDays(numberOfDays);
        this.dateProperty().addListener(it -> {
            LocalDate date = this.getDate();
            if (this.isAdjustToFirstDayOfWeek()) {
                date = Util.adjustToFirstDayOfWeek(date, this.getFirstDayOfWeek());
            }
            this.startDate.set((Object)date);
            this.endDate.set((Object)date.plusDays(this.getNumberOfDays() - 1));
        });
        this.startDate.set((Object)this.getDate());
        this.endDate.set((Object)this.getDate().plusDays(this.getNumberOfDays() - 1));
        this.setCellFactory((Callback<WeekDayHeaderView, WeekDayHeaderCell>)((Callback)date -> new WeekDayHeaderCell(this)));
    }

    public WeekDayHeaderView() {
        this(7);
    }

    protected Skin<?> createDefaultSkin() {
        return new WeekDayHeaderViewSkin(this);
    }

    public final ObjectProperty<Callback<WeekDayHeaderView, WeekDayHeaderCell>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final Callback<WeekDayHeaderView, WeekDayHeaderCell> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public final void setCellFactory(Callback<WeekDayHeaderView, WeekDayHeaderCell> factory) {
        Objects.requireNonNull(factory);
        this.cellFactoryProperty().set(factory);
    }

    public final Callback<WeekDayHeaderView, Region> getSeparatorFactory() {
        return (Callback)this.separatorFactory.get();
    }

    public final ObjectProperty<Callback<WeekDayHeaderView, Region>> separatorFactoryProperty() {
        return this.separatorFactory;
    }

    public final void setSeparatorFactory(Callback<WeekDayHeaderView, Region> separatorFactory) {
        this.separatorFactory.set(separatorFactory);
    }

    public final IntegerProperty numberOfDaysProperty() {
        return this.numberOfDays;
    }

    public final int getNumberOfDays() {
        return this.numberOfDaysProperty().get();
    }

    public final void setNumberOfDays(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("invalid number of days, must be larger than 0 but was " + number);
        }
        this.numberOfDaysProperty().set(number);
    }

    public final BooleanProperty adjustToFirstDayOfWeekProperty() {
        return this.adjustToFirstDayOfWeek;
    }

    public final boolean isAdjustToFirstDayOfWeek() {
        return this.adjustToFirstDayOfWeekProperty().get();
    }

    public final void setAdjustToFirstDayOfWeek(boolean adjust) {
        this.adjustToFirstDayOfWeekProperty().set(adjust);
    }

    public final ReadOnlyObjectProperty<LocalDate> startDateProperty() {
        return this.startDate;
    }

    public final LocalDate getStartDate() {
        return (LocalDate)this.startDate.get();
    }

    public final ReadOnlyObjectProperty<LocalDate> endDateProperty() {
        return this.endDate;
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(WeekDayHeaderView.this.numberOfDaysProperty());
            }

            public void setValue(Object value) {
                WeekDayHeaderView.this.setNumberOfDays((Integer)value);
            }

            public Object getValue() {
                return WeekDayHeaderView.this.getNumberOfDays();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Number of Days";
            }

            public String getDescription() {
                return "Number of Days";
            }

            public String getCategory() {
                return WeekDayHeaderView.WEEK_DAY_HEADER_VIEW_CATEGORY;
            }
        });
        return items;
    }

    public static class WeekDayHeaderCell
    extends Label {
        private final ObjectProperty<DateTimeFormatter> formatter = new SimpleObjectProperty((Object)this, "", (Object)DateTimeFormatter.ofPattern(Messages.getString("WeekDayHeaderView.CELL_DATE_FORMAT")));
        private final ObjectProperty<LocalDate> date = new SimpleObjectProperty((Object)this, "date", (Object)LocalDate.now());

        public WeekDayHeaderCell(WeekDayHeaderView view) {
            Objects.requireNonNull(view);
            this.getStyleClass().add((Object)"cell");
            this.setMaxWidth(Double.MAX_VALUE);
            this.dateProperty().addListener(it -> this.setText(this.getFormatter().format(this.getDate())));
            if (view.isEnableHyperlinks()) {
                this.getStyleClass().add((Object)"date-hyperlink");
                this.setOnMouseClicked(evt -> {
                    if (evt.getButton() == MouseButton.PRIMARY && evt.getClickCount() == 1) {
                        this.fireEvent(new RequestEvent((Object)this, (EventTarget)this, this.getDate()));
                    }
                });
            }
        }

        public final DateTimeFormatter getFormatter() {
            return (DateTimeFormatter)this.formatter.get();
        }

        public final ObjectProperty<DateTimeFormatter> formatterProperty() {
            return this.formatter;
        }

        public final void setFormatter(DateTimeFormatter formatter) {
            this.formatter.set((Object)formatter);
        }

        public final ObjectProperty<LocalDate> dateProperty() {
            return this.date;
        }

        public final void setDate(LocalDate date) {
            this.dateProperty().set((Object)date);
        }

        public final LocalDate getDate() {
            return (LocalDate)this.dateProperty().get();
        }
    }
}

