/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.view.CalendarView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.popover.EntriesPane;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.controlsfx.control.PopOver;

public class DatePopOver
extends PopOver {
    private final DateControl dateControl;
    private final LocalDate date;

    public DatePopOver(DateControl control, LocalDate date) {
        this.dateControl = Objects.requireNonNull(control);
        this.date = Objects.requireNonNull(date);
        EntriesPane entriesPane = new EntriesPane(control);
        this.getRoot().getStylesheets().add((Object)CalendarView.class.getResource("calendar.css").toExternalForm());
        this.getRoot().getStyleClass().add((Object)"root");
        List<Entry<?>> entries = this.findEntries();
        if (entries == null || entries.isEmpty()) {
            Label label = new Label();
            label.setText("No Entries");
            label.getStyleClass().add((Object)"no-entries-label");
            this.setContentNode((Node)label);
        } else {
            entriesPane.getEntries().setAll(entries);
            this.setContentNode((Node)entriesPane);
        }
        this.getStyleClass().add((Object)"date-popover");
        this.setArrowIndent(4.0);
        this.setDetachable(false);
        this.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
        this.setCornerRadius(4.0);
    }

    public final DateControl getDateControl() {
        return this.dateControl;
    }

    public final LocalDate getDate() {
        return this.date;
    }

    private List<Entry<?>> findEntries() {
        ArrayList result = new ArrayList();
        for (CalendarSource source : this.dateControl.getCalendarSources()) {
            for (Calendar calendar : source.getCalendars()) {
                try {
                    Map<LocalDate, List<Entry<?>>> entriesMap = calendar.findEntries(this.date, this.date, this.dateControl.getZoneId());
                    List<Entry<?>> entriesList = entriesMap.get(this.date);
                    if (entriesList == null) continue;
                    for (Entry<?> entry : entriesList) {
                        result.add(entry);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(result);
        return result;
    }
}

