/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Entry;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RecurrenceView;
import com.calendarfx.view.TimeField;
import com.calendarfx.view.popover.EntryMapView;
import com.calendarfx.view.popover.EntryPopOverPane;
import com.calendarfx.view.popover.RecurrencePopup;
import com.calendarfx.view.popover.ZoneIdComparator;
import impl.com.calendarfx.view.ZoneIdStringConverter;
import impl.com.calendarfx.view.util.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Comparator;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class EntryDetailsView
extends EntryPopOverPane {
    private final Label summaryLabel;
    private final MenuButton recurrenceButton;
    private final TimeField startTimeField = new TimeField();
    private final TimeField endTimeField = new TimeField();
    private final DatePicker startDatePicker = new DatePicker();
    private final DatePicker endDatePicker = new DatePicker();
    private final ComboBox<ZoneId> zoneBox = new ComboBox();
    private final Entry<?> entry;
    private boolean updatingFields;
    private final InvalidationListener entryIntervalListener = it -> {
        this.updatingFields = true;
        try {
            Entry<?> entry = this.getEntry();
            this.startTimeField.setValue(entry.getStartTime());
            this.endTimeField.setValue(entry.getEndTime());
            this.startDatePicker.setValue((Object)entry.getStartDate());
            this.endDatePicker.setValue((Object)entry.getEndDate());
            this.zoneBox.setValue((Object)entry.getZoneId());
        }
        finally {
            this.updatingFields = false;
        }
    };
    private final WeakInvalidationListener weakEntryIntervalListener = new WeakInvalidationListener(this.entryIntervalListener);
    private final InvalidationListener recurrenceRuleListener = it -> this.updateRecurrenceRuleButton(this.getEntry());
    private final WeakInvalidationListener weakRecurrenceRuleListener = new WeakInvalidationListener(this.recurrenceRuleListener);
    private final InvalidationListener updateSummaryLabelListener = it -> this.updateSummaryLabel(this.getEntry());
    private final WeakInvalidationListener weakUpdateSummaryLabelListener = new WeakInvalidationListener(this.updateSummaryLabelListener);

    public EntryDetailsView(Entry<?> entry, DateControl dateControl) {
        this.entry = entry;
        this.getStyleClass().add((Object)"entry-details-view");
        Label fullDayLabel = new Label(Messages.getString("EntryDetailsView.FULL_DAY"));
        Label startDateLabel = new Label(Messages.getString("EntryDetailsView.FROM"));
        Label endDateLabel = new Label(Messages.getString("EntryDetailsView.TO"));
        Label recurrentLabel = new Label(Messages.getString("EntryDetailsView.REPEAT"));
        this.summaryLabel = new Label();
        this.summaryLabel.getStyleClass().add((Object)"recurrence-summary-label");
        this.summaryLabel.setWrapText(true);
        this.summaryLabel.setMaxWidth(300.0);
        CheckBox fullDay = new CheckBox();
        fullDay.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        this.startTimeField.setValue(entry.getStartTime());
        this.startTimeField.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        this.endTimeField.setValue(entry.getEndTime());
        this.endTimeField.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        this.startDatePicker.setValue((Object)entry.getStartDate());
        this.startDatePicker.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        this.endDatePicker.setValue((Object)entry.getEndDate());
        this.endDatePicker.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        entry.intervalProperty().addListener((InvalidationListener)this.weakEntryIntervalListener);
        HBox startDateBox = new HBox(10.0);
        HBox endDateBox = new HBox(10.0);
        startDateBox.setAlignment(Pos.CENTER_LEFT);
        endDateBox.setAlignment(Pos.CENTER_LEFT);
        startDateBox.getChildren().addAll((Object[])new Node[]{startDateLabel, this.startDatePicker, this.startTimeField});
        endDateBox.getChildren().addAll((Object[])new Node[]{endDateLabel, this.endDatePicker, this.endTimeField});
        fullDay.setSelected(entry.isFullDay());
        this.startDatePicker.setValue((Object)entry.getStartDate());
        this.endDatePicker.setValue((Object)entry.getEndDate());
        Label zoneLabel = new Label(Messages.getString("EntryDetailsView.TIMEZONE"));
        zoneLabel.visibleProperty().bind((ObservableValue)dateControl.enableTimeZoneSupportProperty());
        zoneLabel.managedProperty().bind((ObservableValue)dateControl.enableTimeZoneSupportProperty());
        SortedList sortedZones = new SortedList(dateControl.getAvailableZoneIds());
        sortedZones.setComparator((Comparator)new ZoneIdComparator());
        this.zoneBox.setItems((ObservableList)sortedZones);
        this.zoneBox.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        this.zoneBox.setConverter((StringConverter)new ZoneIdStringConverter());
        this.zoneBox.setValue((Object)entry.getZoneId());
        this.zoneBox.visibleProperty().bind((ObservableValue)dateControl.enableTimeZoneSupportProperty());
        this.zoneBox.managedProperty().bind((ObservableValue)dateControl.enableTimeZoneSupportProperty());
        this.recurrenceButton = new MenuButton(Messages.getString("EntryDetailsView.MENU_BUTTON_NONE"));
        MenuItem none = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_NONE"));
        MenuItem everyDay = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_DAY"));
        MenuItem everyWeek = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_WEEK"));
        MenuItem everyMonth = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_MONTH"));
        MenuItem everyYear = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_YEAR"));
        MenuItem custom = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_CUSTOM"));
        none.setOnAction(evt -> this.updateRecurrenceRule(entry, null));
        everyDay.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=DAILY"));
        everyWeek.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=WEEKLY"));
        everyMonth.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=MONTHLY"));
        everyYear.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=YEARLY"));
        custom.setOnAction(evt -> this.showRecurrenceEditor(entry));
        this.recurrenceButton.getItems().setAll((Object[])new MenuItem[]{none, everyDay, everyWeek, everyMonth, everyYear, new SeparatorMenuItem(), custom});
        this.recurrenceButton.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        EntryMapView mapView = new EntryMapView(entry);
        GridPane box = new GridPane();
        box.getStyleClass().add((Object)"content");
        box.add((Node)fullDayLabel, 0, 0);
        box.add((Node)fullDay, 1, 0);
        box.add((Node)startDateLabel, 0, 1);
        box.add((Node)startDateBox, 1, 1);
        box.add((Node)endDateLabel, 0, 2);
        box.add((Node)endDateBox, 1, 2);
        box.add((Node)zoneLabel, 0, 3);
        box.add(this.zoneBox, 1, 3);
        box.add((Node)recurrentLabel, 0, 4);
        box.add((Node)this.recurrenceButton, 1, 4);
        box.add((Node)this.summaryLabel, 1, 5);
        box.add((Node)mapView, 1, 6);
        GridPane.setFillWidth(this.zoneBox, (Boolean)true);
        GridPane.setHgrow(this.zoneBox, (Priority)Priority.ALWAYS);
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        col1.setHalignment(HPos.RIGHT);
        col2.setHalignment(HPos.LEFT);
        box.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.getChildren().add((Object)box);
        this.startTimeField.visibleProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)entry.fullDayProperty()));
        this.endTimeField.visibleProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)entry.fullDayProperty()));
        this.startDatePicker.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (!this.updatingFields) {
                this.startDatePicker.getEditor().setText(this.startDatePicker.getConverter().toString(newValue));
                entry.changeStartDate((LocalDate)newValue, true);
            }
        });
        this.startTimeField.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (!this.updatingFields) {
                entry.changeStartTime((LocalTime)newValue, true);
            }
        });
        this.endDatePicker.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (!this.updatingFields) {
                this.endDatePicker.getEditor().setText(this.endDatePicker.getConverter().toString(newValue));
                entry.changeEndDate((LocalDate)newValue, false);
            }
        });
        this.endTimeField.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (!this.updatingFields) {
                entry.changeEndTime((LocalTime)newValue, false);
            }
        });
        this.zoneBox.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (!this.updatingFields && this.zoneBox.getValue() != null) {
                entry.changeZoneId((ZoneId)newValue);
            }
        });
        fullDay.setOnAction(evt -> entry.setFullDay(fullDay.isSelected()));
        entry.recurrenceRuleProperty().addListener((InvalidationListener)this.weakRecurrenceRuleListener);
        this.updateRecurrenceRuleButton(entry);
        this.updateSummaryLabel(entry);
        entry.recurrenceRuleProperty().addListener((InvalidationListener)this.weakUpdateSummaryLabelListener);
    }

    public final Entry<?> getEntry() {
        return this.entry;
    }

    private void updateSummaryLabel(Entry<?> entry) {
        String rule = entry.getRecurrenceRule();
        if (rule != null && !rule.trim().equals("")) {
            String text = Util.convertRFC2445ToText(rule, entry.getStartDate());
            this.summaryLabel.setText(text);
            this.summaryLabel.setVisible(true);
            this.summaryLabel.setManaged(true);
        } else {
            this.summaryLabel.setText("");
            this.summaryLabel.setVisible(false);
            this.summaryLabel.setManaged(false);
        }
    }

    private void showRecurrenceEditor(Entry<?> entry) {
        RecurrencePopup popup = new RecurrencePopup();
        RecurrenceView recurrenceView = popup.getRecurrenceView();
        String recurrenceRule = entry.getRecurrenceRule();
        if (recurrenceRule == null || recurrenceRule.trim().equals("")) {
            recurrenceRule = "RRULE:FREQ=DAILY;";
        }
        recurrenceView.setRecurrenceRule(recurrenceRule);
        popup.setOnOkPressed((EventHandler<RecurrencePopup.RecurrencePopupEvent>)((EventHandler)evt -> {
            String rrule = recurrenceView.getRecurrenceRule();
            entry.setRecurrenceRule(rrule);
        }));
        Point2D anchor = this.recurrenceButton.localToScreen(0.0, this.recurrenceButton.getHeight());
        popup.show((Node)this.recurrenceButton, anchor.getX(), anchor.getY());
    }

    private void updateRecurrenceRule(Entry<?> entry, String rule) {
        entry.setRecurrenceRule(rule);
    }

    private void updateRecurrenceRuleButton(Entry<?> entry) {
        String rule = entry.getRecurrenceRule();
        if (rule == null) {
            this.recurrenceButton.setText(Messages.getString("EntryDetailsView.NONE"));
        } else {
            switch (rule.trim().toUpperCase()) {
                case "RRULE:FREQ=DAILY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.DAILY"));
                    break;
                }
                case "RRULE:FREQ=WEEKLY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.WEEKLY"));
                    break;
                }
                case "RRULE:FREQ=MONTHLY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.MONTHLY"));
                    break;
                }
                case "RRULE:FREQ=YEARLY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.YEARLY"));
                    break;
                }
                default: {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.CUSTOM"));
                }
            }
        }
    }
}

