/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;

public class PopOverContentPane
extends BorderPane {
    private final ObjectProperty<Node> header = new SimpleObjectProperty((Object)this, "header");
    private final ObjectProperty<Node> footer = new SimpleObjectProperty((Object)this, "footer");
    private final ObservableList<TitledPane> panes = FXCollections.observableArrayList();
    private final ObjectProperty<TitledPane> expandedPane = new SimpleObjectProperty((Object)this, "expandedPane");

    public PopOverContentPane() {
        this.topProperty().bind(this.headerProperty());
        Accordion accordion = new Accordion();
        accordion.getStyleClass().add((Object)"popover-accordion");
        this.setCenter((Node)accordion);
        Bindings.bindContentBidirectional(this.getPanes(), (ObservableList)accordion.getPanes());
        Bindings.bindBidirectional(this.expandedPaneProperty(), (Property)accordion.expandedPaneProperty());
        this.bottomProperty().bind(this.footerProperty());
        this.headerProperty().addListener((value, oldNode, newNode) -> {
            if (newNode != null) {
                String style = "popover-header";
                if (!newNode.getStyleClass().contains((Object)style)) {
                    newNode.getStyleClass().add((Object)style);
                }
            }
        });
        this.footerProperty().addListener((value, oldNode, newNode) -> {
            if (newNode != null) {
                String style = "popover-footer";
                if (!newNode.getStyleClass().contains((Object)style)) {
                    newNode.getStyleClass().add((Object)style);
                }
            }
        });
    }

    public final ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public final Node getHeader() {
        return (Node)this.headerProperty().get();
    }

    public final void setHeader(Node node) {
        this.headerProperty().set((Object)node);
    }

    public final ObjectProperty<Node> footerProperty() {
        return this.footer;
    }

    public final Node getFooter() {
        return (Node)this.footerProperty().get();
    }

    public final void setFooter(Node node) {
        this.footerProperty().set((Object)node);
    }

    public final ObservableList<TitledPane> getPanes() {
        return this.panes;
    }

    public final ObjectProperty<TitledPane> expandedPaneProperty() {
        return this.expandedPane;
    }

    public final void setExpandedPane(TitledPane titledPane) {
        this.expandedPaneProperty().set((Object)titledPane);
    }

    public final TitledPane getExpandedPane() {
        return (TitledPane)this.expandedPane.get();
    }
}

