/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.print;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.DetailedDayView;
import com.calendarfx.view.DetailedWeekView;
import com.calendarfx.view.MonthView;
import com.calendarfx.view.print.PaperView;
import com.calendarfx.view.print.ViewType;
import impl.com.calendarfx.view.print.PrintablePageSkin;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class PrintablePage
extends DateControl {
    public static final String DEFAULT_STYLE = "print-page";
    public static final String INVALID_MARGIN = "The margin is invalid: ";
    private final PrintPeriodSplitter periodSplitter;
    private final DetailedDayView detailedDayView;
    private final DetailedWeekView detailedWeekView;
    private final MonthView monthView;
    private final ObjectProperty<Map<ViewType, DateTimeFormatter>> formatterMapProperty = new SimpleObjectProperty((Object)this, "formatterMapProperty");
    private final WeakEventHandler<MouseEvent> weakMouseHandler = new WeakEventHandler(Event::consume);
    private final ObjectProperty<ViewType> viewType = new SimpleObjectProperty<ViewType>((Object)this, "viewType", ViewType.DAY_VIEW){

        public void set(ViewType newValue) {
            super.set((Object)Objects.requireNonNull(newValue));
        }
    };
    private final ReadOnlyObjectWrapper<DateControl> view = new ReadOnlyObjectWrapper<DateControl>((Object)this, "view"){

        public void set(DateControl newValue) {
            super.set((Object)Objects.requireNonNull(newValue));
        }
    };
    private final ObjectProperty<PaperView.MarginType> marginType = new SimpleObjectProperty<PaperView.MarginType>((Object)this, "marginType", PaperView.MarginType.DEFAULT){

        public void set(PaperView.MarginType newValue) {
            super.set((Object)Objects.requireNonNull(newValue));
        }
    };
    private final DoubleProperty topMargin = new SimpleDoubleProperty((Object)this, "topMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException(PrintablePage.INVALID_MARGIN + newValue);
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty rightMargin = new SimpleDoubleProperty((Object)this, "rightMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException(PrintablePage.INVALID_MARGIN + newValue);
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty bottomMargin = new SimpleDoubleProperty((Object)this, "bottomMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException(PrintablePage.INVALID_MARGIN + newValue);
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty leftMargin = new SimpleDoubleProperty((Object)this, "leftMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException(PrintablePage.INVALID_MARGIN + newValue);
            }
            super.set(newValue);
        }
    };
    private final ObjectProperty<LocalDate> printStartDate = new SimpleObjectProperty<LocalDate>((Object)this, "printStartDate", this.getToday()){

        public void set(LocalDate newValue) {
            super.set((Object)Objects.requireNonNull(newValue));
        }
    };
    private final ObjectProperty<LocalDate> printEndDate = new SimpleObjectProperty<LocalDate>((Object)this, "printEndDate", this.getToday()){

        public void set(LocalDate newValue) {
            super.set((Object)Objects.requireNonNull(newValue));
        }
    };
    private final ReadOnlyObjectWrapper<LocalDate> pageStartDate = new ReadOnlyObjectWrapper((Object)this, "pageStartDate", (Object)this.getToday());
    private final ReadOnlyObjectWrapper<LocalDate> pageEndDate = new ReadOnlyObjectWrapper((Object)this, "pageEndDate", (Object)this.getToday());
    private final ObjectProperty<Paper> paper = new SimpleObjectProperty<Paper>((Object)this, "paper", Paper.A4){

        public void set(Paper newValue) {
            super.set((Object)Objects.requireNonNull(newValue));
        }
    };
    private final BooleanProperty showAllDayEntries = new SimpleBooleanProperty((Object)this, "showAllDayEntries", true);
    private final BooleanProperty showMiniCalendars = new SimpleBooleanProperty((Object)this, "showMiniCalendars", true);
    private final BooleanProperty showCalendarKeys = new SimpleBooleanProperty((Object)this, "showCalendarKeys", true);
    private final BooleanProperty showTimedEntries = new SimpleBooleanProperty((Object)this, "showTimedEntries", true);
    private final BooleanProperty showEntryDetails = new SimpleBooleanProperty((Object)this, "showEntryDetails", true);
    private final ReadOnlyIntegerWrapper pageNumber = new ReadOnlyIntegerWrapper((Object)this, "pageNumber");
    private final ReadOnlyIntegerWrapper totalPages = new ReadOnlyIntegerWrapper((Object)this, "totalPages");

    public PrintablePage() {
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        this.addEventFilter(KeyEvent.ANY, Event::consume);
        this.setFocusTraversable(false);
        this.detailedDayView = this.createDetailedDayView();
        Bindings.bindContent(this.detailedDayView.getCalendarSources(), this.getCalendarSources());
        Bindings.bindContent(this.detailedDayView.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        this.detailedWeekView = this.createDetailedWeekView();
        Bindings.bindContent(this.detailedWeekView.getCalendarSources(), this.getCalendarSources());
        Bindings.bindContent(this.detailedWeekView.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        this.monthView = this.createMonthView();
        Bindings.bindContent(this.monthView.getCalendarSources(), this.getCalendarSources());
        Bindings.bindContentBidirectional(this.monthView.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        this.updateView();
        this.updateDimension();
        this.paperProperty().addListener(obs -> this.updateDimension());
        this.viewTypeProperty().addListener(obs -> this.updateView());
        this.periodSplitter = new PrintPeriodSplitter(this);
        this.formatterMapProperty.set(new HashMap());
    }

    protected Skin<?> createDefaultSkin() {
        return new PrintablePageSkin(this);
    }

    public final DetailedDayView getDayView() {
        return this.detailedDayView;
    }

    public final DetailedWeekView getWeekView() {
        return this.detailedWeekView;
    }

    public final MonthView getMonthView() {
        return this.monthView;
    }

    public final ObjectProperty<ViewType> viewTypeProperty() {
        return this.viewType;
    }

    public final ViewType getViewType() {
        return (ViewType)((Object)this.viewTypeProperty().get());
    }

    public final void setViewType(ViewType viewType) {
        this.viewTypeProperty().set((Object)viewType);
    }

    public final ReadOnlyObjectProperty<DateControl> viewProperty() {
        return this.view.getReadOnlyProperty();
    }

    public final DateControl getView() {
        return (DateControl)((Object)this.view.get());
    }

    private void setView(DateControl view) {
        this.view.set((Object)view);
    }

    public final ObjectProperty<PaperView.MarginType> marginTypeProperty() {
        return this.marginType;
    }

    public final PaperView.MarginType getMarginType() {
        return (PaperView.MarginType)((Object)this.marginTypeProperty().get());
    }

    public final void setMarginType(PaperView.MarginType type) {
        this.marginTypeProperty().set((Object)type);
    }

    public ObjectProperty<Map<ViewType, DateTimeFormatter>> formatterMapProperty() {
        return this.formatterMapProperty;
    }

    public Map<ViewType, DateTimeFormatter> getFormatterMap() {
        return (Map)this.formatterMapProperty.get();
    }

    public void setDayDateTimeFormatter(DateTimeFormatter formatter) {
        if (this.getFormatterMap().get((Object)ViewType.DAY_VIEW) == null) {
            this.getFormatterMap().put(ViewType.DAY_VIEW, formatter);
        } else {
            this.getFormatterMap().replace(ViewType.DAY_VIEW, formatter);
        }
    }

    public void setWeekDateTimeFormatter(DateTimeFormatter formatter) {
        if (this.getFormatterMap().get((Object)ViewType.WEEK_VIEW) == null) {
            this.getFormatterMap().put(ViewType.WEEK_VIEW, formatter);
        } else {
            this.getFormatterMap().replace(ViewType.WEEK_VIEW, formatter);
        }
    }

    public void setMonthDateTimeFormatter(DateTimeFormatter formatter) {
        if (this.getFormatterMap().get((Object)ViewType.MONTH_VIEW) == null) {
            this.getFormatterMap().put(ViewType.MONTH_VIEW, formatter);
        } else {
            this.getFormatterMap().replace(ViewType.MONTH_VIEW, formatter);
        }
    }

    public final DoubleProperty topMarginProperty() {
        return this.topMargin;
    }

    public final double getTopMargin() {
        return this.topMarginProperty().get();
    }

    public final void setTopMargin(double margin) {
        this.topMarginProperty().set(margin);
    }

    public final DoubleProperty rightMarginProperty() {
        return this.rightMargin;
    }

    public final double getRightMargin() {
        return this.rightMarginProperty().get();
    }

    public final void setRightMargin(double margin) {
        this.rightMarginProperty().set(margin);
    }

    public final DoubleProperty bottomMarginProperty() {
        return this.bottomMargin;
    }

    public final double getBottomMargin() {
        return this.bottomMarginProperty().get();
    }

    public final void setBottomMargin(double margin) {
        this.bottomMarginProperty().set(margin);
    }

    public final DoubleProperty leftMarginProperty() {
        return this.leftMargin;
    }

    public final double getLeftMargin() {
        return this.leftMarginProperty().get();
    }

    public final void setLeftMargin(double margin) {
        this.leftMarginProperty().set(margin);
    }

    public final ObjectProperty<LocalDate> printStartDateProperty() {
        return this.printStartDate;
    }

    public final LocalDate getPrintStartDate() {
        return (LocalDate)this.printStartDateProperty().get();
    }

    public final void setPrintStartDate(LocalDate date) {
        this.printStartDateProperty().set((Object)date);
    }

    public final ObjectProperty<LocalDate> printEndDateProperty() {
        return this.printEndDate;
    }

    public final LocalDate getPrintEndDate() {
        return (LocalDate)this.printEndDateProperty().get();
    }

    public final void setPrintEndDate(LocalDate date) {
        this.printEndDateProperty().set((Object)date);
    }

    public final ReadOnlyObjectProperty<LocalDate> pageStartDateProperty() {
        return this.pageStartDate.getReadOnlyProperty();
    }

    public final LocalDate getPageStartDate() {
        return (LocalDate)this.pageStartDate.get();
    }

    public void setPageStartDate(LocalDate date) {
        this.pageStartDate.set((Object)date);
    }

    public final ReadOnlyObjectProperty<LocalDate> pageEndDateProperty() {
        return this.pageEndDate.getReadOnlyProperty();
    }

    public final LocalDate getPageEndDate() {
        return (LocalDate)this.pageEndDate.get();
    }

    private void setPageEndDate(LocalDate date) {
        this.pageEndDate.set((Object)date);
    }

    public final ObjectProperty<Paper> paperProperty() {
        return this.paper;
    }

    public final Paper getPaper() {
        return (Paper)this.paperProperty().get();
    }

    public final void setPaper(Paper paper) {
        this.paperProperty().set((Object)paper);
    }

    public final BooleanProperty showAllDayEntriesProperty() {
        return this.showAllDayEntries;
    }

    public final boolean isShowAllDayEntries() {
        return this.showAllDayEntriesProperty().get();
    }

    public final void setShowAllDayEntries(boolean show) {
        this.showAllDayEntriesProperty().set(show);
    }

    public final BooleanProperty showMiniCalendarsProperty() {
        return this.showMiniCalendars;
    }

    public final boolean isShowMiniCalendars() {
        return this.showMiniCalendarsProperty().get();
    }

    public final void setShowMiniCalendars(boolean show) {
        this.showMiniCalendarsProperty().set(show);
    }

    public final BooleanProperty showCalendarKeysProperty() {
        return this.showCalendarKeys;
    }

    public final boolean isShowCalendarKeys() {
        return this.showCalendarKeysProperty().get();
    }

    public final void setShowCalendarKeys(boolean show) {
        this.showCalendarKeysProperty().set(show);
    }

    public final BooleanProperty showTimedEntriesProperty() {
        return this.showTimedEntries;
    }

    public final boolean isShowTimedEntries() {
        return this.showTimedEntriesProperty().get();
    }

    public final void setShowTimedEntries(boolean show) {
        this.showTimedEntriesProperty().set(show);
    }

    public final BooleanProperty showEntryDetailsProperty() {
        return this.showEntryDetails;
    }

    public final boolean isShowEntryDetails() {
        return this.showEntryDetailsProperty().get();
    }

    public final void setShowEntryDetails(boolean show) {
        this.showEntryDetailsProperty().set(show);
    }

    public final ReadOnlyIntegerProperty pageNumberProperty() {
        return this.pageNumber.getReadOnlyProperty();
    }

    public final int getPageNumber() {
        return this.pageNumber.get();
    }

    private void setPageNumber(int number) {
        this.pageNumber.set(number);
    }

    public final ReadOnlyIntegerProperty totalPagesProperty() {
        return this.totalPages.getReadOnlyProperty();
    }

    public final int getTotalPages() {
        return this.totalPages.get();
    }

    private void setTotalPages(int total) {
        this.totalPages.set(total);
    }

    public final boolean next() {
        return this.periodSplitter.next();
    }

    public final boolean back() {
        return this.periodSplitter.back();
    }

    public final void bindPage(PrintablePage otherPage) {
        super.bind(otherPage, true);
        Bindings.bindBidirectional(otherPage.viewTypeProperty(), this.viewTypeProperty());
        Bindings.bindBidirectional(otherPage.paperProperty(), this.paperProperty());
        Bindings.bindBidirectional((Property)otherPage.showAllDayEntriesProperty(), (Property)this.showAllDayEntriesProperty());
        Bindings.bindBidirectional((Property)otherPage.showCalendarKeysProperty(), (Property)this.showCalendarKeysProperty());
        Bindings.bindBidirectional((Property)otherPage.showMiniCalendarsProperty(), (Property)this.showMiniCalendarsProperty());
        Bindings.bindBidirectional((Property)otherPage.showTimedEntriesProperty(), (Property)this.showTimedEntriesProperty());
        Bindings.bindBidirectional(otherPage.printStartDateProperty(), this.printStartDateProperty());
        Bindings.bindBidirectional(otherPage.printEndDateProperty(), this.printEndDateProperty());
        Bindings.bindBidirectional(otherPage.formatterMapProperty(), this.formatterMapProperty());
    }

    public final void unbindPage(PrintablePage otherPage) {
        super.unbind(otherPage);
        Bindings.unbindBidirectional(otherPage.viewTypeProperty(), this.viewTypeProperty());
        Bindings.unbindBidirectional(otherPage.paperProperty(), this.paperProperty());
        Bindings.unbindBidirectional((Property)otherPage.showAllDayEntriesProperty(), (Property)this.showAllDayEntriesProperty());
        Bindings.unbindBidirectional((Property)otherPage.showCalendarKeysProperty(), (Property)this.showCalendarKeysProperty());
        Bindings.unbindBidirectional((Property)otherPage.showMiniCalendarsProperty(), (Property)this.showMiniCalendarsProperty());
        Bindings.unbindBidirectional((Property)otherPage.showTimedEntriesProperty(), (Property)this.showTimedEntriesProperty());
        Bindings.unbindBidirectional(otherPage.printStartDateProperty(), this.printStartDateProperty());
        Bindings.unbindBidirectional(otherPage.printEndDateProperty(), this.printEndDateProperty());
        Bindings.unbindBidirectional(otherPage.formatterMapProperty(), this.formatterMapProperty());
    }

    private void updateView() {
        DateControl newView;
        this.removeDataBindings();
        switch (this.getViewType()) {
            case DAY_VIEW: {
                newView = this.detailedDayView;
                break;
            }
            case WEEK_VIEW: {
                newView = this.detailedWeekView;
                break;
            }
            case MONTH_VIEW: {
                newView = this.monthView;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported view type: " + this.getViewType());
            }
        }
        Bindings.bindContent(newView.getCalendarSources(), this.getCalendarSources());
        Bindings.bindContentBidirectional(newView.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        this.setView(newView);
        this.updateDimension();
    }

    private void removeDataBindings() {
        Bindings.unbindContent(this.detailedDayView.getCalendarSources(), this.getCalendarSources());
        Bindings.unbindContentBidirectional(this.detailedDayView.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        Bindings.unbindContent(this.detailedWeekView.getCalendarSources(), this.getCalendarSources());
        Bindings.unbindContentBidirectional(this.detailedWeekView.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        Bindings.unbindContent(this.monthView.getCalendarSources(), this.getCalendarSources());
        Bindings.unbindContentBidirectional(this.monthView.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
    }

    private void updateDimension() {
        double SIZE_MULTIPLIER = 1.5;
        if (this.getViewType().getPageOrientation() == PageOrientation.PORTRAIT) {
            this.setPrefHeight(this.getPaper().getHeight() * 1.5);
            this.setPrefWidth(this.getPaper().getWidth() * 1.5);
        } else {
            this.setPrefHeight(this.getPaper().getWidth() * 1.5);
            this.setPrefWidth(this.getPaper().getHeight() * 1.5);
        }
    }

    private DetailedDayView createDetailedDayView() {
        DetailedDayView newDetailedDayView = new DetailedDayView();
        newDetailedDayView.setShowScrollBar(false);
        newDetailedDayView.setShowToday(false);
        newDetailedDayView.setEnableCurrentTimeCircle(false);
        newDetailedDayView.setEnableCurrentTimeMarker(false);
        newDetailedDayView.weekFieldsProperty().bind(this.weekFieldsProperty());
        newDetailedDayView.showAllDayViewProperty().bind((ObservableValue)this.showAllDayEntriesProperty());
        newDetailedDayView.showAgendaViewProperty().bind((ObservableValue)this.showEntryDetailsProperty());
        newDetailedDayView.layoutProperty().bind(this.layoutProperty());
        newDetailedDayView.dateProperty().bind(this.pageStartDateProperty());
        newDetailedDayView.addEventFilter(MouseEvent.ANY, (EventHandler)this.weakMouseHandler);
        newDetailedDayView.zoneIdProperty().bind(this.zoneIdProperty());
        this.configureDetailedDayView(newDetailedDayView, true);
        return newDetailedDayView;
    }

    protected void configureDetailedDayView(DetailedDayView newDetailedDayView, boolean trimTimeBounds) {
        newDetailedDayView.getDayView().setStartTime(LocalTime.MIN);
        newDetailedDayView.getDayView().setEndTime(LocalTime.MAX);
        newDetailedDayView.getDayView().setEarlyLateHoursStrategy(DayViewBase.EarlyLateHoursStrategy.HIDE);
        newDetailedDayView.getDayView().setHoursLayoutStrategy(DayViewBase.HoursLayoutStrategy.FIXED_HOUR_COUNT);
        newDetailedDayView.getDayView().setVisibleHours(24);
        newDetailedDayView.getDayView().setTrimTimeBounds(trimTimeBounds);
    }

    private DetailedWeekView createDetailedWeekView() {
        DetailedWeekView newDetailedWeekView = new DetailedWeekView();
        newDetailedWeekView.setShowScrollBar(false);
        newDetailedWeekView.layoutProperty().bind(this.layoutProperty());
        newDetailedWeekView.setEnableCurrentTimeCircle(false);
        newDetailedWeekView.setEnableCurrentTimeMarker(false);
        newDetailedWeekView.showAllDayViewProperty().bind((ObservableValue)this.showAllDayEntriesProperty());
        newDetailedWeekView.weekFieldsProperty().bind(this.weekFieldsProperty());
        newDetailedWeekView.setStartTime(LocalTime.MIN);
        newDetailedWeekView.setEndTime(LocalTime.MAX);
        newDetailedWeekView.setEarlyLateHoursStrategy(DayViewBase.EarlyLateHoursStrategy.HIDE);
        newDetailedWeekView.setHoursLayoutStrategy(DayViewBase.HoursLayoutStrategy.FIXED_HOUR_COUNT);
        newDetailedWeekView.setVisibleHours(24);
        newDetailedWeekView.addEventFilter(MouseEvent.ANY, (EventHandler)this.weakMouseHandler);
        newDetailedWeekView.dateProperty().bind(this.pageStartDateProperty());
        newDetailedWeekView.zoneIdProperty().bind(this.zoneIdProperty());
        this.configureDetailedWeekView(newDetailedWeekView, true);
        return newDetailedWeekView;
    }

    protected void configureDetailedWeekView(DetailedWeekView newDetailedWeekView, boolean trimTimeBounds) {
        newDetailedWeekView.getWeekView().setShowToday(false);
        newDetailedWeekView.getWeekView().setTrimTimeBounds(trimTimeBounds);
    }

    protected MonthView createMonthView() {
        MonthView newMonthView = new MonthView();
        newMonthView.setShowToday(false);
        newMonthView.setShowCurrentWeek(false);
        newMonthView.weekFieldsProperty().bind(this.weekFieldsProperty());
        newMonthView.showFullDayEntriesProperty().bind((ObservableValue)this.showAllDayEntriesProperty());
        newMonthView.showTimedEntriesProperty().bind((ObservableValue)this.showTimedEntriesProperty());
        newMonthView.addEventFilter(MouseEvent.ANY, (EventHandler)this.weakMouseHandler);
        newMonthView.dateProperty().bind(this.pageStartDateProperty());
        newMonthView.zoneIdProperty().bind(this.zoneIdProperty());
        return newMonthView;
    }

    private static final class PrintPeriodSplitter
    implements InvalidationListener {
        private final PrintablePage page;
        private PageSlice slice;

        public PrintPeriodSplitter(PrintablePage page) {
            this.page = Objects.requireNonNull(page);
            page.viewTypeProperty().addListener((InvalidationListener)this);
            page.printStartDateProperty().addListener((InvalidationListener)this);
            page.printEndDateProperty().addListener((InvalidationListener)this);
            this.split();
        }

        public void invalidated(Observable observable) {
            this.split();
        }

        private void split() {
            LocalDate pageEndDate;
            LocalDate printStart = this.page.getPrintStartDate();
            LocalDate printEnd = this.page.getPrintEndDate();
            if (printStart == null || printEnd == null || printStart.isAfter(printEnd)) {
                return;
            }
            PageSlice first = null;
            PageSlice pivot = null;
            LocalDate pageStartDate = printStart;
            int count = 0;
            do {
                pageEndDate = pageStartDate.plus(1L, this.page.getViewType().getChronoUnit()).minusDays(1L);
                PageSlice next = new PageSlice(++count, pageStartDate, pageEndDate);
                if (first == null) {
                    first = next;
                }
                if (pivot != null) {
                    pivot.setNext(next);
                }
                pivot = next;
            } while ((pageStartDate = pageEndDate.plusDays(1L)).isBefore(printEnd) || pageStartDate.isEqual(printEnd));
            this.setSlice(first);
            this.page.setTotalPages(count);
        }

        public boolean next() {
            if (this.slice != null && this.slice.hasNext()) {
                this.setSlice(this.slice.getNext());
                return true;
            }
            return false;
        }

        public boolean back() {
            if (this.slice != null && this.slice.hasBack()) {
                this.setSlice(this.slice.getBack());
            }
            return false;
        }

        private void setSlice(PageSlice slice) {
            this.slice = slice;
            this.page.setPageStartDate(slice.getStart());
            this.page.setPageEndDate(slice.getEnd());
            this.page.setPageNumber(slice.getNumber());
        }
    }

    private static final class PageSlice {
        private final int number;
        private final LocalDate start;
        private final LocalDate end;
        private PageSlice next;
        private PageSlice back;

        public PageSlice(int number, LocalDate start, LocalDate end) {
            this.number = number;
            this.start = start;
            this.end = end;
        }

        public int getNumber() {
            return this.number;
        }

        public LocalDate getStart() {
            return this.start;
        }

        public LocalDate getEnd() {
            return this.end;
        }

        public PageSlice getNext() {
            return this.next;
        }

        public void setNext(PageSlice next) {
            if (this.next != next) {
                this.next = next;
                next.setBack(this);
            }
        }

        public PageSlice getBack() {
            return this.back;
        }

        public void setBack(PageSlice back) {
            if (this.back != back) {
                this.back = back;
                back.setNext(this);
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasBack() {
            return this.back != null;
        }
    }
}

